/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormExportMetaDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormUpgradeInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormUpgradeThreadService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.service.SysFormUpgradeService;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormAttachmentParseVo;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.DigestUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.io.Serializable;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.SysFormUpgradeServiceImpl")
public class SysFormUpgradeServiceImpl
implements SysFormUpgradeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysFormUpgradeServiceImpl.class);
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private IFormUpgradeThreadService formUpgradeThreadService;
    @Resource
    private IFormUpgradeInfoService formUpgradeInfoService;

    public ApiResponse<FormAttachmentParseVo> parseAttachment(MultipartFile file, Long currentFormId) {
        String localPath;
        Long fileId;
        AssertUtil.isNotNull((Object)currentFormId, (String)"\u5347\u7ea7\u8868\u5355ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        try {
            fileId = this.appFileExtendService.fileDecryptAndUpload(file);
            localPath = this.appFileExtendService.downloadAndUnzip(fileId);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)"\u9644\u4ef6\u52a0\u5bc6\u548c\u89e3\u5bc6\u7684\u5bc6\u94a5\u4e0d\u4e00\u81f4");
        }
        String unZipPath = this.formUpgradeInfoService.getUnZipPathByLocalPath(localPath);
        String metaFilePath = FileUtil.posixPath((String[])new String[]{unZipPath, "hussar.meta"});
        String formPath = FileUtil.posixPath((String[])new String[]{unZipPath, "formConfig", "form.json"});
        JSONObject jsonObject = AppMigrateUtil.readFileToObject(formPath, JSONObject.class);
        if (HussarUtils.isEmpty((Object)jsonObject)) {
            return ApiResponse.fail((String)"\u8bfb\u53d6\u8868\u5355\u4fe1\u606f\u5931\u8d25");
        }
        Object object = jsonObject.get((Object)"form");
        JSONObject sysForm = (JSONObject)object;
        if (HussarUtils.isEmpty((Object)sysForm)) {
            return ApiResponse.fail((String)"\u8bfb\u53d6\u8868\u5355\u4fe1\u606f\u5931\u8d25");
        }
        FormExportMetaDto formExportMetaDto = AppMigrateUtil.readFileToObject(metaFilePath, FormExportMetaDto.class);
        if (formExportMetaDto == null) {
            return ApiResponse.fail((String)"\u4e0a\u4f20\u7684\u9644\u4ef6\u683c\u5f0f\u6709\u8bef");
        }
        if (HussarUtils.isEmpty((Object)formExportMetaDto.getFormName())) {
            return ApiResponse.fail((String)"\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u8868\u5355\u6587\u4ef6");
        }
        SysForm sysFormUpgrade = (SysForm)jsonObject.getObject("form", SysForm.class);
        SysForm sysFormCurrent = (SysForm)this.sysFormService.getById((Serializable)currentFormId);
        if (HussarUtils.isEmpty((Object)sysFormCurrent)) {
            return ApiResponse.fail((String)"\u5347\u7ea7\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u6821\u9a8c\u5931\u8d25");
        }
        if (!sysFormUpgrade.getFormType().equals(sysFormCurrent.getFormType())) {
            return ApiResponse.fail((String)"\u8868\u5355\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u6821\u9a8c\u5931\u8d25");
        }
        if (!sysFormUpgrade.getId().equals(sysFormCurrent.getId())) {
            return ApiResponse.fail((String)"\u8868\u5355\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u6821\u9a8c\u5931\u8d25");
        }
        if (!sysFormUpgrade.getTableName().equals(sysFormCurrent.getTableName())) {
            return ApiResponse.fail((String)"\u8868\u5355\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u6821\u9a8c\u5931\u8d25");
        }
        FormAttachmentParseVo formAttachmentParseVo = new FormAttachmentParseVo();
        formAttachmentParseVo.setFileId(fileId);
        formAttachmentParseVo.setPath(unZipPath);
        formAttachmentParseVo.setEncryptFlag(ToolUtil.isNotEmpty((Object)formExportMetaDto.getPassword()));
        BeanUtils.copyProperties((Object)formExportMetaDto, (Object)formAttachmentParseVo);
        formAttachmentParseVo.setI18nKeys(sysForm.getString("i18nKeys"));
        return ApiResponse.success((Object)formAttachmentParseVo);
    }

    public ApiResponse<Boolean> verifyPassword(FormUpgradeDto formUpgradeDto) {
        String inputPwd = DigestUtil.sha1Hex((String)formUpgradeDto.getPassword());
        String metaFilePath = FileUtil.posixPath((String[])new String[]{formUpgradeDto.getPath(), "hussar.meta"});
        FormExportMetaDto formExportMetaDto = AppMigrateUtil.readFileToObject(metaFilePath, FormExportMetaDto.class);
        assert (formExportMetaDto != null);
        String password = formExportMetaDto.getPassword();
        return ApiResponse.success((Object)inputPwd.equals(password));
    }

    public ApiResponse<String> execute(FormUpgradeDto formUpgradeDto) {
        String upgradeTaskId = "formUpgradeCacheKey_" + UUID.randomUUID();
        TransmittableThreadLocalHolder.set((String)"formUpgradeCacheKey", (Object)upgradeTaskId);
        TransmittableThreadLocalHolder.set((String)"loginUserDetails", (Object)HussarSecurityUtils.getLoginUserDetails());
        String dataSourceKey = DataModelUtil.currentDsName();
        String importCacheKey = (String)TransmittableThreadLocalHolder.get((String)"formUpgradeCacheKey");
        HussarNoCodeThreadUtil.executeUserTask(() -> {
            try {
                long startTime = System.currentTimeMillis();
                LOGGER.info("\u8868\u5355\u5347\u7ea7[{}] ===============> \u5f00\u59cb\u6267\u884c...", (Object)formUpgradeDto.getId());
                this.formUpgradeThreadService.startUpgradeThread(formUpgradeDto, dataSourceKey);
                HussarCacheUtil.put((String)"form_upgrade_progress", (Object)importCacheKey, (Object)ImportStatusVo.success((int)this.getUpgradeStatus(formUpgradeDto.getFormType()), (boolean)true, null));
                LOGGER.info("\u8868\u5355\u5347\u7ea7[{}] ==============> \u7ed3\u675f,\u8017\u65f6{}ms...", new Object[]{formUpgradeDto.getId(), System.currentTimeMillis() - startTime, dataSourceKey});
            }
            catch (Exception e) {
                HussarCacheUtil.put((String)"form_upgrade_progress", (Object)importCacheKey, (Object)ImportStatusVo.put((int)-1, null, (boolean)false, (boolean)true));
                LOGGER.error("\u8868\u5355\u5347\u7ea7\u5931\u8d25", (Throwable)e);
                e.printStackTrace();
                throw new HussarException((Throwable)e);
            }
        });
        return ApiResponse.success((Object)upgradeTaskId, (String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    public int getUpgradeStatus(String formType) {
        if ("0".equals(formType)) {
            return 4;
        }
        if ("1".equals(formType)) {
            return 5;
        }
        if ("2".equals(formType)) {
            return 2;
        }
        throw new HussarException("\u5347\u7ea7\u4e0d\u652f\u6301\u6b64\u7c7b\u578b");
    }

    public ApiResponse<ImportStatusVo> getUpgradeProgress(String upgradeCacheKey) {
        return ApiResponse.success((Object)(HussarUtils.isNotEmpty((Object)HussarCacheUtil.get((String)"form_upgrade_progress", (Object)upgradeCacheKey, ImportStatusVo.class)) ? (ImportStatusVo)HussarCacheUtil.get((String)"form_upgrade_progress", (Object)upgradeCacheKey, ImportStatusVo.class) : ImportStatusVo.waitImport((int)1, (boolean)false, (Object)"", (boolean)false, (String)"\u6b63\u5728\u5347\u7ea7\u8868\u5355\u6570\u636e")));
    }
}

