/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.TranslateUtil;
import com.jxdinfo.hussar.formdesign.application.form.dao.FormRecentUsedHisMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.FormRecentUsedHis;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormRecentUsedHisService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormRecentUsedHisVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormRecentUsedHisServiceImpl")
public class FormRecentUsedHisServiceImpl
extends HussarServiceImpl<FormRecentUsedHisMapper, FormRecentUsedHis>
implements IFormRecentUsedHisService {
    @Resource
    private ISysFormService formService;
    @Resource
    private ISysApplicationBoService applicationBoService;
    @Resource
    private FormRecentUsedHisMapper formRecentUsedHisMapper;
    private static final int MAX_HISTORY_SIZE = 8;
    private static final DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final Logger LOGGER = LoggerFactory.getLogger(FormRecentUsedHisServiceImpl.class);
    private static final String USED_HIS_CACHE = "_usedHis";

    public ApiResponse<List<FormRecentUsedHisVo>> getRecentUsedHisList() {
        String recentUsedHis;
        JSONArray jsonArray;
        FormRecentUsedHis formRecentUsedHis = this.getFormRecentUsedHis();
        List<Object> formRecentUsedHisVoList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)formRecentUsedHis) && HussarUtils.isNotEmpty((Object)(jsonArray = JSON.parseArray((String)(recentUsedHis = formRecentUsedHis.getRecentUsedHis()))))) {
            ArrayList<String> formIds = new ArrayList<String>();
            HashMap formIdToVoMap = new HashMap();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String formId = jsonObject.getString("formId");
                formIds.add(formId);
                formIdToVoMap.put(formId, null);
            }
            formRecentUsedHisVoList = this.getFormAndAppInfos(formIds);
            formRecentUsedHisVoList.stream().forEach(vo -> formIdToVoMap.put(vo.getFormId(), vo));
            boolean delFlag = false;
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                JSONObject jsonObject = (JSONObject)iterator.next();
                String formId = jsonObject.getString("formId");
                FormRecentUsedHisVo vo2 = (FormRecentUsedHisVo)formIdToVoMap.get(formId);
                String accessTime = jsonObject.getString("accessTime");
                if (HussarUtils.isNotEmpty((Object)vo2)) {
                    String formLangKeys = vo2.getFormLangKeys();
                    String appLangKeys = vo2.getAppLangKeys();
                    JSONObject formLangJsonObject = JSON.parseObject((String)formLangKeys);
                    JSONObject appLangJsonObject = JSON.parseObject((String)appLangKeys);
                    String appNameKey = null;
                    String formNameKey = null;
                    if (HussarUtils.isNotEmpty((Object)appLangJsonObject)) {
                        appNameKey = appLangJsonObject.getString("appName");
                    }
                    if (HussarUtils.isNotEmpty((Object)formLangJsonObject)) {
                        formNameKey = formLangJsonObject.getString("formName");
                    }
                    String translateFormName = TranslateUtil.getTranslateName(formNameKey);
                    String translateAppName = TranslateUtil.getTranslateName((String)appNameKey);
                    if (HussarUtils.isNotEmpty((Object)translateFormName)) {
                        vo2.setFormName(translateFormName);
                    }
                    if (HussarUtils.isNotEmpty((Object)translateAppName)) {
                        vo2.setAppName(translateAppName);
                    }
                    vo2.setAccessTime(accessTime);
                    continue;
                }
                formIdToVoMap.remove(formId);
                iterator.remove();
                delFlag = true;
            }
            if (delFlag) {
                formRecentUsedHis.setRecentUsedHis(jsonArray.toJSONString());
                this.formRecentUsedHisMapper.updateById(formRecentUsedHis);
            }
            formRecentUsedHisVoList.clear();
            formRecentUsedHisVoList.addAll(formIdToVoMap.values());
            this.sortListByAccessTime(formRecentUsedHisVoList);
        }
        return ApiResponse.success(formRecentUsedHisVoList);
    }

    private List<FormRecentUsedHisVo> getFormAndAppInfos(List<String> formIds) {
        List formIdsLong = Optional.ofNullable(formIds).orElseGet(Collections::emptyList).stream().filter(HussarUtils::isNotEmpty).filter(id -> !id.trim().isEmpty()).map(Long::valueOf).collect(Collectors.toList());
        if (formIdsLong.isEmpty()) {
            return Collections.emptyList();
        }
        List formList = this.formService.listByIds(formIdsLong);
        if (formList.isEmpty()) {
            return Collections.emptyList();
        }
        List appIds = formList.stream().map(SysForm::getAppId).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
        Map appMap = appIds.isEmpty() ? Collections.emptyMap() : Optional.ofNullable(this.applicationBoService.getAppList(null, new ArrayList(appIds))).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(SysApplication::getId, Function.identity()));
        return formList.parallelStream().filter(form -> {
            if (!appMap.containsKey(form.getAppId())) {
                LOGGER.error("\u8868\u5355\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8868\u5355ID\uff1a{}", (Object)form.getId());
                return false;
            }
            return true;
        }).map(form -> {
            SysApplication application = (SysApplication)appMap.get(form.getAppId());
            return this.buildVo((SysForm)form, application);
        }).collect(Collectors.toList());
    }

    private FormRecentUsedHisVo buildVo(SysForm form, SysApplication application) {
        FormRecentUsedHisVo vo = new FormRecentUsedHisVo();
        vo.setFormId(String.valueOf(form.getId()));
        vo.setFormName(form.getFormName());
        vo.setFormType(form.getFormType());
        vo.setAppId(String.valueOf(application.getId()));
        vo.setAppName(application.getAppName());
        vo.setAppLangKeys(application.getI18nKeys());
        vo.setFormIconType(form.getFormIconType());
        vo.setFormIcon(form.getFormIcon());
        vo.setFormIconColor(form.getFormIconColor());
        vo.setIsDeleted(form.getDelFlag());
        vo.setFormLangKeys(form.getI18nKeys());
        return vo;
    }

    public synchronized ApiResponse<Boolean> updateRecentUsedHis(String formId) {
        FormRecentUsedHis formRecentUsedHis = this.getFormRecentUsedHis();
        String currentTime = HussarUtils.formatDateTime((TemporalAccessor)LocalDateTime.now());
        if (HussarUtils.isEmpty((Object)formRecentUsedHis)) {
            Long userId = BaseSecurityUtil.getUser().getUserId();
            String cacheKey = String.format("%s:%s", USED_HIS_CACHE, userId);
            Object usedHisCache = HussarCacheUtil.get((String)USED_HIS_CACHE, (Object)cacheKey);
            if (!HussarUtils.isEmpty((Object)usedHisCache)) {
                return ApiResponse.success((Object)true);
            }
            HussarCacheUtil.put((String)USED_HIS_CACHE, (Object)cacheKey, (Object)"locked", (long)60L);
            formRecentUsedHis = new FormRecentUsedHis();
            formRecentUsedHis.setUserId(userId);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("formId", (Object)formId);
            jsonObject.put("accessTime", (Object)currentTime);
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)jsonObject);
            formRecentUsedHis.setRecentUsedHis(jsonArray.toJSONString());
            int isSuccess = this.formRecentUsedHisMapper.insert(formRecentUsedHis);
            HussarCacheUtil.evict((String)USED_HIS_CACHE, (Object)cacheKey);
            if (isSuccess > 0) {
                return ApiResponse.success((Object)true);
            }
            return ApiResponse.success((Object)false);
        }
        String recentUsedHis = formRecentUsedHis.getRecentUsedHis();
        JSONArray jsonArray = JSON.parseArray((String)recentUsedHis);
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        boolean found = false;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject entry = jsonArray.getJSONObject(i);
            jsonObjects.add(entry);
            if (!HussarUtils.isNotEmpty((Object)entry) || !HussarUtils.isNotEmpty((Object)entry.get((Object)"formId")) || !entry.getString("formId").equals(formId)) continue;
            entry.put("accessTime", (Object)currentTime);
            found = true;
        }
        if (!found) {
            JSONObject newEntry = new JSONObject();
            newEntry.put("formId", (Object)formId);
            newEntry.put("accessTime", (Object)currentTime);
            jsonObjects.add(newEntry);
        }
        this.sortJsonObjectsByAccessTime(jsonObjects);
        while (jsonObjects.size() > 8) {
            jsonObjects.remove(jsonObjects.size() - 1);
        }
        String newRecentUsedHis = JSONArray.toJSONString(jsonObjects);
        formRecentUsedHis.setRecentUsedHis(newRecentUsedHis);
        int isSuccess = this.formRecentUsedHisMapper.updateById(formRecentUsedHis);
        if (isSuccess > 0) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.success((Object)false);
    }

    private FormRecentUsedHis getFormRecentUsedHis() {
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = String.valueOf(user.getUserId());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FormRecentUsedHis::getUserId, (Object)Long.valueOf(userId));
        List list = this.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)list)) {
            FormRecentUsedHis formRecentUsedHis = (FormRecentUsedHis)list.get(0);
            if (list.size() > 1) {
                list.remove(0);
                this.removeBatchByIds(list);
            }
            return formRecentUsedHis;
        }
        return null;
    }

    private void sortJsonObjectsByAccessTime(List<JSONObject> jsonObjects) {
        jsonObjects.sort((o1, o2) -> {
            LocalDateTime date1 = LocalDateTime.parse(o1.getString("accessTime"), sdf);
            LocalDateTime date2 = LocalDateTime.parse(o2.getString("accessTime"), sdf);
            return date2.compareTo(date1);
        });
    }

    private void sortListByAccessTime(List<FormRecentUsedHisVo> formRecentUsedHisVo) {
        formRecentUsedHisVo.sort((o1, o2) -> {
            LocalDateTime date1 = LocalDateTime.parse(o1.getAccessTime(), sdf);
            LocalDateTime date2 = LocalDateTime.parse(o2.getAccessTime(), sdf);
            return date2.compareTo(date1);
        });
    }
}

