/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.DownLoadComponent;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppExportRecord;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppExportRecordService;
import com.jxdinfo.hussar.formdesign.application.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.data.model.SysBatchDownloadTask;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormExportDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormExportInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormExportService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.print.handle.WordHandle;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormExportServiceImpl")
public class FormExportServiceImpl
implements IFormExportService {
    @Resource
    private IFormExportInfoService formExportInfoService;
    @Resource
    private ISysAppExportRecordService sysAppExportRecordService;
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private ISysFormService formService;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private DownLoadComponent downLoadCompent;
    @Resource
    private WordHandle wordHandle;
    private static final Logger logger = LoggerFactory.getLogger(FormExportServiceImpl.class);

    public ApiResponse<Void> export(FormExportDto formExportDto) {
        Long usr = BaseSecurityUtil.getUser().getId();
        SysForm form = (SysForm)this.formService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysForm::getId, (Object)formExportDto.getFormId()));
        String dataSourceKey = DataModelUtil.currentDsName();
        HussarNoCodeThreadUtil.executeDesignTask(() -> {
            try {
                this.exportExecute(formExportDto, form, usr, dataSourceKey);
            }
            catch (IOException | InterruptedException e) {
                ToolUtil.getLogger(FormExportServiceImpl.class).error("\u5bfc\u51fa\u5e94\u7528\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            TransmittableThreadLocalHolder.clear((String)"exportCacheKey");
        });
        return ApiResponse.success();
    }

    public ApiResponse<Long> exportBatch(List<FormExportDto> formExportDtos) {
        ArrayList<Long> fileIds = new ArrayList<Long>();
        Long zipId = null;
        for (FormExportDto formExportDto : formExportDtos) {
            Long usr = BaseSecurityUtil.getUser().getId();
            SysForm form = (SysForm)this.formService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysForm::getId, (Object)formExportDto.getFormId()));
            String dataSourceKey = DataModelUtil.currentDsName();
            try {
                Long fileId = this.exportExecuteBatch(formExportDto, form, usr, dataSourceKey);
                fileIds.add(fileId);
            }
            catch (IOException | InterruptedException e) {
                ToolUtil.getLogger(FormExportServiceImpl.class).error("\u6279\u91cf\u5bfc\u51fa\u8868\u5355\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                throw new BaseException("\u6279\u91cf\u5bfc\u51fa\u8868\u5355\u5931\u8d25");
            }
        }
        try {
            HashMap nameRepeat = new HashMap();
            String projectBackPath = this.formDesignProperties.getBackProjectPath();
            projectBackPath = projectBackPath + File.separator + System.currentTimeMillis() + File.separator;
            String zipFolderPath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), projectBackPath, "exportFormBatch"});
            Files.createDirectories(Paths.get(zipFolderPath, new String[0]), new FileAttribute[0]);
            HashMap<Long, String> idMaps = new HashMap<Long, String>();
            for (Long id : fileIds) {
                idMaps.put(id, "");
            }
            this.downLoadCompent.copyFilesToFolder(idMaps, zipFolderPath, nameRepeat);
            zipId = this.downLoadCompent.zipFile(zipFolderPath, "\u8868\u5355\u6279\u91cf\u5bfc\u51fa-" + this.wordHandle.getFormatTimeNoHour(System.currentTimeMillis()), null, new SysBatchDownloadTask());
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u5bfc\u51fa\u8868\u5355\u5f02\u5e38\uff1a{}", (Throwable)e);
            throw new BaseException("\u6279\u91cf\u5bfc\u51fa\u8868\u5355\u5f02\u5e38");
        }
        return ApiResponse.success((Object)zipId);
    }

    @HussarDs(value="#dataSourceKey")
    public void exportExecute(FormExportDto formExportDto, SysForm form, Long usr, String dataSourceKey) throws InterruptedException, IOException {
        this.formExportInfoService.init(formExportDto);
        this.formExportInfoService.exportFormInfo(formExportDto);
        if ("2".equals(form.getFormType())) {
            this.formExportInfoService.exportDashboardData(formExportDto);
        } else {
            this.formExportInfoService.exportDesignerMidFile(formExportDto);
            this.formExportInfoService.exportFlowConfigInfo(formExportDto);
        }
        if (formExportDto.getExportDataFlag()) {
            this.formExportInfoService.exportBusinessData(formExportDto);
        }
        this.formExportInfoService.generateMetaInfo(formExportDto);
        this.formExportInfoService.exportMenuFuncResInfo(formExportDto);
        Thread.sleep(1000L);
        Long exportFileId = this.formExportInfoService.uploadExportFile(formExportDto);
        SysAppExportRecord record = new SysAppExportRecord();
        record.setType("2");
        record.setName(((SysForm)this.formService.getById((Serializable)formExportDto.getFormId())).getFormName());
        record.setExportUserId(usr);
        record.setExportTime(LocalDateTime.now());
        record.setExportFileId(exportFileId);
        this.sysAppExportRecordService.save((Object)record);
        this.formExportInfoService.clear();
    }

    @HussarDs(value="#dataSourceKey")
    public Long exportExecuteBatch(FormExportDto formExportDto, SysForm form, Long usr, String dataSourceKey) throws InterruptedException, IOException {
        this.formExportInfoService.init(formExportDto);
        this.formExportInfoService.exportFormInfo(formExportDto);
        if ("2".equals(form.getFormType())) {
            this.formExportInfoService.exportDashboardData(formExportDto);
        } else {
            this.formExportInfoService.exportDesignerMidFile(formExportDto);
            this.formExportInfoService.exportFlowConfigInfo(formExportDto);
        }
        if (formExportDto.getExportDataFlag()) {
            this.formExportInfoService.exportBusinessData(formExportDto);
        }
        this.formExportInfoService.generateMetaInfo(formExportDto);
        Thread.sleep(1000L);
        Long exportFileId = this.formExportInfoService.uploadExportFile(formExportDto);
        SysAppExportRecord record = new SysAppExportRecord();
        record.setType("2");
        record.setName(((SysForm)this.formService.getById((Serializable)formExportDto.getFormId())).getFormName());
        record.setExportUserId(usr);
        record.setExportTime(LocalDateTime.now());
        record.setExportFileId(exportFileId);
        this.sysAppExportRecordService.save((Object)record);
        this.formExportInfoService.clear();
        return exportFileId;
    }

    public ApiResponse<ExportStatusVo> getExportProgress(String exportCacheKey) {
        return ApiResponse.success((Object)HussarCacheUtil.get((String)"export_progress", (Object)exportCacheKey, ExportStatusVo.class));
    }

    public void downloadExportFile(Long fileId, HttpServletResponse response) {
        this.appFileExtendService.fileDownload(fileId, response);
    }
}

