/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.permit.dto.QueryAppFuncResDto;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.application.application.service.IPermissionService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleButtonMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dto.ButtonAuthoritiesDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.ButtonDto;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.ButtonVo;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.enums.Button;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.authority.service.impl.sysAppVisitRoleButtonServiceImpl")
public class SysAppVisitRoleButtonServiceImpl
extends HussarServiceImpl<SysAppVisitRoleButtonMapper, SysAppVisitRoleButton>
implements ISysAppVisitRoleButtonService {
    private static final String _TABLE_QUERY_FROM = "_tableQuery_from";
    private static final String _TABLE_QUERY_BUTTON = "_tableQuery_button";
    private static final String _TABLE_QUERY_APP = "_tableQuery_app";
    private static final Long TENANT_SYSTEM_ADMIN_ROLE = 1450715195867925063L;
    private static final Long SYSTEM_ADMIN_ROLE = 1450785135866925067L;
    private static final Long TENANT_SECURITYADMIN_ROLE = 1450785935166925011L;
    private static final Long SECURITYADMIN_ROLE = 1450785135866925068L;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private IPermissionService permissionService;
    @Resource
    private IHussarBaseResourceService hussarBaseResourceService;
    private static Logger logger = LoggerFactory.getLogger(SysAppVisitRoleButtonServiceImpl.class);

    public ApiResponse<List<ButtonVo>> formAuthorityButton(Long formId, List<SysCustomButton> customButtonList) {
        if (HussarUtils.isNotEmpty((Object)formId)) {
            SecurityUser shiroUser = BaseSecurityUtil.getUser();
            if (HussarUtils.isEmpty((Object)shiroUser)) {
                shiroUser = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser");
            }
            if (HussarUtils.isNotEmpty((Object)shiroUser)) {
                boolean isTenantAdmin;
                List rolesList = shiroUser.getRolesList();
                SysForm sysForm = (SysForm)HussarCacheUtil.get((String)_TABLE_QUERY_FROM, (Object)formId, SysForm.class);
                if (HussarUtils.isEmpty((Object)sysForm)) {
                    sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
                    HussarCacheUtil.put((String)_TABLE_QUERY_FROM, (Object)formId, (Object)sysForm, (long)3600L);
                }
                AssertUtil.isNotNull((Object)sysForm, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
                Long appId = sysForm.getAppId();
                SysApplication appDetail = (SysApplication)HussarCacheUtil.get((String)_TABLE_QUERY_APP, (Object)appId, SysApplication.class);
                if (HussarUtils.isEmpty((Object)appDetail)) {
                    appDetail = this.sysApplicationBoService.selectById(appId);
                    HussarCacheUtil.put((String)_TABLE_QUERY_APP, (Object)appId, (Object)appDetail, (long)3600L);
                }
                AssertUtil.isNotNull((Object)appDetail, (String)"\u5e94\u7528\u4e0d\u5b58\u5728");
                Long developRoleId = appDetail.getDevelopRoleId();
                boolean bl = isTenantAdmin = HussarUtils.isNotEmpty((Object)shiroUser.getRolesList()) && (shiroUser.getRolesList().contains(TenantConstant.ADMIN_ROLE) || shiroUser.getRolesList().contains(TENANT_SYSTEM_ADMIN_ROLE) || shiroUser.getRolesList().contains(SYSTEM_ADMIN_ROLE) || shiroUser.getRolesList().contains(TENANT_SECURITYADMIN_ROLE) || shiroUser.getRolesList().contains(SECURITYADMIN_ROLE));
                if (shiroUser.isSuperAdmin() || rolesList.contains(developRoleId) || isTenantAdmin) {
                    ArrayList<Object> result = new ArrayList<Object>();
                    ButtonAuthoritiesDto buttonAuthoritiesDto = new ButtonAuthoritiesDto();
                    this.sysFormService.sysCreateButton(buttonAuthoritiesDto, sysForm.getFormType());
                    List sysButtonList = buttonAuthoritiesDto.getButtonDtoList();
                    for (ButtonDto buttonDto : sysButtonList) {
                        result.add(BeanUtil.copy((Object)buttonDto, ButtonVo.class));
                    }
                    for (SysCustomButton customButton : customButtonList) {
                        ButtonVo buttonVo = new ButtonVo();
                        buttonVo.setButtonCode(customButton.getAction());
                        buttonVo.setButtonName(customButton.getAlias());
                        result.add(buttonVo);
                    }
                    return ApiResponse.success(result);
                }
                if (HussarUtils.isNotEmpty((Object)rolesList)) {
                    return ApiResponse.success((Object)this.permissionService.getButtonRoleResource(formId, rolesList));
                }
            }
            return ApiResponse.success(new ArrayList());
        }
        throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
    }

    public ApiResponse<List<ButtonVo>> formAuthorityButton(Long formId) {
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        SysApplication appDetail = this.sysApplicationBoService.selectById(sysForm.getAppId());
        if (HussarUtils.isNotEmpty((Object)formId)) {
            SysApplicationVo sysApplicationVo = new SysApplicationVo();
            BeanUtils.copyProperties((Object)appDetail, (Object)sysApplicationVo);
            return this.formAuthorityButton(sysForm, sysApplicationVo);
        }
        throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
    }

    public ApiResponse<List<ButtonVo>> formAuthorityButton(SysForm sysForm, SysApplicationVo sysApplicationVo) {
        Long formId = sysForm.getId();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)shiroUser)) {
            shiroUser = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser");
        }
        List rolesList = shiroUser.getRolesList();
        if (HussarUtils.isNotEmpty((Object)shiroUser)) {
            boolean isTenantAdmin;
            AssertUtil.isNotNull((Object)sysForm, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
            Long appId = sysForm.getAppId();
            AssertUtil.isNotNull((Object)sysApplicationVo, (String)"\u5e94\u7528\u4e0d\u5b58\u5728");
            Long developRoleId = sysApplicationVo.getDevelopRoleId();
            boolean bl = isTenantAdmin = HussarUtils.isNotEmpty((Object)shiroUser.getRolesList()) && (shiroUser.getRolesList().contains(TenantConstant.ADMIN_ROLE) || shiroUser.getRolesList().contains(TENANT_SYSTEM_ADMIN_ROLE) || shiroUser.getRolesList().contains(SYSTEM_ADMIN_ROLE) || shiroUser.getRolesList().contains(TENANT_SECURITYADMIN_ROLE) || shiroUser.getRolesList().contains(SECURITYADMIN_ROLE));
            if (shiroUser.isSuperAdmin() || rolesList.contains(developRoleId) || isTenantAdmin) {
                ArrayList<Object> result = new ArrayList<Object>();
                ButtonAuthoritiesDto buttonAuthoritiesDto = new ButtonAuthoritiesDto();
                this.sysFormService.sysCreateButton(buttonAuthoritiesDto, sysForm.getFormType());
                List sysButtonList = buttonAuthoritiesDto.getButtonDtoList();
                for (ButtonDto buttonDto : sysButtonList) {
                    result.add(BeanUtil.copy((Object)buttonDto, ButtonVo.class));
                }
                List customButtonList = this.sysCustomButtonService.list((Wrapper)new LambdaQueryWrapper().eq(SysCustomButton::getFormId, (Object)formId));
                HussarCacheUtil.put((String)_TABLE_QUERY_BUTTON, (Object)formId, (Object)customButtonList, (long)3600L);
                for (SysCustomButton customButton : customButtonList) {
                    ButtonVo buttonVo = new ButtonVo();
                    buttonVo.setButtonCode(customButton.getAction());
                    buttonVo.setButtonName(customButton.getAlias());
                    result.add(buttonVo);
                }
                return ApiResponse.success(result);
            }
            if (HussarUtils.isNotEmpty((Object)rolesList)) {
                return ApiResponse.success((Object)this.permissionService.getButtonRoleResource(formId, rolesList));
            }
        }
        return ApiResponse.success();
    }

    public Map<Long, List<ButtonVo>> listButtonAuthorityByAppId(Long appId, Long roleId, Long formId) {
        HashMap<Long, List<ButtonVo>> buttonAuthorityVoMap = new HashMap<Long, List<ButtonVo>>();
        QueryAppFuncResDto queryAppFuncResDto = new QueryAppFuncResDto();
        queryAppFuncResDto.setAppId(appId);
        queryAppFuncResDto.setRoleId(roleId);
        queryAppFuncResDto.setFormId(formId);
        final List relateIds = this.hussarBaseResourceService.getResourceList(queryAppFuncResDto).stream().map(SysResources::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapperForm = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            wrapperForm.eq(SysForm::getAppId, (Object)appId);
        }
        if (HussarUtils.isNotEmpty((Object)formId)) {
            wrapperForm.eq(SysForm::getId, (Object)formId);
        }
        List sysFormList = this.sysFormService.list((Wrapper)wrapperForm);
        QueryAppFuncResDto queryAll = new QueryAppFuncResDto();
        queryAll.setAppId(appId);
        queryAll.setFormId(formId);
        List allResourceList = this.hussarBaseResourceService.getResourceList(queryAll);
        for (SysForm sysForm : sysFormList) {
            ArrayList<1> buttonVos = new ArrayList<1>();
            buttonAuthorityVoMap.put(sysForm.getId(), buttonVos);
            List relateResList = allResourceList.stream().filter(item -> sysForm.getId().equals(item.getModuleId()) && "res_element".equals(item.getResTypeId())).collect(Collectors.toList());
            for (final SysResources resource : relateResList) {
                final String buttonCode = resource.getPermissions();
                String buttonName = this.getButtonNameByCode(buttonCode);
                final String finalButtonName = HussarUtils.isNotBlank((CharSequence)buttonName) ? buttonName : resource.getResourceName();
                buttonVos.add(new ButtonVo(){
                    {
                        this.setButtonCode(buttonCode);
                        this.setButtonName(finalButtonName);
                        this.setChecked(relateIds.contains(resource.getId()));
                    }
                });
            }
        }
        return buttonAuthorityVoMap;
    }

    private String getButtonNameByCode(String buttonCode) {
        String buttonName = "";
        if (Button.CREATE_OPERATE.getButtonCode().equals(buttonCode)) {
            buttonName = Button.CREATE_OPERATE.getButtonName();
        } else if (Button.EDIT_OPERATE.getButtonCode().equals(buttonCode)) {
            buttonName = Button.EDIT_OPERATE.getButtonName();
        } else if (Button.DELETE_OPERATE.getButtonCode().equals(buttonCode)) {
            buttonName = Button.DELETE_OPERATE.getButtonName();
        } else if (Button.IMPORT_OPTION.getButtonCode().equals(buttonCode)) {
            buttonName = Button.IMPORT_OPTION.getButtonName();
        } else if (Button.EXPORT_OPTION.getButtonCode().equals(buttonCode)) {
            buttonName = Button.EXPORT_OPTION.getButtonName();
        } else if (Button.PRINT_OPERATE.getButtonCode().equals(buttonCode)) {
            buttonName = Button.PRINT_OPERATE.getButtonName();
        } else if (Button.DOWNLOAD_OPERATE.getButtonCode().equals(buttonCode)) {
            buttonName = Button.DOWNLOAD_OPERATE.getButtonName();
        } else if (Button.SUBMIT_OPERATE.getButtonCode().equals(buttonCode)) {
            buttonName = Button.SUBMIT_OPERATE.getButtonName();
        } else if (Button.REJECT_OPERATE.getButtonCode().equals(buttonCode)) {
            buttonName = Button.REJECT_OPERATE.getButtonName();
        }
        return buttonName;
    }
}

