/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.authorization.permit.dto.QueryAppFuncResDto;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitRoleFieldBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.service.INoCodeAppDevelopTeamService;
import com.jxdinfo.hussar.formdesign.application.application.service.IPermissionService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitFormAuthorizeRolesMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dto.SysAppVisitFormAuthorizeRolesDto;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.util.NoCodeSecurityUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.authority.service.impl.sysAppVisitFormAuthorizeRolesServiceImpl")
public class SysAppVisitFormAuthorizeRolesServiceImpl
extends HussarServiceImpl<SysAppVisitFormAuthorizeRolesMapper, SysAppVisitFormAuthorizeRoles>
implements ISysAppVisitFormAuthorizeRolesService {
    private static final String TABLE_QUERY_FROM = "_tableQuery_from";
    private static final String _TABLE_QUERY_APP = "_tableQuery_app";
    private static final Long TENANT_SYSTEM_ADMIN_ROLE = 1450715195867925063L;
    private static final Long SYSTEM_ADMIN_ROLE = 1450785135866925067L;
    private static final Long TENANT_SECURITYADMIN_ROLE = 1450785935166925011L;
    private static final Long SECURITYADMIN_ROLE = 1450785135866925068L;
    @Autowired
    private ISysAppVisitRoleOrganDataAuthorityService roleOrganDataAuthorityService;
    @Autowired
    private ISysAppVisitDataLogicService sysAppVisitDataLogicService;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private ISysRolesExternalService sysRolesService;
    @Resource
    private IHussarBaseUserBoService userRoleService;
    @Resource
    private INoCodeAppDevelopTeamService noCodeAppDevelopTeamService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private IPermissionService permissionService;
    @Resource
    private ISysRoleFunctionsBoService sysRoleFunctionsBoService;
    @Resource
    private ISysFunctionsBoService sysFunctionsBoService;
    @Resource
    private IHussarBaseResourceService hussarBaseResourceService;
    @Resource
    private ISysAppVisitRoleFieldBoService sysAppVisitRoleFieldBoService;

    public ApiResponse<List<Long>> getAuthorityFormList(Long appId) {
        boolean isTenantAdmin;
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        SysApplication app = (SysApplication)HussarCacheUtil.get((String)_TABLE_QUERY_APP, (Object)appId, SysApplication.class);
        if (HussarUtils.isEmpty((Object)app)) {
            app = this.applicationService.getAppDetailById(appId);
            HussarCacheUtil.put((String)_TABLE_QUERY_APP, (Object)appId, (Object)app, (long)3600L);
        }
        boolean isInDevelopTeam = this.noCodeAppDevelopTeamService.checkCurrentUserInTeam(appId);
        boolean bl = isTenantAdmin = HussarUtils.isNotEmpty((Object)securityUser.getRolesList()) && (securityUser.getRolesList().contains(TenantConstant.ADMIN_ROLE) || securityUser.getRolesList().contains(TENANT_SYSTEM_ADMIN_ROLE) || securityUser.getRolesList().contains(SYSTEM_ADMIN_ROLE) || securityUser.getRolesList().contains(TENANT_SECURITYADMIN_ROLE) || securityUser.getRolesList().contains(SECURITYADMIN_ROLE));
        if (securityUser.isSuperAdmin() || securityUser.getId().equals(app.getCreator()) || isInDevelopTeam || isTenantAdmin) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId);
            List sysForms = this.sysFormService.list((Wrapper)queryWrapper);
            List sysFormIds = sysForms.stream().map(SysForm::getId).collect(Collectors.toList());
            return ApiResponse.success(sysFormIds);
        }
        if (HussarUtils.isNotEmpty((Object)securityUser.getRolesList())) {
            return ApiResponse.success((Object)this.permissionService.getAuthorityFormList(securityUser.getRolesList(), appId));
        }
        return ApiResponse.success(new ArrayList());
    }

    public ApiResponse<List<Long>> getAuthFormListByUserId(Long userId, Long appId) {
        boolean isSuperAdmin;
        Long creator;
        List<Long> roleIds = this.getRoleIds(userId);
        boolean isCreator = false;
        SysApplicationVo app = this.applicationService.getAppDetailById(appId);
        if (HussarUtils.isNotEmpty((Object)app) && HussarUtils.isNotEmpty((Object)(creator = app.getCreator()))) {
            isCreator = userId.equals(creator);
        }
        boolean isInDevelopTeam = this.noCodeAppDevelopTeamService.checkUserInTeam(appId, userId);
        boolean bl = isSuperAdmin = HussarUtils.isNotEmpty(roleIds) && roleIds.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue());
        if (HussarUtils.isEmpty(roleIds)) {
            return ApiResponse.success(new ArrayList());
        }
        if (isSuperAdmin || isCreator || isInDevelopTeam) {
            return ApiResponse.success((Object)this.sysFunctionsBoService.getAuthorityFormList(null, appId));
        }
        return ApiResponse.success((Object)this.sysFunctionsBoService.getAuthorityFormList(roleIds, appId));
    }

    private List<Long> getRoleIds(Long userId) {
        List userRoles = this.userRoleService.listUserRolesByUserId(userId);
        List<Long> roleIds = userRoles.stream().map(SysUserRole::getGrantedRole).collect(Collectors.toList());
        HashMap queryParams = new HashMap();
        return roleIds;
    }

    public ApiResponse<Boolean> checkRolePermissions(Long formId) {
        UserDetails userDetails;
        boolean isTenantAdmin;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            return ApiResponse.success((Object)true);
        }
        boolean bl = isTenantAdmin = HussarUtils.isNotEmpty((Object)user.getRolesList()) && (user.getRolesList().contains(TenantConstant.ADMIN_ROLE) || user.getRolesList().contains(TENANT_SYSTEM_ADMIN_ROLE) || user.getRolesList().contains(SYSTEM_ADMIN_ROLE) || user.getRolesList().contains(TENANT_SECURITYADMIN_ROLE) || user.getRolesList().contains(SECURITYADMIN_ROLE));
        if (user.isSuperAdmin() || isTenantAdmin) {
            return ApiResponse.success((Object)true);
        }
        SysForm form = (SysForm)HussarCacheUtil.get((String)TABLE_QUERY_FROM, (Object)formId, SysForm.class);
        if (HussarUtils.isEmpty((Object)form)) {
            form = this.applicationService.getFormDetailById(formId);
            HussarCacheUtil.put((String)TABLE_QUERY_FROM, (Object)formId, (Object)form, (long)3600L);
        }
        if (HussarUtils.isEmpty((Object)form)) {
            return ApiResponse.success((Object)false);
        }
        SysApplication app = (SysApplication)HussarCacheUtil.get((String)_TABLE_QUERY_APP, (Object)form.getAppId(), SysApplication.class);
        if (HussarUtils.isEmpty((Object)app)) {
            app = this.applicationService.getAppDetailById(form.getAppId());
            HussarCacheUtil.put((String)_TABLE_QUERY_APP, (Object)form.getAppId(), (Object)app, (long)3600L);
        }
        if (HussarUtils.isEmpty((Object)app)) {
            return ApiResponse.success((Object)false);
        }
        if (user.getId().equals(app.getCreator())) {
            return ApiResponse.success((Object)true);
        }
        List formRoleIds = this.sysRoleFunctionsBoService.getRoleIdsByFormId(formId);
        if (HussarUtils.isEmpty((Object)formRoleIds)) {
            return ApiResponse.success((Object)false);
        }
        HashSet authorizeRoleIds = new HashSet();
        if (HussarUtils.isNotEmpty((Object)formRoleIds)) {
            authorizeRoleIds.addAll(formRoleIds);
        }
        if ((userDetails = HussarSecurityUtils.getLoginUserDetails()) == null) {
            userDetails = (UserDetails)TransmittableThreadLocalHolder.get((String)"loginUserDetails");
        }
        Map extendUserMap = userDetails.getExtendUserMap();
        ArrayList roleIds = new ArrayList();
        Object rolesList = extendUserMap.get("rolesList");
        List longs = JSON.parseArray((String)JSON.toJSONString(rolesList), Long.class);
        if (HussarUtils.isNotEmpty(rolesList)) {
            roleIds.addAll(longs);
        }
        roleIds.retainAll(authorizeRoleIds);
        return ApiResponse.success((Object)(!roleIds.isEmpty() ? 1 : 0));
    }

    public Map<Long, List<SysAppVisitFormAuthorizeRolesDto>> listFormAuthorizedByAppId(final Long appId, final Long roleId, Long formId) {
        HashMap<Long, List<SysAppVisitFormAuthorizeRolesDto>> formAuthorityVoMap = new HashMap<Long, List<SysAppVisitFormAuthorizeRolesDto>>();
        QueryAppFuncResDto queryAppFuncResDto = new QueryAppFuncResDto();
        queryAppFuncResDto.setAppId(appId);
        queryAppFuncResDto.setRoleId(roleId);
        queryAppFuncResDto.setFormId(formId);
        List resourceList = this.hussarBaseResourceService.getResourceList(queryAppFuncResDto).stream().filter(item -> "res_menu".equals(item.getResTypeId())).collect(Collectors.toList());
        for (final SysResources resource : resourceList) {
            formAuthorityVoMap.put(HussarUtils.toLong((Object)resource.getModuleId()), (List<SysAppVisitFormAuthorizeRolesDto>)new ArrayList<SysAppVisitFormAuthorizeRolesDto>(){
                {
                    this.add(new SysAppVisitFormAuthorizeRolesDto(){
                        {
                            this.setAppId(appId);
                            this.setFormId(HussarUtils.toLong((Object)resource.getModuleId()));
                            this.setRoleId(roleId);
                        }
                    });
                }
            });
        }
        return formAuthorityVoMap;
    }

    public boolean checkFormAuthority(String formId) {
        boolean isTenantAdmin;
        SecurityUser user = NoCodeSecurityUtil.getUser();
        boolean bl = isTenantAdmin = HussarUtils.isNotEmpty((Object)user.getRolesList()) && (user.getRolesList().contains(TenantConstant.ADMIN_ROLE) || user.getRolesList().contains(TENANT_SYSTEM_ADMIN_ROLE) || user.getRolesList().contains(SYSTEM_ADMIN_ROLE) || user.getRolesList().contains(TENANT_SECURITYADMIN_ROLE) || user.getRolesList().contains(SECURITYADMIN_ROLE));
        if (user.isSuperAdmin() || isTenantAdmin) {
            return true;
        }
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        Long appId = sysForm.getAppId();
        SysApplicationVo sysApplication = this.applicationService.getAppDetailById(appId);
        Long developRoleId = sysApplication.getDevelopRoleId();
        List rolesList = user.getRolesList();
        if (rolesList.contains(developRoleId)) {
            return true;
        }
        if (HussarUtils.isNotEmpty((Object)rolesList)) {
            List roleIds = this.sysRoleFunctionsBoService.getRoleIdsByFormId(Long.valueOf(formId));
            if (HussarUtils.isEmpty((Object)roleIds)) {
                return false;
            }
            return rolesList.stream().anyMatch(roleIds::contains);
        }
        return false;
    }

    public Boolean getFormAuth(Long appId, Long formId) {
        boolean isTenantAdmin;
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        SysApplication app = (SysApplication)HussarCacheUtil.get((String)_TABLE_QUERY_APP, (Object)appId, SysApplication.class);
        if (HussarUtils.isEmpty((Object)app)) {
            app = this.applicationService.getAppDetailById(appId);
            HussarCacheUtil.put((String)_TABLE_QUERY_APP, (Object)appId, (Object)app, (long)3600L);
        }
        boolean isInDevelopTeam = this.noCodeAppDevelopTeamService.checkCurrentUserInTeam(appId);
        boolean bl = isTenantAdmin = HussarUtils.isNotEmpty((Object)securityUser.getRolesList()) && (securityUser.getRolesList().contains(TenantConstant.ADMIN_ROLE) || securityUser.getRolesList().contains(TENANT_SYSTEM_ADMIN_ROLE) || securityUser.getRolesList().contains(SYSTEM_ADMIN_ROLE) || securityUser.getRolesList().contains(TENANT_SECURITYADMIN_ROLE) || securityUser.getRolesList().contains(SECURITYADMIN_ROLE));
        if (securityUser.isSuperAdmin() || securityUser.getId().equals(app.getCreator()) || isInDevelopTeam || isTenantAdmin) {
            return true;
        }
        if (HussarUtils.isNotEmpty((Object)securityUser.getRolesList())) {
            List authorityFormList = this.permissionService.getAuthorityFormList(securityUser.getRolesList(), appId);
            return HussarUtils.isNotEmpty((Object)authorityFormList) && authorityFormList.contains(formId);
        }
        return false;
    }
}

