/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamBoService;
import com.jxdinfo.hussar.application.service.ISysAppGroupBoService;
import com.jxdinfo.hussar.application.service.ISysAppRecycleBoService;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.app.frame.server.enmus.FormTypeEnum;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppGroupInfoTreeDto;
import com.jxdinfo.hussar.formdesign.application.application.enums.AppGroupInfoTreeEnum;
import com.jxdinfo.hussar.formdesign.application.application.enums.SysUserRoleEnum;
import com.jxdinfo.hussar.formdesign.application.application.service.INoCodeAppDevelopTeamService;
import com.jxdinfo.hussar.formdesign.application.application.service.INoCodeAppVisitAuthorizationService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.utils.AppGroupInfoTreeUtil;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullService;
import com.jxdinfo.hussar.formdesign.application.extapi.service.ISysFormExtApiService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormGroupService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormGroupVo;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.lefttree.service.INavLeftTreeOrderService;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushConfigService;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleInfoService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CustomViewService;
import com.jxdinfo.hussar.formdesign.no.code.util.ModuleVerifyUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.sysApplicationServiceImpl")
public class SysApplicationServiceImpl
implements ISysApplicationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysApplicationServiceImpl.class);
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Autowired
    private ISysAppRecycleBoService sysAppRecycleBoService;
    @Resource
    private ISysAppGroupBoService sysAppGroupBoService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysFormGroupService sysFormGroupService;
    @Resource
    private ISysFormService formService;
    @Resource
    private INoCodeAppVisitAuthorizationService noCodeAppVisitAuthorizationService;
    @Resource
    private INoCodeAppDevelopTeamService noCodeAppDevelopTeamService;
    @Resource
    private ISysAppDevelopTeamBoService appDevelopTeamBoService;
    @Resource
    private ISysAppRecycleBoService appRecycleBoService;
    @Resource
    private ISysFormCheckConfigService sysFormCheckConfigService;
    @Resource
    private SysMsgPushConfigService msgPushConfigService;
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Resource
    private ISysFormLinkService sysFormLinkService;
    @Resource
    private SysDataPullService pullDataService;
    @Resource
    private PushDataService pushDataService;
    @Resource
    private ISysRuleInfoService ruleInfoService;
    @Resource
    private CustomViewService customViewService;
    @Resource
    private INavLeftTreeOrderService navLeftTreeOrderService;
    @Resource
    private ISysFormExtApiService sysFormExtApiService;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    private static final Long TENANT_SYSTEM_ADMIN_ROLE = 1450715195867925063L;
    private static final Long SYSTEM_ADMIN_ROLE = 1450785135866925067L;
    private static final Long TENANT_SECURITYADMIN_ROLE = 1450785935166925011L;
    private static final Long SECURITYADMIN_ROLE = 1450785135866925068L;
    private static final Long ALL_STAFF = -1L;
    private static final String STATUS_DISABLE = "0";

    public List<SysAppGroupVo> getAppList(String appName) {
        ArrayList<SysApplicationVo> appList = new ArrayList<SysApplicationVo>();
        ArrayList<Long> groupIds = new ArrayList<Long>();
        List<Object> appIds = new ArrayList();
        List applicationVoList = new ArrayList();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.isSuperAdmin() || user.getRolesList().contains(SysUserRoleEnum.APPLICATIONADMIN.getValue()) || user.getRolesList().contains(SysUserRoleEnum.TENANT_ROLE.getValue())) {
            applicationVoList = this.sysApplicationBoService.getAppListManage(null, appName, null, "");
            if (applicationVoList.isEmpty()) {
                return null;
            }
        } else {
            appIds = this.getCurrentUserAuthorityApp();
            if (HussarUtils.isEmpty(appIds)) {
                return null;
            }
            applicationVoList = this.sysApplicationBoService.getAppList(appName, appIds);
        }
        for (com.jxdinfo.hussar.application.vo.SysApplicationVo app : applicationVoList) {
            SysApplicationVo vo = new SysApplicationVo();
            BeanUtils.copyProperties((Object)app, (Object)vo);
            appList.add(vo);
        }
        for (SysApplicationVo sysApplicationVo : appList) {
            groupIds.add(sysApplicationVo.getAppGroupId());
        }
        ArrayList<SysAppGroup> sysAppGroups = new ArrayList();
        if (HussarUtils.isNotEmpty(groupIds)) {
            sysAppGroups = this.sysAppGroupBoService.getAppGroupByIds(groupIds);
        }
        ArrayList<SysApplicationVo> appListVo = new ArrayList<SysApplicationVo>();
        for (SysApplicationVo app : appList) {
            SysApplicationVo vo = new SysApplicationVo();
            BeanUtils.copyProperties((Object)app, (Object)vo);
            appListVo.add(vo);
        }
        return this.combinedData(appListVo, sysAppGroups);
    }

    public List<SysAppGroupVo> getManageAppList(Long appGroupId, String appName, String appStatus) {
        List appIds;
        ArrayList appListVo = Lists.newArrayListWithCapacity((int)10);
        SecurityUser user = BaseSecurityUtil.getUser();
        ArrayList<SysApplicationVo> appList = new ArrayList<SysApplicationVo>();
        List sysAppGroups = new ArrayList();
        if (user.isSuperAdmin() || user.getRolesList().contains(SysUserRoleEnum.APPLICATIONADMIN.getValue()) || user.getRolesList().contains(SysUserRoleEnum.TENANT_ROLE.getValue())) {
            List applicationVoList = new ArrayList();
            applicationVoList = this.sysApplicationBoService.getAppListManage(appGroupId, appName, null, appStatus);
            for (Object app : applicationVoList) {
                SysApplicationVo sysApplicationVo = new SysApplicationVo();
                BeanUtils.copyProperties((Object)app, (Object)sysApplicationVo);
                appList.add(sysApplicationVo);
            }
            if (HussarUtils.isEmpty((Object)appGroupId) && HussarUtils.isEmpty((Object)appName) && HussarUtils.isEmpty((Object)appStatus)) {
                sysAppGroups = this.sysAppGroupBoService.list();
            } else {
                LinkedHashSet groupIds = Sets.newLinkedHashSetWithExpectedSize((int)10);
                for (SysApplication sysApplication : appList) {
                    groupIds.add(sysApplication.getAppGroupId());
                }
                if (HussarUtils.isNotEmpty((Object)appGroupId)) {
                    groupIds.add(appGroupId);
                }
                if (HussarUtils.isNotEmpty((Object)groupIds)) {
                    sysAppGroups = this.sysAppGroupBoService.getAppGroup(null, new ArrayList(groupIds));
                }
            }
        } else {
            appIds = this.noCodeAppDevelopTeamService.selectAppListByCurrentUser();
            if (HussarUtils.isEmpty((Object)appIds)) {
                if (HussarUtils.isNotEmpty((Object)appGroupId)) {
                    sysAppGroups = this.sysAppGroupBoService.getAppGroupById(appGroupId);
                    return this.combinedData(appListVo, sysAppGroups);
                }
                return Lists.newArrayListWithCapacity((int)0);
            }
            List applicationVoList = new ArrayList();
            applicationVoList = this.sysApplicationBoService.getAppListManage(appGroupId, appName, appIds, appStatus);
            for (com.jxdinfo.hussar.application.vo.SysApplicationVo sysApplicationVo : applicationVoList) {
                SysApplicationVo vo = new SysApplicationVo();
                BeanUtils.copyProperties((Object)sysApplicationVo, (Object)vo);
                appList.add(vo);
            }
            if (HussarUtils.isEmpty(appList)) {
                if (HussarUtils.isNotEmpty((Object)appGroupId)) {
                    sysAppGroups = this.sysAppGroupBoService.getAppGroupById(appGroupId);
                    return this.combinedData(appListVo, sysAppGroups);
                }
                return Lists.newArrayListWithCapacity((int)0);
            }
            Set groupIds = appList.stream().map(SysApplication::getAppGroupId).collect(Collectors.toSet());
            if (HussarUtils.isNotEmpty((Object)appGroupId) || HussarUtils.isNotEmpty((Object)appName) || HussarUtils.isNotEmpty((Object)appStatus)) {
                if (HussarUtils.isNotEmpty((Object)appGroupId)) {
                    groupIds.add(appGroupId);
                }
                sysAppGroups = this.sysAppGroupBoService.getAppGroupByIds(new ArrayList(groupIds));
            } else {
                sysAppGroups = this.sysAppGroupBoService.getAppGroup(BaseSecurityUtil.getUser().getUserId(), new ArrayList(groupIds));
            }
        }
        appIds = appList.stream().map(SysApplication::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(appIds)) {
            List sysAppDevelopTeams = this.appDevelopTeamBoService.selectAppDevelopTeamList(appIds);
            Map sysAppDevelopTeamMap = sysAppDevelopTeams.stream().collect(Collectors.toMap(SysAppDevelopTeam::getAppId, Function.identity()));
            for (SysApplicationVo app : appList) {
                SysApplicationVo vo = new SysApplicationVo();
                BeanUtils.copyProperties((Object)app, (Object)vo);
                if (null != sysAppDevelopTeamMap.get(vo.getId())) {
                    vo.setTeamId(((SysAppDevelopTeam)sysAppDevelopTeamMap.get(vo.getId())).getId());
                }
                appListVo.add(vo);
            }
        }
        return this.combinedData(appListVo, sysAppGroups);
    }

    public List<AppGroupInfoTreeDto> groupInfoTree() {
        ArrayList<AppGroupInfoTreeDto> tree = new ArrayList<AppGroupInfoTreeDto>();
        LOGGER.info("\u5f00\u59cb\u5904\u7406\u5e94\u7528\u5206\u7ec4");
        List sysAppGroups = this.sysAppGroupBoService.list().stream().peek(e -> e.setSEQ(Integer.valueOf(HussarUtils.isEmpty((Object)e.getSEQ()) ? 0 : e.getSEQ()))).sorted(Comparator.comparing(SysAppGroup::getSEQ)).collect(Collectors.toList());
        Map appGroupMap = sysAppGroups.stream().collect(Collectors.toMap(e -> String.valueOf(e.getId()), Function.identity()));
        ArrayList<AppGroupInfoTreeDto> appGroups = new ArrayList<AppGroupInfoTreeDto>();
        for (SysAppGroup sysAppGroup : sysAppGroups) {
            AppGroupInfoTreeDto appGroupInfoTreeDto = new AppGroupInfoTreeDto();
            appGroupInfoTreeDto.setFieldId(String.valueOf(sysAppGroup.getId()));
            appGroupInfoTreeDto.setFieldName(sysAppGroup.getGroupName());
            appGroupInfoTreeDto.setFieldType(AppGroupInfoTreeEnum.APP_GROUP.getValue());
            appGroupInfoTreeDto.setLeaf(false);
            appGroups.add(appGroupInfoTreeDto);
        }
        LOGGER.info("\u5f00\u59cb\u5904\u7406\u5e94\u7528");
        List sysApplications = this.sysApplicationBoService.list().stream().filter(e -> HussarUtils.equals((Object)e.getAppType(), (Object)"1")).peek(e -> e.setAppSeq(Integer.valueOf(HussarUtils.isEmpty((Object)e.getAppSeq()) ? 0 : e.getAppSeq()))).sorted(Comparator.comparing(SysApplication::getAppSeq)).collect(Collectors.toList());
        Map applicationMap = sysApplications.stream().collect(Collectors.toMap(e -> String.valueOf(e.getId()), Function.identity()));
        ArrayList<AppGroupInfoTreeDto> appLications = new ArrayList<AppGroupInfoTreeDto>();
        for (SysApplication sysApplication : sysApplications) {
            AppGroupInfoTreeDto appGroupInfoTreeDto = new AppGroupInfoTreeDto();
            appGroupInfoTreeDto.setFieldId(String.valueOf(sysApplication.getId()));
            appGroupInfoTreeDto.setFieldName(sysApplication.getAppName());
            appGroupInfoTreeDto.setFieldType(AppGroupInfoTreeEnum.APP.getValue());
            appGroupInfoTreeDto.setLeaf(false);
            String parentId = String.valueOf(sysApplication.getAppGroupId());
            SysAppGroup sysAppGroup = (SysAppGroup)appGroupMap.get(parentId);
            if (HussarUtils.isEmpty((Object)sysAppGroup)) continue;
            appGroupInfoTreeDto.setParentId(parentId);
            appGroupInfoTreeDto.setParentName(sysAppGroup.getGroupName());
            appGroupInfoTreeDto.setParentType(AppGroupInfoTreeEnum.APP_GROUP.getValue());
            appLications.add(appGroupInfoTreeDto);
        }
        LOGGER.info("\u5f00\u59cb\u5904\u7406\u8868\u5355\u5206\u7ec4");
        List sysFormGroups = this.sysFormGroupService.list().stream().peek(e -> e.setSeq(Integer.valueOf(HussarUtils.isEmpty((Object)e.getSeq()) ? 0 : e.getSeq()))).sorted(Comparator.comparing(SysFormGroup::getSeq)).collect(Collectors.toList());
        Map formGroupMap = sysFormGroups.stream().collect(Collectors.toMap(e -> String.valueOf(e.getId()), Function.identity()));
        ArrayList<Object> formGroups = new ArrayList<Object>();
        for (SysFormGroup sysFormGroup : sysFormGroups) {
            AppGroupInfoTreeDto appGroupInfoTreeDto = new AppGroupInfoTreeDto();
            appGroupInfoTreeDto.setFieldId(String.valueOf(sysFormGroup.getId()));
            appGroupInfoTreeDto.setFieldName(sysFormGroup.getGroupName());
            appGroupInfoTreeDto.setFieldType(AppGroupInfoTreeEnum.FORM_GROUP.getValue());
            appGroupInfoTreeDto.setLeaf(false);
            String parentId = String.valueOf(sysFormGroup.getAppId());
            SysApplication sysApplication = (SysApplication)applicationMap.get(parentId);
            if (HussarUtils.isEmpty((Object)sysApplication)) continue;
            appGroupInfoTreeDto.setParentId(parentId);
            appGroupInfoTreeDto.setParentName(sysApplication.getAppName());
            appGroupInfoTreeDto.setParentType(AppGroupInfoTreeEnum.APP.getValue());
            formGroups.add(appGroupInfoTreeDto);
        }
        LOGGER.info("\u5f00\u59cb\u5904\u7406\u8868\u5355");
        List sysForms = this.sysFormService.list().stream().filter(item -> HussarUtils.equals((Object)FormTypeEnum.FLOW_FORM.getFormType(), (Object)item.getFormType()) || HussarUtils.equals((Object)FormTypeEnum.NORMAL_FORM.getFormType(), (Object)item.getFormType())).peek(e -> e.setSeq(HussarUtils.isEmpty((Object)e.getSeq()) ? 0 : e.getSeq())).sorted(Comparator.comparing(SysForm::getSeq)).collect(Collectors.toList());
        ArrayList<AppGroupInfoTreeDto> forms = new ArrayList<AppGroupInfoTreeDto>();
        for (SysForm sysForm : sysForms) {
            AppGroupInfoTreeDto appGroupInfoTreeDto = new AppGroupInfoTreeDto();
            appGroupInfoTreeDto.setFieldId(String.valueOf(sysForm.getId()));
            appGroupInfoTreeDto.setFieldName(sysForm.getFormName());
            appGroupInfoTreeDto.setFieldType(AppGroupInfoTreeEnum.FORM.getValue());
            appGroupInfoTreeDto.setLeaf(true);
            Long formGroupId = sysForm.getFormGroupId();
            if (HussarUtils.isEmpty((Object)formGroupId) || HussarUtils.equals((Object)formGroupId, (Object)"")) {
                String parentId = String.valueOf(sysForm.getAppId());
                SysApplication sysApplication = (SysApplication)applicationMap.get(parentId);
                if (HussarUtils.isEmpty((Object)sysApplication)) continue;
                appGroupInfoTreeDto.setParentId(parentId);
                appGroupInfoTreeDto.setParentName(sysApplication.getAppName());
                appGroupInfoTreeDto.setParentType(AppGroupInfoTreeEnum.APP.getValue());
            } else {
                SysFormGroup sysFormGroup = (SysFormGroup)formGroupMap.get(String.valueOf(formGroupId));
                if (HussarUtils.isEmpty((Object)sysFormGroup)) continue;
                appGroupInfoTreeDto.setParentId(String.valueOf(formGroupId));
                appGroupInfoTreeDto.setParentName(sysFormGroup.getGroupName());
                appGroupInfoTreeDto.setParentType(AppGroupInfoTreeEnum.FORM_GROUP.getValue());
            }
            forms.add(appGroupInfoTreeDto);
        }
        tree.addAll(appGroups);
        tree.addAll(appLications);
        tree.addAll(formGroups);
        tree.addAll(forms);
        List<AppGroupInfoTreeDto> finalTree = AppGroupInfoTreeUtil.dealTree(tree);
        return finalTree;
    }

    public ApiResponse<SysApplicationVo> getAppDetail(Long appId) {
        SysApplicationVo sysApplicationVo = null;
        com.jxdinfo.hussar.application.vo.SysApplicationVo lowCodeSysApplicationVo = this.sysApplicationBoService.getAppDetailContainUserName(appId);
        if (HussarUtils.isEmpty((Object)lowCodeSysApplicationVo)) {
            return ApiResponse.success(sysApplicationVo);
        }
        sysApplicationVo = new SysApplicationVo();
        BeanUtils.copyProperties((Object)lowCodeSysApplicationVo, (Object)sysApplicationVo);
        return ApiResponse.success((Object)sysApplicationVo);
    }

    public SysApplicationVo getAuthorityAppDetail(Long appId) {
        List dataFormGroup;
        SysApplicationVo appDetail = new SysApplicationVo();
        com.jxdinfo.hussar.application.vo.SysApplicationVo lowCodeSysApplicationVo = this.sysApplicationBoService.getAppDetail(appId);
        BeanUtils.copyProperties((Object)lowCodeSysApplicationVo, (Object)appDetail);
        AssertUtil.isNotNull((Object)appDetail, (String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        SecurityUser user = BaseSecurityUtil.getUser();
        boolean designedOrNotFlag = false;
        List dataForm = (List)this.formService.getSysFormByAppId(appId).getData();
        if (HussarUtils.isNotEmpty((Object)dataForm)) {
            designedOrNotFlag = true;
        }
        if (!designedOrNotFlag && HussarUtils.isNotEmpty((Object)(dataFormGroup = (List)this.sysFormGroupService.getFormGroupList(appId).getData()))) {
            designedOrNotFlag = true;
        }
        Boolean hasAuthorityCreateForm = user.isSuperAdmin() || user.getRolesList().contains(SysUserRoleEnum.APPLICATIONADMIN.getValue()) || user.getRolesList().contains(SysUserRoleEnum.TENANT_ROLE.getValue()) ? Boolean.valueOf(true) : this.noCodeAppDevelopTeamService.checkCurrentUserInTeam(appId);
        appDetail.setDesignedOrNot(Boolean.valueOf(designedOrNotFlag));
        appDetail.setHasAuthorityCreateForm(hasAuthorityCreateForm);
        return appDetail;
    }

    public Boolean updateSecretKey(Long appId) {
        SysApplicationDto sysApplicationDto = new SysApplicationDto();
        sysApplicationDto.setId(appId);
        sysApplicationDto.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        return this.sysApplicationBoService.updateApp(sysApplicationDto);
    }

    public String getCurrentCode() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    private List<SysAppGroupVo> combinedData(List<SysApplicationVo> appList, List<SysAppGroup> sysAppGroups) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysAppGroups), SysAppGroupVo.class).stream().collect(Collectors.toMap(SysAppGroup::getId, sysAppGroupVo -> sysAppGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysApplicationVo sysApplication : appList) {
            SysAppGroupVo sysAppGroupVo2 = (SysAppGroupVo)resultCollect.get(sysApplication.getAppGroupId());
            if (HussarUtils.isEmpty((Object)sysAppGroupVo2)) continue;
            if (HussarUtils.isNotEmpty((Object)sysAppGroupVo2.getSysApplicationList())) {
                sysAppGroupVo2.getSysApplicationList().add(sysApplication);
            }
            if (!HussarUtils.isEmpty((Object)sysAppGroupVo2.getSysApplicationList())) continue;
            ArrayList<SysApplicationVo> sysApplicationList = new ArrayList<SysApplicationVo>();
            sysApplicationList.add(sysApplication);
            sysAppGroupVo2.setSysApplicationList(sysApplicationList);
        }
        return new ArrayList<SysAppGroupVo>(resultCollect.values());
    }

    public Boolean validateAuthorityByAppId(Long appId) {
        HashSet currentUserRoleSet;
        Sets.SetView intersectionSet;
        boolean isTenantAdmin;
        SecurityUser user = BaseSecurityUtil.getUser();
        boolean isInDevelopTeam = this.noCodeAppDevelopTeamService.checkCurrentUserInTeam(appId);
        boolean bl = isTenantAdmin = HussarUtils.isNotEmpty((Object)user.getRolesList()) && (user.getRolesList().contains(TenantConstant.ADMIN_ROLE) || user.getRolesList().contains(TENANT_SYSTEM_ADMIN_ROLE) || user.getRolesList().contains(SYSTEM_ADMIN_ROLE) || user.getRolesList().contains(TENANT_SECURITYADMIN_ROLE) || user.getRolesList().contains(SECURITYADMIN_ROLE));
        if (user.isSuperAdmin() || isInDevelopTeam || isTenantAdmin) {
            return true;
        }
        SysApplicationVo app = new SysApplicationVo();
        com.jxdinfo.hussar.application.vo.SysApplicationVo lowCodeSysApplicationVo = this.sysApplicationBoService.getAppDetail(appId);
        BeanUtils.copyProperties((Object)lowCodeSysApplicationVo, (Object)app);
        if (user.getId().equals(app.getCreator())) {
            return true;
        }
        if (HussarUtils.equals((Object)STATUS_DISABLE, (Object)app.getAppStatus())) {
            return false;
        }
        ApiResponse appRoleList = this.noCodeAppVisitAuthorizationService.getAppRoleList(appId);
        List roleVoList = (List)appRoleList.getData();
        if (HussarUtils.isEmpty((Object)roleVoList)) {
            return false;
        }
        List roleIdList = roleVoList.stream().map(RoleVo::getId).collect(Collectors.toList());
        if (roleIdList.contains(ALL_STAFF)) {
            return true;
        }
        Map extendUserMap = user.getExtendUserMap();
        Set authorityRoleSet = roleVoList.stream().map(RoleVo::getId).collect(Collectors.toSet());
        List currentUserRoleList = user.getRolesList();
        currentUserRoleList.add(user.getId());
        if (HussarUtils.isNotEmpty((Object)extendUserMap) && HussarUtils.isNotEmpty(extendUserMap.get("deptId"))) {
            currentUserRoleList.add(Long.valueOf(extendUserMap.get("deptId").toString()));
        }
        if (HussarUtils.isNotEmpty((Object)extendUserMap) && HussarUtils.isNotEmpty(extendUserMap.get("postId"))) {
            currentUserRoleList.add(Long.valueOf(extendUserMap.get("postId").toString()));
        }
        return !HussarUtils.isEmpty((Object)(intersectionSet = Sets.intersection(authorityRoleSet, currentUserRoleSet = new HashSet(currentUserRoleList))));
    }

    public List<Long> getCurrentUserAuthorityApp() {
        return this.noCodeAppVisitAuthorizationService.getCurrentUserAuthorityApp();
    }

    public List<SysApplicationVo> getAppContainFormInfoList() {
        ArrayList resultApps = Lists.newArrayListWithCapacity((int)10);
        List appIds = this.noCodeAppDevelopTeamService.selectAppListByCurrentUser();
        if (HussarUtils.isEmpty((Object)appIds)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList<SysApplicationVo> appList = new ArrayList<SysApplicationVo>();
        List applicationVoList = new ArrayList();
        applicationVoList = this.sysApplicationBoService.getAppListManage(null, null, appIds, null);
        for (com.jxdinfo.hussar.application.vo.SysApplicationVo app : applicationVoList) {
            SysApplicationVo vo = new SysApplicationVo();
            BeanUtils.copyProperties((Object)app, (Object)vo);
            appList.add(vo);
        }
        List sysForms = this.sysFormService.getFormsByAppIds(appIds);
        if (HussarUtils.isEmpty((Object)sysForms)) {
            return resultApps;
        }
        List sysFormGroups = this.sysFormGroupService.getFormGroupsByAppIds(appIds);
        ArrayList<SysFormGroupVo> formGroupTreeVos = new ArrayList<SysFormGroupVo>();
        if (HussarUtils.isNotEmpty((Object)sysFormGroups)) {
            for (SysFormGroup sysFormGroup : sysFormGroups) {
                SysFormGroupVo formGroupTreeVo2 = new SysFormGroupVo();
                formGroupTreeVo2.setId(sysFormGroup.getId());
                formGroupTreeVo2.setGroupName(sysFormGroup.getGroupName());
                formGroupTreeVo2.setAppId(sysFormGroup.getAppId());
                List haveGroupForms = sysForms.stream().filter(sysForm -> HussarUtils.equals((Object)sysFormGroup.getId(), (Object)sysForm.getFormGroupId())).collect(Collectors.toList());
                formGroupTreeVo2.setSysFormList(haveGroupForms);
                formGroupTreeVos.add(formGroupTreeVo2);
            }
        }
        for (SysApplicationVo applicationVo : appList) {
            SysApplicationVo appTreeVo = new SysApplicationVo();
            appTreeVo.setId(applicationVo.getId());
            appTreeVo.setAppName(applicationVo.getAppName());
            List noGroupForms = sysForms.stream().filter(sysForm -> HussarUtils.equals((Object)appTreeVo.getId(), (Object)sysForm.getAppId()) && HussarUtils.isEmpty((Object)sysForm.getFormGroupId())).collect(Collectors.toList());
            appTreeVo.setNoGroupList(noGroupForms);
            if (HussarUtils.isNotEmpty(formGroupTreeVos)) {
                List formGroupTreesOfApp = formGroupTreeVos.stream().filter(formGroupTreeVo -> HussarUtils.equals((Object)formGroupTreeVo.getAppId(), (Object)appTreeVo.getId())).collect(Collectors.toList());
                appTreeVo.setSysFormGroupVos(formGroupTreesOfApp);
            }
            resultApps.add(appTreeVo);
        }
        return resultApps;
    }

    public String getNewAppName() {
        String appName = "\u672a\u547d\u540d\u5e94\u7528";
        return this.getNewAppName(appName);
    }

    public String getUniqueAppName(String appName) {
        if (HussarUtils.isNotEmpty((Object)appName) && appName.length() > 19) {
            appName = appName.substring(0, 19);
        }
        return this.getNewAppName(appName);
    }

    public Boolean updateApp(SysApplicationDto sysApplicationDto) {
        return this.sysApplicationBoService.updateApp(sysApplicationDto);
    }

    private String getNewAppName(String appName) {
        ArrayList appNames = new ArrayList();
        List apps = this.sysApplicationBoService.list();
        List recycles = this.appRecycleBoService.getAllSysAppRecycle();
        if (ObjectUtils.isNotEmpty((Object)apps)) {
            List appNameInDb = apps.stream().map(SysApplication::getAppName).collect(Collectors.toList());
            appNames.addAll(appNameInDb);
        }
        if (ObjectUtils.isNotEmpty((Object)recycles)) {
            List recycleAppNames = recycles.stream().map(SysAppRecycle::getAppName).collect(Collectors.toList());
            appNames.addAll(recycleAppNames);
        }
        int count = 1;
        String newAppName;
        while (appNames.contains(newAppName = appName + count)) {
            ++count;
        }
        return newAppName;
    }

    public Boolean delAppAdvancedInfo(Long appId, List<Long> allFormId) {
        try {
            LOGGER.info("\u5220\u9664\u5e94\u7528\u9ad8\u7ea7\u914d\u7f6e\u5f00\u59cb\uff0c\u5e94\u7528ID: {}", (Object)appId);
            if (HussarUtils.isEmpty(allFormId)) {
                allFormId = this.sysFormService.getAllFormId(appId);
            }
            this.sysFormCheckConfigService.deleteFormCheckConfigByAppId(appId, allFormId);
            LOGGER.info("\u5220\u9664\u8868\u5355\u6821\u9a8c\u914d\u7f6e\u5b8c\u6210");
            this.msgPushConfigService.deleteAllConfigByAppId(appId);
            LOGGER.info("\u5220\u9664\u6d88\u606f\u63a8\u9001\u914d\u7f6e\u5b8c\u6210");
            this.sysPrintTemplateService.deleteByAppId(appId, allFormId);
            LOGGER.info("\u5220\u9664\u6253\u5370\u6a21\u677f\u914d\u7f6e\u5b8c\u6210");
            allFormId.forEach(formId -> this.sysFormLinkService.deleteAllForm(formId));
            LOGGER.info("\u5220\u9664\u516c\u5f00\u53d1\u5e03\u914d\u7f6e\u5b8c\u6210");
            this.pullDataService.removeByAppId(appId);
            LOGGER.info("\u5220\u9664\u6570\u636e\u62c9\u53d6\u914d\u7f6e\u5b8c\u6210");
            this.pushDataService.deleteByAppId(appId);
            LOGGER.info("\u5220\u9664\u6570\u636e\u63a8\u9001\u914d\u7f6e\u5b8c\u6210");
            this.customViewService.deleteByAppId(appId);
            LOGGER.info("\u5220\u9664\u516c\u5171\u89c6\u56fe\u914d\u7f6e\u5b8c\u6210");
            this.navLeftTreeOrderService.deleteByAppId(appId);
            LOGGER.info("\u5220\u9664\u5de6\u4fa7\u6811\u914d\u7f6e\u5b8c\u6210");
            this.sysFormExtApiService.deleteByAppId(appId);
            LOGGER.info("\u5220\u9664\u81ea\u5b9a\u4e49\u63a5\u53e3\u914d\u7f6e\u5b8c\u6210");
            this.ruleInfoService.deleteRuleByAppId(appId);
            LOGGER.info("\u5220\u9664\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e\u5b8c\u6210");
            this.sysCustomButtonService.deleteByAppId(appId);
            LOGGER.info("\u5220\u9664\u81ea\u5b9a\u4e49\u6309\u94ae\u914d\u7f6e\u5b8c\u6210");
            return true;
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5e94\u7528\u9ad8\u7ea7\u914d\u7f6e\u5931\u8d25\uff0c\u5e94\u7528ID: {}", (Object)appId, (Object)e);
            return false;
        }
    }

    public void addAppAuth() {
        long limit = ModuleVerifyUtil.addAppVerify();
        if (limit < 0L) {
            throw new BaseException("\u4e0d\u5141\u8bb8\u521b\u5efa\u5e94\u7528");
        }
        if (limit > 0L) {
            int appRecycleCount;
            List applicationList = this.sysApplicationBoService.list();
            List appRecycles = this.sysAppRecycleBoService.getAllSysAppRecycle();
            int appCount = HussarUtils.isNotEmpty((Object)applicationList) ? applicationList.size() : 0;
            int n = appRecycleCount = HussarUtils.isNotEmpty((Object)appRecycles) ? appRecycles.size() : 0;
            if ((long)(appCount + appRecycleCount) >= limit) {
                throw new BaseException("\u6388\u6743\u9a8c\u8bc1\u5931\u8d25\uff0c\u6388\u6743\u53ef\u8bbe\u8ba1\u5e94\u7528\u6570\u91cf" + limit + ",\u5df2\u6709\u5e94\u7528\u6570\u91cf" + (appCount + appRecycleCount) + "\uff0c\u8bf7\u91cd\u65b0\u7533\u8bf7\u6388\u6743\uff01");
            }
        }
    }
}

