/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.permit.dto.IdsCollectionDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryStruRightFeignDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserRelationDto;
import com.jxdinfo.hussar.authorization.permit.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleUserRights;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitDataLogicBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitRoleFieldBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleStruRightBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleUserRightBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.relational.dto.RoleOrganRelationDto;
import com.jxdinfo.hussar.authorization.relational.dto.RolePostRelationDto;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppRoleService;
import com.jxdinfo.hussar.formdesign.application.authority.dto.SaveRoleMembersDto;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.appRoleServiceImpl")
public class AppRoleServiceImpl
implements IAppRoleService {
    @Resource
    private ISysRolesExternalService sysRolesExternalService;
    @Resource
    private ISysAppVisitRoleButtonService roleButtonService;
    @Resource
    private ISysAppVisitRoleFieldBoService sysAppVisitRoleFieldBoService;
    @Resource
    private ISysAppVisitDataLogicBoService sysAppVisitDataLogicBoService;
    @Resource
    private ISysRoleFunctionsBoService sysRoleFunctionsBoService;
    @Resource
    private ISysRoleResourceBoService sysRoleResourceBoService;
    @Resource
    private ISysRoleDataRightBoService sysRoleDataRightBoService;
    @Resource
    private ISysRoleStruRightBoService sysRoleStruRightBoService;
    @Resource
    private ISysRoleUserRightBoService sysRoleUserRightBoService;

    @HussarTransactional
    public Boolean delAppRole(Long roleId) {
        Boolean flag = this.sysRolesExternalService.delAppRole(roleId);
        this.delAppRoleNoCode(roleId);
        return flag;
    }

    @HussarTransactional
    public Long copyAppRole(Long roleId) {
        Long newRoleId = this.sysRolesExternalService.copyAppRole(roleId);
        this.copyAppRoleNoCode(roleId, newRoleId);
        return newRoleId;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean saveAppRoleMembers(SaveRoleMembersDto saveRoleMembersDto) {
        if (HussarUtils.isNotEmpty((Object)saveRoleMembersDto.getStruIds())) {
            RoleOrganRelationDto roleOrganRelationDto = new RoleOrganRelationDto();
            roleOrganRelationDto.setRoleId(saveRoleMembersDto.getRoleId());
            roleOrganRelationDto.setStruIds(saveRoleMembersDto.getStruIds());
            this.sysRolesExternalService.saveAppOrganRole(roleOrganRelationDto);
        }
        if (HussarUtils.isNotEmpty((Object)saveRoleMembersDto.getUserIds())) {
            RoleUserRelationDto roleUserRelationDto = new RoleUserRelationDto();
            roleUserRelationDto.setRoleId(saveRoleMembersDto.getRoleId());
            roleUserRelationDto.setUserIds(saveRoleMembersDto.getUserIds());
            this.sysRolesExternalService.saveAppUserRole(roleUserRelationDto);
        }
        if (HussarUtils.isNotEmpty((Object)saveRoleMembersDto.getPostIds())) {
            RolePostRelationDto rolePostRelationDto = new RolePostRelationDto();
            rolePostRelationDto.setRoleId(saveRoleMembersDto.getRoleId());
            rolePostRelationDto.setPostIds(saveRoleMembersDto.getPostIds());
            this.sysRolesExternalService.saveAppPostRole(rolePostRelationDto);
        }
        return Boolean.TRUE;
    }

    private void delAppRoleNoCode(Long roleId) {
        this.sysRoleFunctionsBoService.remove(Collections.singletonList(roleId), null);
        IdsCollectionDto idsCollectionDto = new IdsCollectionDto();
        idsCollectionDto.setRoleIds(Collections.singletonList(roleId));
        idsCollectionDto.setResIds(null);
        this.sysRoleResourceBoService.removeByRoleIdsAndResIds(idsCollectionDto);
        this.sysRoleDataRightBoService.deleteRoleDataRightByRoleIds(Collections.singletonList(roleId));
        this.sysRoleStruRightBoService.deleteRoleStruRightByRoleIds(Collections.singletonList(roleId));
        this.sysRoleUserRightBoService.deleteRoleUserRightByRoleIds(Collections.singletonList(roleId));
        this.sysAppVisitRoleFieldBoService.deleteSysAppVisitRoleField(null, null, roleId);
        this.sysAppVisitDataLogicBoService.deleteDataLogicByFormId(null, null, Arrays.asList(roleId));
    }

    private void copyAppRoleNoCode(Long sourceRoleId, Long targetRoleId) {
        this.copyAuthorizeRoles(sourceRoleId, targetRoleId);
        this.copyField(sourceRoleId, targetRoleId);
        this.copyDataLogic(sourceRoleId, targetRoleId);
    }

    private void copyAuthorizeRoles(Long sourceRoleId, Long targetRoleId) {
        ArrayList<Object> list;
        SysRoleFunctions item;
        ArrayList<SysRoleFunctions> list2;
        List roleFuncList = this.sysRoleFunctionsBoService.list(Collections.singletonList(sourceRoleId), null);
        List roleResList = this.sysRoleResourceBoService.getRoleResourceList(Collections.singletonList(sourceRoleId), null);
        List dataRightList = this.sysRoleDataRightBoService.list(Collections.singletonList(sourceRoleId), null);
        List struRightList = this.sysRoleStruRightBoService.listByRoleId(Collections.singletonList(sourceRoleId));
        QueryStruRightFeignDto feignDto = new QueryStruRightFeignDto();
        feignDto.setRoleIds(Collections.singletonList(sourceRoleId));
        List userRightList = this.sysRoleUserRightBoService.listUserRights(feignDto);
        if (HussarUtils.isNotEmpty((Object)roleFuncList)) {
            list2 = new ArrayList<SysRoleFunctions>();
            for (SysRoleFunctions roleFunction : roleFuncList) {
                item = new SysRoleFunctions();
                item.setRoleId(targetRoleId);
                item.setFunctionId(roleFunction.getFunctionId());
                list2.add(item);
            }
            this.sysRoleFunctionsBoService.saveBatch(list2);
        }
        if (HussarUtils.isNotEmpty((Object)roleResList)) {
            list2 = new ArrayList();
            for (SysRoleResource roleResource : roleResList) {
                item = new SysRoleResource();
                item.setRoleId(targetRoleId);
                item.setResourceId(roleResource.getResourceId());
                item.setRelationSource(roleResource.getRelationSource());
                list2.add(item);
            }
            this.sysRoleResourceBoService.saveBatch(list2);
        }
        HashMap<Long, Long> dataRightIdMap = new HashMap<Long, Long>();
        if (HussarUtils.isNotEmpty((Object)dataRightList)) {
            list = new ArrayList<Object>();
            for (SysRoleDataRight dataRight : dataRightList) {
                SysRoleDataRight roleDataRight = new SysRoleDataRight();
                Long id = IdWorker.getId((Object)roleDataRight);
                dataRightIdMap.put(dataRight.getDataRightsId(), id);
                roleDataRight.setDataRightsId(id);
                roleDataRight.setRoleId(targetRoleId);
                roleDataRight.setFunctionId(dataRight.getFunctionId());
                roleDataRight.setDataScope(dataRight.getDataScope());
                roleDataRight.setCustomDataCondition(dataRight.getCustomDataCondition());
                roleDataRight.setResTypeCode(dataRight.getResTypeCode());
                roleDataRight.setDataScopeLabel(dataRight.getDataScopeLabel());
                list.add(roleDataRight);
            }
            this.sysRoleDataRightBoService.saveBatch(list);
        }
        if (HussarUtils.isNotEmpty((Object)struRightList)) {
            list = new ArrayList();
            for (SysRoleStruRights struRight : struRightList) {
                if (HussarUtils.isEmpty(dataRightIdMap.get(struRight.getRoleDataRightsId()))) continue;
                SysRoleStruRights roleStruRight = new SysRoleStruRights();
                roleStruRight.setRoleId(targetRoleId);
                roleStruRight.setRoleDataRightsId((Long)dataRightIdMap.get(struRight.getRoleDataRightsId()));
                roleStruRight.setStruid(struRight.getStruid());
                list.add(roleStruRight);
            }
            this.sysRoleStruRightBoService.saveBatch(list);
        }
        if (HussarUtils.isNotEmpty((Object)userRightList)) {
            list = new ArrayList();
            for (SysRoleUserRights userRight : userRightList) {
                if (HussarUtils.isEmpty(dataRightIdMap.get(userRight.getRoleDataRightsId()))) continue;
                SysRoleUserRights roleUserRight = new SysRoleUserRights();
                roleUserRight.setRoleId(targetRoleId);
                roleUserRight.setRoleDataRightsId((Long)dataRightIdMap.get(userRight.getRoleDataRightsId()));
                roleUserRight.setUserId(userRight.getUserId());
                list.add(roleUserRight);
            }
            this.sysRoleUserRightBoService.saveBatch(list);
        }
    }

    private void copyField(Long sourceRoleId, Long targetRoleId) {
        List roleFieldList = this.sysAppVisitRoleFieldBoService.listRoleField(null, null, sourceRoleId);
        roleFieldList.forEach(field -> {
            field.setId(null);
            field.setRoleId(targetRoleId);
        });
        this.sysAppVisitRoleFieldBoService.saveBatchSysAppVisitRoleField(roleFieldList);
    }

    private void copyDataLogic(Long sourceRoleId, Long targetRoleId) {
        List dataLogicList = this.sysAppVisitDataLogicBoService.listDataLogic(null, null, sourceRoleId);
        if (HussarUtils.isNotEmpty((Object)dataLogicList)) {
            List dataLogicIds = dataLogicList.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
            List dataLogicFilterList = this.sysAppVisitDataLogicBoService.dataLogicFilterListByLogicIds(dataLogicIds);
            HashMap dataLogicIdMapping = new HashMap();
            dataLogicList.forEach(dataLogic -> {
                Long newLogicDataId = IdWorker.getId((Object)dataLogic);
                dataLogicIdMapping.put(dataLogic.getId(), newLogicDataId);
                dataLogic.setId(newLogicDataId);
                dataLogic.setRoleId(targetRoleId);
            });
            this.sysAppVisitDataLogicBoService.saveOrUpdateBatch(dataLogicList);
            dataLogicFilterList.forEach(filter -> {
                filter.setId(null);
                filter.setRoleDataLogicId((Long)dataLogicIdMapping.get(filter.getRoleDataLogicId()));
            });
            this.sysAppVisitDataLogicBoService.saveBatchDataLogicFilter(dataLogicFilterList);
        }
    }
}

