/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.sync.union.impl;

import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.permit.dto.QueryStruRightFeignDto;
import com.jxdinfo.hussar.authorization.permit.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleUserRights;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitDataLogicBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitRoleFieldBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleStruRightBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleUserRightBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.FieldAuthorityVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.service.IPermissionService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.ButtonVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.DataLogicAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FormRoleVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.OrganDataAuthorityFeignVo;
import com.jxdinfo.hussar.formdesign.application.sync.union.util.SyncUnionHelper;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.permissionService")
public class UnionPermissionServiceImpl
implements IPermissionService {
    @Resource
    private ISysRolesExternalService rolesExternalService;
    @Resource
    private SyncUnionHelper syncUnionHelper;
    @Resource
    private ISysAppVisitDataLogicBoService sysAppVisitDataLogicBoService;
    @Resource
    private ISysAppVisitRoleFieldBoService sysAppVisitRoleFieldBoService;
    @Resource
    private ISysRoleStruRightBoService sysRoleStruRightBoService;
    @Resource
    private ISysRoleUserRightBoService sysRoleUserRightBoService;
    @Resource
    private IHussarBaseOrganizationBoService organBoService;

    public List<Long> getAuthorityFormList(List<Long> rolesList, Long appId) {
        ArrayList<Long> authFormIds = new ArrayList<Long>();
        Map<Long, Long> menuFunFormIdMap = this.syncUnionHelper.getFunctionIdsForAppForms(appId);
        Set<Long> menuFunIds = menuFunFormIdMap.keySet();
        if (HussarUtils.isNotEmpty(rolesList) && HussarUtils.isNotEmpty(menuFunIds)) {
            ArrayList<Long> funIdsList = new ArrayList<Long>();
            for (Long funId : menuFunIds) {
                funIdsList.add(funId);
            }
            List formAuth = this.rolesExternalService.listRoleFunByRoleIdsAndFunIds(rolesList, funIdsList);
            formAuth.forEach(auth -> {
                Long formId = (Long)menuFunFormIdMap.get(auth.getFunctionId());
                if (formId != null) {
                    authFormIds.add(formId);
                }
            });
        }
        return authFormIds;
    }

    public List<ButtonVo> getButtonRoleResource(Long formId, List<Long> rolesList) {
        if (HussarUtils.isEmpty(rolesList)) {
            return Collections.emptyList();
        }
        List<SysResources> allElementRes = this.syncUnionHelper.getAllElementRes(formId);
        Map resElementIdMap = allElementRes.stream().collect(Collectors.toMap(SysResources::getId, Function.identity()));
        if (HussarUtils.isEmpty(resElementIdMap)) {
            return Collections.emptyList();
        }
        Set<Long> resElementIds = resElementIdMap.keySet();
        ArrayList<Long> resIdList = new ArrayList<Long>();
        for (Long resId : resElementIds) {
            resIdList.add(resId);
        }
        List sysRoleResources = this.rolesExternalService.listRoleResByRoleAndResIds(rolesList, resIdList);
        ArrayList<ButtonVo> result = new ArrayList<ButtonVo>(sysRoleResources.size());
        sysRoleResources.forEach(sysRoleResource -> {
            SysResources sysResources = (SysResources)resElementIdMap.get(sysRoleResource.getResourceId());
            ButtonVo buttonVo = new ButtonVo();
            buttonVo.setButtonCode(sysResources.getPermissions());
            buttonVo.setButtonName(sysResources.getResourceName());
            result.add(buttonVo);
        });
        return result;
    }

    public List<FormRoleVo> getFormAuthorizeRolesList(Long formId) {
        ArrayList<FormRoleVo> result = new ArrayList<FormRoleVo>();
        Long menuFunId = this.syncUnionHelper.getMenuFunId(formId);
        List sysRoleFunctions = this.rolesExternalService.listRoleFunByFunctionId(menuFunId);
        sysRoleFunctions.forEach(sysRoleFunctions1 -> {
            FormRoleVo formRoleVo = new FormRoleVo();
            formRoleVo.setRoleId(sysRoleFunctions1.getRoleId());
            result.add(formRoleVo);
        });
        return result;
    }

    public OrganDataAuthorityFeignVo formAuthorityOrganData(Long formId, Long roleId) {
        String dataScope;
        if (HussarUtils.isEmpty((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            user = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser");
        }
        if (HussarUtils.isEmpty((Object)user)) {
            throw new BaseException("\u5f53\u524d\u65e0\u767b\u5f55\u7528\u6237");
        }
        OrganDataAuthorityFeignVo result = new OrganDataAuthorityFeignVo();
        HashSet<Long> organIds = new HashSet<Long>();
        HashSet<Long> userIds = new HashSet<Long>();
        result.setOrganIds(organIds);
        result.setUserIds(userIds);
        SysRoleDataRight roleDataRight = this.rolesExternalService.getRoleRightByFunAndRoleId(roleId, this.syncUnionHelper.getMenuFunId(formId));
        String string = dataScope = HussarUtils.isEmpty((Object)roleDataRight) ? "1" : String.valueOf(roleDataRight.getDataScope());
        if (HussarUtils.equals((Object)"1", (Object)dataScope)) {
            return null;
        }
        if (HussarUtils.equals((Object)"4", (Object)dataScope)) {
            userIds.add(user.getUserId());
        } else if (HussarUtils.equals((Object)"3", (Object)dataScope)) {
            Object organId = user.getExtendUserMap().get("deptId");
            if (HussarUtils.isNotEmpty(organId)) {
                organIds.add(Long.valueOf(organId.toString()));
            }
        } else if (HussarUtils.equals((Object)"2", (Object)dataScope)) {
            Object deptId = user.getExtendUserMap().get("deptId");
            if (HussarUtils.isNotEmpty(deptId)) {
                List allSubOrgan = this.organBoService.getAllSubOrgan(Long.valueOf(HussarUtils.toLong(deptId)));
                List childStruIds = allSubOrgan.stream().map(OrganVo::getId).map(Long::parseLong).collect(Collectors.toList());
                organIds.addAll(childStruIds);
            }
        } else if (HussarUtils.equals((Object)"5", (Object)dataScope)) {
            List sysRoleStruRights = this.sysRoleStruRightBoService.listByRoleRightId(roleDataRight.getDataRightsId());
            if (HussarUtils.isNotEmpty((Object)sysRoleStruRights)) {
                Set organIdSet = sysRoleStruRights.stream().map(SysRoleStruRights::getStruid).collect(Collectors.toSet());
                organIds.addAll(organIdSet);
            }
            QueryStruRightFeignDto feignDto = new QueryStruRightFeignDto();
            feignDto.setRoleRightIds(Collections.singletonList(roleDataRight.getDataRightsId()));
            List sysRoleUserRights = this.sysRoleUserRightBoService.listUserRights(feignDto);
            if (HussarUtils.isNotEmpty((Object)sysRoleUserRights)) {
                Set userIdSet = sysRoleUserRights.stream().map(SysRoleUserRights::getUserId).collect(Collectors.toSet());
                userIds.addAll(userIdSet);
            }
        }
        return result;
    }

    public DataLogicAuthorityVo dataLogicAuthorityByFormId(Long formId, Long roleId) {
        SysAppVisitDataLogic sysAppVisitDataLogic = this.sysAppVisitDataLogicBoService.getDataLogic(null, formId, roleId);
        if (HussarUtils.isNotEmpty((Object)sysAppVisitDataLogic)) {
            DataLogicAuthorityVo dataLogicAuthorityVo = new DataLogicAuthorityVo();
            BeanUtil.copy((Object)sysAppVisitDataLogic, (Object)dataLogicAuthorityVo);
            List dataLogicFilterVos = this.sysAppVisitDataLogicBoService.dataLogicFilterList(sysAppVisitDataLogic.getId());
            dataLogicAuthorityVo.setFilters(dataLogicFilterVos);
            return dataLogicAuthorityVo;
        }
        return null;
    }

    public List<FieldAuthorityVo> getFormFieldAuthority(Long formId, List<Long> roleIds) {
        return this.sysAppVisitRoleFieldBoService.selectByFormId(formId, roleIds);
    }
}

