/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormConvertHistoryMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormConvertHistory;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormConvertHistoryService;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.SysFormConvertHistoryServiceImpl")
public class SysFormConvertHistoryServiceImpl
extends HussarServiceImpl<SysFormConvertHistoryMapper, SysFormConvertHistory>
implements ISysFormConvertHistoryService {
    public void saveHistory(Long formId, String formType, String convertType) {
        SysFormConvertHistory sysFormConvertHistory = new SysFormConvertHistory();
        sysFormConvertHistory.setConvertId(EngineUtil.getId());
        sysFormConvertHistory.setFormId(formId);
        sysFormConvertHistory.setFormType(formType);
        sysFormConvertHistory.setConvertType(convertType);
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)shiroUser) && HussarUtils.isEmpty((Object)(shiroUser = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser")))) {
            throw new BaseException("\u5f53\u524d\u65e0\u767b\u5f55\u7528\u6237");
        }
        sysFormConvertHistory.setOperator(shiroUser.getUserId());
        sysFormConvertHistory.setOperationTime(new Date());
        this.save((BaseEntity)sysFormConvertHistory);
    }

    public SysFormConvertHistory getFistHistory(Long formId) {
        Page page = new Page(1L, 1L);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysFormConvertHistory::getFormId, (Object)formId)).orderByAsc(SysFormConvertHistory::getOperationTime);
        this.page((IPage)page, (Wrapper)queryWrapper);
        List records = page.getRecords();
        if (HussarUtils.isEmpty((Object)records)) {
            return null;
        }
        return (SysFormConvertHistory)records.get(0);
    }

    public int getConvertCount(Long formId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFormConvertHistory::getFormId, (Object)formId);
        return (int)this.count((Wrapper)queryWrapper);
    }
}

