/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.data.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.formdesign.application.data.dto.SysDataPullConfigDto;
import com.jxdinfo.hussar.formdesign.application.data.dto.TestUrlDto;
import com.jxdinfo.hussar.formdesign.application.data.model.HttpDoPostResponse;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullConfig;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullRecord;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullRecordService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OpControllerAnno;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hussarPull/data"})
public class SysDataPullController {
    private final SysDataPullService pullDataService;
    @Autowired
    private SysDataPullRecordService sysDataPullRecordService;

    @Autowired
    public SysDataPullController(SysDataPullService pullDataService) {
        this.pullDataService = pullDataService;
    }

    @ApiOperation(value="\u4fdd\u5b58\u914d\u7f6e")
    @PostMapping(value={"/save"})
    public ApiResponse<Void> save(@RequestBody SysDataPullConfigDto sysDataPullConfigDto) {
        return this.pullDataService.saveConfig(sysDataPullConfigDto);
    }

    @ApiOperation(value="\u590d\u5236\u914d\u7f6e")
    @PostMapping(value={"/copy"})
    public ApiResponse<Void> copy(@RequestParam String id) {
        return this.pullDataService.copyConfig(id);
    }

    @ApiOperation(value="\u67e5\u8be2\u5168\u90e8")
    @GetMapping(value={"/list"})
    public ApiResponse<List<SysDataPullConfig>> list(@RequestParam String formId) {
        return this.pullDataService.getConfigList(formId, "0");
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2")
    @PostMapping(value={"/condition/list"})
    public ApiResponse<List<SysDataPullConfig>> list(@RequestBody SysDataPullConfigDto sysDataPullConfigDto) {
        return ApiResponse.success((Object)this.pullDataService.listByCondition(sysDataPullConfigDto));
    }

    @ApiOperation(value="\u67e5\u8be2\u8bb0\u5f55")
    @GetMapping(value={"/record/list"})
    public ApiResponse<Page<SysDataPullRecord>> recordList(@RequestParam(required=false) String startTime, @RequestParam(required=false) String endTime, @RequestParam String configId, @RequestParam(required=false) String success, @RequestParam(required=false) Long current, @RequestParam(required=false) Long size) {
        Long currentSelf = 1L;
        Long sizeSelf = 10L;
        if (current != null && current > 0L) {
            currentSelf = current;
        }
        if (size != null && size > 0L) {
            sizeSelf = size;
        }
        return this.sysDataPullRecordService.getRecordList(startTime, endTime, configId, success, currentSelf, sizeSelf);
    }

    @ApiOperation(value="\u67e5\u8be2\u8bb0\u5f55\u8be6\u60c5")
    @GetMapping(value={"/record/detail"})
    public ApiResponse<SysDataPullRecord> recordDetail(@RequestParam Long id) {
        return ApiResponse.success((Object)this.sysDataPullRecordService.getById((Serializable)id));
    }

    @ApiOperation(value="\u6309 ID \u67e5\u8be2")
    @GetMapping(value={"/{id}"})
    public ApiResponse<SysDataPullConfig> getById(@PathVariable Long id) {
        return ApiResponse.success((Object)this.pullDataService.getById((Serializable)id));
    }

    @ApiOperation(value="\u540c\u6b65\u62c9\u53d6\u6570\u636e\u5230\u8868\u5355")
    @PostMapping(value={"/asyncPullData"})
    @OpControllerAnno
    public ApiResponse<Void> asyncPullData(@RequestParam Long formId, @RequestParam Long id) throws IOException {
        this.pullDataService.asyncPullData(formId, id, "1");
        return ApiResponse.success((String)"\u540c\u6b65\u6210\u529f");
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public ApiResponse<Void> edit(@RequestBody SysDataPullConfigDto sysDataPullConfigDto) {
        return this.pullDataService.editConfig(sysDataPullConfigDto);
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    public ApiResponse<Void> delete(@RequestParam Long id) {
        return this.pullDataService.deleteConfig(id);
    }

    @ApiOperation(value="\u4fee\u6539\u5f00\u542f\u72b6\u6001")
    @PostMapping(value={"/status"})
    public ApiResponse<Void> status(@RequestBody SysDataPullConfigDto sysDataPullConfigDto) {
        return this.pullDataService.status(sysDataPullConfigDto);
    }

    @ApiOperation(value="\u670d\u52a1\u5668\u8fde\u901a\u6027\u6d4b\u8bd5")
    @PostMapping(value={"/connection"})
    public ApiResponse<HttpDoPostResponse> connection(@RequestBody TestUrlDto testUrlDto) throws IOException {
        return this.pullDataService.connection(testUrlDto);
    }

    @ApiOperation(value="\u83b7\u53d6api\u7684\u8fd4\u56de\u7ed3\u679c")
    @PostMapping(value={"/getApiKeys"})
    public ApiResponse<List<Map<String, Object>>> getApiKeys(@RequestBody SysDataPullConfigDto sysDataPullConfigDto) throws IOException {
        String url = sysDataPullConfigDto.getUrl();
        String param = sysDataPullConfigDto.getParams();
        return this.pullDataService.getApiKeys(url, param, sysDataPullConfigDto);
    }
}

