/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.property.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.formdesign.application.property.dao.PageExpMapper;
import com.jxdinfo.hussar.formdesign.application.property.model.PageExp;
import com.jxdinfo.hussar.formdesign.application.property.model.PageExpGroup;
import com.jxdinfo.hussar.formdesign.application.property.service.IPageExpGroupService;
import com.jxdinfo.hussar.formdesign.application.property.service.IPageExpService;
import com.jxdinfo.hussar.formdesign.application.property.vo.PageExpGroupVo;
import com.jxdinfo.hussar.formdesign.application.property.vo.PageExpVo;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.application.util.NoCodeFileUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeBusinessDB;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IoUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class PageExpServiceImpl
extends HussarServiceImpl<PageExpMapper, PageExp>
implements IPageExpService {
    @Resource
    private PageExpMapper pageExpMapper;
    @Resource
    private OssService ossService;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private IPageExpGroupService pageExpGroupService;
    private static final Logger LOGGER = LoggerFactory.getLogger(PageExpServiceImpl.class);

    public ApiResponse<Void> importPage(Long fileId, Long groupId) {
        JSONObject manifestData;
        byte[] zipData;
        String content;
        ApiResponse ossDownloadResponse = this.ossService.backgroundDownload(fileId);
        if (ossDownloadResponse.isSuccess() && HussarUtils.isNotEmpty((Object)(content = NoCodeFileUtil.extractFileFromZip((byte[])(zipData = (byte[])ossDownloadResponse.getData()), (String)"manifest.json"))) && HussarUtils.isNotEmpty((Object)(manifestData = (JSONObject)JSON.parseObject((String)content, JSONObject.class)))) {
            if (!"JXDNExtPage".equals(manifestData.getString("type")) && !"JXDNExtRouterPage".equals(manifestData.getString("type"))) {
                throw new BaseException("\u4e0a\u4f20\u9644\u4ef6\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
            }
            String pageName = manifestData.getString("name");
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(PageExp::getName, (Object)pageName);
            PageExp oldPage = (PageExp)this.getOne((Wrapper)wrapper);
            if (HussarUtils.isNotEmpty((Object)oldPage)) {
                this.assignValueToPage(manifestData, oldPage);
                oldPage.setFileId(fileId);
                oldPage.setGroupId(groupId);
                oldPage.setDelFlag("0");
                this.updateById((BaseEntity)oldPage);
                AppMigrateUtil.deleteFolder(this.getUnzipPath(pageName));
            } else {
                PageExp pageExp = new PageExp();
                this.assignValueToPage(manifestData, pageExp);
                pageExp.setFileId(fileId);
                pageExp.setGroupId(groupId);
                pageExp.setDelFlag("0");
                this.save((BaseEntity)pageExp);
            }
            try {
                NoCodeFileUtil.extractZipToDirectory((byte[])zipData, (String)this.getUnzipPath(pageName));
            }
            catch (IOException e) {
                LOGGER.error("\u5bfc\u5165\u5931\u8d25\uff0c\u5199\u5165\u6570\u636e\u9519\u8bef", (Throwable)e);
                return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5199\u5165\u6570\u636e\u9519\u8bef");
            }
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u7b26\u5408\u89c4\u8303");
    }

    public ApiResponse<List<PageExpGroupVo>> getPages(String pageName) {
        ArrayList<PageExpGroupVo> pageExpGroupVos = new ArrayList<PageExpGroupVo>();
        List pageExpGroups = this.pageExpGroupService.list();
        String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
        List<Object> pageExpVos = new ArrayList();
        pageExpVos = HussarUtils.equals((Object)dbType, (Object)DbType.ORACLE.name()) ? this.pageExpMapper.getPagesByTitleOracle(pageName) : this.pageExpMapper.getPagesByTitle(pageName);
        for (PageExpGroup pageExpGroup : pageExpGroups) {
            PageExpGroupVo pageExpGroupVo = new PageExpGroupVo();
            BeanUtils.copyProperties((Object)pageExpGroup, (Object)pageExpGroupVo);
            if (HussarUtils.isNotEmpty(pageExpVos)) {
                List pages = pageExpVos.stream().filter(pageExpVo -> Objects.equals(pageExpVo.getGroupId(), pageExpGroup.getGroupId())).collect(Collectors.toList());
                pageExpGroupVo.setPageExpVos(pages);
            }
            pageExpGroupVos.add(pageExpGroupVo);
        }
        return ApiResponse.success(pageExpGroupVos);
    }

    public ApiResponse<Page<PageExpVo>> getPagesPage(PageInfo pageInfo, String pageName, Long pageGroupId) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List<PageExpVo> pagesList = this.pageExpMapper.getPagesPage((Page<PageExpVo>)page, pageName, pageGroupId);
        page.setRecords(pagesList);
        return ApiResponse.success((Object)page);
    }

    public List<PageExp> getPagesByName(List<String> pageNames) {
        if (HussarUtils.isEmpty(pageNames)) {
            return new ArrayList<PageExp>();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(PageExp::getName, pageNames);
        return ((PageExpMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public List<PageExp> getAllUsablePages() {
        return ((PageExpMapper)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
    }

    public void showImage(String pageName, String fileName, HttpServletResponse response) {
        String logoPath = FileUtil.posixPath((String[])new String[]{this.getUnzipPath(pageName), "assets", fileName});
        byte[] data = this.readFileToBinaryByPath(logoPath);
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("image/jpeg;charset=UTF-8");
            IOUtils.write((byte[])data, (OutputStream)os);
        }
        catch (IOException e) {
            LOGGER.error("\u8bfb\u53d6\u81ea\u5b9a\u4e49\u9875\u9762\u56fe\u6807\u5931\u8d25\uff1a{}\uff01", (Object)e.getMessage(), (Object)e);
            throw new BaseException("\u8bfb\u53d6\u7ec4\u4ef6\u56fe\u6807\u5931\u8d25");
        }
        finally {
            if (HussarUtils.isNotEmpty((Object)os)) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u81ea\u5b9a\u4e49\u9875\u9762\u8bfb\u53d6\u56fe\u6807\u54cd\u5e94\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}\uff01", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    public void deletePage(Long id) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(PageExp::getId, (Object)id);
        PageExp page = (PageExp)this.getOne((Wrapper)wrapper);
        page.setDelFlag("1");
        ((PageExpMapper)this.baseMapper).updateById(page);
    }

    public String getPageFileContent(String pageName, String fileName) throws IOException {
        String filePath = FileUtil.posixPath((String[])new String[]{this.getUnzipPath(pageName), fileName});
        if (!new File(filePath).exists()) {
            throw new BaseException("\u6307\u5b9a\u6587\u4ef6\u540d\u8d44\u6e90\u4e0d\u5b58\u5728\uff01");
        }
        return new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
    }

    private String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }

    private void assignValueToPage(JSONObject manifestData, PageExp pageExp) {
        pageExp.setName(manifestData.getString("name"));
        pageExp.setTitle(manifestData.getString("title"));
        pageExp.setType(manifestData.getString("type"));
        pageExp.setLogo(manifestData.getString("logo"));
        pageExp.setDescription(manifestData.getString("description"));
        pageExp.setAuthor(manifestData.getString("author"));
        pageExp.setVersion(manifestData.getString("version"));
        pageExp.setOptions(manifestData.getString("options"));
    }

    private String getUnzipPath(String pageName) {
        String backProjectPath = this.formDesignProperties.getBackProjectPath();
        String noCodeStore = ".noCode-store";
        String expPageFIleName = "expPages";
        return FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), backProjectPath, noCodeStore, expPageFIleName, pageName});
    }

    private byte[] readFileToBinaryByPath(String filePath) {
        try {
            byte[] data;
            try (FileInputStream fis = new FileInputStream(filePath);){
                data = IoUtil.readToByteArray((InputStream)fis);
            }
            return data;
        }
        catch (IOException var17) {
            LOGGER.error("errorMessage:{}", (Object)var17.getMessage(), (Object)var17);
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
    }
}

