/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.authority.v1.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseSyncUserService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v1.dto.AddStaffUserDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v1.dto.ExtStaffUserEditDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v1.service.OrganSyncService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v1.service.UserSyncService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.model.ThirdOrganRela;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.model.ThirdUserRela;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdOrganService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdUserService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserSyncServiceImpl
implements UserSyncService {
    @Resource
    private IHussarBaseUserBoService sysUsersService;
    @Resource
    private IThirdOrganService thirdOrganService;
    @Resource
    private IHussarBaseSyncUserService hussarBaseSyncUserService;
    @Resource
    private OrganSyncService organSyncService;
    @Resource
    private IThirdUserService thirdUserService;
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarServiceImpl.class);

    @Override
    public ApiResponse<Void> addStaffUser(AddStaffUserDto addStaffUserDto) {
        LOGGER.info("\u6743\u9650\u4e2d\u5fc3\u540c\u6b65 -> \u65b0\u589e\u4eba\u5458\u7528\u6237\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)addStaffUserDto)));
        this.checkParameter(addStaffUserDto);
        if (addStaffUserDto.getOrganIds() == null) {
            addStaffUserDto.setOrganIds(new ArrayList());
        }
        String[] extDepartmentIds = addStaffUserDto.getExtDepartmentId().split(",");
        for (int i = 0; i < extDepartmentIds.length; ++i) {
            Long struId = this.getHussarOrganId(extDepartmentIds[i]);
            addStaffUserDto.getOrganIds().add(struId);
        }
        ThirdUserRela thirdUserRela1 = this.thirdUserService.getThirdUserRela(addStaffUserDto.getExtUserId());
        if (HussarUtils.isNotEmpty((Object)((Object)thirdUserRela1)) && HussarUtils.equals((Object)"1", (Object)thirdUserRela1.getDelFlag())) {
            ExtStaffUserEditDto extStaffUserEditDto = (ExtStaffUserEditDto)((Object)HussarUtils.copyProperties((Object)((Object)addStaffUserDto), ExtStaffUserEditDto.class));
            assert (extStaffUserEditDto != null);
            extStaffUserEditDto.setUpdateDeleteFlag(true);
            R editOutsideUserDtoR = this.hussarBaseSyncUserService.editUser((EditOutsideUserDto)extStaffUserEditDto);
            if (!editOutsideUserDtoR.isSuccess()) {
                LOGGER.error("\u540c\u6b65\u903b\u8f91\u5220\u9664\u4eba\u5458\u7528\u6237\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)editOutsideUserDtoR.getErrorList()));
                throw new HussarException("\u540c\u6b65\u4eba\u5458\u7528\u6237\u5931\u8d25");
            }
            LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(ThirdUserRela::getUserId, (Object)thirdUserRela1.getUserId());
            ThirdUserRela thirdUserRela = new ThirdUserRela();
            thirdUserRela.setDelFlag("0");
            this.thirdUserService.update((Object)thirdUserRela, (Wrapper)updateWrapper);
        } else {
            R addStaffUserResult = this.hussarBaseSyncUserService.addUser((AddOutsideUserDto)addStaffUserDto);
            if (!addStaffUserResult.isSuccess()) {
                LOGGER.error("\u540c\u6b65\u4eba\u5458\u7528\u6237\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)addStaffUserResult.getErrorList()));
                throw new HussarException("\u540c\u6b65\u4eba\u5458\u7528\u6237\u5931\u8d25");
            }
            ThirdUserRela thirdUserRela = new ThirdUserRela();
            thirdUserRela.setThirdUserId(addStaffUserDto.getExtUserId());
            thirdUserRela.setUserId(this.getUserIdByUserAccount(addStaffUserDto.getUserAccount()));
            thirdUserRela.setThirdUserSource("KeHu");
            thirdUserRela.setDelFlag("0");
            this.thirdUserService.save((Object)thirdUserRela);
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> editStaffUser(ExtStaffUserEditDto extStaffUserEditDto) {
        LOGGER.info("\u6743\u9650\u4e2d\u5fc3\u540c\u6b65 -> \u4fee\u6539\u4eba\u5458\u7528\u6237\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)extStaffUserEditDto)));
        if (extStaffUserEditDto.getOrganIds() == null) {
            extStaffUserEditDto.setOrganIds(new ArrayList());
        }
        String[] extDepartmentIds = extStaffUserEditDto.getExtDepartmentId().split(",");
        for (int i = 0; i < extDepartmentIds.length; ++i) {
            Long departmentId = this.organSyncService.getOrganIdByRela(extDepartmentIds[i]);
            extStaffUserEditDto.getOrganIds().add(departmentId);
        }
        R editStaffUserResult = this.hussarBaseSyncUserService.editUser((EditOutsideUserDto)extStaffUserEditDto);
        if (!editStaffUserResult.isSuccess()) {
            LOGGER.error("\u4fee\u6539\u4eba\u5458\u7528\u6237\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)editStaffUserResult.getErrorList()));
            throw new HussarException("\u4fee\u6539\u4eba\u5458\u7528\u6237\u5931\u8d25");
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> delStaffUser(String userAccount) {
        LOGGER.info("\u6743\u9650\u4e2d\u5fc3\u540c\u6b65 -> \u5220\u9664\u4eba\u5458\u7528\u6237\uff0c\u5165\u53c2\uff1a{}", (Object)userAccount);
        Long userId = this.getUserIdByUserAccount(userAccount);
        R delStaffUserResult = this.hussarBaseSyncUserService.deleteUser(userAccount);
        if (!delStaffUserResult.isSuccess()) {
            LOGGER.error("\u6743\u9650\u4e2d\u5fc3\u540c\u6b65 -> \u5220\u9664\u4eba\u5458\u7528\u6237\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)delStaffUserResult.getErrorList()));
            return ApiResponse.fail((String)"\u6743\u9650\u4e2d\u5fc3\u540c\u6b65\uff0c\u5220\u9664\u4eba\u5458\u7528\u6237\u5931\u8d25");
        }
        this.thirdUserService.remove((Wrapper)new LambdaQueryWrapper().eq(ThirdUserRela::getUserId, (Object)userId));
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> delLogicalStaffUser(String userAccount) {
        LOGGER.info("\u6743\u9650\u4e2d\u5fc3\u540c\u6b65 -> \u903b\u8f91\u5220\u9664\u4eba\u5458\u7528\u6237\uff0c\u5165\u53c2\uff1a{}", (Object)userAccount);
        Long userId = this.getUserIdByUserAccount(userAccount);
        R delStaffUserResult = this.hussarBaseSyncUserService.deleteLogicalUser(userAccount);
        if (!delStaffUserResult.isSuccess()) {
            LOGGER.error("\u6743\u9650\u4e2d\u5fc3\u540c\u6b65 -> \u903b\u8f91\u5220\u9664\u4eba\u5458\u7528\u6237\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)delStaffUserResult.getErrorList()));
            return ApiResponse.fail((String)"\u6743\u9650\u4e2d\u5fc3\u540c\u6b65\uff0c\u5220\u9664\u4eba\u5458\u7528\u6237\u5931\u8d25");
        }
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(ThirdUserRela::getUserId, (Object)userId);
        ThirdUserRela thirdUserRela = new ThirdUserRela();
        thirdUserRela.setDelFlag("1");
        this.thirdUserService.update((Object)thirdUserRela, (Wrapper)updateWrapper);
        return ApiResponse.success();
    }

    private void checkParameter(AddStaffUserDto addStaffUserDto) {
        if (HussarUtils.isEmpty((Object)addStaffUserDto.getExtUserId())) {
            throw new HussarException("\u7528\u6237 ID \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isEmpty((Object)addStaffUserDto.getUserAccount())) {
            throw new HussarException("\u5916\u90e8\u7528\u6237\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isEmpty((Object)addStaffUserDto.getExtDepartmentId())) {
            throw new HussarException("\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Long getUserIdByUserAccount(String userAccount) {
        SysUsers sysUser = this.sysUsersService.getOneByUserAccount(userAccount);
        return sysUser.getId();
    }

    private Long getHussarOrganId(String extOrganId) {
        ThirdOrganRela thirdOrganRela = (ThirdOrganRela)((Object)this.thirdOrganService.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdOrganRela::getThirdOrganId, (Object)extOrganId)));
        if (HussarUtils.isEmpty((Object)((Object)thirdOrganRela))) {
            throw new HussarException("\u672a\u83b7\u53d6\u5230\u5f85\u540c\u6b65\u4eba\u5458\u7528\u6237\u7684\u90e8\u95e8\u4fe1\u606f");
        }
        return thirdOrganRela.getOrganId();
    }
}

