/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.authority.v1.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseSyncOrganizationService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v1.dto.ThirdOrganAddDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v1.dto.ThirdOrganEditDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v1.service.OrganSyncService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.model.ThirdOrganRela;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdOrganService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrganSyncServiceImpl
implements OrganSyncService {
    @Resource
    private IThirdOrganService thirdOrganService;
    @Resource
    private IHussarBaseOrganizationBoService sysOrganService;
    @Resource
    private IHussarBaseUserBoService sysStruService;
    @Resource
    private IHussarBaseSyncOrganizationService hussarBaseSyncOrganizationService;
    private static final Logger LOGGER = LoggerFactory.getLogger(OrganSyncServiceImpl.class);

    @Override
    public ApiResponse<Void> addOrgan(ThirdOrganAddDto thirdOrganAddDto) {
        LOGGER.info("\u6743\u9650\u4e2d\u5fc3\u540c\u6b65 -> \u65b0\u589e\u7ec4\u7ec7\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)thirdOrganAddDto)));
        if (this.existThirdOrgan(thirdOrganAddDto.getThirdOrganId())) {
            return ApiResponse.fail((String)"\u7ec4\u7ec7\u5df2\u5b58\u5728\uff01");
        }
        AddOutsideOrganizationDto addOuterOrgDto = new AddOutsideOrganizationDto();
        String pOrganCode = this.getOrganCodeByExtOrganId(thirdOrganAddDto.getThirdOrganParentId());
        addOuterOrgDto.setParentOrganCode(pOrganCode);
        addOuterOrgDto.setOrganCode(thirdOrganAddDto.getOrganCode());
        addOuterOrgDto.setOrganType(thirdOrganAddDto.getStruType());
        addOuterOrgDto.setOrganName(thirdOrganAddDto.getOrganName());
        addOuterOrgDto.setOrganShortName(thirdOrganAddDto.getShortName());
        addOuterOrgDto.setOrganAlias(thirdOrganAddDto.getOrganAlias());
        addOuterOrgDto.setOrganDescription(thirdOrganAddDto.getOfficeAlias());
        addOuterOrgDto.setOrganAddress(thirdOrganAddDto.getOfficeAddress());
        addOuterOrgDto.setStruOrder(thirdOrganAddDto.getStruOrder());
        R addOutOrganResult = this.hussarBaseSyncOrganizationService.addOrganization(addOuterOrgDto);
        if (!addOutOrganResult.isSuccess()) {
            LOGGER.error("\u6743\u9650\u4e2d\u5fc3\u540c\u6b65 -> \u65b0\u589e\u7ec4\u7ec7\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)addOutOrganResult.getErrorList()));
            throw new HussarException("\u540c\u6b65\u7ec4\u7ec7\u5931\u8d25");
        }
        ThirdOrganRela thirdOrganRela = new ThirdOrganRela();
        Long struId = ((DataMapping)addOutOrganResult.getSuccessList().get(0)).getId();
        thirdOrganRela.setOrganId(struId);
        thirdOrganRela.setThirdOrganId(thirdOrganAddDto.getThirdOrganId());
        thirdOrganRela.setThirdOrganSource("KeHu");
        this.thirdOrganService.save((Object)thirdOrganRela);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> editOrgan(ThirdOrganEditDto thirdOrganEditDto) {
        LOGGER.info("\u6743\u9650\u4e2d\u5fc3\u540c\u6b65 -> \u4fee\u6539\u7ec4\u7ec7\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)thirdOrganEditDto)));
        R editOutsideOrganResult = this.hussarBaseSyncOrganizationService.editOrganization((EditOutsideOrganizationDto)thirdOrganEditDto);
        if (!editOutsideOrganResult.isSuccess()) {
            LOGGER.error("\u4fee\u6539\u5916\u90e8\u7ec4\u7ec7\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)editOutsideOrganResult.getErrorList()));
            return ApiResponse.fail((String)"\u4fee\u6539\u7ec4\u7ec7\u5931\u8d25");
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<String> delOrgan(ThirdOrganRela thirdOrganRela) {
        LOGGER.info("\u6743\u9650\u4e2d\u5fc3\u540c\u6b65 -> \u5220\u9664\u7ec4\u7ec7\uff0c\u5165\u53c2\uff1a{}", (Object)thirdOrganRela.getThirdOrganId());
        try {
            Long structId = this.retrieveOrganStructId(thirdOrganRela.getThirdOrganId());
            String delOrgResult = this.sysOrganService.deleteOrganizationByStruId(structId);
            this.removeThirdOrganRela(thirdOrganRela.getThirdOrganId());
            LOGGER.info("\u6743\u9650\u4e2d\u5fc3\u540c\u6b65 -> \u5220\u9664\u7ec4\u7ec7\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u7ed3\u679c\uff1a{}", (Object)delOrgResult);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u7ec4\u7ec7\u5931\u8d25", (Throwable)e);
            throw new HussarException("\u5220\u9664\u7ec4\u7ec7\u5931\u8d25");
        }
        return ApiResponse.success();
    }

    private Long retrieveOrganStructId(String thirdOrganId) {
        return ((ThirdOrganRela)((Object)this.thirdOrganService.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdOrganRela::getThirdOrganId, (Object)thirdOrganId)))).getOrganId();
    }

    private void removeThirdOrganRela(String thirdOrganId) {
        this.thirdOrganService.remove((Wrapper)new LambdaQueryWrapper().eq(ThirdOrganRela::getThirdOrganId, (Object)thirdOrganId));
    }

    @Override
    public Long getOrganIdByRela(String extOrganId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ThirdOrganRela::getThirdOrganId, (Object)extOrganId);
        ThirdOrganRela thirdOrganRela = (ThirdOrganRela)((Object)this.thirdOrganService.getOne((Wrapper)queryWrapper));
        if (HussarUtils.isEmpty((Object)((Object)thirdOrganRela))) {
            LOGGER.error("\u83b7\u53d6\u7ec4\u7ec7\u540c\u6b65\u4fe1\u606f\u5931\u8d25\uff0c\u5916\u90e8\u7ec4\u7ec7 ID\uff1a{}", (Object)extOrganId);
            throw new HussarException("\u83b7\u53d6\u7ec4\u7ec7\u540c\u6b65\u4fe1\u606f\u5931\u8d25");
        }
        return thirdOrganRela.getOrganId();
    }

    private boolean existThirdOrgan(String thirdOrganId) {
        LambdaQueryWrapper thirdOrganRelaWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ThirdOrganRela::getThirdOrganId, (Object)thirdOrganId);
        List thirdOrganRelas = this.thirdOrganService.list((Wrapper)thirdOrganRelaWrapper);
        return HussarUtils.isNotEmpty((Object)thirdOrganRelas);
    }

    private String getOrganCodeByExtOrganId(String outOrganId) {
        if (HussarUtils.isEmpty((Object)outOrganId)) {
            return null;
        }
        try {
            Long stuId = ((ThirdOrganRela)((Object)this.thirdOrganService.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdOrganRela::getThirdOrganId, (Object)outOrganId)))).getOrganId();
            Long organId = this.sysStruService.getSysStruById(stuId).getOrganId();
            return this.sysOrganService.findOrganizationById(organId).getOrganCode();
        }
        catch (Exception e) {
            LOGGER.error("\u7ec4\u7ec7\u540c\u6b65 => \u83b7\u53d6\u5e73\u53f0\u6620\u5c04\u5173\u7cfb\u5931\u8d25\uff0c\u4e09\u65b9\u7ec4\u7ec7ID\uff1a{}", (Object)outOrganId);
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            throw new HussarException("\u7ec4\u7ec7\u540c\u6b65 => \u83b7\u53d6\u5e73\u53f0\u6620\u5c04\u5173\u7cfb\u5931\u8d25");
        }
    }
}

