/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysApplicationVersionMapper;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysApplicationVersion;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppUpgradeInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppUpgradeService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationVersionDetailService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationVersionService;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppUpQuickMatchVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVersionVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.UpgradeStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormUpgradeInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.SysApplicationVersionServiceImpl")
public class SysApplicationVersionServiceImpl
extends HussarServiceImpl<SysApplicationVersionMapper, SysApplicationVersion>
implements ISysApplicationVersionService {
    private static final String UPGRADE_OPERTYPE = "0";
    private static final String NOT_DELFLAG = "0";
    private static final String DELFLAG = "1";
    private static final Logger LOGGER = LoggerFactory.getLogger(SysApplicationVersionServiceImpl.class);
    @Resource
    private IHussarBaseUserBoService usersService;
    @Resource
    private IAppUpgradeService appUpgradeService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysApplicationVersionDetailService applicationVersionDetailService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private IAppUpgradeInfoService appUpgradeInfoService;
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private IFormUpgradeInfoService formUpgradeInfoService;

    public ApiResponse<List<SysApplicationVersionVo>> listApplicationVersionByAppId(Long appId) {
        List<Object> SysApplicationVersionVos = Lists.newArrayListWithCapacity((int)5);
        List appHistoryVersionList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplicationVersion::getAppId, (Object)appId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).orderByDesc(HussarBaseEntity::getCreateTime));
        if (CollectionUtils.isEmpty((Collection)appHistoryVersionList)) {
            return ApiResponse.success((Object)SysApplicationVersionVos);
        }
        SysApplicationVersionVos = appHistoryVersionList.stream().map(version -> (SysApplicationVersionVo)BeanUtil.copy((Object)version, SysApplicationVersionVo.class)).collect(Collectors.toList());
        ArrayList userIds = new ArrayList();
        SysApplicationVersionVos.forEach(SysApplicationVersionVo2 -> {
            Long upgradedBy = SysApplicationVersionVo2.getCreator();
            if (HussarUtils.isNotEmpty((Object)upgradedBy)) {
                Long userId = upgradedBy;
                userIds.add(userId);
            }
        });
        List sysUsers = this.usersService.listByIds(userIds);
        HashMap userMap = new HashMap();
        sysUsers.forEach(sysUser -> userMap.put(String.valueOf(sysUser.getId()), sysUser.getUserName()));
        SysApplicationVersionVos.forEach(SysApplicationVersionVo2 -> {
            Long upgradedBy = SysApplicationVersionVo2.getCreator();
            if (HussarUtils.isNotEmpty((Object)upgradedBy)) {
                SysApplicationVersionVo2.setUpgradeByName(userMap.getOrDefault(String.valueOf(upgradedBy), "\u672a\u77e5\u7528\u6237"));
            }
        });
        return ApiResponse.success(SysApplicationVersionVos);
    }

    public void updataCurrentVersion(Long appId, Long versionId, Long currentVersionId) {
        SysApplicationVersion rollBackVersion = (SysApplicationVersion)this.getById(versionId);
        rollBackVersion.setCurrentFlag(1);
        this.saveOrUpdate((BaseEntity)rollBackVersion);
        SysApplicationVersion currentVersion = (SysApplicationVersion)this.getById(currentVersionId);
        currentVersion.setCurrentFlag(0);
        currentVersion.setDelFlag(DELFLAG);
        this.saveOrUpdate((BaseEntity)currentVersion);
        List versions = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplicationVersion::getAppId, (Object)appId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).ge(HussarBaseEntity::getCreateTime, (Object)rollBackVersion.getCreateTime())).le(HussarBaseEntity::getCreateTime, (Object)currentVersion.getCreateTime())).orderByDesc(HussarBaseEntity::getCreateTime));
        List versionsMiddle = versions.stream().filter(s -> !versionId.equals(s.getId()) && !currentVersionId.equals(s.getId())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(versionsMiddle)) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(SysApplicationVersion::getId, (Collection)versionsMiddle.stream().map(SysApplicationVersion::getId).collect(Collectors.toList()));
            updateWrapper.set(HussarDelflagEntity::getDelFlag, (Object)DELFLAG);
            this.update((Wrapper)updateWrapper);
        }
    }

    public AppUpgradeDto initAppUpgrade(Long appId, Long versionId) throws IOException {
        AppUpgradeDto appUpgradeDto = new AppUpgradeDto();
        SysApplicationVersion applicationVersion = (SysApplicationVersion)this.getById(versionId);
        appUpgradeDto.setFileId(applicationVersion.getBackFileId());
        appUpgradeDto.setCurrentAppId(appId);
        String localPath = this.appFileExtendService.downloadAndUnzip(applicationVersion.getBackFileId());
        appUpgradeDto.setPath(this.formUpgradeInfoService.getUnZipPathByLocalPath(localPath));
        ApiResponse appUpQuickMatchVoApiResponse = this.appUpgradeService.quickMatch(appUpgradeDto);
        appUpgradeDto.setUpGroupContrastList(((AppUpQuickMatchVo)appUpQuickMatchVoApiResponse.getData()).getFormContrast());
        return appUpgradeDto;
    }

    public ApiResponse<SysApplicationVersionVo> getCurrentAppVersion(Long appId) {
        List rollbackVersions;
        SysApplicationVersion appHistoryVersion = (SysApplicationVersion)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplicationVersion::getAppId, (Object)appId)).eq(SysApplicationVersion::getCurrentFlag, (Object)1)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isEmpty((Object)appHistoryVersion)) {
            return ApiResponse.success();
        }
        SysApplicationVersionVo SysApplicationVersionVo2 = new SysApplicationVersionVo();
        BeanUtil.copy((Object)appHistoryVersion, (Object)SysApplicationVersionVo2);
        Long upgradedBy = SysApplicationVersionVo2.getCreator();
        if (HussarUtils.isNotEmpty((Object)upgradedBy)) {
            SysUsers sysUser = this.usersService.getUser(upgradedBy);
            if (HussarUtils.isNotEmpty((Object)sysUser)) {
                SysApplicationVersionVo2.setUpgradeByName(sysUser.getUserName());
            } else {
                SysApplicationVersionVo2.setUpgradeByName("\u672a\u77e5\u7528\u6237");
            }
        }
        if ((rollbackVersions = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplicationVersion::getAppId, (Object)appId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"))).size() > 1) {
            SysApplicationVersionVo2.setRollBackFlag(true);
        }
        return ApiResponse.success((Object)SysApplicationVersionVo2);
    }

    public void updateCurrentFlag(Long appId, Long lastAppVersionId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(SysApplicationVersion::getAppId, (Object)appId)).eq(SysApplicationVersion::getId, (Object)lastAppVersionId)).set(SysApplicationVersion::getCurrentFlag, (Object)false);
        this.update((Wrapper)updateWrapper);
    }

    public ApiResponse<Boolean> rollbackSuccessCallback(Long appId, Long versionId) {
        SysApplicationVersionVo currentVersionVo = (SysApplicationVersionVo)this.getCurrentAppVersion(appId).getData();
        currentVersionVo.setCurrentFlag(0);
        SysApplicationVersion currentVersion = (SysApplicationVersion)BeanUtil.copy((Object)currentVersionVo, SysApplicationVersion.class);
        SysApplicationVersion backVersion = (SysApplicationVersion)this.getById(versionId);
        backVersion.setCurrentFlag(1);
        this.saveOrUpdate((BaseEntity)currentVersion);
        this.saveOrUpdate((BaseEntity)backVersion);
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    public ApiResponse<UpgradeStatusVo> getRollbackVersionProgress(String taskId) {
        UpgradeStatusVo statusVo = (UpgradeStatusVo)HussarCacheUtil.get((String)"upgrade_progress", (Object)taskId);
        return ApiResponse.success((Object)statusVo);
    }

    public String updateAppLock(Long currentAppId) {
        SysApplication sysApplication = (SysApplication)this.sysApplicationService.getAppDetail(currentAppId).getData();
        String appStatusOld = sysApplication.getAppStatus();
        SysApplicationDto applicationDto = new SysApplicationDto();
        applicationDto.setAppStatus("2");
        applicationDto.setId(sysApplication.getId());
        this.sysApplicationService.updateApp(applicationDto);
        return appStatusOld;
    }

    public void updateAppRestore(Long currentAppId, String appStatusOld) {
        SysApplicationDto applicationRestoreDto = new SysApplicationDto();
        applicationRestoreDto.setAppStatus(appStatusOld);
        applicationRestoreDto.setId(currentAppId);
        this.sysApplicationService.updateApp(applicationRestoreDto);
    }
}

