/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.application.model.SysAppVisitAuthorization;
import com.jxdinfo.hussar.application.service.ISysAppGroupBoService;
import com.jxdinfo.hussar.application.service.ISysAppVisitAuthorizationBoService;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.AppMenuVo;
import com.jxdinfo.hussar.formdesign.application.openapi.application.service.OpenAppService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.OpenUserService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.external.openapi.application.service.impl.OpenAppServiceImpl")
public class OpenAppServiceImpl
implements OpenAppService {
    @Resource
    private OpenUserService openUserService;
    @Resource
    private IHussarBaseUserBoService sysUserRoleService;
    @Resource
    private ISysAppVisitAuthorizationBoService appVisitAuthBoService;
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private ISysAppGroupBoService sysAppGroupBoService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysFormService formService;

    @Override
    public ApiResponse<List<SysAppGroupVo>> getAppList(String loginUserId, String appName) {
        Long userId = this.openUserService.getPlatformUserId(loginUserId);
        List<Long> appIds = this.getCurrentUserAuthorityApp(userId);
        if (HussarUtils.isEmpty(appIds)) {
            return null;
        }
        ArrayList<SysApplicationVo> appList = new ArrayList<SysApplicationVo>();
        List applicationVoList = new ArrayList();
        applicationVoList = this.sysApplicationBoService.getAppList(appName, appIds);
        for (Object app : applicationVoList) {
            SysApplicationVo vo = new SysApplicationVo();
            BeanUtils.copyProperties((Object)app, (Object)vo);
            appList.add(vo);
        }
        ArrayList<Long> groupIds = new ArrayList<Long>();
        for (SysApplicationVo sysApplicationVo : appList) {
            groupIds.add(sysApplicationVo.getAppGroupId());
        }
        ArrayList<SysAppGroup> sysAppGroups = new ArrayList();
        if (HussarUtils.isNotEmpty(groupIds)) {
            sysAppGroups = this.sysAppGroupBoService.getAppGroupByIds(groupIds);
        }
        ArrayList<SysApplicationVo> appListVo = new ArrayList<SysApplicationVo>();
        for (SysApplicationVo app : appList) {
            SysApplicationVo vo = new SysApplicationVo();
            BeanUtils.copyProperties((Object)app, (Object)vo);
            appListVo.add(vo);
        }
        return ApiResponse.success(this.combinedData(appListVo, sysAppGroups));
    }

    @Override
    public ApiResponse<List<AppMenuVo>> getFormMenuList(String loginUserId, Long appId) {
        Long userId = this.openUserService.getPlatformUserId(loginUserId);
        return this.formService.getFormMenuList(userId, appId);
    }

    private List<Long> getCurrentUserAuthorityApp(Long userId) {
        List<Long> roleIds = new ArrayList<Long>();
        List sysUserRoles = this.sysUserRoleService.listUserRolesByUserId(userId);
        if (HussarUtils.isNotEmpty((Object)sysUserRoles)) {
            roleIds = sysUserRoles.stream().map(SysUserRole::getGrantedRole).collect(Collectors.toList());
        }
        roleIds.add(userId);
        List authorizeList = this.appVisitAuthBoService.listByRoleIds(roleIds);
        return authorizeList.stream().map(SysAppVisitAuthorization::getAppId).distinct().collect(Collectors.toList());
    }

    private List<SysAppGroupVo> combinedData(List<SysApplicationVo> appList, List<SysAppGroup> sysAppGroups) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysAppGroups), SysAppGroupVo.class).stream().collect(Collectors.toMap(SysAppGroup::getId, sysAppGroupVo -> sysAppGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysApplicationVo sysApplication : appList) {
            SysAppGroupVo sysAppGroupVo2 = (SysAppGroupVo)resultCollect.get(sysApplication.getAppGroupId());
            if (HussarUtils.isEmpty((Object)sysAppGroupVo2)) continue;
            if (HussarUtils.isNotEmpty((Object)sysAppGroupVo2.getSysApplicationList())) {
                sysAppGroupVo2.getSysApplicationList().add(sysApplication);
            }
            if (!HussarUtils.isEmpty((Object)sysAppGroupVo2.getSysApplicationList())) continue;
            ArrayList<SysApplicationVo> sysApplicationList = new ArrayList<SysApplicationVo>();
            sysApplicationList.add(sysApplication);
            sysAppGroupVo2.setSysApplicationList(sysApplicationList);
        }
        return new ArrayList<SysAppGroupVo>(resultCollect.values());
    }

    @Override
    public List<Long> checkPermission(List<Long> formIds, Long userId) {
        List sysForms = this.sysFormService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysForm::getId, formIds)).eq(SysForm::getFormStatus, (Object)1));
        List useFormIds = sysForms.stream().map(SysForm::getId).distinct().collect(Collectors.toList());
        List uniqueAppIds = sysForms.stream().map(SysForm::getAppId).distinct().collect(Collectors.toList());
        ArrayList appMenuVos = new ArrayList();
        for (Long appId : uniqueAppIds) {
            appMenuVos.addAll((Collection)this.sysFormService.getFormMenuList(userId, appId).getData());
        }
        List appMenuFormIds = appMenuVos.stream().map(AppMenuVo::getId).distinct().collect(Collectors.toList());
        return formIds.stream().filter(appMenuFormIds::contains).filter(useFormIds::contains).collect(Collectors.toList());
    }
}

