/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.message.middle;

import com.jxdinfo.hussar.support.exception.HussarException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;

public class RepeatRule {
    private String type;
    private String customType;
    private List<Integer> daysOfWeek;
    private List<Integer> daysOfMonth;
    private boolean relativeRepeat;
    public static final String ONLY_ONCE = "only_once";
    public static final String HOURLY = "hourly";
    public static final String DAILY = "daily";
    public static final String WEEKLY = "weekly";
    public static final String MONTHLY = "monthly";
    public static final String YEARLY = "yearly";
    public static final String CUSTOM = "custom";
    public static final String BY_WEEK = "by_week";
    public static final String BY_MONTH = "by_month";

    public RepeatRule() {
    }

    public RepeatRule(String type) {
        this.type = type;
    }

    public LocalDateTime calculateNextReminderTime(LocalDateTime firstReminderTime, LocalDateTime now) {
        switch (this.type) {
            case "only_once": {
                return firstReminderTime;
            }
            case "hourly": {
                return this.hourly(firstReminderTime, now);
            }
            case "daily": {
                return this.daily(firstReminderTime, now);
            }
            case "weekly": {
                return this.weekly(firstReminderTime, now);
            }
            case "monthly": {
                return this.monthly(firstReminderTime, now);
            }
            case "yearly": {
                return this.yearly(firstReminderTime, now);
            }
            case "custom": {
                return this.custom(firstReminderTime, now);
            }
        }
        throw new HussarException("\u91cd\u590d\u89c4\u5219\u7c7b\u578b\u53c2\u6570\u4e0d\u5408\u6cd5");
    }

    private LocalDateTime hourly(LocalDateTime firstReminderTime, LocalDateTime now) {
        int nowMinute = now.getMinute();
        int nowSecond = now.getSecond();
        int firstReminderTimeMinute = firstReminderTime.getMinute();
        int firstReminderTimeSecond = firstReminderTime.getSecond();
        int firstMs = firstReminderTimeMinute * 60 + firstReminderTimeSecond;
        int nowMs = nowMinute * 60 + nowSecond;
        LocalDateTime nextReminderTime = firstReminderTime.isBefore(now) ? (firstMs < nowMs ? now.plusHours(1L).withMinute(firstReminderTimeMinute).withSecond(firstReminderTimeSecond).withNano(0) : now.withMinute(firstReminderTimeMinute).withSecond(firstReminderTimeSecond).withNano(0)) : firstReminderTime;
        return nextReminderTime;
    }

    private LocalDateTime daily(LocalDateTime firstReminderTime, LocalDateTime now) {
        LocalTime datumTime;
        LocalDate datumDate = firstReminderTime.isBefore(now) ? now.toLocalDate() : firstReminderTime.toLocalDate();
        LocalDateTime nextReminderTime = LocalDateTime.of(datumDate, datumTime = firstReminderTime.toLocalTime());
        if (nextReminderTime.isBefore(now)) {
            nextReminderTime = nextReminderTime.plusDays(1L);
        }
        return nextReminderTime;
    }

    private LocalDateTime weekly(LocalDateTime firstReminderTime, LocalDateTime now) {
        LocalDate datumDate = firstReminderTime.isBefore(now) ? now.toLocalDate() : firstReminderTime.toLocalDate();
        LocalTime datumTime = firstReminderTime.toLocalTime();
        LocalDate resultDate = datumDate.with(firstReminderTime.getDayOfWeek());
        LocalDateTime nextReminderTime = LocalDateTime.of(resultDate, datumTime);
        if (nextReminderTime.isBefore(now)) {
            nextReminderTime = nextReminderTime.plusWeeks(1L);
        }
        return nextReminderTime;
    }

    private LocalDateTime monthly(LocalDateTime firstReminderTime, LocalDateTime now) {
        int monthLength;
        LocalDate datumDate = firstReminderTime.isBefore(now) ? now.toLocalDate() : firstReminderTime.toLocalDate();
        LocalTime datumTime = firstReminderTime.toLocalTime();
        int dayOfMonth = firstReminderTime.getDayOfMonth();
        LocalDate resultDate = datumDate.withDayOfMonth(Math.min(dayOfMonth, monthLength = datumDate.getMonth().length(datumDate.isLeapYear())));
        LocalDateTime nextReminderTime = LocalDateTime.of(resultDate, datumTime);
        if (nextReminderTime.isBefore(now)) {
            resultDate = datumDate.plusMonths(1L);
            resultDate = resultDate.withDayOfMonth(Math.min(dayOfMonth, resultDate.getMonth().length(resultDate.isLeapYear())));
            nextReminderTime = LocalDateTime.of(resultDate, datumTime);
        }
        return nextReminderTime;
    }

    private LocalDateTime yearly(LocalDateTime firstReminderTime, LocalDateTime now) {
        LocalDate datumDate = firstReminderTime.isBefore(now) ? now.toLocalDate() : firstReminderTime.toLocalDate();
        LocalTime datumTime = firstReminderTime.toLocalTime();
        int month = firstReminderTime.getMonthValue();
        int dayOfMonth = firstReminderTime.getDayOfMonth();
        LocalDate resultDate = datumDate.withMonth(month);
        int length = resultDate.getMonth().length(resultDate.isLeapYear());
        LocalDateTime nextReminderTime = LocalDateTime.of(resultDate = resultDate.withDayOfMonth(Math.min(dayOfMonth, length)), datumTime);
        if (nextReminderTime.isBefore(now)) {
            resultDate = resultDate.plusYears(1L);
            length = resultDate.getMonth().length(resultDate.isLeapYear());
            resultDate = resultDate.withDayOfMonth(Math.min(dayOfMonth, length));
            nextReminderTime = LocalDateTime.of(resultDate, datumTime);
        }
        return nextReminderTime;
    }

    private LocalDateTime custom(LocalDateTime firstReminderTime, LocalDateTime now) {
        switch (this.customType) {
            case "by_week": {
                return this.customByWeek(firstReminderTime, now);
            }
            case "by_month": {
                if (this.relativeRepeat) {
                    return this.customByMonthRelative(firstReminderTime, now);
                }
                return this.customByMonthAbsolute(firstReminderTime, now);
            }
        }
        throw new HussarException("\u8ba1\u7b97\u4e0b\u6b21\u63d0\u9192\u65f6\u95f4");
    }

    private LocalDateTime customByWeek(LocalDateTime firstReminderTime, LocalDateTime now) {
        LocalDate datumDate = firstReminderTime.isBefore(now) ? now.toLocalDate() : firstReminderTime.toLocalDate();
        LocalTime datumTime = firstReminderTime.toLocalTime();
        LocalDateTime datumDateTime = LocalDateTime.of(datumDate, datumTime);
        int day = datumDateTime.getDayOfWeek().getValue();
        for (int dayOfWeek : this.daysOfWeek) {
            LocalDateTime nextReminderTime;
            if (dayOfWeek < day || !(nextReminderTime = datumDateTime.plusDays(dayOfWeek - day)).isAfter(now)) continue;
            return nextReminderTime;
        }
        return datumDateTime.plusWeeks(1L).with(DayOfWeek.of(this.daysOfWeek.get(0)));
    }

    private LocalDateTime customByMonthRelative(LocalDateTime firstReminderTime, LocalDateTime now) {
        LocalDate datumDate = firstReminderTime.isBefore(now) ? now.toLocalDate() : firstReminderTime.toLocalDate();
        LocalTime datumTime = firstReminderTime.toLocalTime();
        LocalDate tempDate = datumDate.withDayOfMonth(datumDate.lengthOfMonth());
        LocalDateTime nextReminderTime = LocalDateTime.of(tempDate, datumTime);
        if (nextReminderTime.isBefore(now)) {
            tempDate = datumDate.plusMonths(1L).withDayOfMonth(datumDate.plusMonths(1L).lengthOfMonth());
            nextReminderTime.with(tempDate);
        }
        return nextReminderTime;
    }

    private LocalDateTime customByMonthAbsolute(LocalDateTime firstReminderTime, LocalDateTime now) {
        int length;
        LocalDateTime nextReminderTime;
        LocalDate datumDate = firstReminderTime.isBefore(now) ? now.toLocalDate() : firstReminderTime.toLocalDate();
        LocalTime datumTime = firstReminderTime.toLocalTime();
        int datumDayOfMonth = datumDate.getDayOfMonth();
        int datumMonthLength = datumDate.getMonth().length(datumDate.isLeapYear());
        for (int dayOfMonth : this.daysOfMonth) {
            LocalDate resultDate;
            if (dayOfMonth < datumDayOfMonth || dayOfMonth > datumMonthLength || !(nextReminderTime = LocalDateTime.of(resultDate = datumDate.withDayOfMonth(dayOfMonth), datumTime)).isAfter(now)) continue;
            return nextReminderTime;
        }
        do {
            datumDate = datumDate.plusMonths(1L);
            length = datumDate.getMonth().length(datumDate.isLeapYear());
        } while (this.daysOfMonth.get(0) > length);
        LocalDate resultDate = datumDate.withDayOfMonth(this.daysOfMonth.get(0));
        nextReminderTime = LocalDateTime.of(resultDate, datumTime);
        return nextReminderTime;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCustomType() {
        return this.customType;
    }

    public void setCustomType(String customType) {
        this.customType = customType;
    }

    public List<Integer> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public void setDaysOfWeek(List<Integer> daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public List<Integer> getDaysOfMonth() {
        return this.daysOfMonth;
    }

    public void setDaysOfMonth(List<Integer> daysOfMonth) {
        this.daysOfMonth = daysOfMonth;
    }

    public boolean isRelativeRepeat() {
        return this.relativeRepeat;
    }

    public void setRelativeRepeat(boolean relativeRepeat) {
        this.relativeRepeat = relativeRepeat;
    }
}

