/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.button.aspect;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class TableButtonViewAspect {
    private static final String _TABLE_QUERY_BUTTON = "_tableQuery_button";
    @Resource
    private ISysCustomButtonService sysCustomButtonService;

    @Pointcut(value="execution(* com.jxdinfo.hussar.formdesign.no.code.business.service.impl.ViewServiceImpl.get(..)) || execution(* com.jxdinfo.hussar.formdesign.no.code.business.service.impl.ViewServiceImpl.getWithPublic(..))")
    public void addSysCustomButtonInfo() {
    }

    @Pointcut(value="execution(* com.jxdinfo.hussar.formdesign.no.code.business.service.impl.ViewServiceImpl.save(..)) || execution(* com.jxdinfo.hussar.formdesign.no.code.business.service.impl.ViewServiceImpl.saveWithPublic(..))")
    public void removeSysCustomButtonInfo() {
    }

    @AfterReturning(value="addSysCustomButtonInfo()", returning="viewResponse")
    public FormDesignResponse<FormViewSchema> afterReturningFormViewSchema(FormDesignResponse<FormViewSchema> viewResponse) {
        long startTime = System.currentTimeMillis();
        FormViewSchema view = (FormViewSchema)viewResponse.getData();
        if (HussarUtils.isNotEmpty((Object)view)) {
            String viewJsonString = JSON.toJSONString((Object)view);
            FormViewSchema formView = (FormViewSchema)JSON.parseObject((String)viewJsonString, FormViewSchema.class);
            List dataViews = formView.getViews();
            Long formId = Long.valueOf(view.getFormId());
            List storageButtons = (List)HussarCacheUtil.get((String)_TABLE_QUERY_BUTTON, (Object)formId, List.class);
            if (HussarUtils.isEmpty((Object)storageButtons)) {
                storageButtons = this.sysCustomButtonService.list((Wrapper)new LambdaQueryWrapper().eq(SysCustomButton::getFormId, (Object)formId));
            }
            HussarCacheUtil.evict((String)_TABLE_QUERY_BUTTON, (Object)formId);
            for (DataView dataView : dataViews) {
                List operations;
                List buttons;
                if ("1".equals(view.getFormType()) && ("2".equals(dataView.getTabType()) || "1".equals(dataView.getTabType()) || "3".equals(dataView.getTabType()))) {
                    buttons = dataView.getButtons();
                    if (HussarUtils.isNotEmpty((Object)buttons)) {
                        buttons = buttons.stream().filter(button -> !"custom".equals(button.getType())).collect(Collectors.toList());
                    }
                    if (HussarUtils.isNotEmpty((Object)(operations = dataView.getOperations()))) {
                        operations = operations.stream().filter(operation -> !"custom".equals(operation.getType())).collect(Collectors.toList());
                    }
                } else {
                    buttons = this.sysCustomButtonService.addCustomButtonInfo(storageButtons, dataView.getButtons());
                    operations = this.sysCustomButtonService.addCustomButtonInfo(storageButtons, dataView.getOperations());
                }
                dataView.setButtons(buttons);
                dataView.setOperations(operations);
            }
            viewResponse.setData((Object)formView);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("\u7ebf\u7a0b" + Thread.currentThread().getName() + "TableButtonViewAspect.afterReturningFormViewSchema() \u8017\u65f6\uff1a" + (endTime - startTime) + "ms");
        return viewResponse;
    }

    @Before(value="removeSysCustomButtonInfo()")
    public void beforeSaveFormViewSchema(JoinPoint joinPoint) {
        FormViewSchema view;
        Object[] args = joinPoint.getArgs();
        if (HussarUtils.isNotEmpty((Object[])args) && HussarUtils.isNotEmpty((Object)(view = (FormViewSchema)args[0]))) {
            List dataViews = view.getViews();
            dataViews.forEach(dataView -> {
                List buttons = dataView.getButtons();
                this.sysCustomButtonService.removeCustomButtonInfo(buttons);
            });
        }
    }
}

