/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.panel.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.panel.dao.SysPanelChartMapper;
import com.jxdinfo.hussar.formdesign.application.panel.dto.QueryChartDataDto;
import com.jxdinfo.hussar.formdesign.application.panel.dto.SysPanelChartDto;
import com.jxdinfo.hussar.formdesign.application.panel.model.SysPanelChart;
import com.jxdinfo.hussar.formdesign.application.panel.service.ISysPanelChartService;
import com.jxdinfo.hussar.formdesign.application.panel.vo.SysPanelChartVo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.FormViewSchemaDTO;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.CustomViewServiceImpl;
import com.jxdinfo.hussar.formdesign.no.code.constant.ViewIdEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.panel.service.impl.SysPanelChartServiceImpl")
public class SysPanelChartServiceImpl
extends HussarServiceImpl<SysPanelChartMapper, SysPanelChart>
implements ISysPanelChartService {
    @Resource
    private SysPanelChartMapper sysPanelChartMapper;
    @Resource
    private CustomViewServiceImpl customViewService;
    @Resource
    private ViewService viewService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private EngineApiService engineApiService;
    @Resource
    private ISysApplicationExternalService applicationService;
    public static final String[] SYS_VIEW_ID = ViewIdEnum.sysViews().toArray(new String[0]);

    public ApiResponse<Long> addPanelChart(SysPanelChartDto sysPanelChartDto) {
        this.save((BaseEntity)sysPanelChartDto);
        return ApiResponse.success((Object)sysPanelChartDto.getChartId(), (String)"\u521b\u5efa\u8868\u5355\u6210\u529f");
    }

    public ApiResponse<Boolean> editPanelChart(SysPanelChartDto sysPanelChartDto) {
        boolean flag = this.updateById((BaseEntity)sysPanelChartDto);
        if (!flag) {
            throw new BaseException("\u66f4\u65b0\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    public ApiResponse<Boolean> deletePanelChart(Long chartId) {
        boolean flag = this.removeById(chartId);
        if (!flag) {
            throw new BaseException("\u66f4\u65b0\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    public List<SysPanelChartVo> getPanelChartList(SysPanelChartDto sysPanelChartDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List panelChartList = this.sysPanelChartMapper.selectList((Wrapper)queryWrapper.like(SysPanelChart::getChartName, (Object)sysPanelChartDto.getChartName()));
        return panelChartList.stream().map(sysPanelChart -> (SysPanelChartVo)sysPanelChart).collect(Collectors.toList());
    }

    public SysPanelChartVo getPanelChartDetail(String panelChartId) {
        SysPanelChartVo sysPanelChartVo = new SysPanelChartVo();
        SysPanelChart sysPanelChart = (SysPanelChart)this.getById((Serializable)((Object)panelChartId));
        if (HussarUtils.isNotEmpty((Object)sysPanelChart)) {
            BeanUtils.copyProperties((Object)sysPanelChart, (Object)sysPanelChartVo);
        }
        return sysPanelChartVo;
    }

    public ApiResponse<Object> queryChartData(QueryChartDataDto queryChartDataDto) {
        String businessId = this.getBusinessId(HttpMethod.POST.name(), queryChartDataDto.getAppId(), queryChartDataDto.getFormId(), "echartQuery");
        ResponseEntity responseEntity = this.engineApiService.invokeByReturnEntity(businessId, null, queryChartDataDto.getParams());
        return (ApiResponse)responseEntity.getBody();
    }

    public ApiResponse<Object> formData(QueryChartDataDto queryChartDataDto) {
        Boolean flag = (Boolean)this.applicationService.checkRolePermissions(Long.valueOf(queryChartDataDto.getFormId())).getData();
        if (!flag.booleanValue()) {
            return ApiResponse.success(null, (String)"\u65e0\u8868\u5355\u6743\u9650");
        }
        String appId = queryChartDataDto.getAppId();
        String formId = queryChartDataDto.getFormId();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        if (!((Boolean)WidgetTool.isSourceExist((String)appId, (String)formId).getData()).booleanValue()) {
            ApiResponse objectApiResponse = new ApiResponse();
            objectApiResponse.setData(new ArrayList());
            objectApiResponse.setCode(10000);
            return objectApiResponse;
        }
        String viewId = queryChartDataDto.getViewId();
        if (HussarUtils.isEmpty((Object)viewId)) {
            viewId = HussarUtils.equals((Object)queryChartDataDto.getFormType(), (Object)"0") ? "joiopt0oou9plqj559byloyqdj0dk31i" : "e33a41s5fcl06btfvdc0qnbvqt9wd1h4";
        } else if (!HussarUtils.contains((Object[])SYS_VIEW_ID, (Object)viewId)) {
            viewId = "";
        }
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, String.format("%s%s", "TableQuery", viewId));
        return (ApiResponse)this.engineApiService.invokeByReturnEntity(businessId, null, queryChartDataDto.getParams()).getBody();
    }

    public List<Map<String, Object>> formDataBySelect(QueryChartDataDto queryChartDataDto, String filedName) {
        ArrayList<Map<String, Object>> allData = new ArrayList<Map<String, Object>>();
        Map params = queryChartDataDto.getParams();
        params.put("superQueryConditionDto", new ArrayList());
        params.put("orders", new ArrayList());
        Map group = (Map)params.get("groupAggregation");
        String appId = queryChartDataDto.getAppId();
        String formId = queryChartDataDto.getFormId();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        if (!((Boolean)WidgetTool.isSourceExist((String)appId, (String)formId).getData()).booleanValue()) {
            ApiResponse objectApiResponse = new ApiResponse();
            objectApiResponse.setData(new ArrayList());
            objectApiResponse.setCode(10000);
            return allData;
        }
        String viewId = queryChartDataDto.getViewId();
        if (HussarUtils.isEmpty((Object)viewId)) {
            viewId = HussarUtils.equals((Object)queryChartDataDto.getFormType(), (Object)"0") ? "joiopt0oou9plqj559byloyqdj0dk31i" : "e33a41s5fcl06btfvdc0qnbvqt9wd1h4";
        } else if (!HussarUtils.contains((Object[])SYS_VIEW_ID, (Object)viewId)) {
            FormCanvasSchema formCanvasSchema;
            List widgets;
            Object condition = params.get("superQueryConditionDto");
            Object order = params.get("orders");
            ArrayList filters = new ArrayList();
            List orders = new ArrayList();
            List filtersOfSuper = JSON.parseArray((String)JSON.toJSONString(condition), Filter.class);
            List orderItems = JSON.parseArray((String)JSON.toJSONString(order), OrderItem.class);
            filters = HussarUtils.isEmpty((Object)filtersOfSuper) ? filters : filtersOfSuper;
            orders = HussarUtils.isEmpty((Object)orderItems) ? orders : orderItems;
            DataView data = (DataView)this.customViewService.getById(Long.valueOf(viewId)).getData();
            if (HussarUtils.isEmpty((Object)data)) {
                return allData;
            }
            List cusTomsFilters = data.getFilters();
            ArrayList<Filter> viewFilters = new ArrayList<Filter>();
            for (Filter cusTomsFilter : cusTomsFilters) {
                Filter filter = new Filter();
                HussarUtils.copy((Object)cusTomsFilter, (Object)filter);
                filter.setRule(HeExternalApiUtil.getOperatorType((String)filter.getRule()).getValue());
                viewFilters.add(filter);
            }
            List orderBy = data.getOrderBy();
            filters.addAll(viewFilters);
            if (HussarUtils.isNotEmpty(orders) && HussarUtils.isNotEmpty((Object)orderBy)) {
                Map cNameMaporderBy = orderBy.stream().collect(Collectors.toMap(OrderItem::getColumn, Function.identity()));
                Map cNameMaporders = orders.stream().collect(Collectors.toMap(OrderItem::getColumn, Function.identity()));
                List ordersTemp = JSON.parseArray((String)JSON.toJSONString(order), OrderItem.class);
                for (Map.Entry dataEntry : cNameMaporderBy.entrySet()) {
                    if (cNameMaporders.containsKey(dataEntry.getKey())) continue;
                    ordersTemp.add(dataEntry.getValue());
                }
                orders = ordersTemp;
            } else {
                orders.addAll(orderBy);
            }
            String formType = ((FormViewSchema)this.viewService.get(formId).getData()).getFormType();
            if (HussarUtils.equals((Object)formType, (Object)"1")) {
                Filter processNodeFilter = new Filter();
                processNodeFilter.setField("PROCESS_KEY");
                processNodeFilter.setMatch("AND");
                processNodeFilter.setRule("_isNotNull");
                processNodeFilter.setVal("");
                filters.add(processNodeFilter);
            }
            if (HussarUtils.isNotEmpty(filters) && HussarUtils.isNotEmpty((Object)(widgets = (formCanvasSchema = (FormCanvasSchema)this.canvasService.get(formId).getData()).getWidgets()))) {
                for (Filter filter : filters) {
                    Optional<Widget> any = widgets.stream().filter(x -> HussarUtils.equals((Object)x.getType(), (Object)WidgetType.DATE.getType()) && HussarUtils.equals((Object)x.getName(), (Object)filter.getField())).findAny();
                    if (!any.isPresent()) continue;
                    Widget widget = any.get();
                    Object format = widget.getProps().get((Object)"format");
                    this.setDateCondition(filter, format.toString());
                }
            }
            params.put("superQueryConditionDto", filters);
            params.put("orders", orders);
            viewId = "";
        }
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
        OrderItem orderItem = new OrderItem();
        orderItem.setAsc(true);
        orderItem.setColumn(filedName);
        orderItems.add(orderItem);
        group.put("orders", orderItems);
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, String.format("%s%s", "TableQuery", viewId));
        int i = 1;
        while (true) {
            params.put("current", i);
            params.put("size", 500);
            ResponseEntity response = this.engineApiService.invokeByReturnEntity(businessId, null, params);
            ApiResponse body = (ApiResponse)response.getBody();
            if (!HussarUtils.isNotEmpty((Object)body) || !HussarUtils.isNotEmpty((Object)body.getData())) break;
            PageVo pageVo = (PageVo)((ApiResponse)response.getBody()).getData();
            List oneData = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)pageVo.getData())) {
                oneData = pageVo.getData();
            }
            allData.addAll(oneData);
            if (oneData.size() < 500) break;
            ++i;
        }
        return allData;
    }

    public List<Map<String, Object>> childDataBySelect(QueryChartDataDto selectQueryDto, String parentKey, String fieldName) {
        ArrayList<Map<String, Object>> allData = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> allChildData = new ArrayList<Map<String, Object>>();
        Map params = selectQueryDto.getParams();
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        Filter filterC = new Filter();
        filterC.setRule(String.valueOf(params.get("rule")));
        filterC.setMatch(String.valueOf(params.get("match")));
        filterC.setField(String.valueOf(params.get("fieldName")));
        filterC.setVal("");
        filterList.add(filterC);
        params.put("superQueryConditionDto", filterList);
        params.put("orders", new ArrayList());
        String appId = selectQueryDto.getAppId();
        String formId = selectQueryDto.getFormId();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        if (!((Boolean)WidgetTool.isSourceExist((String)appId, (String)formId).getData()).booleanValue()) {
            ApiResponse objectApiResponse = new ApiResponse();
            objectApiResponse.setData(new ArrayList());
            objectApiResponse.setCode(10000);
            return allData;
        }
        String viewId = selectQueryDto.getViewId();
        if (HussarUtils.isEmpty((Object)viewId)) {
            viewId = HussarUtils.equals((Object)selectQueryDto.getFormType(), (Object)"0") ? "joiopt0oou9plqj559byloyqdj0dk31i" : "e33a41s5fcl06btfvdc0qnbvqt9wd1h4";
        } else if (!HussarUtils.contains((Object[])SYS_VIEW_ID, (Object)viewId)) {
            FormCanvasSchema formCanvasSchema;
            List widgets;
            Object condition = params.get("superQueryConditionDto");
            Object order = params.get("orders");
            ArrayList arrayList = new ArrayList();
            List orders = new ArrayList();
            List filtersOfSuper = JSON.parseArray((String)JSON.toJSONString(condition), Filter.class);
            List orderItems = JSON.parseArray((String)JSON.toJSONString(order), OrderItem.class);
            List<Filter> list = HussarUtils.isEmpty((Object)filtersOfSuper) ? arrayList : filtersOfSuper;
            orders = HussarUtils.isEmpty((Object)orderItems) ? orders : orderItems;
            DataView data = (DataView)this.customViewService.getById(Long.valueOf(viewId)).getData();
            if (HussarUtils.isEmpty((Object)data)) {
                return allData;
            }
            List cusTomsFilters = data.getFilters();
            ArrayList<Filter> viewFilters = new ArrayList<Filter>();
            for (Filter cusTomsFilter : cusTomsFilters) {
                Filter filter = new Filter();
                HussarUtils.copy((Object)cusTomsFilter, (Object)filter);
                filter.setRule(HeExternalApiUtil.getOperatorType((String)filter.getRule()).getValue());
                viewFilters.add(filter);
            }
            List orderBy = data.getOrderBy();
            list.addAll(viewFilters);
            if (HussarUtils.isNotEmpty(orders) && HussarUtils.isNotEmpty((Object)orderBy)) {
                Map cNameMaporderBy = orderBy.stream().collect(Collectors.toMap(OrderItem::getColumn, Function.identity()));
                Map cNameMaporders = orders.stream().collect(Collectors.toMap(OrderItem::getColumn, Function.identity()));
                List ordersTemp = JSON.parseArray((String)JSON.toJSONString(order), OrderItem.class);
                for (Map.Entry dataEntry : cNameMaporderBy.entrySet()) {
                    if (cNameMaporders.containsKey(dataEntry.getKey())) continue;
                    ordersTemp.add(dataEntry.getValue());
                }
                orders = ordersTemp;
            } else {
                orders.addAll(orderBy);
            }
            String formType = ((FormViewSchema)this.viewService.get(formId).getData()).getFormType();
            if (HussarUtils.equals((Object)formType, (Object)"1")) {
                Filter processNodeFilter = new Filter();
                processNodeFilter.setField("PROCESS_KEY");
                processNodeFilter.setMatch("AND");
                processNodeFilter.setRule("_isNotNull");
                processNodeFilter.setVal("");
                list.add(processNodeFilter);
            }
            if (HussarUtils.isNotEmpty(list) && HussarUtils.isNotEmpty((Object)(widgets = (formCanvasSchema = (FormCanvasSchema)this.canvasService.get(formId).getData()).getWidgets()))) {
                for (Filter filter : list) {
                    Optional<Widget> any = widgets.stream().filter(x -> HussarUtils.equals((Object)x.getType(), (Object)WidgetType.DATE.getType()) && HussarUtils.equals((Object)x.getName(), (Object)filter.getField())).findAny();
                    if (!any.isPresent()) continue;
                    Widget widget = any.get();
                    Object format = widget.getProps().get((Object)"format");
                    this.setDateCondition(filter, format.toString());
                }
            }
            params.put("superQueryConditionDto", list);
            params.put("orders", orders);
            viewId = "";
        }
        String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, String.format("%s%s", "TableQuery", viewId));
        int i = 1;
        while (true) {
            params.put("current", i);
            params.put("size", 500);
            ResponseEntity responseEntity = this.engineApiService.invokeByReturnEntity(businessId, null, params);
            PageVo pageVo = (PageVo)((ApiResponse)responseEntity.getBody()).getData();
            if (HussarUtils.isEmpty((Object)((ApiResponse)responseEntity.getBody()).getData())) break;
            List oneData = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)pageVo.getData())) {
                oneData = pageVo.getData();
            }
            allData.addAll(oneData);
            if (oneData.size() < 500) break;
            ++i;
        }
        for (Map map : allData) {
            Object childDataObj = map.get(parentKey);
            if (!HussarUtils.isNotEmpty(childDataObj)) continue;
            List childData = (List)childDataObj;
            allChildData.addAll(childData);
        }
        return allChildData;
    }

    private FormViewSchemaDTO getViewTemp(String formId, String appId) {
        FormDesignResponse viewResponse;
        FormViewSchema view;
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        if (HussarUtils.isNotEmpty((Object)(view = (FormViewSchema)(viewResponse = this.viewService.getWithPublic(formId)).getData()))) {
            FormViewSchemaDTO viewDto = new FormViewSchemaDTO();
            BeanUtils.copyProperties((Object)view, (Object)viewDto);
            ISysApplicationExternalService iSysApplicationExternalService = (ISysApplicationExternalService)SpringUtil.getBean(ISysApplicationExternalService.class);
            SysForm formDetailById = iSysApplicationExternalService.getFormDetailById(Long.valueOf(Long.parseLong(formId)));
            if (HussarUtils.isEmpty((Object)formDetailById) || HussarUtils.isEmpty((Object)formDetailById.getFormStatus())) {
                ToolUtil.getLogger(((Object)((Object)this)).getClass()).error("\u83b7\u53d6\u6570\u636e\u89c6\u56fe ==> \u83b7\u53d6\u8868\u5355\u72b6\u6001\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
                return null;
            }
            viewDto.setFormStatus(formDetailById.getFormStatus());
            viewDto.setFormTitle(formDetailById.getFormName());
            return viewDto;
        }
        return null;
    }

    private void setDateCondition(Filter filter, String format) {
        if (HussarUtils.equals((Object)filter.getRule(), (Object)"_le")) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime time = LocalDateTime.parse(filter.getVal(), df);
            LocalDateTime newTime = null;
            switch (format) {
                case "yyyy": {
                    newTime = time.with(TemporalAdjusters.lastDayOfYear()).withHour(23).withMinute(59).withSecond(59);
                    break;
                }
                case "yyyy-MM": {
                    newTime = time.with(TemporalAdjusters.lastDayOfMonth()).withHour(23).withMinute(59).withSecond(59);
                    break;
                }
                case "yyyy-MM-dd": {
                    newTime = time.withHour(23).withMinute(59).withSecond(59);
                    break;
                }
                case "yyyy-MM-dd HH:mm": {
                    newTime = time.withMinute(59).withSecond(59);
                }
            }
            String result = newTime.format(df);
            filter.setVal(result);
        }
    }

    public String getBusinessId(String requestMethod, String appId, String formId, String invokeMethod) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        String url = FileUtil.posixPath((String[])new String[]{appId, formId, invokeMethod});
        return String.format("%s /%s", requestMethod, url);
    }
}

