/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageBoService;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppImportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportThreadService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.appImportThreadServiceImpl")
public class AppImportThreadServiceImpl
implements IAppImportThreadService {
    @Resource
    private IAppImportInfoService appImportInfoService;
    @Resource
    private ISysApplicationBoService applicationBoService;
    @Resource
    private AppSyncService appSyncService;
    @Resource
    private ISysMenuManageBoService menuBoService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Value(value="${plugin.runMode}")
    private String pluginRunMode;
    private static final Logger LOGGER = LoggerFactory.getLogger(AppImportThreadServiceImpl.class);

    @HussarDs(value="#dataSourceKey")
    public void startImportThread(AppImportDto appImportDto, String dataSourceKey) {
        String currentDsName = DataModelUtil.currentDsName();
        LOGGER.info("\u5e94\u7528\u5bfc\u5165 => \u4f20\u5165\u6570\u636e\u6e90\uff1a{}, \u5f53\u524d\u6570\u636e\u6e90\uff1a{}", (Object)dataSourceKey, (Object)currentDsName);
        ImportMappingDto importMappingDto = new ImportMappingDto();
        try {
            this.appImportInfoService.init(appImportDto);
            this.appImportInfoService.importAppData(appImportDto, importMappingDto);
            TransmittableThreadLocalHolder.set((String)"appId", (Object)String.valueOf(importMappingDto.getNewAppId()));
            this.menuBoService.deleteRecycleApp(importMappingDto.getNewAppId());
            this.appImportInfoService.importFormData(appImportDto, importMappingDto);
            this.appImportInfoService.importMidFile(appImportDto, importMappingDto);
            this.appImportInfoService.importFormAuthData(appImportDto, importMappingDto);
            this.appImportInfoService.importFlowData(appImportDto, importMappingDto);
            if (appImportDto.isImportBusinessData()) {
                this.appImportInfoService.importBusinessData(appImportDto, importMappingDto);
            }
            this.appImportInfoService.syncData(appImportDto, importMappingDto);
            if ("prod".equals(this.pluginRunMode)) {
                this.appImportInfoService.importPlugin(appImportDto, importMappingDto);
            }
            String importCacheKey = (String)TransmittableThreadLocalHolder.get((String)"importCacheKey");
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.success((int)8, (boolean)true, (Object)importMappingDto.getNewAppId()));
        }
        catch (Exception e) {
            if (HussarUtils.isNotEmpty((Object)importMappingDto.getNewAppId())) {
                this.removeAppById(importMappingDto.getNewAppId());
                this.appSyncService.importAppFail(importMappingDto.getNewAppId());
            }
            LOGGER.error("\u5e94\u7528\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            throw new HussarException("\u5bfc\u5165\u5931\u8d25");
        }
    }

    public void removeAppById(Long appId) {
        this.sysApplicationService.delAppAdvancedInfo(appId, null);
        SysApplicationVo appDetail = this.applicationBoService.getAppDetail(appId);
        if (HussarUtils.isNotEmpty((Object)appDetail)) {
            this.applicationBoService.deleteAppCascade(appId);
        }
    }
}

