/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.operatelog.data.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.config.DefaultForm;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.dao.SysUserUsuallyFormMapper;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.model.SysUserUsuallyForm;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.service.ISysUserUsuallyFormService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.operatelog.data.service.impl.SysCommonFormServiceImpl")
public class SysUserUsuallyFormServiceImpl
extends HussarServiceImpl<SysUserUsuallyFormMapper, SysUserUsuallyForm>
implements ISysUserUsuallyFormService {
    @Resource
    private SysUserUsuallyFormMapper sysUserUsuallyFormMapper;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private DefaultForm defaultForm;
    private static final int DEFAULT_SIZE = 20;

    public List<SysUserUsuallyForm> getCommonForm(Long userId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserUsuallyForm::getUserId, (Object)userId);
        List commonForms = this.sysUserUsuallyFormMapper.selectList((Wrapper)wrapper);
        int formSize = commonForms.size();
        SysUserUsuallyFormServiceImpl sysUserUsuallyFormServiceImpl = this;
        List<Long> ids = sysUserUsuallyFormServiceImpl.defaultForm.getIds();
        int i = 0;
        if (HussarUtils.isNotEmpty(ids)) {
            i = ids.size();
        }
        ArrayList<Long> formIds = new ArrayList<Long>();
        while (formSize < 20 && i > 0) {
            boolean found = false;
            for (SysUserUsuallyForm commonForm : commonForms) {
                if (!HussarUtils.equals((Object)commonForm.getFormId(), (Object)ids.get(i - 1))) continue;
                found = true;
                break;
            }
            if (!found) {
                formIds.add(ids.get(i - 1));
                ++formSize;
            }
            --i;
        }
        if (HussarUtils.isNotEmpty(formIds)) {
            List<Object> defaultCommonForms = new ArrayList();
            List forms = this.sysFormService.listByIds(formIds);
            defaultCommonForms = forms.stream().map(sysForm -> {
                SysApplicationVo applicationVo = (SysApplicationVo)this.sysApplicationService.getAppDetail(sysForm.getAppId()).getData();
                if (HussarUtils.isEmpty((Object)applicationVo)) {
                    return null;
                }
                SysUserUsuallyForm sysUserUsuallyForm = new SysUserUsuallyForm();
                sysUserUsuallyForm.setFormId(sysForm.getId());
                sysUserUsuallyForm.setAppId(sysForm.getAppId());
                sysUserUsuallyForm.setUserId(userId);
                sysUserUsuallyForm.setFormName(sysForm.getFormName());
                sysUserUsuallyForm.setAppName(applicationVo.getAppName());
                return sysUserUsuallyForm;
            }).filter(sysUserUsuallyForm -> sysUserUsuallyForm != null).collect(Collectors.toList());
            commonForms.addAll(defaultCommonForms);
        }
        return commonForms;
    }

    public void deleteCommonForm(Long userId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserUsuallyForm::getUserId, (Object)userId);
        this.sysUserUsuallyFormMapper.delete((Wrapper)wrapper);
    }
}

