/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.formLink.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FieldControlVo;
import com.jxdinfo.hussar.formdesign.application.application.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.enums.NoFieldControlEnum;
import com.jxdinfo.hussar.formdesign.application.application.enums.SysFormLinkEnum;
import com.jxdinfo.hussar.formdesign.application.form.dto.CopyMappingDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.formLink.FieldControlUtil;
import com.jxdinfo.hussar.formdesign.application.formLink.constant.FormLinkConstant;
import com.jxdinfo.hussar.formdesign.application.formLink.dao.SysFormLinkMapper;
import com.jxdinfo.hussar.formdesign.application.formLink.dao.SysFormLinkOpenMapper;
import com.jxdinfo.hussar.formdesign.application.formLink.dto.SysFormLinkDto;
import com.jxdinfo.hussar.formdesign.application.formLink.model.SysFormLink;
import com.jxdinfo.hussar.formdesign.application.formLink.model.SysFormLinkOpen;
import com.jxdinfo.hussar.formdesign.application.formLink.model.SysFormLinkSingleInner;
import com.jxdinfo.hussar.formdesign.application.formLink.model.SysFormLinkSingleStatus;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkOpenService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleInnerService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleStatusService;
import com.jxdinfo.hussar.formdesign.application.formLink.vo.SysFormLinkOpenVo;
import com.jxdinfo.hussar.formdesign.application.formLink.vo.SysFormLinkSingleStatusVo;
import com.jxdinfo.hussar.formdesign.application.formLink.vo.SysFormLinkVo;
import com.jxdinfo.hussar.formdesign.application.properties.HussarNocodePublicProperties;
import com.jxdinfo.hussar.formdesign.application.properties.RedirectProperties;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.application.util.ImportUtil;
import com.jxdinfo.hussar.formdesign.application.util.TerminalUtil;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControl;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.FieldControlUnitSchema;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SettingService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.RandomType;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.bpm.form.WorkflowAuthConfigQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.godaxe.service.SysActFormAuthApiService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.formLink.service.impl.SysFormLinkServiceImpl")
public class SysFormLinkServiceImpl
extends HussarServiceImpl<SysFormLinkMapper, SysFormLink>
implements ISysFormLinkService {
    @Resource
    private RedirectProperties redirectProperties;
    @Resource
    private HussarNocodePublicProperties hussarNocodePublicProperties;
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private SysFormLinkMapper sysFormLinkMapper;
    @Resource
    private SysActFormAuthApiService sysActFormAuthApiService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysFormLinkSingleStatusService sysFormLinkSingleStatusService;
    @Resource
    private SysFormLinkOpenMapper sysFormLinkOpenMapper;
    @Resource
    private ISysFormLinkOpenService sysFormLinkOpenService;
    @Resource
    private ISysFormLinkSingleInnerService sysFormLinkSingleInnerService;
    @Resource
    private SettingService settingService;
    private static final Logger LOGGER = LogManager.getLogger(SysFormLinkServiceImpl.class);
    List<String> noFieldContorls = Arrays.asList(NoFieldControlEnum.JXDNUser.getValue(), NoFieldControlEnum.JXDNUserMulti.getValue(), NoFieldControlEnum.JXDNOrg.getValue(), NoFieldControlEnum.JXDNOrgMulti.getValue());

    @HussarTransactional
    public ApiResponse<Map<String, Object>> initFormLinkField(Long formId) {
        if (HussarUtils.isNull((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysFormLinkVo fromLinkByFromId = this.sysFormLinkMapper.getFromLinkByFromId(formId);
        if (HussarUtils.isNull((Object)fromLinkByFromId)) {
            return ApiResponse.success(new HashMap());
        }
        ArrayList<FieldControl> fieldControls = new ArrayList<FieldControl>();
        SysForm sysForm = (SysForm)this.sysFormService.getDetailById(formId).getData();
        if (SysFormLinkEnum.FLOW_FORM.getValue().toString().equals(sysForm.getFormType())) {
            List<FieldControl> addBpmFiledControl = this.getAddBpmFiledControl(formId, sysForm.getAppId());
            fieldControls.addAll(addBpmFiledControl);
        } else {
            List<FieldControl> addFiledControl = this.getAddFiledControl(formId);
            fieldControls.addAll(addFiledControl);
        }
        List<FieldControl> collect = this.filterFormLinkField(fieldControls);
        Map map1 = (Map)JSON.parseObject((String)fromLinkByFromId.getFieldControl(), Map.class);
        List formLinkFieldVoList = JSON.parseArray((String)map1.get("formLinkFieldVoList").toString(), FieldControl.class);
        FieldControlUtil.mergeFieldControl(collect, formLinkFieldVoList);
        Map<String, Object> map = SysFormLinkServiceImpl.setMap(collect);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.set(SysFormLink::getFieldControl, (Object)JSON.toJSONString(map))).eq(SysFormLink::getFormId, (Object)formId);
        boolean flag = this.update((Wrapper)updateWrapper);
        if (!flag) {
            throw new BaseException("\u521d\u59cb\u5316\u8868\u5355\u5916\u94fe\u5b57\u6bb5\u63a7\u5236\u5931\u8d25");
        }
        return ApiResponse.success(map);
    }

    private List<FieldControl> filterFormLinkField(List<FieldControl> fieldControls) {
        if (HussarUtils.isEmpty(fieldControls)) {
            return fieldControls;
        }
        List<FieldControl> result = fieldControls.stream().filter(fieldControl1 -> !this.noFieldContorls.contains(fieldControl1.getType())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(result)) {
            result.forEach(fieldControl -> {
                if (HussarUtils.isNotEmpty((Object)fieldControl.getChildren())) {
                    List<FieldControl> childrenFieldControls = this.filterFormLinkField(fieldControl.getChildren());
                    fieldControl.setChildren(childrenFieldControls);
                }
            });
        }
        return result;
    }

    public ApiResponse<Boolean> updateFormLinkField(Long formId, List<FieldControl> fieldControls) {
        if (fieldControls.size() == 0) {
            return ApiResponse.fail((String)"\u60a8\u8fd8\u672a\u6dfb\u52a0\u8868\u5355\u5b57\u6bb5");
        }
        if (HussarUtils.isNull((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, Object> map = SysFormLinkServiceImpl.setMap(fieldControls);
        String jsonString = JSON.toJSONString(map);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(SysFormLink::getFieldControl, (Object)jsonString)).set(SysFormLink::getHasFieldControl, (Object)SysFormLinkEnum.HAS_FIELD_CONTROL.getValue())).eq(SysFormLink::getFormId, (Object)formId);
        boolean flag = this.update((Wrapper)updateWrapper);
        if (!flag) {
            throw new BaseException("\u66f4\u65b0\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @HussarTransactional
    public ApiResponse<SysFormLinkVo> addFormLink(SysFormLinkDto sysFormLinkDto, HttpServletRequest request) {
        String tcode;
        Long formId = sysFormLinkDto.getFormId();
        SysFormLinkVo fromLinkByFromId = this.sysFormLinkMapper.getFromLinkByFromId(formId);
        if (!HussarUtils.isNull((Object)fromLinkByFromId)) {
            String tcode2;
            this.sysFormLinkMapper.updateFormLinkStatus(fromLinkByFromId.getLinkId(), SysFormLinkEnum.OPENED.getValue());
            fromLinkByFromId.setLinkStatus(SysFormLinkEnum.OPENED.getValue());
            String shortLink = this.hussarNocodePublicProperties.getFrontIp() + "/" + this.redirectProperties.getPublicWrite() + fromLinkByFromId.getLinkShortAddress();
            if (HussarUtils.isNotEmpty((Object)request) && HussarUtils.isNotEmpty((Object)(tcode2 = request.getHeader("Tcode")))) {
                shortLink = shortLink + "?tcode=" + tcode2;
            }
            fromLinkByFromId.setShortLink(shortLink);
            return ApiResponse.success((Object)fromLinkByFromId, (String)"\u8868\u5355\u5916\u94fe\u5df2\u5b58\u5728");
        }
        long linkId = IdWorker.getId((Object)sysFormLinkDto);
        sysFormLinkDto.setLinkId(Long.valueOf(linkId));
        sysFormLinkDto.setHasPass(SysFormLinkEnum.LINKPASS_CLOSE.getValue());
        sysFormLinkDto.setHasFieldControl(SysFormLinkEnum.NO_FIELD_CONTROL.getValue());
        sysFormLinkDto.setLinkShortAddress(this.generateShortLink());
        ArrayList<FieldControl> add = new ArrayList<FieldControl>();
        SysForm sysForm = (SysForm)this.sysFormService.getDetailById(formId).getData();
        if (SysFormLinkEnum.FLOW_FORM.getValue().toString().equals(sysForm.getFormType())) {
            List<FieldControl> addBpmFiledControl = this.getAddBpmFiledControl(formId, sysForm.getAppId());
            add.addAll(addBpmFiledControl);
        } else {
            List<FieldControl> addFiledControl = this.getAddFiledControl(formId);
            add.addAll(addFiledControl);
        }
        List<FieldControl> collect = this.filterFormLinkField(add);
        collect.forEach(fieldControl -> {
            if (NoFieldControlEnum.JXDNGraphicDisplay.getValue().equals(fieldControl.getType())) {
                fieldControl.setWitable(false);
                fieldControl.setRequired(false);
            }
            fieldControl.getChildren().forEach(fieldControlChildren -> {
                if (NoFieldControlEnum.JXDNGraphicDisplay.getValue().equals(fieldControl.getType())) {
                    fieldControlChildren.setRequired(false);
                    fieldControlChildren.setWitable(false);
                }
            });
        });
        Map<String, Object> map = SysFormLinkServiceImpl.setMap(collect);
        String fieldControls = JSON.toJSONString(map);
        sysFormLinkDto.setFieldControl(fieldControls);
        boolean flag = this.save((BaseEntity)sysFormLinkDto);
        if (!flag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25");
        }
        SysFormLink sysFormLink = (SysFormLink)this.getById(Long.valueOf(linkId));
        SysFormLinkVo sysFormLinkVo = new SysFormLinkVo(sysFormLink);
        String shortLink = this.hussarNocodePublicProperties.getFrontIp() + "/" + this.redirectProperties.getPublicWrite() + sysFormLinkVo.getLinkShortAddress();
        if (HussarUtils.isNotEmpty((Object)request) && HussarUtils.isNotEmpty((Object)(tcode = request.getHeader("Tcode")))) {
            shortLink = shortLink + "?tcode=" + tcode;
        }
        sysFormLinkVo.setShortLink(shortLink);
        String formName = this.getFormName(sysFormLinkVo.getFormId());
        sysFormLinkVo.setFormName(formName);
        return ApiResponse.success((Object)sysFormLinkVo, (String)"\u65b0\u589e\u6210\u529f");
    }

    public ApiResponse<SysFormLinkVo> editFormLink(SysFormLinkDto sysFormLinkDto, HttpServletRequest request) {
        boolean flag;
        SysFormLinkVo fromLinkByFromId = this.sysFormLinkMapper.getFromLinkByFromId(sysFormLinkDto.getFormId());
        if (HussarUtils.isNull((Object)fromLinkByFromId)) {
            throw new BaseException("\u8868\u5355\u5916\u94fe\u4e0d\u5b58\u5728");
        }
        if (sysFormLinkDto.isRefresh()) {
            sysFormLinkDto.setLinkShortAddress(this.generateShortLink());
        }
        if (fromLinkByFromId.getHasPass().intValue() == SysFormLinkEnum.LINKPASS_CLOSE.getValue().intValue() && sysFormLinkDto.getHasPass().intValue() == SysFormLinkEnum.LINKPASS_OPEN.getValue().intValue()) {
            sysFormLinkDto.setLinkPass(HussarUtils.random((int)6, (RandomType)RandomType.ALL));
        }
        if (sysFormLinkDto.isRefreshPass()) {
            sysFormLinkDto.setLinkPass(HussarUtils.random((int)6, (RandomType)RandomType.ALL));
        }
        if (!(flag = this.updateById((BaseEntity)sysFormLinkDto))) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
        }
        return ApiResponse.success((Object)this.getFormLinkDetail(fromLinkByFromId.getFormId(), request).getData(), (String)"\u4fdd\u5b58\u6210\u529f");
    }

    public ApiResponse<Boolean> emptyLinkPass(long linkId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.set(SysFormLink::getLinkPass, null)).eq(SysFormLink::getLinkId, (Object)linkId);
        boolean flag = this.update((Wrapper)updateWrapper);
        if (!flag) {
            throw new BaseException("\u5220\u9664\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    public ApiResponse<SysFormLinkVo> getFormLinkDetail(Long formId, HttpServletRequest request) {
        String tcode;
        if (HussarUtils.isNull((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysFormLinkVo fromLinkByShortLink = this.sysFormLinkMapper.getFromLinkByFromId(formId);
        if (HussarUtils.isNull((Object)fromLinkByShortLink)) {
            SysFormLinkVo sysFormLinkVo = new SysFormLinkVo();
            return ApiResponse.success((Object)sysFormLinkVo, (String)"\u8be5\u8868\u5355\u5916\u94fe\u4e0d\u5b58\u5728");
        }
        String shortLink = this.hussarNocodePublicProperties.getFrontIp() + "/" + this.redirectProperties.getPublicWrite() + fromLinkByShortLink.getLinkShortAddress();
        if (HussarUtils.isNotEmpty((Object)request) && HussarUtils.isNotEmpty((Object)(tcode = request.getHeader("Tcode")))) {
            shortLink = shortLink + "?tcode=" + tcode;
        }
        String formName = this.getFormName(fromLinkByShortLink.getFormId());
        fromLinkByShortLink.setFormName(formName);
        fromLinkByShortLink.setType("w");
        fromLinkByShortLink.setShortLink(shortLink);
        return ApiResponse.success((Object)fromLinkByShortLink);
    }

    public ApiResponse<Boolean> getLinkOpenStatus(String formId, String shortLink) {
        SysFormLink sysFormLink = this.getFormFillSettingByFormId(formId);
        if (HussarUtils.isEmpty((Object)sysFormLink)) {
            throw new HussarException("\u83b7\u53d6\u8868\u5355\u5916\u94fe\u8bbe\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        if (!HussarUtils.equals((Object)shortLink, (Object)sysFormLink.getLinkShortAddress())) {
            return ApiResponse.success((Object)false, (String)"\u77ed\u7801\u4e0d\u4e00\u81f4");
        }
        return ApiResponse.success((Object)HussarUtils.equals((Object)FormLinkConstant.LINK_STATUS_OPEN, (Object)sysFormLink.getLinkStatus()));
    }

    public ApiResponse<Boolean> getPwdStatus(String formId) {
        SysFormLink sysFormLink = this.getFormFillSettingByFormId(formId);
        if (HussarUtils.isEmpty((Object)sysFormLink)) {
            throw new HussarException("\u83b7\u53d6\u8868\u5355\u5916\u94fe\u8bbe\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        boolean pwdOpenStatus = HussarUtils.equals((Object)sysFormLink.getHasPass(), (Object)SysFormLinkEnum.LINKPASS_OPEN.getValue());
        return ApiResponse.success((Object)pwdOpenStatus);
    }

    public ApiResponse<Void> verifyPassword(String formId, String password) {
        SysFormLink sysFormLink = this.getFormFillSettingByFormId(formId);
        if (HussarUtils.isEmpty((Object)sysFormLink)) {
            throw new HussarException("\u83b7\u53d6\u8868\u5355\u5916\u94fe\u8bbe\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        String realPassword = sysFormLink.getLinkPass();
        if (HussarUtils.equals((Object)password, (Object)realPassword)) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u5bc6\u7801\u9519\u8bef");
    }

    public String generateShortLink() {
        String shortLink = HussarUtils.random((int)6, (RandomType)RandomType.ALL);
        int count = this.sysFormLinkMapper.getCountByShortLink(shortLink);
        if (count != 0) {
            this.generateShortLink();
        }
        return shortLink;
    }

    @HussarDs(value="#tcode")
    public String redirect(String shortLink, String tcode, HttpServletRequest request) {
        if (HussarUtils.isEmpty((Object)shortLink)) {
            throw new BaseException("\u8868\u5355\u5916\u94fe\u77ed\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysFormLinkVo sysFormLink = this.sysFormLinkMapper.getFromLinkByShortLink(shortLink = shortLink.substring(0, 6));
        if (HussarUtils.isNull((Object)sysFormLink)) {
            return null;
        }
        String userAgent = request.getHeader("User-Agent");
        if (!TerminalUtil.isMobileReq(userAgent)) {
            return sysFormLink.getLinkAddress();
        }
        return sysFormLink.getLinkAddress().replaceFirst("public", "public-m");
    }

    @HussarTransactional
    public Boolean deleteAllForm(Long formId) {
        SysFormLinkSingleStatusVo sysFormLinkSingleStatusVo;
        SysFormLinkOpenVo fromLinkOpenByFromId;
        SysFormLinkVo fromLinkByFromId = this.sysFormLinkMapper.getFromLinkByFromId(formId);
        if (!HussarUtils.isNull((Object)fromLinkByFromId)) {
            this.removeById(fromLinkByFromId.getLinkId());
        }
        if (!HussarUtils.isNull((Object)(fromLinkOpenByFromId = this.sysFormLinkOpenMapper.getFromLinkOpenByFromId(formId)))) {
            this.sysFormLinkOpenService.removeById((Serializable)fromLinkOpenByFromId.getLinkId());
        }
        if (!HussarUtils.isNull((Object)(sysFormLinkSingleStatusVo = (SysFormLinkSingleStatusVo)this.sysFormLinkSingleStatusService.getSysFormLinkSingleStatusByFormId(formId).getData()))) {
            this.sysFormLinkSingleStatusService.removeById((Serializable)sysFormLinkSingleStatusVo.getSingleId());
        }
        LambdaQueryWrapper queryWrapperSelect = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapperSelect.eq(SysFormLinkSingleInner::getFormId, (Object)formId)).isNull(SysFormLinkSingleInner::getDataId);
        SysFormLinkSingleInner sysFormLinkSingleInner = (SysFormLinkSingleInner)this.sysFormLinkSingleInnerService.getOne((Wrapper)queryWrapperSelect);
        if (!HussarUtils.isNull((Object)sysFormLinkSingleInner)) {
            this.sysFormLinkSingleInnerService.removeById((Serializable)sysFormLinkSingleInner.getLinkId());
        }
        return true;
    }

    public Map<String, Object> getFormLinkExportData(List<Long> formIds) {
        HashMap<String, Object> formLinkMap = new HashMap<String, Object>();
        if (HussarUtils.isEmpty(formIds)) {
            return formLinkMap;
        }
        LambdaQueryWrapper formLinkWrapper = new LambdaQueryWrapper();
        formLinkWrapper.in(SysFormLink::getFormId, formIds);
        List formLinks = this.list((Wrapper)formLinkWrapper);
        formLinkMap.put("formLink", formLinks);
        LambdaQueryWrapper formLinkOpenWrapper = new LambdaQueryWrapper();
        formLinkOpenWrapper.in(SysFormLinkOpen::getFormId, formIds);
        List formLinkOpenList = this.sysFormLinkOpenService.list((Wrapper)formLinkOpenWrapper);
        formLinkMap.put("formLinkOpen", formLinkOpenList);
        LambdaQueryWrapper formLinkSingleStatusWrapper = new LambdaQueryWrapper();
        formLinkSingleStatusWrapper.in(SysFormLinkSingleStatus::getFormId, formIds);
        List formLinkSingleStatusList = this.sysFormLinkSingleStatusService.list((Wrapper)formLinkSingleStatusWrapper);
        formLinkMap.put("singleStatus", formLinkSingleStatusList);
        return formLinkMap;
    }

    /*
     * WARNING - void declaration
     */
    @HussarTransactional
    public void saveBatchImportData(JSONObject jsonObject, ImportMappingDto importMappingDto) {
        if (ToolUtil.isNotEmpty((Object)jsonObject)) {
            JSONArray formLinkSingleStatusJsonArray;
            List<SysFormLinkSingleStatus> formLinkSingleStatuses;
            String value;
            String key;
            JSONArray formLinkOpenJsonArray;
            List<SysFormLinkOpen> formLinkOpens;
            JSONArray formLinkJsonArray = (JSONArray)jsonObject.getObject("formLink", JSONArray.class);
            List<SysFormLink> formLinks = AppMigrateUtil.parseJsonArrayToList(formLinkJsonArray, SysFormLink.class);
            if (HussarUtils.isNotEmpty(formLinks)) {
                for (SysFormLink formLink : formLinks) {
                    Long formId = (Long)importMappingDto.getFormIdMap().get(formLink.getFormId());
                    String fieldControl = formLink.getFieldControl();
                    String json = JSON.parse((String)fieldControl).toString();
                    for (Map.Entry entry : importMappingDto.getSubTableNameMap().entrySet()) {
                        String key2 = (String)entry.getKey();
                        String string = (String)entry.getValue();
                        if (!json.contains(key2)) continue;
                        json = json.replace(key2, string);
                    }
                    formLink.setLinkId(ImportUtil.isKeepId(importMappingDto) ? formLink.getLinkId() : null);
                    formLink.setFormId(formId);
                    formLink.setFieldControl(json);
                    formLink.setLinkShortAddress(this.generateShortLink());
                    formLink.setLinkAddress("/public/#/f/" + importMappingDto.getNewAppId() + "/" + formId);
                }
                this.saveBatch(formLinks);
            }
            if (HussarUtils.isNotEmpty(formLinkOpens = AppMigrateUtil.parseJsonArrayToList(formLinkOpenJsonArray = (JSONArray)jsonObject.getObject("formLinkOpen", JSONArray.class), SysFormLinkOpen.class))) {
                for (SysFormLinkOpen formLinkOpen : formLinkOpens) {
                    Long formId = (Long)importMappingDto.getFormIdMap().get(formLinkOpen.getFormId());
                    String linkShow = formLinkOpen.getLinkShow();
                    String json = JSON.parse((String)linkShow).toString();
                    for (Map.Entry entry : importMappingDto.getSubTableNameMap().entrySet()) {
                        String key3 = (String)entry.getKey();
                        String value3 = (String)entry.getValue();
                        if (!json.contains(key3)) continue;
                        json = json.replace(key3, value3);
                    }
                    String printIdArr = formLinkOpen.getPrintIdArr();
                    if (HussarUtils.isNotEmpty((Object)printIdArr)) {
                        for (Map.Entry entry : importMappingDto.getPrintTemplateIdMap().entrySet()) {
                            key = ((Long)entry.getKey()).toString();
                            value = ((Long)entry.getValue()).toString();
                            if (!printIdArr.contains(key)) continue;
                            printIdArr = printIdArr.replace(key, value);
                        }
                    }
                    formLinkOpen.setLinkId(ImportUtil.isKeepId(importMappingDto) ? formLinkOpen.getLinkId() : null);
                    formLinkOpen.setFormId(formId);
                    formLinkOpen.setLinkShow(json);
                    formLinkOpen.setPrintIdArr(printIdArr);
                    formLinkOpen.setLinkShortAddress(this.sysFormLinkOpenService.generateShortLink());
                    formLinkOpen.setLinkAddress("/public/#/s/" + importMappingDto.getNewAppId() + "/" + formId);
                }
                this.sysFormLinkOpenService.saveBatch(formLinkOpens);
            }
            if (HussarUtils.isNotEmpty(formLinkSingleStatuses = AppMigrateUtil.parseJsonArrayToList(formLinkSingleStatusJsonArray = (JSONArray)jsonObject.getObject("singleStatus", JSONArray.class), SysFormLinkSingleStatus.class))) {
                for (SysFormLinkSingleStatus formLinkSingleStatus : formLinkSingleStatuses) {
                    void var13_20;
                    String fieldControl = formLinkSingleStatus.getFieldControl();
                    String json = JSON.parse((String)fieldControl).toString();
                    for (Map.Entry entry2 : importMappingDto.getSubTableNameMap().entrySet()) {
                        key = (String)entry2.getKey();
                        value = (String)entry2.getValue();
                        if (!json.contains(key)) continue;
                        json = json.replace(key, value);
                    }
                    String string = formLinkSingleStatus.getPrintIdArr();
                    if (HussarUtils.isNotEmpty((Object)string)) {
                        for (Map.Entry entry : importMappingDto.getPrintTemplateIdMap().entrySet()) {
                            String key4 = ((Long)entry.getKey()).toString();
                            String value4 = ((Long)entry.getValue()).toString();
                            if (!var13_20.contains(key4)) continue;
                            String string2 = var13_20.replace(key4, value4);
                        }
                    }
                    formLinkSingleStatus.setSingleId(ImportUtil.isKeepId(importMappingDto) ? formLinkSingleStatus.getSingleId() : null);
                    formLinkSingleStatus.setFieldControl(json);
                    formLinkSingleStatus.setPrintIdArr((String)var13_20);
                    formLinkSingleStatus.setFormId((Long)importMappingDto.getFormIdMap().get(formLinkSingleStatus.getFormId()));
                }
                this.sysFormLinkSingleStatusService.saveBatch(formLinkSingleStatuses);
            }
        }
    }

    private boolean isCover(ImportMappingDto importMappingDto) {
        return importMappingDto.isKeepTableName() && HussarUtils.isEmpty((Object)importMappingDto.getSpliceSuffix());
    }

    @HussarTransactional
    public void copyFormLinkData(CopyMappingDto copyMappingDto) {
        String value;
        String key;
        Object printIdArr;
        String value2;
        String key2;
        String json;
        String fieldControl;
        Long oldFormId = copyMappingDto.getOldFormId();
        Long newFormId = copyMappingDto.getNewFormId();
        Long appId = copyMappingDto.getNewAppId();
        LambdaQueryWrapper formLinkWrapper = new LambdaQueryWrapper();
        formLinkWrapper.eq(SysFormLink::getFormId, (Object)oldFormId);
        SysFormLink sysFormLink = (SysFormLink)this.getOne((Wrapper)formLinkWrapper);
        LambdaQueryWrapper formLinkOpenWrapper = new LambdaQueryWrapper();
        formLinkOpenWrapper.eq(SysFormLinkOpen::getFormId, (Object)oldFormId);
        SysFormLinkOpen sysFormLinkOpen = (SysFormLinkOpen)this.sysFormLinkOpenService.getOne((Wrapper)formLinkOpenWrapper);
        LambdaQueryWrapper formLinkSingleStatusWrapper = new LambdaQueryWrapper();
        formLinkSingleStatusWrapper.eq(SysFormLinkSingleStatus::getFormId, (Object)oldFormId);
        SysFormLinkSingleStatus sysFormLinkSingleStatus = (SysFormLinkSingleStatus)this.sysFormLinkSingleStatusService.getOne((Wrapper)formLinkSingleStatusWrapper);
        if (HussarUtils.isNotEmpty((Object)sysFormLink)) {
            fieldControl = sysFormLink.getFieldControl();
            json = JSON.parse((String)fieldControl).toString();
            for (Map.Entry entry : copyMappingDto.getSubTableNameMap().entrySet()) {
                String key22 = (String)entry.getKey();
                String value22 = (String)entry.getValue();
                if (!json.contains(key22)) continue;
                json = json.replace(key22, value22);
            }
            sysFormLink.setLinkId(null);
            sysFormLink.setFieldControl(json);
            sysFormLink.setFormId(newFormId);
            sysFormLink.setLinkShortAddress(this.generateShortLink());
            sysFormLink.setLinkAddress("/public/#/f/" + appId + "/" + newFormId);
            this.save((BaseEntity)sysFormLink);
        }
        if (HussarUtils.isNotEmpty((Object)sysFormLinkOpen)) {
            String linkShow = sysFormLinkOpen.getLinkShow();
            json = JSON.parse((String)linkShow).toString();
            for (Map.Entry entry : copyMappingDto.getSubTableNameMap().entrySet()) {
                key2 = (String)entry.getKey();
                value2 = (String)entry.getValue();
                if (!json.contains(key2)) continue;
                json = json.replace(key2, value2);
            }
            printIdArr = sysFormLinkOpen.getPrintIdArr();
            if (HussarUtils.isNotEmpty((Object)printIdArr)) {
                for (Map.Entry entry : copyMappingDto.getPrintTemplateIdMap().entrySet()) {
                    key = ((Long)entry.getKey()).toString();
                    value = ((Long)entry.getValue()).toString();
                    if (!((String)printIdArr).contains(key)) continue;
                    printIdArr = ((String)printIdArr).replace(key, value);
                }
            }
            sysFormLinkOpen.setLinkId(null);
            sysFormLinkOpen.setLinkShow(json);
            sysFormLinkOpen.setPrintIdArr((String)printIdArr);
            sysFormLinkOpen.setFormId(newFormId);
            sysFormLinkOpen.setLinkShortAddress(this.sysFormLinkOpenService.generateShortLink());
            sysFormLinkOpen.setLinkAddress("/public/#/s/" + appId + "/" + newFormId);
            this.sysFormLinkOpenService.save((Object)sysFormLinkOpen);
        }
        if (HussarUtils.isNotEmpty((Object)sysFormLinkSingleStatus)) {
            fieldControl = sysFormLinkSingleStatus.getFieldControl();
            json = JSON.parse((String)fieldControl).toString();
            for (Map.Entry entry : copyMappingDto.getSubTableNameMap().entrySet()) {
                key2 = (String)entry.getKey();
                value2 = (String)entry.getValue();
                if (!json.contains(key2)) continue;
                json = json.replace(key2, value2);
            }
            printIdArr = sysFormLinkSingleStatus.getPrintIdArr();
            if (HussarUtils.isNotEmpty((Object)printIdArr)) {
                for (Map.Entry entry : copyMappingDto.getPrintTemplateIdMap().entrySet()) {
                    key = ((Long)entry.getKey()).toString();
                    value = ((Long)entry.getValue()).toString();
                    if (!((String)printIdArr).contains(key)) continue;
                    printIdArr = ((String)printIdArr).replace(key, value);
                }
            }
            sysFormLinkSingleStatus.setSingleId(null);
            sysFormLinkSingleStatus.setFieldControl(json);
            sysFormLinkSingleStatus.setPrintIdArr((String)printIdArr);
            sysFormLinkSingleStatus.setFormId(newFormId);
            this.sysFormLinkSingleStatusService.save((Object)sysFormLinkSingleStatus);
        }
    }

    private SysFormLink getFormFillSettingByFormId(String formId) {
        LambdaQueryWrapper formLinkWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFormLink::getFormId, (Object)Long.valueOf(formId));
        return (SysFormLink)this.getOne((Wrapper)formLinkWrapper);
    }

    private static List<FieldControl> copy(List<FieldControl> fieldControlOrigin) {
        ArrayList<FieldControl> add = new ArrayList<FieldControl>();
        if (HussarUtils.isEmpty(fieldControlOrigin)) {
            LOGGER.info("----------fieldControlOrigin\u4e3a\u7a7a----------");
        }
        fieldControlOrigin.forEach(fieldControl -> {
            if (!HussarUtils.isNull((Object)fieldControl)) {
                FieldControl fieldControl1 = new FieldControl();
                fieldControl1.setField(fieldControl.getField());
                fieldControl1.setType(fieldControl.getType());
                fieldControl1.setTitle(fieldControl.getTitle());
                fieldControl1.setVisible(fieldControl.isVisible());
                fieldControl1.setWitable(fieldControl.isWitable());
                fieldControl1.setRequired(fieldControl.isRequired());
                fieldControl1.setReadOnly(fieldControl.isReadOnly());
                fieldControl1.setVisibleDownload(fieldControl.getVisibleDownload());
                fieldControl1.setWitableAdd(fieldControl.getWitableAdd());
                fieldControl1.setWitableDel(fieldControl.getWitableDel());
                fieldControl1.setChildren(Collections.emptyList());
                if (!HussarUtils.isNull((Object)fieldControl.getChildren())) {
                    fieldControl1.setChildren(SysFormLinkServiceImpl.copy(fieldControl.getChildren()));
                }
                add.add(fieldControl1);
            }
        });
        return add;
    }

    private static Map<String, Object> setMap(List<FieldControl> fieldControls) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formLinkFieldVoList", fieldControls);
        AtomicLong visibleCount = new AtomicLong(fieldControls.stream().filter(FieldControl::isVisible).count());
        fieldControls.forEach(fieldControl -> fieldControl.getChildren().stream().filter(FieldControl::isVisible).collect(Collectors.toList()).forEach(fieldControl1 -> visibleCount.getAndIncrement()));
        map.put("visibleNum", visibleCount);
        AtomicLong witableCount = new AtomicLong(fieldControls.stream().filter(FieldControl::isWitable).count());
        fieldControls.forEach(fieldControl -> fieldControl.getChildren().stream().filter(FieldControl::isWitable).collect(Collectors.toList()).forEach(fieldControl1 -> witableCount.getAndIncrement()));
        map.put("editableNum", witableCount);
        return map;
    }

    private String getFormName(Long formId) {
        try {
            SysForm sysForm = (SysForm)this.sysFormService.getDetailById(formId).getData();
            return sysForm.getFormName();
        }
        catch (Exception e) {
            throw new BaseException("\u83b7\u53d6\u8868\u5355\u57fa\u7840\u4fe1\u606f\u5931\u8d25");
        }
    }

    public List<FieldControl> getAddBpmFiledControl(Long formId, Long appId) {
        WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto = new WorkflowAuthConfigQueryDto();
        workflowAuthConfigQueryDto.setFormId(String.valueOf(formId));
        JSONArray jsonArray = this.sysActFormAuthApiService.queryFormAuthConfig(workflowAuthConfigQueryDto);
        if (!jsonArray.isEmpty()) {
            Object object;
            String processKey = "";
            Object object1 = jsonArray.get(0);
            LOGGER.info("-----object1\u7c7b\u578b:{}----------", (Object)object1.getClass().getName());
            LOGGER.info("-----jsonArray\u6570\u636e:{}----------", (Object)jsonArray.toJSONString());
            if (jsonArray.get(0) instanceof LinkedHashMap) {
                LOGGER.info("-----object1\u7c7b\u578b\u4e3aLinkedHashMap----------");
                for (Object o : jsonArray) {
                    LinkedHashMap linkedHashMap = (LinkedHashMap)o;
                    object = linkedHashMap.get("formId");
                    LOGGER.info("-----object\u6570\u636e:{}----------", object);
                    if (!HussarUtils.isNotEmpty(object) || !object.toString().equals(String.valueOf(formId))) continue;
                    processKey = String.valueOf(linkedHashMap.get("processKey"));
                    LOGGER.info("-----processKey\u6570\u636e:{}----------", (Object)processKey);
                    break;
                }
            }
            if (jsonArray.get(0) instanceof JSONObject) {
                LOGGER.info("-----object1\u7c7b\u578b\u4e3aJSONObject----------");
                for (Object o : jsonArray) {
                    JSONObject jsonObject = (JSONObject)o;
                    object = jsonObject.get((Object)"formId");
                    LOGGER.info("-----object\u6570\u636e:{}----------", object);
                    if (!HussarUtils.isNotEmpty((Object)object) || !object.toString().equals(String.valueOf(formId))) continue;
                    processKey = String.valueOf(jsonObject.get((Object)"processKey"));
                    break;
                }
            }
            if (jsonArray.get(0) instanceof SysActFormAuth) {
                LOGGER.info("-----object1\u7c7b\u578b\u4e3aSysActFormAuth----------");
                for (Object o : jsonArray) {
                    SysActFormAuth sysActFormAuth = (SysActFormAuth)o;
                    object = sysActFormAuth.getFormId();
                    LOGGER.info("-----object\u6570\u636e:{}----------", object);
                    if (!HussarUtils.isNotEmpty((Object)object) || !object.toString().equals(String.valueOf(formId))) continue;
                    processKey = sysActFormAuth.getProcessKey();
                    break;
                }
            }
            LOGGER.info("-----processKey:{}----------", (Object)processKey);
            return this.getBpmFiledControl(processKey, appId, formId);
        }
        return this.getAddFiledControl(formId);
    }

    public List<FieldControl> getEditBpmFiledControl(Long formId, Long appId) {
        WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto = new WorkflowAuthConfigQueryDto();
        workflowAuthConfigQueryDto.setFormId(String.valueOf(formId));
        JSONArray jsonArray = this.sysActFormAuthApiService.queryFormAuthConfig(workflowAuthConfigQueryDto);
        if (jsonArray.size() > 0) {
            Object object;
            String processKey = "";
            if (jsonArray.get(0) instanceof LinkedHashMap) {
                for (Object o : jsonArray) {
                    LinkedHashMap linkedHashMap = (LinkedHashMap)o;
                    object = linkedHashMap.get("formId");
                    if (!HussarUtils.isNotEmpty(object) || !object.toString().equals(String.valueOf(formId))) continue;
                    processKey = String.valueOf(linkedHashMap.get("processKey"));
                    break;
                }
            }
            if (jsonArray.get(0) instanceof JSONObject) {
                for (Object o : jsonArray) {
                    JSONObject jsonObject = (JSONObject)o;
                    object = jsonObject.get((Object)"formId");
                    if (!HussarUtils.isNotEmpty(object) || !object.toString().equals(String.valueOf(formId))) continue;
                    processKey = String.valueOf(jsonObject.get((Object)"processKey"));
                    break;
                }
            }
            if (jsonArray.get(0) instanceof SysActFormAuth) {
                for (Object o : jsonArray) {
                    SysActFormAuth sysActFormAuth = (SysActFormAuth)o;
                    object = sysActFormAuth.getFormId();
                    if (!HussarUtils.isNotEmpty(object) || !object.toString().equals(String.valueOf(formId))) continue;
                    processKey = sysActFormAuth.getProcessKey();
                    break;
                }
            }
            return this.getBpmFiledControl(processKey, appId, formId);
        }
        return this.getEditFiledControl(formId);
    }

    private List<FieldControl> getBpmFiledControl(String processKey, Long appId, Long formId) {
        try {
            FieldControlVo fieldControl = this.appFormService.getFieldControl(String.valueOf(formId), null, "2", processKey, String.valueOf(appId));
            LOGGER.info("-----fieldControl:{},\u8868\u5355id:{}----------", (Object)fieldControl, (Object)formId);
            return SysFormLinkServiceImpl.copy(fieldControl.getBpmControl());
        }
        catch (IOException e) {
            throw new BaseException("\u83b7\u53d6\u6d41\u7a0b\u8868\u5355\u7533\u8bf7\u8282\u70b9\u5b57\u6bb5\u63a7\u5236\u5931\u8d25");
        }
    }

    public List<FieldControl> getAddFiledControl(Long formId) {
        try {
            FormDesignResponse fieldControlSchemaFake = this.settingService.getFieldControl(String.valueOf(formId));
            return SysFormLinkServiceImpl.copy(((FieldControlUnitSchema)fieldControlSchemaFake.getData()).getFieldControl().getAdd());
        }
        catch (IOException e) {
            throw new BaseException("\u83b7\u53d6\u666e\u901a\u8868\u5355\u5b57\u6bb5\u63a7\u5236\u5931\u8d25");
        }
    }

    public List<FieldControl> getEditFiledControl(Long formId) {
        try {
            FormDesignResponse fieldControlSchemaFake = this.settingService.getFieldControl(String.valueOf(formId));
            return SysFormLinkServiceImpl.copy(((FieldControlUnitSchema)fieldControlSchemaFake.getData()).getFieldControl().getEdit());
        }
        catch (IOException e) {
            throw new BaseException("\u83b7\u53d6\u666e\u901a\u8868\u5355\u5b57\u6bb5\u63a7\u5236\u5931\u8d25");
        }
    }
}

