/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.button.dao.SysCustomButtonMapper;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.form.dao.FormReferenceDetailMapper;
import com.jxdinfo.hussar.formdesign.application.form.dao.FormReferenceMapper;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.dto.BriefReferenceDto;
import com.jxdinfo.hussar.formdesign.application.form.enums.ReferenceType;
import com.jxdinfo.hussar.formdesign.application.form.model.BriefReference;
import com.jxdinfo.hussar.formdesign.application.form.model.DetailReference;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormReferenceService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.BriefReferenceVo;
import com.jxdinfo.hussar.formdesign.application.rule.dao.SysRuleInfoMapper;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormReferenceServiceImpl")
public class FormReferenceServiceImpl
extends HussarServiceImpl<FormReferenceMapper, BriefReference>
implements IFormReferenceService {
    @Resource
    private FormReferenceMapper formReferenceMapper;
    @Resource
    private FormReferenceDetailMapper formReferenceDetailMapper;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private SysCustomButtonMapper sysCustomButtonMapper;
    @Resource
    private SysRuleInfoMapper sysRuleInfoMapper;
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private CanvasService canvasService;

    public ApiResponse<Boolean> saveBriefReference(BriefReference briefReference) {
        return ApiResponse.success((Object)this.save((BaseEntity)briefReference));
    }

    public ApiResponse<Boolean> delReferenceByReferId(List<String> referId) {
        if (HussarUtils.isNotEmpty(referId)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(BriefReference::getReferId, referId);
            return ApiResponse.success((Object)this.remove((Wrapper)queryWrapper));
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> delReferenceByFormId(Long formId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BriefReference::getReferFormId, (Object)formId);
        return ApiResponse.success((Object)this.remove((Wrapper)queryWrapper));
    }

    public ApiResponse<Boolean> saveDetailReference(DetailReference detailReference) {
        return null;
    }

    public ApiResponse<List<BriefReferenceVo>> briefReference(Long appId, Long formId) {
        ArrayList briefReferenceVos = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isEmpty((Object)formId)) {
            queryWrapper.eq(BriefReference::getSourceAppId, (Object)appId);
        } else {
            queryWrapper.eq(BriefReference::getSourceFormId, (Object)formId);
        }
        List briefReferences = this.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)briefReferences)) {
            Map<Long, List<BriefReference>> groupedReference = briefReferences.stream().collect(Collectors.groupingBy(BriefReference::getReferAppId));
            groupedReference.forEach((key, value) -> {
                BriefReferenceVo briefReferenceVo = new BriefReferenceVo();
                briefReferenceVo.setAppId(key);
                String appName = ((SysApplicationVo)this.sysApplicationService.getAppDetail(key).getData()).getAppName();
                briefReferenceVo.setAppName(appName);
                ArrayList briefReferenceDtos = new ArrayList();
                Map<Long, List<BriefReference>> map = value.stream().collect(Collectors.groupingBy(BriefReference::getReferFormId));
                map.forEach((mapKey, mapValue) -> {
                    BriefReferenceDto briefReferenceDto = new BriefReferenceDto();
                    briefReferenceDto.setFormName(((SysForm)this.sysFormService.getById((Serializable)mapKey)).getFormName());
                    mapValue.forEach(mv -> {
                        if (ReferenceType.CUSTOM_BUTTON.getTypeCode().equals(mv.getType())) {
                            mv.setType("\u81ea\u5b9a\u4e49\u6309\u94ae");
                            mv.setDetailType("\u6309\u94ae\u52a8\u4f5c-\u586b\u5199\u6307\u5b9a\u5185\u5bb9-\u5176\u4ed6\u8868\u5355");
                        } else if (ReferenceType.RULE.getTypeCode().equals(mv.getType())) {
                            mv.setType("\u4e1a\u52a1\u89c4\u5219");
                            mv.setDetailType("\u6267\u884c\u52a8\u4f5c");
                        } else {
                            if (WidgetType.INPUT.getType().equals(mv.getDetailType())) {
                                mv.setType("\u5355\u884c\u6587\u672c");
                                mv.setDetailType("\u9ed8\u8ba4\u503c-\u8ddf\u968f\u5176\u4ed6\u6570\u636e\u53d8\u5316");
                            }
                            if (WidgetType.TEXTAREA.getType().equals(mv.getDetailType())) {
                                mv.setType("\u591a\u884c\u6587\u672c");
                                mv.setDetailType("\u9ed8\u8ba4\u503c-\u8ddf\u968f\u5176\u4ed6\u6570\u636e\u53d8\u5316");
                            }
                            if (WidgetType.SELECT.getType().equals(mv.getDetailType())) {
                                mv.setType("\u4e0b\u62c9\u5355\u9009");
                                mv.setDetailType("\u9009\u9879\u7c7b\u578b-\u5173\u8054\u5df2\u6709\u6570\u636e");
                            }
                            if ((WidgetType.SELECT.getType() + "async").equals(mv.getDetailType())) {
                                mv.setType("\u4e0b\u62c9\u5355\u9009");
                                mv.setDetailType("\u9009\u9879\u7c7b\u578b-\u6570\u636e\u8054\u52a8");
                            }
                            if (WidgetType.SELECT_MUL.getType().equals(mv.getDetailType())) {
                                mv.setType("\u4e0b\u62c9\u591a\u9009");
                                mv.setDetailType("\u9009\u9879\u7c7b\u578b-\u5173\u8054\u5df2\u6709\u6570\u636e");
                            }
                            if ((WidgetType.SELECT_MUL.getType() + "async").equals(mv.getDetailType())) {
                                mv.setType("\u4e0b\u62c9\u591a\u9009");
                                mv.setDetailType("\u9009\u9879\u7c7b\u578b-\u6570\u636e\u8054\u52a8");
                            }
                            if (WidgetType.NUMBER.getType().equals(mv.getDetailType())) {
                                mv.setType("\u6570\u5b57");
                                mv.setDetailType("\u9ed8\u8ba4\u503c-\u8ddf\u968f\u5176\u4ed6\u6570\u636e\u53d8\u5316");
                            }
                            if (WidgetType.DATE.getType().equals(mv.getDetailType())) {
                                mv.setType("\u65e5\u671f");
                                mv.setDetailType("\u9ed8\u8ba4\u503c-\u8ddf\u968f\u5176\u4ed6\u6570\u636e\u53d8\u5316");
                            }
                            if (WidgetType.ADDRESS.getType().equals(mv.getDetailType())) {
                                mv.setType("\u5730\u5740");
                                mv.setDetailType("\u9ed8\u8ba4\u503c-\u8ddf\u968f\u5176\u4ed6\u6570\u636e\u53d8\u5316");
                            }
                            if (WidgetType.JXDNSwitch.getType().equals(mv.getDetailType())) {
                                mv.setType("\u662f\u5426");
                                mv.setDetailType("\u9ed8\u8ba4\u503c-\u8ddf\u968f\u5176\u4ed6\u6570\u636e\u53d8\u5316");
                            }
                            if (WidgetType.JXDNLinkForm.getType().equals(mv.getDetailType())) {
                                mv.setType("\u9009\u62e9\u6570\u636e");
                                mv.setDetailType("\u9009\u62e9\u6570\u636e\u6765\u6e90");
                            }
                            if (WidgetType.JXDNUser.getType().equals(mv.getDetailType())) {
                                mv.setType("\u7528\u6237\u5355\u9009");
                                mv.setDetailType("\u9ed8\u8ba4\u503c-\u8ddf\u968f\u5176\u4ed6\u6570\u636e\u53d8\u5316");
                            }
                            if (WidgetType.JXDNUserMulti.getType().equals(mv.getDetailType())) {
                                mv.setType("\u7528\u6237\u591a\u9009");
                                mv.setDetailType("\u9ed8\u8ba4\u503c-\u8ddf\u968f\u5176\u4ed6\u6570\u636e\u53d8\u5316");
                            }
                            if (WidgetType.JXDNOrg.getType().equals(mv.getDetailType())) {
                                mv.setType("\u7ec4\u7ec7\u5355\u9009");
                                mv.setDetailType("\u9ed8\u8ba4\u503c-\u8ddf\u968f\u5176\u4ed6\u6570\u636e\u53d8\u5316");
                            }
                            if (WidgetType.JXDNOrgMulti.getType().equals(mv.getDetailType())) {
                                mv.setType("\u7ec4\u7ec7\u591a\u9009");
                                mv.setDetailType("\u9ed8\u8ba4\u503c-\u8ddf\u968f\u5176\u4ed6\u6570\u636e\u53d8\u5316");
                            }
                        }
                    });
                    briefReferenceDto.setList(mapValue);
                    briefReferenceDtos.add(briefReferenceDto);
                });
                briefReferenceVo.setGroupedByApp(briefReferenceDtos);
                briefReferenceVos.add(briefReferenceVo);
            });
        }
        return ApiResponse.success(briefReferenceVos);
    }

    public ApiResponse<Boolean> dataProcessing() {
        ArrayList<Object> briefReferenceList = new ArrayList<Object>();
        LambdaQueryWrapper querySysCustomButtonWrapper = new LambdaQueryWrapper();
        List sysCustomButtonList = this.sysCustomButtonMapper.selectList((Wrapper)querySysCustomButtonWrapper);
        if (HussarUtils.isNotEmpty((Object)sysCustomButtonList)) {
            for (SysCustomButton sysCustomButton : sysCustomButtonList) {
                if (sysCustomButton.getFillAction().getInteger("type") != 2) continue;
                String string = sysCustomButton.getFillAction().getJSONObject("data").getString("appId");
                String sourceFormId = sysCustomButton.getFillAction().getJSONObject("data").getString("formId");
                if (!HussarUtils.isNotEmpty((Object)string) || !HussarUtils.isNotEmpty((Object)sourceFormId)) continue;
                BriefReference briefReference = new BriefReference();
                briefReference.setReferFormId(sysCustomButton.getFormId());
                briefReference.setReferAppId(sysCustomButton.getAppId());
                briefReference.setSourceAppId(Long.valueOf(string));
                briefReference.setSourceFormId(Long.valueOf(sourceFormId));
                briefReference.setReferId(String.valueOf(sysCustomButton.getId()));
                briefReference.setType(ReferenceType.CUSTOM_BUTTON.getTypeCode());
                briefReferenceList.add(briefReference);
            }
        }
        List<Map<String, Object>> listRule = this.sysRuleInfoMapper.listRule();
        for (Map map : listRule) {
            BriefReference briefReference = new BriefReference();
            briefReference.setReferFormId(Long.valueOf(map.get("formId").toString()));
            briefReference.setReferAppId(Long.valueOf(map.get("appId").toString()));
            JSONObject target = JSON.parseObject((String)map.get("target").toString());
            if (HussarUtils.isNotEmpty((Object)target)) {
                briefReference.setSourceAppId(Long.valueOf(target.getString("appId")));
                briefReference.setSourceFormId(Long.valueOf(target.getString("formId")));
            }
            briefReference.setReferId(String.valueOf(map.get("ruleId")));
            briefReference.setType(ReferenceType.RULE.getTypeCode());
            briefReferenceList.add(briefReference);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List list = this.sysFormMapper.selectList((Wrapper)queryWrapper);
        for (SysForm sysForm : list) {
            try {
                FormCanvasSchema formCanvasSchema = (FormCanvasSchema)this.canvasService.get(String.valueOf(sysForm.getId())).getData();
                List widgetList = formCanvasSchema.getWidgets();
                String formType = formCanvasSchema.getFormType();
                if (!HussarUtils.isNotEmpty((Object)widgetList) || !"0".equals(formType) && !"1".equals(formType)) continue;
                for (Widget widget : widgetList) {
                    BriefReference briefReference;
                    Boolean isCurrent;
                    JSONObject widgetData;
                    Boolean isCurrent2;
                    Boolean associated = widget.getType().equals(WidgetType.JXDNLinkForm.getType());
                    if (associated.booleanValue() && !(isCurrent2 = Boolean.valueOf(formCanvasSchema.getId().equals(widget.getProps().getJSONObject("linkTableInfo").get((Object)"formId").toString()))).booleanValue()) {
                        BriefReference briefReference2 = new BriefReference();
                        briefReference2.setReferAppId(sysForm.getAppId());
                        briefReference2.setReferFormId(Long.valueOf(formCanvasSchema.getId()));
                        JSONObject widgetJsonObject = (JSONObject)widget.getProps().get((Object)"linkTableInfo");
                        briefReference2.setSourceAppId(Long.valueOf(widgetJsonObject.get((Object)"appId").toString()));
                        briefReference2.setSourceFormId(Long.valueOf(widgetJsonObject.get((Object)"formId").toString()));
                        briefReference2.setReferId(widget.getName());
                        briefReference2.setType(ReferenceType.WIDGET.getTypeCode());
                        briefReference2.setDetailType(widget.getType());
                        briefReferenceList.add(briefReference2);
                    }
                    if (HussarUtils.isNotEmpty((Object)widget.getProps().get((Object)"dataLinkage"))) {
                        widgetData = widget.getProps().getJSONObject("dataLinkage").getJSONObject("data");
                        isCurrent = formCanvasSchema.getId().equals(widgetData.get((Object)"formId").toString());
                        if (!isCurrent.booleanValue()) {
                            briefReference = new BriefReference();
                            briefReference.setReferAppId(sysForm.getAppId());
                            briefReference.setReferFormId(Long.valueOf(formCanvasSchema.getId()));
                            briefReference.setSourceAppId(Long.valueOf(widgetData.get((Object)"appId").toString()));
                            briefReference.setSourceFormId(Long.valueOf(widgetData.get((Object)"formId").toString()));
                            briefReference.setReferId(widget.getName());
                            briefReference.setType(ReferenceType.WIDGET.getTypeCode());
                            briefReference.setDetailType(widget.getType());
                            briefReferenceList.add(briefReference);
                        }
                    }
                    if (!"async".equals(widget.getProps().get((Object)"optionType"))) continue;
                    widgetData = widget.getProps().getJSONObject("async");
                    isCurrent = formCanvasSchema.getId().equals(widgetData.get((Object)"formId"));
                    if (isCurrent.booleanValue()) continue;
                    briefReference = new BriefReference();
                    briefReference.setReferAppId(sysForm.getAppId());
                    briefReference.setReferFormId(Long.valueOf(formCanvasSchema.getId()));
                    briefReference.setSourceAppId(Long.valueOf(widgetData.get((Object)"appId").toString()));
                    briefReference.setSourceFormId(Long.valueOf(widgetData.get((Object)"formId").toString()));
                    briefReference.setReferId(String.valueOf(widget.getName()));
                    briefReference.setType(ReferenceType.WIDGET.getTypeCode());
                    String type = widget.getType();
                    type = type + "async";
                    briefReference.setDetailType(type);
                    briefReferenceList.add(briefReference);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        this.remove((Wrapper)wrapper);
        this.saveBatch(briefReferenceList);
        return ApiResponse.success((Object)true, (String)"\u5386\u53f2\u6570\u636e\u5904\u7406\u5b8c\u6210\uff01");
    }
}

