/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.jxdinfo.hussar.formdesign.app.frame.api.service.IAiSyncService;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.form.service.IAIService;
import com.jxdinfo.hussar.support.config.manager.api.HussarConfigApi;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AiServiceImpl
implements IAIService {
    @Autowired
    private IAiSyncService aiSyncService;
    private static final String ENABLE_VOICE_FILL_FORM_ID = "hussar.system.enableVoiceFillForm";
    @Resource
    private HussarConfigApi configApi;

    public void syncAi(Long formId) {
        if (this.enableVoiceFill().booleanValue()) {
            HussarNoCodeThreadUtil.executeDesignTask(() -> this.aiSyncService.syncForm(formId));
        }
    }

    public void deleteFromAi(Long formId) {
        if (this.enableVoiceFill().booleanValue()) {
            HussarNoCodeThreadUtil.executeDesignTask(() -> this.aiSyncService.deleteForm(formId));
        }
    }

    private Boolean enableVoiceFill() {
        return (Boolean)this.configApi.getConfigInfo(Boolean.class, ENABLE_VOICE_FILL_FORM_ID);
    }
}

