/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.permit.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.authorization.permit.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitDataLogicBoService;
import com.jxdinfo.hussar.authorization.permit.vo.DataLogicFilterVo;
import com.jxdinfo.hussar.authorization.permit.vo.DataLogicVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.service.IPermissionService;
import com.jxdinfo.hussar.formdesign.application.authority.dto.DataLogicAuthorityDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.DataLogicFilterDto;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.DataLogicAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.SysFormRoleAuthVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.authority.service.impl.sysAppVisitDataLogicServiceImpl")
public class SysAppVisitDataLogicServiceImpl
implements ISysAppVisitDataLogicService {
    @Resource
    private ISysFormService sysFormService;
    @Autowired
    private IPermissionService permissionService;
    @Resource
    private ISysAppVisitDataLogicBoService sysAppVisitDataLogicBoService;
    @Resource
    private IdentifierGenerator identifierGenerator;

    @HussarTransactional
    public ApiResponse<Boolean> dataLogicAuthoritySave(DataLogicAuthorityDto dataLogicAuthorityDto) {
        SysAppVisitDataLogic sysAppVisitDataLogic = new SysAppVisitDataLogic();
        BeanUtil.copy((Object)dataLogicAuthorityDto, (Object)sysAppVisitDataLogic);
        SysAppVisitDataLogic lastSysAppVisitDataLogic = this.sysAppVisitDataLogicBoService.getDataLogic(dataLogicAuthorityDto.getAppId(), dataLogicAuthorityDto.getFormId(), dataLogicAuthorityDto.getRoleId());
        sysAppVisitDataLogic.setId(Long.valueOf(HussarUtils.isNotEmpty((Object)lastSysAppVisitDataLogic) ? lastSysAppVisitDataLogic.getId() : IdWorker.getId((Object)sysAppVisitDataLogic)));
        this.sysAppVisitDataLogicBoService.saveOrUpdateBatch(Arrays.asList(sysAppVisitDataLogic));
        this.sysAppVisitDataLogicBoService.deleteDataLogicFilterByLogicIds(Arrays.asList(sysAppVisitDataLogic.getId()));
        if (HussarUtils.isNotEmpty((Object)dataLogicAuthorityDto.getFilters())) {
            ArrayList listDataLogicFilter = Lists.newArrayListWithCapacity((int)10);
            for (DataLogicFilterDto dataLogicFilterDto : dataLogicAuthorityDto.getFilters()) {
                SysAppVisitDataLogicFilter sysAppVisitDataLogicFilter = new SysAppVisitDataLogicFilter();
                BeanUtil.copy((Object)dataLogicFilterDto, (Object)sysAppVisitDataLogicFilter);
                sysAppVisitDataLogicFilter.setRoleDataLogicId(sysAppVisitDataLogic.getId());
                sysAppVisitDataLogicFilter.setFilterConditionCode(dataLogicFilterDto.getFilterCode());
                sysAppVisitDataLogicFilter.setFilterConditionName(dataLogicFilterDto.getFilterName());
                listDataLogicFilter.add(sysAppVisitDataLogicFilter);
            }
            this.sysAppVisitDataLogicBoService.saveBatchDataLogicFilter((List)listDataLogicFilter);
        }
        return ApiResponse.success((Object)Boolean.TRUE, (String)"\u4fdd\u5b58\u6210\u529f");
    }

    @HussarTransactional
    public void saveBatchDataLogicAuthority(List<DataLogicAuthorityDto> dataLogicAuthorityDtoList) {
        if (HussarUtils.isEmpty(dataLogicAuthorityDtoList)) {
            return;
        }
        Long appId = dataLogicAuthorityDtoList.get(0).getAppId();
        List sysAppVisitDataLogics = this.sysAppVisitDataLogicBoService.listDataLogic(appId, null, null);
        Map<String, List<SysAppVisitDataLogic>> dataLogicMap = sysAppVisitDataLogics.stream().collect(Collectors.groupingBy(dataLogic -> String.format("%s-%s", dataLogic.getFormId(), dataLogic.getRoleId())));
        ArrayList<SysAppVisitDataLogic> sysAppVisitDataLogicList = new ArrayList<SysAppVisitDataLogic>();
        ArrayList sysAppVisitDataLogicFilterList = new ArrayList();
        ArrayList<Long> delDataLogicIds = new ArrayList<Long>();
        for (DataLogicAuthorityDto dataLogicAuthorityDto : dataLogicAuthorityDtoList) {
            SysAppVisitDataLogic sysAppVisitDataLogic = new SysAppVisitDataLogic();
            BeanUtil.copy((Object)dataLogicAuthorityDto, (Object)sysAppVisitDataLogic);
            List<SysAppVisitDataLogic> dataLogicsByFormIdRoleId = dataLogicMap.get(String.format("%s-%s", dataLogicAuthorityDto.getFormId(), dataLogicAuthorityDto.getRoleId()));
            if (HussarUtils.isNotEmpty(dataLogicsByFormIdRoleId)) {
                SysAppVisitDataLogic lastSysAppVisitDataLogic = dataLogicsByFormIdRoleId.get(0);
                sysAppVisitDataLogic.setId(lastSysAppVisitDataLogic.getId());
            } else {
                sysAppVisitDataLogic.setId(Long.valueOf(this.identifierGenerator.nextId(SysAppVisitDataLogic.class).longValue()));
            }
            sysAppVisitDataLogicList.add(sysAppVisitDataLogic);
            delDataLogicIds.add(sysAppVisitDataLogic.getId());
            dataLogicAuthorityDto.getFilters().forEach(dataLogicFilterDto -> {
                SysAppVisitDataLogicFilter sysAppVisitDataLogicFilter = new SysAppVisitDataLogicFilter();
                BeanUtil.copy((Object)dataLogicFilterDto, (Object)sysAppVisitDataLogicFilter);
                sysAppVisitDataLogicFilter.setRoleDataLogicId(sysAppVisitDataLogic.getId());
                sysAppVisitDataLogicFilter.setFilterConditionCode(dataLogicFilterDto.getFilterCode());
                sysAppVisitDataLogicFilter.setFilterConditionName(dataLogicFilterDto.getFilterName());
                sysAppVisitDataLogicFilterList.add(sysAppVisitDataLogicFilter);
            });
        }
        if (HussarUtils.isNotEmpty(sysAppVisitDataLogicList)) {
            this.sysAppVisitDataLogicBoService.saveOrUpdateBatch(sysAppVisitDataLogicList);
            if (HussarUtils.isNotEmpty(delDataLogicIds)) {
                this.sysAppVisitDataLogicBoService.deleteDataLogicFilterByLogicIds(delDataLogicIds);
                this.sysAppVisitDataLogicBoService.saveBatchDataLogicFilter(sysAppVisitDataLogicFilterList);
            }
        }
    }

    public ApiResponse<DataLogicAuthorityVo> dataLogicAuthorityList(Long formId, Long roleId) {
        if (HussarUtils.isNotEmpty((Object)formId) && HussarUtils.isNotEmpty((Object)roleId)) {
            DataLogicAuthorityVo dataLogicAuthorityVo = new DataLogicAuthorityVo();
            SysAppVisitDataLogic sysAppVisitDataLogic = this.sysAppVisitDataLogicBoService.getDataLogic(null, formId, roleId);
            if (HussarUtils.isNotEmpty((Object)sysAppVisitDataLogic)) {
                BeanUtil.copy((Object)sysAppVisitDataLogic, (Object)dataLogicAuthorityVo);
                List dataLogicFilterVos = this.sysAppVisitDataLogicBoService.dataLogicFilterList(sysAppVisitDataLogic.getId());
                dataLogicAuthorityVo.setFilters(dataLogicFilterVos);
            }
            return ApiResponse.success((Object)dataLogicAuthorityVo);
        }
        throw new BaseException("\u8868\u5355id\u6216\u89d2\u8272id\u4e3a\u7a7a");
    }

    public Map<Long, DataLogicAuthorityVo> listDataLogicAuthorityByAppId(Long appId, Long roleId, Long formId) {
        HashMap<Long, DataLogicAuthorityVo> dataLogicAuthorityVoMap = new HashMap<Long, DataLogicAuthorityVo>();
        LambdaQueryWrapper wrapperForm = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            wrapperForm.eq(SysForm::getAppId, (Object)appId);
        }
        if (HussarUtils.isNotEmpty((Object)formId)) {
            wrapperForm.eq(SysForm::getId, (Object)formId);
        }
        List sysFormList = this.sysFormService.list((Wrapper)wrapperForm);
        List dataLogicList = this.sysAppVisitDataLogicBoService.listDataLogicAuthority(appId, formId, roleId);
        Map<Long, List<DataLogicVo>> dataLogicGroupMap = dataLogicList.stream().collect(Collectors.groupingBy(SysAppVisitDataLogic::getFormId));
        for (SysForm sysForm : sysFormList) {
            DataLogicAuthorityVo dataLogicAuthorityVo = new DataLogicAuthorityVo();
            List<DataLogicVo> dataLogicAuthorities = dataLogicGroupMap.get(sysForm.getId());
            if (HussarUtils.isNotEmpty(dataLogicAuthorities)) {
                HussarUtils.copy((Object)dataLogicAuthorities.get(0), (Object)dataLogicAuthorityVo);
            }
            dataLogicAuthorityVoMap.put(sysForm.getId(), dataLogicAuthorityVo);
        }
        return dataLogicAuthorityVoMap;
    }

    public void prepareDataLogicAuthorityByFormId(List<SysFormRoleAuthVo> result, Long appId, Long formId) {
        List dataLogicList = this.sysAppVisitDataLogicBoService.listDataLogicAuthority(appId, formId, null);
        Map<Long, List<DataLogicVo>> dataLogicGroupMap = dataLogicList.stream().collect(Collectors.groupingBy(SysAppVisitDataLogic::getRoleId));
        for (SysFormRoleAuthVo formRoleAuthVo : result) {
            DataLogicAuthorityVo dataLogicAuthorityVo = new DataLogicAuthorityVo();
            List<DataLogicVo> dataLogicAuthorities = dataLogicGroupMap.get(formRoleAuthVo.getRoleId());
            if (HussarUtils.isNotEmpty(dataLogicAuthorities)) {
                HussarUtils.copy((Object)dataLogicAuthorities.get(0), (Object)dataLogicAuthorityVo);
            }
            formRoleAuthVo.setDataLogicAuthority(dataLogicAuthorityVo);
        }
    }

    @HussarTransactional
    public void dataLogicAuthorityCancel(Long formId, Long roleId) {
        this.sysAppVisitDataLogicBoService.deleteDataLogicByFormId(null, formId, Arrays.asList(roleId));
    }

    public ApiResponse<List<DataLogicAuthorityVo>> dataLogicAuthorityByFormId(Long formId) {
        if (HussarUtils.isNotEmpty((Object)formId)) {
            List sysAppVisitDataLogics;
            List rolesList;
            SecurityUser user = BaseSecurityUtil.getUser();
            ArrayList<DataLogicAuthorityVo> dataLogicAuthorityVos = new ArrayList<DataLogicAuthorityVo>();
            if (HussarUtils.isNotEmpty((Object)user) && HussarUtils.isNotEmpty((Object)(rolesList = user.getRolesList())) && HussarUtils.isNotEmpty((Object)(sysAppVisitDataLogics = this.sysAppVisitDataLogicBoService.listDataLogicByRoles(null, formId, rolesList)))) {
                for (SysAppVisitDataLogic sysAppVisitDataLogic : sysAppVisitDataLogics) {
                    DataLogicAuthorityVo dataLogicAuthorityVo = new DataLogicAuthorityVo();
                    BeanUtil.copy((Object)sysAppVisitDataLogic, (Object)dataLogicAuthorityVo);
                    List dataLogicFilterVos = this.sysAppVisitDataLogicBoService.dataLogicFilterList(sysAppVisitDataLogic.getId());
                    for (DataLogicFilterVo dataLogicFilterVo : dataLogicFilterVos) {
                        dataLogicFilterVo.setFilterCode(HeExternalApiUtil.getOperatorType((String)dataLogicFilterVo.getFilterCode()).toString());
                    }
                    dataLogicAuthorityVo.setFilters(dataLogicFilterVos);
                    dataLogicAuthorityVos.add(dataLogicAuthorityVo);
                }
            }
            return ApiResponse.success(dataLogicAuthorityVos);
        }
        throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
    }

    public ApiResponse<DataLogicAuthorityVo> dataLogicAuthorityByFormId(Long formId, Long roleId) {
        if (HussarUtils.isNotEmpty((Object)formId)) {
            DataLogicAuthorityVo dataLogicAuthorityVo = this.permissionService.dataLogicAuthorityByFormId(formId, roleId);
            if (HussarUtils.isNotEmpty((Object)dataLogicAuthorityVo)) {
                for (DataLogicFilterVo dataLogicFilterVo : dataLogicAuthorityVo.getFilters()) {
                    dataLogicFilterVo.setFilterCode(HeExternalApiUtil.getOperatorType((String)dataLogicFilterVo.getFilterCode()).toString());
                }
            }
            return ApiResponse.success((Object)dataLogicAuthorityVo);
        }
        throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
    }

    public Boolean deleteDataLogicByFormId(Long appId, Long formId, List<Long> roleIds) {
        return this.sysAppVisitDataLogicBoService.deleteDataLogicByFormId(appId, formId, roleIds);
    }
}

