/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.tableinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataColumnService;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataTableService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.df.data.set.api.table.vo.DataSetTierTable;
import com.jxdinfo.hussar.df.data.set.server.table.form.model.SysDfForm;
import com.jxdinfo.hussar.df.data.set.server.table.form.service.ISysDfFormService;
import com.jxdinfo.hussar.df.data.set.server.table.vo.MetaTableInfo;
import com.jxdinfo.hussar.formdesign.app.frame.server.enmus.FormSysFieldEnum;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.form.dto.AppFormExistResult;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.tabeinfo.LazyQuery;
import com.jxdinfo.hussar.formdesign.application.tableinfo.dto.DataSetTierTableDto;
import com.jxdinfo.hussar.formdesign.application.tableinfo.dto.TableColumnsDto;
import com.jxdinfo.hussar.formdesign.application.tableinfo.dto.TableNameQueryDto;
import com.jxdinfo.hussar.formdesign.application.tableinfo.model.SysUserTableName;
import com.jxdinfo.hussar.formdesign.application.tableinfo.service.FormTableInfoService;
import com.jxdinfo.hussar.formdesign.application.tableinfo.service.ISysUserTableNameService;
import com.jxdinfo.hussar.formdesign.application.util.DatabaseTypeConverter;
import com.jxdinfo.hussar.formdesign.application.util.DatabaseTypewidget;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.service.DatasourceDataService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeBusinessDB;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.engine.api.entity.ModelRelationship;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelRelationshipService;
import com.jxdinfo.hussar.workstation.application.dto.SearchAppFeignDto;
import com.jxdinfo.hussar.workstation.application.service.ISysAppVisitAuthorizeBoService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.tableinfo.service.impl.FormTableInfoServiceImpl")
public class FormTableInfoServiceImpl
implements FormTableInfoService {
    private final Logger LOGGER = LoggerFactory.getLogger(FormTableInfoServiceImpl.class);
    @Autowired
    private DatasourceDataService dataSourceDataService;
    @Autowired
    private ISysFormService formService;
    @Autowired
    private ISysUserTableNameService sysUserTableNameService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private MetadataTableService metadataTableService;
    @Resource
    private ModelRelationshipService modelRelationshipService;
    @Resource
    private ISysAppVisitAuthorizeBoService sysAppVisitAuthorizeService;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService;
    @Resource
    private MetadataColumnService metadataColumnService;
    @Resource
    private ISysDfFormService dfFormService;
    @Resource
    private ISysFormService sysFormService;

    @Override
    public ApiResponse<Boolean> flushed() throws IOException, LcdpException {
        Boolean flushing = (Boolean)HussarCacheUtil.get((String)"sys_user_table_name_flushed", (Object)"flushed_key");
        if (HussarUtils.isNotEmpty((Object)flushing) && flushing.booleanValue()) {
            return ApiResponse.success((Object)false);
        }
        HussarCacheUtil.put((String)"sys_user_table_name_flushed", (Object)"flushed_key", (Object)true, (long)600L);
        try {
            this.sysUserTableNameService.flushed();
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            HussarCacheUtil.evict((String)"sys_user_table_name_flushed", (Object)"flushed_key");
        }
        return ApiResponse.success((Object)true);
    }

    @Override
    public Page<SysUserTableName> getTableInfoList(TableNameQueryDto queryDto) throws IOException, LcdpException {
        this.sysUserTableNameService.clearCreated();
        return this.sysUserTableNameService.selectByPage(queryDto.getPage(), queryDto.getTableNameLike());
    }

    @Override
    public List<TableInfo> getTables(List<String> tableNames) throws IOException, LcdpException {
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource datasource = sysDataSourceService.getByConnName(NoCodeBusinessDB.getNocodeBusinessDB());
        ArrayList tableNamesContainUpper = Lists.newArrayListWithCapacity((int)5);
        tableNamesContainUpper.addAll(tableNames);
        for (String s : tableNames) {
            tableNamesContainUpper.add(s.toUpperCase());
        }
        List tableInfoList = this.dataSourceDataService.filterTables(datasource.getId(), "BASE TABLE", (List)tableNamesContainUpper);
        Set fieldNameUppers = FormSysFieldEnum.getFieldNameUppers();
        for (TableInfo tableInfo : tableInfoList) {
            List fields = tableInfo.getFields();
            if (HussarUtils.isNotEmpty((Object)fields)) {
                fields.removeIf(field -> fieldNameUppers.contains(field.getName().toUpperCase()) || HussarUtils.equals((Object)tableInfo.getName().toUpperCase(), (Object)field.getName().toUpperCase()));
            }
            for (TableField field2 : fields) {
                String widgetType = DatabaseTypewidget.convertWidgetType((String)field2.getType());
                field2.setWidgetType(widgetType);
            }
        }
        return tableInfoList;
    }

    @Override
    public ApiResponse<String> checkTableNames(List<String> tableNames) {
        ApiResponse<Boolean> check = this.sysUserTableNameService.check(tableNames);
        if (!check.isSuccess()) {
            return ApiResponse.fail((String)check.getMsg());
        }
        String key = this.sysUserTableNameService.put(tableNames);
        return ApiResponse.success((Object)key, (String)"");
    }

    @Override
    public ApiResponse<Map<String, List<TableColumnsDto>>> getNoSyncColumns(Long formId) throws Exception {
        HashMap<String, List<TableColumnsDto>> unSyncTableColumnsMap = new HashMap<String, List<TableColumnsDto>>(3);
        SysForm form = (SysForm)this.formService.getDetailById(formId).getData();
        if (HussarUtils.isEmpty((Object)form)) {
            return ApiResponse.fail((String)"\u672a\u627e\u5230\u8868\u5355");
        }
        String tableName = form.getTableName();
        FormCanvasSchema canvas = (FormCanvasSchema)this.canvasSchemaService.get(String.valueOf(formId)).getData();
        if (HussarUtils.isEmpty((Object)canvas)) {
            return ApiResponse.fail((String)"\u672a\u627e\u5230\u753b\u5e03");
        }
        List widgets = canvas.widgetsContainChildren();
        this.getUnSyncColumns(tableName, unSyncTableColumnsMap, widgets);
        return ApiResponse.success(unSyncTableColumnsMap);
    }

    private void getUnSyncColumns(String tableName, Map<String, List<TableColumnsDto>> unSyncTableColumnsMap, List<Widget> widgets) throws IOException, LcdpException {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(tableName.toUpperCase());
        tableNames.add(tableName.toLowerCase());
        List<TableInfo> tableInfos = this.getTables(tableNames);
        if (HussarUtils.isNotEmpty(tableInfos)) {
            List tableFields = tableInfos.get(0).getFields();
            List existingColumns = WidgetTool.getAllFieldsByType(widgets);
            ArrayList<TableColumnsDto> unSyncColumns = new ArrayList<TableColumnsDto>();
            for (TableField tableField : tableFields) {
                if (existingColumns.contains(tableField.getName())) continue;
                TableColumnsDto tableColumnsDto = new TableColumnsDto();
                tableColumnsDto.setFieldName(tableField.getName());
                tableColumnsDto.setFieldDesc(tableField.getComment());
                tableColumnsDto.setFieldType(DatabaseTypeConverter.convertDataBaseType((String)tableField.getType()));
                tableColumnsDto.setFieldLength(tableField.getDataLength());
                tableColumnsDto.setAllowNull(!tableField.getDataIsEmpty());
                unSyncColumns.add(tableColumnsDto);
            }
            unSyncTableColumnsMap.put(tableName, unSyncColumns);
            List childWidget = widgets.stream().filter(widget -> WidgetType.CHILDREN_TABLE.getType().equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType())).collect(Collectors.toList());
            for (Widget subWidget : childWidget) {
                if (!HussarUtils.isNotEmpty((Object)subWidget.getChildren())) continue;
                String subTableName = subWidget.getName();
                this.getUnSyncColumns(subTableName, unSyncTableColumnsMap, subWidget.getChildren());
            }
        }
    }

    @Override
    public List<DataSetTierTableDto> sqlListTable(LazyQuery lazyQuery) {
        ArrayList<DataSetTierTableDto> appTables = new ArrayList<DataSetTierTableDto>();
        if (lazyQuery.isRoot()) {
            SearchAppFeignDto searchAppFeignDto = new SearchAppFeignDto();
            List appList = this.sysAppVisitAuthorizeService.getAppList(searchAppFeignDto);
            if (HussarUtils.isEmpty((Object)appList)) {
                return new ArrayList<DataSetTierTableDto>();
            }
            ArrayList applications = new ArrayList();
            appList.forEach(app -> applications.addAll(app.getSysApplicationList()));
            if (HussarUtils.isEmpty(applications)) {
                return new ArrayList<DataSetTierTableDto>();
            }
            List appFormExistResults = this.sysFormService.existFormByAppId(applications.stream().map(SysApplication::getId).collect(Collectors.toList()));
            for (SysApplication application : applications) {
                DataSetTierTableDto appInfo = new DataSetTierTableDto();
                if (HussarUtils.isNotEmpty((Object)appFormExistResults)) {
                    Optional<AppFormExistResult> first = appFormExistResults.stream().filter(item -> item.getAppId().equals(application.getId())).findFirst();
                    first.ifPresent(appFormExistResult -> appInfo.setAppChild(appFormExistResult.isExist()));
                }
                appInfo.setName(application.getAppCode());
                appInfo.setCode(application.getAppCode());
                appInfo.setComment(application.getAppName());
                appInfo.setType("1");
                appInfo.setAppId(application.getId());
                appTables.add(appInfo);
            }
        } else if (HussarUtils.isNotEmpty((Object)lazyQuery.getAppId()) && HussarUtils.isEmpty((Object)lazyQuery.getTableName())) {
            String appId = lazyQuery.getAppId();
            ArrayList allForms = new ArrayList();
            List formIds = (List)this.sysAppVisitFormAuthorizeRolesService.getAuthorityFormList(Long.valueOf(appId)).getData();
            if (HussarUtils.isEmpty((Object)formIds)) {
                return new ArrayList<DataSetTierTableDto>();
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysDfForm::getId, (Collection)formIds);
            List collect = this.dfFormService.list((Wrapper)queryWrapper);
            if (!collect.isEmpty()) {
                allForms.addAll(collect);
            }
            ArrayList tableIdList = new ArrayList();
            HashMap<String, Object> masterTableMap = new HashMap<String, Object>();
            HashMap<String, String> tableNameMap = new HashMap<String, String>();
            for (Object form : allForms) {
                MetadataTable metadataTable;
                String tableName = form.getTableName();
                tableNameMap.put(tableName.toUpperCase(), form.getFormName());
                if (!HussarUtils.isNotEmpty((Object)tableName) || !HussarUtils.isNotEmpty((Object)(metadataTable = this.metadataTableService.getMetadataTableByName(tableName, null)))) continue;
                List modelRelationships = this.modelRelationshipService.getModelsByTfmodelId(form.getId().toString());
                tableIdList.addAll(modelRelationships.stream().map(ModelRelationship::getTableId).collect(Collectors.toList()));
                masterTableMap.put(metadataTable.getTableName().toUpperCase(), metadataTable);
            }
            List tableInfosByTableIds = this.metadataTableService.getTableInfosByTableIds(tableIdList);
            for (Object tableInfoDto : tableInfosByTableIds) {
                masterTableMap.put(tableInfoDto.getTableName().toUpperCase(), tableInfoDto);
            }
            DataSetTierTableDto appInfo = new DataSetTierTableDto();
            appInfo.setAppId(Long.valueOf(appId));
            appTables.add(appInfo);
            if (HussarUtils.isEmpty((Object)collect)) {
                return appTables;
            }
            for (String tableName : masterTableMap.keySet()) {
                MetadataTable metadataTable = (MetadataTable)masterTableMap.get(tableName.toUpperCase());
                if (!HussarUtils.isNotEmpty((Object)metadataTable)) continue;
                String formName = (String)tableNameMap.get(tableName.toUpperCase());
                if (HussarUtils.isNotEmpty((Object)formName)) {
                    metadataTable.setTableDec(formName);
                }
                DataSetTierTable table = new DataSetTierTable();
                table.setName(metadataTable.getTableName());
                table.setCode(metadataTable.getTableName());
                table.setComment(metadataTable.getTableDec());
                table.setType("2");
                table.setTableId(metadataTable.getTableId());
                if (!HussarUtils.isNotEmpty((Object)table)) continue;
                appInfo.addChild(table);
            }
        } else if (HussarUtils.isNotEmpty((Object)lazyQuery.getTableName())) {
            String appId = lazyQuery.getAppId();
            Long tableId = lazyQuery.getTableId();
            String tableName = lazyQuery.getTableName().toUpperCase();
            if (HussarUtils.isNotEmpty((Object)tableId)) {
                List metadataColumns = this.metadataColumnService.listByTableId(tableId);
                DataSetTierTableDto appInfo = new DataSetTierTableDto();
                appInfo.setAppId(Long.valueOf(appId));
                ArrayList<DataSetTierTable> formTables = new ArrayList<DataSetTierTable>();
                DataSetTierTable formTable = new DataSetTierTable();
                formTables.add(formTable);
                formTable.setName(tableName);
                formTable.setTableId(tableId);
                appInfo.setChildren(formTables);
                ArrayList<DataSetTierTable> dataSetTierTables = new ArrayList<DataSetTierTable>();
                for (MetadataColumn metadataColumn : metadataColumns) {
                    DataSetTierTable field = new DataSetTierTable();
                    field.setName(metadataColumn.getColumnName());
                    field.setCode(tableName + "_" + metadataColumn.getColumnName());
                    field.setComment(metadataColumn.getColumnComment());
                    field.setColumnId(metadataColumn.getColumnId());
                    field.setType("3");
                    field.setDataType(metadataColumn.getJdbcType());
                    field.setJavaType(metadataColumn.getJavaType());
                    dataSetTierTables.add(field);
                }
                formTable.setChildren(dataSetTierTables);
                appTables.add(appInfo);
            }
        }
        return appTables;
    }

    @Override
    public List<DataSetTierTableDto> querySqlList(LazyQuery lazyQuery) {
        if (lazyQuery == null) {
            return Collections.emptyList();
        }
        if (lazyQuery.isRoot()) {
            return Collections.emptyList();
        }
        if (HussarUtils.isEmpty((Object)lazyQuery.getTableName()) || HussarUtils.isEmpty((Object)lazyQuery.getAppId())) {
            return Collections.emptyList();
        }
        ArrayList<DataSetTierTableDto> appTables = new ArrayList<DataSetTierTableDto>();
        String queryTableName = lazyQuery.getTableName();
        if (HussarUtils.isEmpty((Object)lazyQuery.getTableId())) {
            String appId = lazyQuery.getAppId();
            ArrayList allForms = new ArrayList();
            List formIds = (List)this.sysAppVisitFormAuthorizeRolesService.getAuthorityFormList(Long.valueOf(appId)).getData();
            if (HussarUtils.isEmpty((Object)formIds)) {
                return new ArrayList<DataSetTierTableDto>();
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysDfForm::getId, (Collection)formIds);
            List collect = this.dfFormService.list((Wrapper)queryWrapper);
            if (!collect.isEmpty()) {
                allForms.addAll(collect);
            }
            ArrayList tableIdList = new ArrayList();
            HashMap<String, Object> masterTableMap = new HashMap<String, Object>();
            HashMap<String, String> tableNameMap = new HashMap<String, String>();
            for (Object form : allForms) {
                MetadataTable metadataTable;
                String tableName = form.getTableName();
                tableNameMap.put(tableName.toUpperCase(), form.getFormName());
                if (!HussarUtils.isNotEmpty((Object)tableName) || !HussarUtils.isNotEmpty((Object)(metadataTable = this.metadataTableService.getMetadataTableByName(tableName, null)))) continue;
                List modelRelationships = this.modelRelationshipService.getModelsByTfmodelId(form.getId().toString());
                tableIdList.addAll(modelRelationships.stream().map(ModelRelationship::getTableId).collect(Collectors.toList()));
                masterTableMap.put(metadataTable.getTableName().toUpperCase(), metadataTable);
            }
            List tableInfosByTableIds = this.metadataTableService.getTableInfosByTableIds(tableIdList);
            for (Object tableInfoDto : tableInfosByTableIds) {
                masterTableMap.put(tableInfoDto.getTableName().toUpperCase(), tableInfoDto);
            }
            DataSetTierTableDto appInfo = new DataSetTierTableDto();
            appInfo.setAppId(Long.valueOf(appId));
            appTables.add(appInfo);
            if (HussarUtils.isEmpty((Object)collect)) {
                return appTables;
            }
            for (String tableName : masterTableMap.keySet()) {
                MetadataTable metadataTable = (MetadataTable)masterTableMap.get(tableName.toUpperCase());
                if (!HussarUtils.isNotEmpty((Object)metadataTable)) continue;
                String formName = (String)tableNameMap.get(tableName.toUpperCase());
                if (HussarUtils.isNotEmpty((Object)formName)) {
                    metadataTable.setTableDec(formName);
                }
                DataSetTierTable table = new DataSetTierTable();
                String metadataTableTableName = metadataTable.getTableName();
                String tableDec = metadataTable.getTableDec();
                table.setName(metadataTable.getTableName());
                table.setCode(metadataTable.getTableName());
                table.setComment(metadataTable.getTableDec());
                table.setType("2");
                table.setTableId(metadataTable.getTableId());
                if (!HussarUtils.isNotEmpty((Object)tableDec) || !tableDec.contains(queryTableName) && !metadataTableTableName.toUpperCase().contains(queryTableName.toUpperCase())) continue;
                appInfo.addChild(table);
            }
        } else {
            String appId = lazyQuery.getAppId();
            Long tableId = lazyQuery.getTableId();
            String tableName = lazyQuery.getTableName().toUpperCase();
            List metadataColumns = this.metadataColumnService.listByTableId(tableId);
            DataSetTierTableDto appInfo = new DataSetTierTableDto();
            appInfo.setAppId(Long.valueOf(appId));
            ArrayList<DataSetTierTable> formTables = new ArrayList<DataSetTierTable>();
            DataSetTierTable formTable = new DataSetTierTable();
            formTables.add(formTable);
            formTable.setName(tableName);
            formTable.setTableId(tableId);
            appInfo.setChildren(formTables);
            ArrayList<DataSetTierTable> dataSetTierTables = new ArrayList<DataSetTierTable>();
            for (MetadataColumn metadataColumn : metadataColumns) {
                DataSetTierTable field = new DataSetTierTable();
                String columnName = metadataColumn.getColumnName();
                String columnComment = metadataColumn.getColumnComment();
                field.setName(metadataColumn.getColumnName());
                field.setCode(tableName + "_" + metadataColumn.getColumnName());
                field.setComment(metadataColumn.getColumnComment());
                field.setColumnId(metadataColumn.getColumnId());
                field.setType("3");
                field.setDataType(metadataColumn.getJdbcType());
                field.setJavaType(metadataColumn.getJavaType());
                if (!HussarUtils.isNotEmpty((Object)columnName) || !HussarUtils.isNotEmpty((Object)columnComment) || !columnName.contains(queryTableName) && !columnComment.toUpperCase().contains(queryTableName.toUpperCase())) continue;
                dataSetTierTables.add(field);
            }
            formTable.setChildren(dataSetTierTables);
            appTables.add(appInfo);
        }
        return appTables;
    }

    private void transMasterFileds(DataSetTierTable appTables, MetadataTable metadataTable, List<MetadataColumn> metadataColumns, Boolean linkedDataSet) {
        DataSetTierTable table = new DataSetTierTable();
        table.setName(metadataTable.getTableName());
        table.setCode(metadataTable.getTableName());
        table.setComment(metadataTable.getTableDec());
        table.setType("2");
        table.setTableId(metadataTable.getTableId());
        for (MetadataColumn metadataColumn : metadataColumns) {
            DataSetTierTable field = new DataSetTierTable();
            field.setName(metadataColumn.getColumnName());
            field.setCode(metadataTable.getTableName() + "_" + metadataColumn.getColumnName());
            field.setComment(metadataColumn.getColumnComment());
            field.setColumnId(metadataColumn.getColumnId());
            field.setType("3");
            field.setDataType(metadataColumn.getJdbcType());
            field.setJavaType(metadataColumn.getJavaType());
            if (linkedDataSet.booleanValue()) {
                table.addChild(field);
                continue;
            }
            table.addfields(field);
        }
        if (HussarUtils.isNotEmpty((Object)table)) {
            appTables.addChild(table);
        }
    }

    private void transSlaveFileds(DataSetTierTable appTables, MetaTableInfo metaTableInfo, Boolean linkedDataSet) {
        DataSetTierTable table = new DataSetTierTable();
        MetadataTable metadataTable = metaTableInfo.getMetadataTable();
        List metadataColumnList = metaTableInfo.getMetadataColumn();
        table.setName(metadataTable.getTableName());
        table.setCode(metadataTable.getTableName());
        table.setComment(metadataTable.getTableDec());
        table.setType("2");
        table.setTableId(metadataTable.getTableId());
        for (MetadataColumn metadataColumn : metadataColumnList) {
            DataSetTierTable field = new DataSetTierTable();
            field.setName(metadataColumn.getColumnName());
            field.setCode(metadataTable.getTableName() + "_" + metadataColumn.getColumnName());
            field.setComment(metadataColumn.getColumnComment());
            field.setColumnId(metadataColumn.getColumnId());
            field.setType("3");
            field.setDataType(metadataColumn.getJdbcType());
            field.setJavaType(metadataColumn.getJavaType());
            if (linkedDataSet.booleanValue()) {
                table.addChild(field);
                continue;
            }
            table.addfields(field);
        }
        if (HussarUtils.isNotEmpty((Object)table)) {
            appTables.addChild(table);
        }
    }

    private void dealSlaveTable(List<ModelRelationship> modelRelationships, Map<Long, ModelRelationship> modelRelationshipMap, Map<Long, List<MetaTableInfo>> dataSetTableVoMapList, List<MetadataColumn> metadataColumns, Map<Long, MetadataTable> metadataTableMap, List<MetadataTable> metadataTables) {
        HashSet<Long> tableIds = new HashSet<Long>();
        for (ModelRelationship modelRelationship : modelRelationships) {
            MetadataTable metadataTable;
            Long tableId;
            ModelRelationship parentModelRelationship;
            Long parentId = modelRelationship.getParentId();
            if (HussarUtils.isEmpty((Object)parentId) || HussarUtils.isEmpty((Object)(parentModelRelationship = modelRelationshipMap.get(parentId))) || !HussarUtils.isNotEmpty((Object)metadataTableMap.get(tableId = parentModelRelationship.getTableId())) || !tableIds.add((metadataTable = metadataTables.stream().filter(table -> table.getTableId().equals(modelRelationship.getTableId())).findFirst().get()).getTableId())) continue;
            List metadataColumnList = metadataColumns.stream().filter(metadataColumn -> metadataColumn.getTableId().equals(metadataTable.getTableId())).collect(Collectors.toList());
            final MetaTableInfo metadataTableInfo = new MetaTableInfo();
            metadataTableInfo.setMetadataTable(metadataTable);
            metadataTableInfo.setMetadataColumn(metadataColumnList);
            if (HussarUtils.isNotEmpty(dataSetTableVoMapList.get(tableId))) {
                dataSetTableVoMapList.get(tableId).add(metadataTableInfo);
                continue;
            }
            dataSetTableVoMapList.put(tableId, (List<MetaTableInfo>)new ArrayList<MetaTableInfo>(){
                {
                    this.add(metadataTableInfo);
                }
            });
        }
    }
}

