/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.operatelog.data.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.dao.SysDataOperateLogMapper;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.dto.DataOperateLogDto;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.model.SysDataOperateLog;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.model.SysUserUsuallyForm;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.service.ISysDataOperateLogService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.vo.SysDataOperateLogPage;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.vo.SysDataOperateLogVo;
import com.jxdinfo.hussar.formdesign.application.properties.DataOperateLogProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.operatelog.data.service.impl.SysDataOperateLogServiceImpl")
public class SysDataOperateLogServiceImpl
extends HussarServiceImpl<SysDataOperateLogMapper, SysDataOperateLog>
implements ISysDataOperateLogService {
    @Resource
    private DataOperateLogProperties dataOperateLogProperties;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private IHussarBaseUserBoService usersService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private IHussarAppFormService hussarAppFormService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private SysDataOperateLogMapper sysDataOperateLogMapper;
    @Resource
    private ISysApplicationService sysApplicationService;

    public ApiResponse<SysDataOperateLogPage> list(DataOperateLogDto dataOperateLogDto) {
        try {
            Long.valueOf(dataOperateLogDto.getDataId());
        }
        catch (Exception e) {
            this.log.error("\u6570\u636e\u64cd\u4f5c\u65e5\u5fd7\u67e5\u8be2\u5931\u8d25\uff0c\u6570\u636eID\u7c7b\u578b\u5f02\u5e38", (Throwable)e);
            return ApiResponse.success();
        }
        String dataId = dataOperateLogDto.getDataId();
        Long formId = dataOperateLogDto.getFormId();
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        boolean formConsistentFlag = this.hussarAppFormService.contrastFormid(String.valueOf(sysForm.getAppId()), String.valueOf(formId), dataId);
        if (HussarUtils.equals((Object)sysForm.getCreateSource(), (Object)"1")) {
            formConsistentFlag = true;
        }
        if (formConsistentFlag) {
            SysDataOperateLogPage sysDataOperateLogPage = this.getLogPage(dataOperateLogDto, Long.valueOf(dataId), formId);
            sysDataOperateLogPage.setFormConsistentFlag(formConsistentFlag);
            return ApiResponse.success((Object)sysDataOperateLogPage);
        }
        Map objectMap = this.hussarAppFormService.queryAllTableInfo(String.valueOf(formId), String.valueOf(sysForm.getAppId()), String.valueOf(dataId));
        if (!objectMap.containsKey("FORM_ID") || HussarUtils.isEmpty(objectMap.get("FORM_ID"))) {
            SysDataOperateLogPage page = new SysDataOperateLogPage();
            page.setTotal(Long.valueOf(0L));
            page.setSysDataOperateLogVos((List)Lists.newArrayListWithExpectedSize((int)0));
            return ApiResponse.success((Object)page);
        }
        SysDataOperateLogPage sysDataOperateLogPage = this.getLogPage(dataOperateLogDto, Long.valueOf(dataId), Long.valueOf(String.valueOf(objectMap.get("FORM_ID"))));
        return this.getEffectiveLogs(sysDataOperateLogPage, formConsistentFlag, formId);
    }

    public List<SysUserUsuallyForm> getCommonForm(Long userId) {
        List<Object> commonForms = new ArrayList<SysUserUsuallyForm>();
        LocalDateTime time = LocalDateTime.now().minusMonths(1L);
        List<Long> formIds = this.sysDataOperateLogMapper.getCommonForm(userId, time);
        if (HussarUtils.isNotEmpty(formIds)) {
            List forms = this.sysFormService.listByIds(formIds);
            commonForms = forms.stream().filter(sysForm -> !HussarUtils.equals((Object)sysForm.getFormName(), (Object)"\u672a\u547d\u540d\u8868\u5355")).map(sysForm -> {
                ApiResponse appDetail = this.sysApplicationService.getAppDetail(sysForm.getAppId());
                if (HussarUtils.isEmpty((Object)appDetail.getData())) {
                    return null;
                }
                SysUserUsuallyForm sysUserUsuallyForm = new SysUserUsuallyForm();
                sysUserUsuallyForm.setFormId(sysForm.getId());
                sysUserUsuallyForm.setAppId(sysForm.getAppId());
                sysUserUsuallyForm.setUserId(userId);
                sysUserUsuallyForm.setFormName(sysForm.getFormName());
                sysUserUsuallyForm.setAppName(((SysApplicationVo)appDetail.getData()).getAppName());
                return sysUserUsuallyForm;
            }).filter(sysUserUsuallyForm -> sysUserUsuallyForm != null).collect(Collectors.toList());
        }
        return commonForms;
    }

    private ApiResponse<SysDataOperateLogPage> getEffectiveLogs(SysDataOperateLogPage sysDataOperateLogPage, boolean formConsistentFlag, Long formId) {
        if (sysDataOperateLogPage.getTotal() > 0L && !formConsistentFlag) {
            FormDesignResponse formCanvasSchema = this.canvasSchemaService.get(String.valueOf(formId));
            FormCanvasSchema canvas = (FormCanvasSchema)formCanvasSchema.getData();
            ArrayList widgets = new ArrayList();
            List widgetsFromCanvas = canvas.widgets();
            List childTables = canvas.childTables();
            widgets.addAll(widgetsFromCanvas);
            widgets.addAll(childTables);
            if (CollectionUtils.isEmpty(widgets)) {
                SysDataOperateLogPage page = new SysDataOperateLogPage();
                page.setTotal(Long.valueOf(0L));
                page.setSysDataOperateLogVos((List)Lists.newArrayListWithExpectedSize((int)0));
                return ApiResponse.success((Object)page);
            }
            Map widgetNameMap = widgets.stream().collect(Collectors.toMap(Widget::getName, Function.identity()));
            List sysDataOperateLogVos = sysDataOperateLogPage.getSysDataOperateLogVos();
            ArrayList sysDataOperateLogVosNewList = Lists.newArrayListWithExpectedSize((int)5);
            for (SysDataOperateLogVo operateLogVo : sysDataOperateLogVos) {
                SysDataOperateLogVo sysDataOperateLogVoNew = new SysDataOperateLogVo();
                BeanUtil.copy((Object)operateLogVo, (Object)sysDataOperateLogVoNew);
                Map oldRecord = (Map)JSON.parseObject((String)operateLogVo.getOldRecord(), Map.class);
                if (HussarUtils.isEmpty((Object)oldRecord)) {
                    sysDataOperateLogVosNewList.add(sysDataOperateLogVoNew);
                    continue;
                }
                Map newRecord = (Map)JSON.parseObject((String)operateLogVo.getNewRecord(), Map.class);
                List widgetList = JSON.parseArray((String)operateLogVo.getWidget(), Widget.class);
                Iterator iterator = oldRecord.keySet().iterator();
                while (iterator.hasNext()) {
                    String currentKey = (String)iterator.next();
                    if (HussarUtils.isNotEmpty((Object)currentKey) && currentKey.endsWith("_label")) {
                        currentKey = currentKey.split("_")[0];
                    }
                    if (widgetNameMap.containsKey(currentKey)) continue;
                    iterator.remove();
                    newRecord.remove(currentKey);
                }
                if (HussarUtils.isEmpty((Object)oldRecord)) continue;
                ArrayList widgetListNew = Lists.newArrayListWithExpectedSize((int)5);
                for (Widget w : widgetList) {
                    if (WidgetType.CHILDREN_TABLE.getType().equals(w.getType())) {
                        List childRecordList = JSON.parseArray((String)operateLogVo.getChildRecord(), Map.class);
                        for (Map map : childRecordList) {
                            for (Map.Entry entry : map.entrySet()) {
                                if (!widgetNameMap.containsKey(entry.getKey())) continue;
                                List childrenWidgetT = ((Widget)widgetNameMap.get(entry.getKey())).getChildren();
                                Map childrenWidgetTMap = childrenWidgetT.stream().collect(Collectors.toMap(Widget::getName, Function.identity()));
                                JSONArray array = (JSONArray)entry.getValue();
                                array.forEach(a -> {
                                    Map childMap = (Map)a;
                                    Iterator iteratoredChild = childMap.keySet().iterator();
                                    while (iteratoredChild.hasNext()) {
                                        String key = (String)iteratoredChild.next();
                                        if ("row".equals(key) || "FORM_ID".equals(key)) continue;
                                        String widgetRealName = key;
                                        if (HussarUtils.isNotEmpty((Object)widgetRealName) && widgetRealName.endsWith("_label")) {
                                            widgetRealName = widgetRealName.split("_")[0];
                                        }
                                        if (!childrenWidgetTMap.containsKey(widgetRealName)) {
                                            iteratoredChild.remove();
                                            continue;
                                        }
                                        Map cell = (Map)childMap.get(key);
                                        if (!"3".equals(String.valueOf(cell.get("mode")))) continue;
                                        iteratoredChild.remove();
                                    }
                                });
                            }
                        }
                        operateLogVo.setChildRecord(JSONArray.toJSONString((Object)childRecordList));
                        continue;
                    }
                    if (!oldRecord.containsKey(w.getName())) continue;
                    widgetListNew.add(w);
                }
                sysDataOperateLogVoNew.setOldRecord(JSON.toJSONString((Object)oldRecord));
                sysDataOperateLogVoNew.setNewRecord(JSON.toJSONString((Object)newRecord));
                sysDataOperateLogVoNew.setWidget(JSONArray.toJSONString((Object)widgetListNew));
                if (HussarUtils.isNotEmpty((Object)operateLogVo.getChildRecord()) && JSON.parseArray((String)operateLogVo.getChildRecord()).size() > 0) {
                    List childRecordList = JSON.parseArray((String)operateLogVo.getChildRecord(), Map.class);
                    boolean effectiveChildFlag = false;
                    for (Map map : childRecordList) {
                        for (Map.Entry entry : map.entrySet()) {
                            JSONArray array = (JSONArray)entry.getValue();
                            Map childMap = (Map)array.get(0);
                            if (childMap.size() <= 2) continue;
                            effectiveChildFlag = true;
                        }
                    }
                    if (!effectiveChildFlag) continue;
                    sysDataOperateLogVosNewList.add(sysDataOperateLogVoNew);
                    continue;
                }
                sysDataOperateLogVosNewList.add(sysDataOperateLogVoNew);
            }
            sysDataOperateLogPage.setSysDataOperateLogVos((List)sysDataOperateLogVosNewList);
            sysDataOperateLogPage.setTotal(Long.valueOf(sysDataOperateLogVosNewList.size()));
        }
        return ApiResponse.success((Object)sysDataOperateLogPage);
    }

    @NotNull
    private SysDataOperateLogPage getLogPage(DataOperateLogDto dataOperateLogDto, Long dataId, Long formId) {
        int pageSize = dataOperateLogDto.getPageSize();
        int pageIndex = dataOperateLogDto.getPageIndex();
        AssertUtil.isNotNull((Object)dataId, (String)"\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)formId, (String)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<SysDataOperateLogVo> sysDataOperateLogs = new ArrayList<SysDataOperateLogVo>();
        SysDataOperateLogPage sysDataOperateLogPage = new SysDataOperateLogPage();
        String storageType = this.dataOperateLogProperties.getStorageType();
        if (storageType.equals("mysql")) {
            Page page = new Page((long)pageIndex, (long)pageSize);
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataOperateLog::getDataId, (Object)dataId)).eq(SysDataOperateLog::getFormId, (Object)formId)).orderByDesc(HussarBaseEntity::getCreateTime)).orderByDesc(SysDataOperateLog::getOperateId);
            IPage selectPage = ((SysDataOperateLogMapper)this.getBaseMapper()).selectPage((IPage)page, (Wrapper)wrapper);
            List records = selectPage.getRecords();
            long total = selectPage.getTotal();
            this.handleLog(records, sysDataOperateLogs);
            sysDataOperateLogPage.setSysDataOperateLogVos(sysDataOperateLogs);
            sysDataOperateLogPage.setTotal(Long.valueOf(total));
        } else {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"dataId").is((Object)dataId));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"formId").is((Object)formId));
            PageRequest pageable = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
            query.with((Pageable)pageable);
            List records = this.mongoTemplate.find(query, SysDataOperateLog.class);
            long total = this.mongoTemplate.count(query, SysDataOperateLog.class);
            this.handleLog(records, sysDataOperateLogs);
            sysDataOperateLogPage.setSysDataOperateLogVos(sysDataOperateLogs);
            sysDataOperateLogPage.setTotal(Long.valueOf(total));
        }
        return sysDataOperateLogPage;
    }

    private void handleLog(List<SysDataOperateLog> records, List<SysDataOperateLogVo> sysDataOperateLogs) {
        ArrayList userIds = new ArrayList();
        ArrayList triggerFormIds = new ArrayList();
        ArrayList buttonIds = new ArrayList();
        records.forEach(sysDataOperateLog -> {
            userIds.add(sysDataOperateLog.getCreator());
            triggerFormIds.add(sysDataOperateLog.getTriggerFormId());
            buttonIds.add(sysDataOperateLog.getButtonId());
        });
        ArrayList users = new ArrayList();
        if (HussarUtils.isNotEmpty(userIds)) {
            users.addAll(this.usersService.listByIds(userIds));
        }
        ArrayList sysForms = new ArrayList();
        if (HussarUtils.isNotEmpty(triggerFormIds)) {
            sysForms.addAll(this.sysFormService.list((Wrapper)new LambdaQueryWrapper().in(SysForm::getId, triggerFormIds)));
        }
        ArrayList sysCustomButtons = new ArrayList();
        if (HussarUtils.isNotEmpty(buttonIds)) {
            sysCustomButtons.addAll(this.sysCustomButtonService.list((Wrapper)new LambdaQueryWrapper().in(SysCustomButton::getId, buttonIds)));
        }
        records.forEach(sysDataOperateLog -> {
            Long creator = sysDataOperateLog.getCreator();
            Long triggerFormId = sysDataOperateLog.getTriggerFormId();
            Long buttonId = sysDataOperateLog.getButtonId();
            SysDataOperateLogVo sysDataOperateLogVo = new SysDataOperateLogVo();
            BeanUtils.copyProperties((Object)sysDataOperateLog, (Object)sysDataOperateLogVo);
            if (HussarUtils.isNotEmpty((Object)triggerFormId)) {
                boolean isFindForm = false;
                for (SysForm sysForm : sysForms) {
                    if (!sysForm.getId().equals(triggerFormId)) continue;
                    sysDataOperateLogVo.setTriggerFormName(sysForm.getFormName());
                    sysDataOperateLogVo.setI18nKeys(sysForm.getI18nKeys());
                    isFindForm = true;
                    break;
                }
                if (!isFindForm) {
                    sysDataOperateLogVo.setTriggerFormName("\u672a\u77e5\u8868\u5355");
                }
            }
            if (HussarUtils.isNotEmpty((Object)buttonId)) {
                boolean isFindButton = false;
                for (SysCustomButton sysCustomButton : sysCustomButtons) {
                    if (!sysCustomButton.getId().equals(buttonId)) continue;
                    sysDataOperateLogVo.setButtonName(sysCustomButton.getAlias());
                    sysDataOperateLogVo.setI18nKeys(sysCustomButton.getI18nKeys());
                    isFindButton = true;
                    break;
                }
                if (!isFindButton) {
                    sysDataOperateLogVo.setButtonName("\u672a\u77e5\u6309\u94ae");
                }
            }
            boolean isFindUser = false;
            for (SysUsers sysUser : users) {
                if (!sysUser.getId().equals(creator)) continue;
                SysDataOperateLogVo.Operator operator = new SysDataOperateLogVo.Operator();
                BeanUtils.copyProperties((Object)sysUser, (Object)operator);
                sysDataOperateLogVo.setOperator(operator);
                sysDataOperateLogs.add(sysDataOperateLogVo);
                isFindUser = true;
                break;
            }
            if (!isFindUser) {
                SysDataOperateLogVo.Operator operator = new SysDataOperateLogVo.Operator();
                if (HussarUtils.isNotEmpty((Object)sysDataOperateLogVo.getTriggerFormId())) {
                    if (creator == 8934723032766293738L) {
                        operator.setUserName("\u5916\u90e8\u7528\u6237");
                    } else {
                        operator.setUserName("\u5b9a\u65f6\u89e6\u53d1");
                    }
                } else if (sysDataOperateLogVo.getOpMode() == 6) {
                    operator.setUserName("\u6570\u636e\u62c9\u53d6");
                } else {
                    operator.setUserName("\u5916\u90e8\u7528\u6237");
                }
                sysDataOperateLogVo.setOperator(operator);
                sysDataOperateLogs.add(sysDataOperateLogVo);
            }
        });
    }
}

