/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleInnerService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleService;
import com.jxdinfo.hussar.formdesign.application.openapi.form.util.OpenFormUtils;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.DataOperateLog;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.formdesign.extension.api.dto.TableUpdateDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.FlowFormSubmitHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.service.IFormOperateHookService;
import com.jxdinfo.hussar.formdesign.extension.api.service.IOpeApiService;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.no.code.business.service.InvokeService;
import com.jxdinfo.hussar.formdesign.no.code.business.util.HookUtil;
import com.jxdinfo.hussar.formdesign.no.code.constant.ViewIdEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.mail.core.collection.CollUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.IResultCode;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OpenApiServiceImpl
implements IOpeApiService {
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private EngineApiService engineApiService;
    @Resource
    private InvokeService invokeService;
    @Autowired(required=false)
    private IFormOperateHookService formOperateHookService;
    @Resource
    private ISysFormLinkSingleService sysFormLinkSingleService;
    @Resource
    private ISysFormLinkSingleInnerService sysFormLinkSingleInnerService;
    @Resource
    private HookUtil hookUtil;
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiServiceImpl.class);
    private static final String IMPORT_KEY = "importList";

    public ApiResponse<Object> formQuery(String formId, String id, String appId, String tabType, boolean isOutLinkQuery) {
        ApiResponse responseEntity;
        List childTables;
        if (HussarUtils.isEmpty((Object)appId)) {
            SysForm sysForm = (SysForm)this.sysFormService.getDetailById(Long.valueOf(formId)).getData();
            if (HussarUtils.isEmpty((Object)sysForm)) {
                return ApiResponse.fail((IResultCode)LcdpExceptionEnum.FORM_NOT_FOUND);
            }
            appId = String.valueOf(sysForm.getAppId());
        }
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        HashMap<String, Object> tableQueryParams = new HashMap<String, Object>();
        ArrayList orderItems = Lists.newArrayListWithCapacity((int)1);
        FormDesignResponse formDesignResponse = this.canvasSchemaService.get(formId);
        FormCanvasSchema formCanvasSchema = null;
        if (HussarUtils.isNotEmpty((Object)formDesignResponse) && HussarUtils.isNotEmpty((Object)formDesignResponse.getData()) && CollectionUtil.isNotEmpty((Collection)(childTables = (formCanvasSchema = (FormCanvasSchema)formDesignResponse.getData()).childTables()))) {
            for (Widget child : childTables) {
                OrderItem subOrder = new OrderItem();
                subOrder.setColumn(child.getName() + ".SEQ");
                subOrder.setAsc(true);
                orderItems.add(subOrder);
            }
        }
        tableQueryParams.put("orders", orderItems);
        if ((HussarUtils.isEmpty((Object)tabType) || HussarUtils.equals((Object)tabType, (Object)"0")) && (responseEntity = (ApiResponse)this.invokeService.formQuery(appId, formId, id, isOutLinkQuery, tableQueryParams).getBody()).isSuccess() && HussarUtils.isNotEmpty((Object)responseEntity.getData())) {
            return responseEntity;
        }
        if ((HussarUtils.isEmpty((Object)tabType) || HussarUtils.equals((Object)tabType, (Object)"2") || HussarUtils.equals((Object)tabType, (Object)"1") || HussarUtils.equals((Object)tabType, (Object)"3")) && HussarUtils.equals((Object)formCanvasSchema.getFormType(), (Object)"1")) {
            ArrayList<Filter> filters = new ArrayList<Filter>(1);
            Filter dataIdFilter = new Filter();
            dataIdFilter.setField("RECORD_ID");
            dataIdFilter.setMatch("AND");
            dataIdFilter.setRule("_Eq");
            dataIdFilter.setVal(id);
            filters.add(dataIdFilter);
            tableQueryParams.put("current", 1);
            tableQueryParams.put("size", 1);
            tableQueryParams.put("aggFlag", false);
            tableQueryParams.put("superQueryConditionDto", filters);
            ApiResponse<Object> tableQuery = HussarUtils.equals((Object)tabType, (Object)"1") ? this.tableQuery(formId, tableQueryParams, ViewIdEnum.SYS_FLOW_DONE.getId(), appId) : (HussarUtils.equals((Object)tabType, (Object)"2") ? this.tableQuery(formId, tableQueryParams, ViewIdEnum.SYS_FLOW_TASK.getId(), appId) : this.tableQuery(formId, tableQueryParams, ViewIdEnum.SYS_FLOW_DRAFT.getId(), appId));
            PageVo data = (PageVo)tableQuery.getData();
            if (data.getCount() == null || data.getCount() == 0L) {
                if (HussarUtils.equals((Object)tabType, (Object)"2") && (data = (PageVo)(tableQuery = this.tableQuery(formId, tableQueryParams, ViewIdEnum.SYS_FLOW_DONE.getId(), appId)).getData()).getCount() != null && data.getCount() > 0L) {
                    return ApiResponse.success(data.getData().get(0));
                }
                if (HussarUtils.isNotEmpty((Object)tabType) && HussarUtils.isNotEmpty(tableQuery = this.tableQuery(formId, tableQueryParams, ViewIdEnum.SYS_FLOW_ALL_DATA.getId(), appId)) && HussarUtils.isNotEmpty((Object)tableQuery.getData())) {
                    PageVo dataAll = (PageVo)tableQuery.getData();
                    if (HussarUtils.isEmpty((Object)dataAll.getData())) {
                        return ApiResponse.fail((IResultCode)LcdpExceptionEnum.NO_DATA_PREMISSION);
                    }
                    return ApiResponse.success(dataAll.getData().get(0));
                }
                return ApiResponse.fail((IResultCode)LcdpExceptionEnum.NO_DATA_PREMISSION);
            }
            return ApiResponse.success(data.getData().get(0));
        }
        return ApiResponse.fail((IResultCode)LcdpExceptionEnum.NO_DATA_PREMISSION);
    }

    public ApiResponse<Object> tableQuery(String formId, Map<String, Object> params, String appId, String viewId) {
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        AssertUtil.isTrue((boolean)HussarUtils.isNotEmpty((Object)sysForm), (String)"\u8868\u5355\u4e0d\u5b58\u5728");
        params.put("BC8D215A-26F1-9B83-4DE2-7867003DA241", "BC8D215A-26F1-9B83-4DE2-7867003DA241");
        if (HussarUtils.isEmpty((Object)viewId)) {
            switch (sysForm.getFormType()) {
                case "0": {
                    viewId = ViewIdEnum.SYS_ORDINARY_ALL_DATA.getId();
                    break;
                }
                case "1": {
                    viewId = ViewIdEnum.SYS_FLOW_ALL_DATA.getId();
                    break;
                }
                default: {
                    throw new HussarException("\u4e0d\u652f\u6301\u6b64\u7c7b\u578b\u8868\u5355\u7684\u67e5\u8be2!");
                }
            }
        }
        return (ApiResponse)this.appFormService.tableQuery(formId, viewId, params, appId).getBody();
    }

    @DataOperateLog(moduleCode="create", handleName="\u5916\u90e8api\u8868\u5355\u6570\u636e\u4fdd\u5b58")
    public ApiResponse<Object> create(String formId, Map<String, Object> params, String appId) {
        ArrayList<Object> importList = new ArrayList<Object>();
        importList.add(params);
        this.setIdAndTableNameColumnValue(formId, importList);
        this.invokeService.formSave(appId, formId, params);
        params.remove(null);
        return ApiResponse.success(params, (String)"\u65b0\u589e\u6210\u529f!");
    }

    @DataOperateLog(moduleCode="flowFormSubmit", handleName="\u5916\u90e8api\u6d41\u7a0b\u8868\u5355\u6570\u636e\u4fdd\u5b58")
    public ApiResponse<Object> flowFormSubmit(String formId, Map<String, Object> params) {
        SysForm form = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        String appId = String.valueOf(form.getAppId());
        this.flowFormSubmitHookParams(formId, form.getTableName(), appId, params);
        this.setIdAndTableNameColumnValue(formId, (Map<String, Object>)((Map)params.get("formData")));
        ApiResponse responseEntity = (ApiResponse)this.invokeService.flowFormSubmit(appId, formId, params).getBody();
        this.flowFormSubmitHook(formId, form.getTableName(), appId, params, (ApiResponse<Object>)responseEntity);
        return responseEntity;
    }

    @DataOperateLog(moduleCode="createBatch", handleName="\u5916\u90e8api\u591a\u6761\u6570\u636e\u65b0\u589e")
    public ApiResponse<Object> createBatch(String appId, String formId, Map<String, Object> params) {
        List importList = (List)params.get(IMPORT_KEY);
        this.setIdAndTableNameColumnValue(formId, importList);
        this.invokeService.tableSave(appId, formId, params);
        ArrayList successIds = new ArrayList();
        List<Map<String, Object>> castListMap = OpenFormUtils.castListMap(params.get(IMPORT_KEY), String.class, Object.class);
        castListMap.forEach(entity -> successIds.add(this.getIdValue(formId, (Map<String, Object>)entity)));
        return ApiResponse.success(successIds, (String)"\u65b0\u589e\u6210\u529f!");
    }

    @DataOperateLog(moduleCode="update", handleName="\u5916\u90e8api\u8868\u5355\u6570\u636e\u66f4\u65b0")
    public ApiResponse<Object> update(String formId, Map<String, Object> params, String appId) {
        ArrayList<Object> importList = new ArrayList<Object>();
        importList.add(params);
        this.setIdAndTableNameColumnValue(formId, importList);
        this.invokeService.formSave(appId, formId, params);
        params.remove(null);
        return ApiResponse.success(params, (String)"\u66f4\u65b0\u6210\u529f!");
    }

    public ApiResponse<Object> updateBatch(String appId, String formId, TableUpdateDto tableUpdateDto) {
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        return (ApiResponse)this.appFormService.tableUpdate(appId, formId, tableUpdateDto, sysForm).getBody();
    }

    public ApiResponse<Object> deleteBatch(String formId, String ids, String newAppId) {
        Boolean flag;
        if (HussarUtils.isNotEmpty((Object)newAppId)) {
            AppContextUtil.setAppId((String)newAppId);
        }
        if (!(flag = this.sysFormLinkSingleService.deleteBatch(ids)).booleanValue()) {
            return ApiResponse.fail((String)"\u5220\u9664\u5916\u94fe\u6570\u636e\u5931\u8d25");
        }
        Boolean flagInner = this.sysFormLinkSingleInnerService.deleteBatch(ids);
        if (!flagInner.booleanValue()) {
            return ApiResponse.fail((String)"\u5220\u9664\u5e94\u7528\u5185\u5916\u94fe\u6570\u636e\u5931\u8d25");
        }
        return (ApiResponse)this.invokeService.deleteBatch(newAppId, formId, ids).getBody();
    }

    public String getIdValue(String formId, Map<String, Object> entity) {
        ApiResponse sysFormApiResponse = this.sysFormService.getDetailById(Long.valueOf(formId));
        String tableName = Optional.ofNullable(sysFormApiResponse).map(ApiResponse::getData).map(SysForm::getTableName).orElseThrow(() -> new BaseException("\u8868\u5355\u540d\u67e5\u8be2\u5931\u8d25"));
        return String.valueOf(entity.get(tableName));
    }

    public String getBusinessId(String requestMethod, String appId, String formId, String invokeMethod) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        String url = FileUtil.posixPath((String[])new String[]{appId, formId, invokeMethod});
        return String.format("%s /%s", requestMethod, url);
    }

    private void setIdAndTableNameColumnValue(String formId, List<Object> importList) {
        FormDesignResponse formDesignResponse = this.canvasSchemaService.get(formId);
        if (HussarUtils.isEmpty((Object)formDesignResponse.getData())) {
            LOGGER.error("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            throw new BaseException("\u8868\u5355\u753b\u5e03\u4e0d\u5b58\u5728");
        }
        importList.forEach(params -> {
            this.setIdAndTableNameColumnValue((FormCanvasSchema)formDesignResponse.getData(), (Map<String, Object>)((Map)params));
            this.parseSuggestValueToJsonString((FormCanvasSchema)formDesignResponse.getData(), (Map)params);
        });
    }

    private void parseSuggestValueToJsonString(FormCanvasSchema canvasSchema, Map<String, Object> params) {
        canvasSchema.widgets().stream().filter(widget -> HussarUtils.equals((Object)widget.getType(), (Object)WidgetType.JXDN_SUGGESTION.getType())).forEach(widget -> {
            Object suggestValue = params.get(widget.getName());
            if (HussarUtils.isNotEmpty(suggestValue) && !(suggestValue instanceof String)) {
                params.put(widget.getName(), JSON.toJSONString(suggestValue));
            }
        });
    }

    private void setIdAndTableNameColumnValue(FormCanvasSchema canvasSchema, Map<String, Object> params) {
        if (HussarUtils.isEmpty((Object)params.get("RECORD_ID"))) {
            params.put("RECORD_ID", EngineUtil.getId());
        } else {
            this.paddingSubTableColumn(canvasSchema, params);
        }
        params.put(canvasSchema.getName(), params.get("RECORD_ID"));
        canvasSchema.childTables().forEach(childTable -> this.setChildIdAndTableName((Widget)childTable, (List)params.get(childTable.getName()), params.get("RECORD_ID"), null));
    }

    private void setIdAndTableNameColumnValue(String formId, Map<String, Object> params) {
        FormDesignResponse formDesignResponse = this.canvasSchemaService.get(formId);
        if (HussarUtils.isEmpty((Object)formDesignResponse.getData())) {
            LOGGER.error("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            throw new BaseException("\u8868\u5355\u753b\u5e03\u4e0d\u5b58\u5728");
        }
        this.setIdAndTableNameColumnValue((FormCanvasSchema)formDesignResponse.getData(), params);
        this.parseSuggestValueToJsonString((FormCanvasSchema)formDesignResponse.getData(), params);
    }

    private void paddingSubTableColumn(FormCanvasSchema canvasSchema, Map<String, Object> params) {
        if (!HussarUtils.isEmpty((Object)params.get("RECORD_ID")) && HussarUtils.isNotEmpty((Object)canvasSchema.childTables())) {
            String recordId = String.valueOf(params.get("RECORD_ID"));
            ApiResponse<Object> formQuery = this.formQuery(canvasSchema.getId(), recordId, null, canvasSchema.getAppId(), Boolean.FALSE);
            if (formQuery.isSuccess()) {
                canvasSchema.childTables().forEach(widget -> {
                    List childs = (List)params.get(widget.getName());
                    Optional.ofNullable(childs).ifPresent(o -> o.forEach(child -> {
                        if (HussarUtils.isNotEmpty(child.get("RECORD_ID"))) {
                            Set subTableKeys = child.keySet();
                            Map oldData = (Map)formQuery.getData();
                            List oldChildData = (List)oldData.get(widget.getName());
                            if (!HussarUtils.isEmpty((Object)oldChildData)) {
                                Map<Object, Map> oldChildDataMap = oldChildData.stream().collect(Collectors.toMap(map -> map.get("RECORD_ID"), map -> map, (v1, v2) -> v1));
                                Map oldOneData = oldChildDataMap.get(child.get("RECORD_ID"));
                                Optional.ofNullable(oldOneData).ifPresent(ood -> ood.entrySet().forEach(feildValue -> {
                                    if (!subTableKeys.contains(feildValue.getKey())) {
                                        child.put(feildValue.getKey(), feildValue.getValue());
                                    }
                                }));
                            }
                        }
                    }));
                });
            }
        }
    }

    private void setChildIdAndTableName(Widget widget, List<Map<String, Object>> childList, Object fid, Object gid) {
        if (HussarUtils.isNotEmpty(childList)) {
            childList.forEach(child -> {
                List cs;
                if (ToolUtil.isEmpty(child.get("RECORD_ID"))) {
                    child.put("RECORD_ID", EngineUtil.getId());
                }
                child.put(widget.getName(), child.get("RECORD_ID"));
                child.put("F_RECORD_ID", fid);
                if (gid != null) {
                    child.put("G_RECORD_ID", gid);
                }
                if (CollUtil.isNotEmpty((Collection)(cs = WidgetTool.flatButChildren(new ArrayList(), (List)widget.getChildren())))) {
                    cs.forEach(e -> this.setChildIdAndTableName((Widget)e, (List)child.get(e.getName()), child.get("RECORD_ID"), gid == null ? fid : gid));
                }
            });
        }
    }

    private void flowFormSubmitHook(String formId, String tableName, String newAppId, Map<String, Object> params, ApiResponse<Object> flowFormSubmitResponse) {
        FlowFormSubmitHookDto formSubmitHookDto = new FlowFormSubmitHookDto();
        formSubmitHookDto.setFormId(Long.valueOf(formId));
        formSubmitHookDto.setAppId(Long.valueOf(newAppId));
        formSubmitHookDto.setParams(params);
        if (HussarUtils.isNotEmpty((Object)this.formOperateHookService)) {
            this.formOperateHookService.flowFormSubmitHook(formSubmitHookDto, flowFormSubmitResponse);
        }
        this.hookUtil.flowFormSubmitHook(formId, tableName, formSubmitHookDto, flowFormSubmitResponse);
    }

    private void flowFormSubmitHookParams(String formId, String tableName, String newAppId, Map<String, Object> params) {
        FlowFormSubmitHookDto formSubmitHookDto = new FlowFormSubmitHookDto();
        formSubmitHookDto.setFormId(Long.valueOf(formId));
        formSubmitHookDto.setAppId(Long.valueOf(newAppId));
        formSubmitHookDto.setParams(params);
        if (HussarUtils.isNotEmpty((Object)this.formOperateHookService)) {
            this.formOperateHookService.beforeFlowFormSubmit(formSubmitHookDto);
        }
        this.hookUtil.beforeFlowFormSubmit(formId, tableName, formSubmitHookDto);
    }
}

