/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.post.dto.AddOutsidePostDto;
import com.jxdinfo.hussar.authorization.post.dto.AddOutsideStruPostDto;
import com.jxdinfo.hussar.authorization.post.dto.AddOutsideUserPostDto;
import com.jxdinfo.hussar.authorization.post.dto.EditOutsidePostDto;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostBoService;
import com.jxdinfo.hussar.authorization.post.service.IHussarBaseSyncPostService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dao.ThirdPostMapper;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtPostAddDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtPostDelDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtPostEditDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtStruPostDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtUserPostDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.model.ThirdPostRela;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdOrganService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdPostService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdUserService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThirdPostServiceImpl
extends HussarServiceImpl<ThirdPostMapper, ThirdPostRela>
implements IThirdPostService {
    @Resource
    private IHussarBasePostBoService hussarBasePostService;
    @Resource
    private IHussarBaseSyncPostService hussarBaseSyncPostService;
    @Resource
    private IThirdUserService thirdUserService;
    @Resource
    private IThirdOrganService thirdOrganService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPostServiceImpl.class);

    @Override
    public ApiResponse<Void> addPost(ExtPostAddDto extPostAddDto) {
        LOGGER.info("\u65b0\u589e\u5c97\u4f4d\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)extPostAddDto)));
        String extPostId = extPostAddDto.getExtPostId();
        R addPostResult = this.hussarBaseSyncPostService.addPost((AddOutsidePostDto)extPostAddDto);
        if (addPostResult.isSuccess()) {
            Long platPostId = ((DataMapping)addPostResult.getSuccessList().get(0)).getId();
            ThirdPostRela thirdPostRela = new ThirdPostRela();
            thirdPostRela.setPostId(platPostId);
            thirdPostRela.setThirdPostId(extPostId);
            this.save((BaseEntity)thirdPostRela);
            return ApiResponse.success();
        }
        LOGGER.error("\u65b0\u589e\u5c97\u4f4d\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)addPostResult.getErrorList()));
        return ApiResponse.fail((String)"\u65b0\u589e\u5c97\u4f4d\u5931\u8d25");
    }

    @Override
    public ApiResponse<Void> editPost(ExtPostEditDto extPostEditDto) {
        LOGGER.info("\u4fee\u6539\u5c97\u4f4d\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)extPostEditDto)));
        R editPostRes = this.hussarBaseSyncPostService.editPost((EditOutsidePostDto)extPostEditDto);
        if (editPostRes.isSuccess()) {
            return ApiResponse.success();
        }
        LOGGER.error("\u4fee\u6539\u5c97\u4f4d\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)editPostRes.getErrorList()));
        return ApiResponse.fail((String)"\u4fee\u6539\u5c97\u4f4d\u5931\u8d25");
    }

    @Override
    public ApiResponse<Void> delPost(ExtPostDelDto extPostDelDto) {
        LOGGER.info("\u5220\u9664\u5c97\u4f4d\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)extPostDelDto));
        SysPost platPost = this.hussarBasePostService.getPostByCode(extPostDelDto.getPostCode());
        if (HussarUtils.isEmpty((Object)platPost)) {
            return ApiResponse.fail((String)"\u672a\u83b7\u53d6\u5230\u5c97\u4f4d\u7684\u540c\u6b65\u6570\u636e");
        }
        R delPostRes = this.hussarBaseSyncPostService.deletePost(extPostDelDto.getPostCode());
        if (delPostRes.isSuccess()) {
            this.remove((Wrapper)new LambdaQueryWrapper().eq(ThirdPostRela::getPostId, (Object)platPost.getId()));
            return ApiResponse.success();
        }
        LOGGER.error("\u5220\u9664\u5c97\u4f4d\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)delPostRes));
        return ApiResponse.fail((String)"\u5220\u9664\u5c97\u4f4d\u5931\u8d25");
    }

    @Override
    public ApiResponse<Void> saveUserPost(ExtUserPostDto extUserPostDto) {
        LOGGER.info("\u4fdd\u5b58\u7528\u6237\u5c97\u4f4d\u5173\u8054\u5173\u7cfb\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)extUserPostDto)));
        if ("post".equals(extUserPostDto.getType())) {
            extUserPostDto.setIds(this.listPlatPostIdsByExtPostIds(extUserPostDto.getExtIds()));
        } else if ("user".equals(extUserPostDto.getType())) {
            extUserPostDto.setIds(this.thirdUserService.listPlatformUserIds(extUserPostDto.getExtIds()));
        }
        ArrayList<SysUserPost> userPostList = new ArrayList<SysUserPost>();
        List<ExtUserPostDto.ExtUserPost> extUserPostList = extUserPostDto.getExtUserPostList();
        if (HussarUtils.isNotEmpty(extUserPostList)) {
            for (ExtUserPostDto.ExtUserPost extUserPost : extUserPostList) {
                SysUserPost sysUserPost = new SysUserPost();
                sysUserPost.setPostId(this.getPlatPostIdByExtPostId(extUserPost.getExtPostId()));
                sysUserPost.setUserId(this.thirdUserService.getPlatformUserId(extUserPost.getExtUserId()));
                sysUserPost.setRelateType(extUserPost.getRelateType());
                userPostList.add(sysUserPost);
            }
        }
        extUserPostDto.setUserPostList(userPostList);
        Boolean saveUserPostRes = this.hussarBaseSyncPostService.saveUserPost((AddOutsideUserPostDto)extUserPostDto);
        if (saveUserPostRes.booleanValue()) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u4fdd\u5b58\u7528\u6237\u5c97\u4f4d\u5173\u8054\u5173\u7cfb\u5931\u8d25");
    }

    @Override
    public ApiResponse<Void> saveStruPost(ExtStruPostDto extStruPostDto) {
        LOGGER.info("\u4fdd\u5b58\u7ec4\u7ec7\u5c97\u4f4d\u5173\u8054\u5173\u7cfb\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)extStruPostDto)));
        if ("post".equals(extStruPostDto.getType())) {
            extStruPostDto.setIds(this.listPlatPostIdsByExtPostIds(extStruPostDto.getExtIds()));
        } else if ("organ".equals(extStruPostDto.getType())) {
            extStruPostDto.setIds(this.thirdOrganService.listPlatformOrganIds(extStruPostDto.getExtIds()));
        }
        ArrayList<SysStruPost> struPostList = new ArrayList<SysStruPost>();
        List<ExtStruPostDto.ExtStruPost> extStruPostList = extStruPostDto.getExtStruPostList();
        if (HussarUtils.isNotEmpty(extStruPostList)) {
            for (ExtStruPostDto.ExtStruPost extStruPost : extStruPostList) {
                SysStruPost sysStruPost = new SysStruPost();
                sysStruPost.setPostId(this.getPlatPostIdByExtPostId(extStruPost.getExtPostId()));
                sysStruPost.setStruId(this.thirdOrganService.getPlatformOrganId(extStruPost.getExtStruId()));
                struPostList.add(sysStruPost);
            }
        }
        extStruPostDto.setStruPostList(struPostList);
        Boolean saveStruPostRes = this.hussarBaseSyncPostService.saveStruPost((AddOutsideStruPostDto)extStruPostDto);
        if (saveStruPostRes.booleanValue()) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u4fdd\u5b58\u7ec4\u7ec7\u5c97\u4f4d\u5173\u8054\u5173\u7cfb\u5931\u8d25");
    }

    @Override
    public Long getPlatPostIdByExtPostId(String extPostId) {
        ThirdPostRela thirdPostRela = (ThirdPostRela)((Object)this.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdPostRela::getThirdPostId, (Object)extPostId)));
        return HussarUtils.isNotEmpty((Object)((Object)thirdPostRela)) ? thirdPostRela.getPostId() : null;
    }

    @Override
    public List<Long> listPlatPostIdsByExtPostIds(List<String> extPostIds) {
        if (HussarUtils.isEmpty(extPostIds)) {
            return new ArrayList<Long>();
        }
        List thirdPostRelas = this.list((Wrapper)new LambdaQueryWrapper().in(ThirdPostRela::getThirdPostId, extPostIds));
        return thirdPostRelas.stream().map(ThirdPostRela::getPostId).collect(Collectors.toList());
    }
}

