/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.impl;

import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceBoService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtFormAuthorityDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdFormAuthorityService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ThirdFormAuthorityServiceImpl
implements IThirdFormAuthorityService {
    @Resource
    private ISysFunctionsBoService sysFunctionsBoService;
    @Resource
    private IHussarBaseResourceService hussarBaseResourceService;
    @Resource
    private ISysRoleFunctionsBoService sysRoleFunctionsBoService;
    @Resource
    private ISysRoleResourceBoService sysRoleResourceBoService;
    @Resource
    private ISysFormService sysFormService;
    public static final String FORM_AUTH_ADD = "add";
    public static final String FORM_AUTH_DEL = "del";

    @Override
    public ApiResponse<Boolean> formAuthorize(List<ExtFormAuthorityDto> extFormAuthorityDto) {
        if (HussarUtils.isNotEmpty(extFormAuthorityDto)) {
            List relationIds;
            List roleIds;
            ArrayList delIds;
            List formIds = extFormAuthorityDto.stream().map(ExtFormAuthorityDto::getFormId).collect(Collectors.toList());
            List functionList = this.sysFunctionsBoService.list(formIds, null, "menu_");
            List resourcesList = this.hussarBaseResourceService.list(formIds, Arrays.asList("res_menu", "res_form_rights"));
            Map<Long, List<SysFunctions>> formFuncMap = functionList.stream().collect(Collectors.groupingBy(SysFunctions::getFunctionModuleId));
            Map<Long, List<SysResources>> formResMap = resourcesList.stream().collect(Collectors.groupingBy(SysResources::getModuleId));
            ArrayList<SysRoleFunctions> addRoleFuncList = new ArrayList<SysRoleFunctions>();
            ArrayList<SysRoleResource> addRoleResList = new ArrayList<SysRoleResource>();
            HashMap<Long, List<Long>> delRoleFuncMap = new HashMap<Long, List<Long>>();
            HashMap<Long, List<Long>> delRoleResMap = new HashMap<Long, List<Long>>();
            for (ExtFormAuthorityDto formAuthorityDto : extFormAuthorityDto) {
                List<Long> roleIds2;
                List<SysFunctions> functions = formFuncMap.get(formAuthorityDto.getFormId());
                List<SysResources> resources = formResMap.get(formAuthorityDto.getFormId());
                if (HussarUtils.isEmpty(functions) || HussarUtils.isEmpty(resources)) continue;
                if (FORM_AUTH_ADD.equals(formAuthorityDto.getAuthType())) {
                    for (SysFunctions function : functions) {
                        SysRoleFunctions roleFunction = new SysRoleFunctions();
                        roleFunction.setFunctionId(function.getId());
                        roleFunction.setRoleId(formAuthorityDto.getRoleId());
                        addRoleFuncList.add(roleFunction);
                    }
                    for (SysResources resource : resources) {
                        SysRoleResource roleResource = new SysRoleResource();
                        roleResource.setResourceId(resource.getId());
                        roleResource.setRoleId(formAuthorityDto.getRoleId());
                        roleResource.setRelationSource("1");
                        addRoleResList.add(roleResource);
                    }
                    continue;
                }
                if (!FORM_AUTH_DEL.equals(formAuthorityDto.getAuthType())) continue;
                for (SysFunctions function : functions) {
                    if (HussarUtils.isEmpty(delRoleFuncMap.get(function.getId()))) {
                        roleIds2 = new ArrayList<Long>();
                        roleIds2.add(formAuthorityDto.getRoleId());
                        delRoleFuncMap.put(function.getId(), roleIds2);
                        continue;
                    }
                    roleIds2 = (List)delRoleFuncMap.get(function.getId());
                    roleIds2.add(formAuthorityDto.getRoleId());
                }
                for (SysResources resource : resources) {
                    if (HussarUtils.isEmpty(delRoleResMap.get(resource.getId()))) {
                        roleIds2 = new ArrayList();
                        roleIds2.add(formAuthorityDto.getRoleId());
                        delRoleResMap.put(resource.getId(), roleIds2);
                        continue;
                    }
                    roleIds2 = (List)delRoleResMap.get(resource.getId());
                    roleIds2.add(formAuthorityDto.getRoleId());
                }
            }
            if (HussarUtils.isNotEmpty(addRoleFuncList)) {
                this.sysRoleFunctionsBoService.saveBatch(addRoleFuncList);
            }
            if (HussarUtils.isNotEmpty(addRoleResList)) {
                this.sysRoleResourceBoService.saveBatch(addRoleResList);
            }
            if (HussarUtils.isNotEmpty(delRoleFuncMap)) {
                delIds = new ArrayList();
                List roleFuncList = this.sysRoleFunctionsBoService.list(null, new ArrayList(delRoleFuncMap.keySet()));
                for (Map.Entry entry : delRoleFuncMap.entrySet()) {
                    Long funcId = (Long)entry.getKey();
                    roleIds = (List)entry.getValue();
                    relationIds = roleFuncList.stream().filter(item -> funcId.equals(item.getFunctionId()) && roleIds.contains(item.getRoleId())).map(SysRoleFunctions::getId).collect(Collectors.toList());
                    delIds.addAll(relationIds);
                }
                this.sysRoleFunctionsBoService.removeByIds(delIds);
            }
            if (HussarUtils.isNotEmpty(delRoleResMap)) {
                delIds = new ArrayList();
                List roleResList = this.sysRoleResourceBoService.getRoleResourceList(null, new ArrayList(delRoleResMap.keySet()));
                for (Map.Entry entry : delRoleResMap.entrySet()) {
                    Long resId = (Long)entry.getKey();
                    roleIds = (List)entry.getValue();
                    relationIds = roleResList.stream().filter(item -> resId.equals(item.getResourceId()) && roleIds.contains(item.getRoleId())).map(SysRoleResource::getId).collect(Collectors.toList());
                    delIds.addAll(relationIds);
                }
                this.sysRoleResourceBoService.removeByIds(delIds);
            }
        }
        return ApiResponse.success((Object)Boolean.TRUE);
    }
}

