/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.authority.v1.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dto.SysRolesDto;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v1.dto.ThirdRoleDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v1.service.RoleSyncService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.model.ThirdRoleRela;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdRoleService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RoleSyncServiceImpl
implements RoleSyncService {
    @Resource
    private ISysRolesExternalService iSysRolesService;
    @Resource
    private IThirdRoleService thirdRoleService;
    private static final Long COMMON_ROLE_GROUP_ID = 1450785135866925058L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleSyncServiceImpl.class);

    @Override
    public ApiResponse<Void> addRole(ThirdRoleDto thirdRoleDto) {
        Long roleId;
        if (this.checkRoleSyncStatus(thirdRoleDto.getThirdRoleId())) {
            return ApiResponse.fail((String)"\u6b64\u89d2\u8272\u5df2\u540c\u6b65\uff01");
        }
        if (this.existRoleName(thirdRoleDto.getRoleName(), COMMON_ROLE_GROUP_ID)) {
            return ApiResponse.fail((String)"\u65b0\u589e\u5931\u8d25\uff01\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        thirdRoleDto.setAppId(1L);
        thirdRoleDto.setGroupId(COMMON_ROLE_GROUP_ID);
        try {
            roleId = this.iSysRolesService.saveRoleNoSign((SysRolesDto)thirdRoleDto);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u540c\u6b65\u89d2\u8272\u63a5\u53e3\u62a5\u9519\uff1a{}", (Object)e.getMessage());
            throw new HussarException("\u6743\u9650\u4e2d\u5fc3\u540c\u6b65\u89d2\u8272\u5931\u8d25");
        }
        ThirdRoleRela thirdRoleRela = new ThirdRoleRela();
        thirdRoleRela.setRoleId(roleId);
        thirdRoleRela.setThirdRoleId(thirdRoleDto.getThirdRoleId());
        thirdRoleRela.setThirdRoleSource("KeHu");
        this.thirdRoleService.save((Object)thirdRoleRela);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> editRole(ThirdRoleDto thirdRoleDto) {
        SysRoles sysRoles = this.iSysRolesService.getById(this.getPlatformRoleId(thirdRoleDto.getThirdRoleId()));
        if (this.existRoleName(thirdRoleDto.getRoleName(), sysRoles.getGroupId())) {
            return ApiResponse.fail((String)"\u4fee\u6539\u5931\u8d25\uff01\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        sysRoles.setRoleName(thirdRoleDto.getRoleName());
        sysRoles.setRoleAlias(thirdRoleDto.getRoleAlias());
        this.iSysRolesService.updateRole(sysRoles);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> delRole(ThirdRoleRela thirdRoleRela) {
        LOGGER.info("\u6743\u9650\u4e2d\u5fc3\u540c\u6b65 -> \u5220\u9664\u89d2\u8272\uff1a{}", (Object)thirdRoleRela.getThirdRoleId());
        Boolean delRoleResult = this.iSysRolesService.delRole(this.getPlatformRoleId(thirdRoleRela.getThirdRoleId()));
        if (delRoleResult.booleanValue()) {
            this.thirdRoleService.remove((Wrapper)new LambdaQueryWrapper().eq(ThirdRoleRela::getThirdRoleId, (Object)thirdRoleRela.getThirdRoleId()));
        }
        return ApiResponse.success();
    }

    private boolean checkRoleSyncStatus(String thirdRoleId) {
        List thirdRoleRelas = this.thirdRoleService.list((Wrapper)new LambdaQueryWrapper().eq(ThirdRoleRela::getThirdRoleId, (Object)thirdRoleId));
        return HussarUtils.isNotEmpty((Object)thirdRoleRelas);
    }

    private Long getPlatformRoleId(String thirdRoleId) {
        ThirdRoleRela thirdRoleRela = (ThirdRoleRela)((Object)this.thirdRoleService.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdRoleRela::getThirdRoleId, (Object)thirdRoleId)));
        if (HussarUtils.isEmpty((Object)((Object)thirdRoleRela))) {
            LOGGER.error("\u672a\u627e\u5230\u6b64\u4e09\u65b9\u89d2\u8272\u7684\u540c\u6b65\u8bb0\u5f55\uff0c\u4e09\u65b9\u89d2\u8272 ID\uff1a{}", (Object)thirdRoleId);
            throw new HussarException("\u83b7\u53d6\u4e09\u65b9\u89d2\u8272\u540c\u6b65\u8bb0\u5f55\u5931\u8d25");
        }
        return thirdRoleRela.getRoleId();
    }

    private boolean existRoleName(String roleName, Long roleGroupId) {
        return HussarUtils.isNotEmpty((Object)this.iSysRolesService.listByGroupIdAndRoleName(roleGroupId, roleName));
    }
}

