/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitRoleFieldBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.AppRoleRelateInfoVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.PingYinUtil;
import com.jxdinfo.hussar.dashboard.model.DashEntry;
import com.jxdinfo.hussar.dashboard.service.IDashEntryService;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppFormTreeVo;
import com.jxdinfo.hussar.formdesign.application.authority.dto.ButtonAuthoritiesDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.ButtonDto;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysUpAppVisitRoleFieldService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.ButtonVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.DataLogicAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FieldAuthWithStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FieldVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.OrganDataAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.SysFormRoleAuthVo;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.data.service.FormMapService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataRecordService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullRecordService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullTaskService;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormGroupMapper;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.dto.AppFormExistResult;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormSaveDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.Widget;
import com.jxdinfo.hussar.formdesign.application.form.enums.Button;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.IAIService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormReferenceService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormConvertHistoryService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.AppMenuVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.FlowFormProcessNodeVO;
import com.jxdinfo.hussar.formdesign.application.form.vo.FlowFormProcessVO;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormAuthorityMap;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormGroupVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormGroupWithAuthVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormWithAuthVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysSiftGroupList;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysSiftGroupListWithAuth;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.panel.dto.SysPanelDto;
import com.jxdinfo.hussar.formdesign.application.panel.service.ISysPanelService;
import com.jxdinfo.hussar.formdesign.application.tableinfo.service.ISysUserTableNameService;
import com.jxdinfo.hussar.formdesign.application.util.FormUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.FormDeleteHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.service.IFormOperateHookService;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseForm;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeBusinessDB;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.util.HookUtil;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.FormCleaner;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.IResultCode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.NodeInfQueryDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import com.jxdinfo.hussar.workflow.upgrade.StandardDefinitionEngineApiService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.sysFormServiceImpl")
public class SysFormServiceImpl
extends HussarServiceImpl<SysFormMapper, SysForm>
implements ISysFormService {
    private final Logger LOGGER = LoggerFactory.getLogger(SysFormServiceImpl.class);
    @Resource
    private FormOperateService formOperate;
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private SysFormGroupMapper sysFormGroupMapper;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService;
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private ISysAppVisitRoleButtonService roleButtonService;
    @Resource
    private ISysApplicationBoService applicationBoService;
    @Resource
    private ISysAppVisitRoleFieldBoService sysAppVisitRoleFieldBoService;
    @Resource
    private ISysPanelService sysPanelService;
    @Resource
    private FormCleaner formCleaner;
    @Resource
    private CanvasService canvasService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private ISysFormLinkService sysFormLinkService;
    @Resource
    private ISysFormCheckConfigService sysFormCheckConfigService;
    @Resource
    private FormMapService formMapService;
    @Resource
    private PushDataService pushDataService;
    @Resource
    private PushDataRecordService pushDataRecordService;
    @Value(value="${open.rePublish.saveCanvas:false}")
    private boolean saveCanvas;
    @Resource
    private ISysAppVisitRoleButtonService sysAppVisitRoleButtonService;
    @Resource
    private ISysAppVisitRoleOrganDataAuthorityService sysAppVisitRoleOrganDataAuthorityService;
    @Resource
    private ISysUpAppVisitRoleFieldService sysUpAppVisitRoleFieldService;
    @Resource
    private ISysAppVisitDataLogicService sysAppVisitDataLogicService;
    @Resource
    private AppSyncService appSyncService;
    @Resource
    private IFormReferenceService formReferenceService;
    @Resource
    private SysDataPullTaskService sysDataPullTaskService;
    @Resource
    private SysDataPullService sysDataPullService;
    @Resource
    private SysDataPullRecordService sysDataPullRecordService;
    @Resource
    private ISysFormConvertHistoryService sysFormConvertHistoryService;
    @Resource
    private IDashEntryService dashEntryService;
    @Resource
    private ISysUserTableNameService sysUserTableNameService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysRolesExternalService sysRolesExternalService;
    @Resource
    private StandardDefinitionEngineApiService standardDefinitionEngineApiService;
    @Resource
    private ISysRoleFunctionsBoService sysRoleFunctionsBoService;
    @Resource
    private ISysFunctionsBoService sysFunctionsBoService;
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private GodAxeModelService godAxeModelService;
    @Autowired(required=false)
    private IFormOperateHookService formOperateHookService;
    @Resource
    private HookUtil hookUtil;
    @Resource
    private HussarDdlService hussarDdlService;
    @Resource
    private IAIService aiService;
    @Value(value="${ai.sub:false}")
    private Boolean aiSub;

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Long> addForm(SysFormDto sysFormDto) {
        return this.addForm(sysFormDto, null, true);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Long> addForm(SysFormDto sysFormDto, List<Widget> widgets, boolean createTable) {
        DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        String jdbcUrl = bean.getCurrentDatasource().getUrl();
        String dbType = DbUtil.getDbType((String)jdbcUrl).toUpperCase();
        int maxFormSeq = HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.HIGHGO.name(), (Object)dbType) ? this.sysFormMapper.maxSeqPg(sysFormDto.getAppId(), sysFormDto.getFormGroupId()) : this.sysFormMapper.maxSeq(sysFormDto.getAppId(), sysFormDto.getFormGroupId());
        sysFormDto.setSeq(maxFormSeq + 1);
        if ("2".equals(sysFormDto.getFormType())) {
            DashEntry dashEntry = new DashEntry();
            dashEntry.setEntryName(sysFormDto.getFormName());
            dashEntry.setAppId(sysFormDto.getAppId());
            dashEntry.setGroupId(sysFormDto.getFormGroupId() == null ? null : sysFormDto.getFormGroupId().toString());
            dashEntry.setIcon(sysFormDto.getFormIcon());
            Long panelId = this.dashEntryService.savePanelData(dashEntry);
            sysFormDto.setId(panelId);
        }
        if ("2".equals(sysFormDto.getFormType()) || "3".equals(sysFormDto.getFormType())) {
            sysFormDto.setTableName(sysFormDto.getExtname());
            sysFormDto.setFormStatus("1");
            this.save((BaseEntity)sysFormDto);
            SysPanelDto sysPanelDto = new SysPanelDto();
            sysPanelDto.setPanelId(sysFormDto.getId());
            sysPanelDto.setPanelName(sysFormDto.getFormName());
            sysPanelDto.setAppId(sysFormDto.getAppId());
            this.sysPanelService.addPanel(sysPanelDto);
        } else {
            if (createTable && HussarUtils.isEmpty((Object)sysFormDto.getTableName())) {
                String tableName = FormUtil.generateTableName(sysFormDto.getFormType());
                if (HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.HIGHGO.name(), (Object)dbType) || com.baomidou.mybatisplus.annotation.DbType.KINGBASE_ES.name().replace("_", "").equals(dbType)) {
                    sysFormDto.setTableName(tableName.toLowerCase());
                } else {
                    sysFormDto.setTableName(tableName);
                }
            } else if (createTable && HussarUtils.isNotEmpty((Object)sysFormDto.getTableName())) {
                if (HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.HIGHGO.name(), (Object)dbType) || com.baomidou.mybatisplus.annotation.DbType.KINGBASE_ES.name().replace("_", "").equals(dbType)) {
                    sysFormDto.setTableName(sysFormDto.getTableName().toLowerCase());
                }
                if (HussarUtils.equals((Object)DbType.ORACLE.name(), (Object)dbType)) {
                    sysFormDto.setTableName(sysFormDto.getTableName().toUpperCase());
                }
            }
            sysFormDto.setFormStatus("1");
            this.save((BaseEntity)sysFormDto);
            BaseForm baseForm = new BaseForm();
            baseForm.setId(sysFormDto.getId().toString());
            baseForm.setName(sysFormDto.getTableName());
            baseForm.setTitle(sysFormDto.getFormName());
            baseForm.setFormType(sysFormDto.getFormType());
            baseForm.setIcon(sysFormDto.getFormIcon());
            baseForm.setCreateSource(sysFormDto.getCreateSource());
            if ("1".equals(sysFormDto.getFormType())) {
                baseForm.setIdentity("bpm_" + PingYinUtil.getPYIndexStr((String)sysFormDto.getFormName(), (boolean)true) + sysFormDto.getId());
            }
            String widgetStr = null;
            if (HussarUtils.isNotEmpty(widgets)) {
                widgetStr = JSON.toJSONString(widgets);
            }
            try {
                this.formOperateExposedService.create(baseForm, sysFormDto.getAppId().toString(), widgetStr, createTable);
            }
            catch (Exception e) {
                throw new BaseException("\u8868\u5355\u521d\u59cb\u5316\u8d44\u6e90\u5931\u8d25!", (Throwable)e);
            }
        }
        this.appSyncService.syncForm("add", (SysForm)sysFormDto);
        return ApiResponse.success((Object)sysFormDto.getId(), (String)"\u521b\u5efa\u8868\u5355\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#dataSourceKey")
    public void dealTableToForm(List<SysFormSaveDto> sysFormSaveDto, String key, String tableKey, String dataSourceKey) {
        HashMap<String, Object> progress = new HashMap<String, Object>();
        progress.put("size", sysFormSaveDto.size());
        int num = 0;
        int errNum = 0;
        int successNum = 0;
        ArrayList<String> errNames = new ArrayList<String>();
        progress.put("num", num);
        progress.put("name", sysFormSaveDto.get(num).getFormName());
        progress.put("errNum", errNum);
        progress.put("successNum", successNum);
        progress.put("errNames", errNames);
        HussarCacheUtil.put((String)"createFromCacheKey", (Object)key, progress);
        for (SysFormSaveDto formSaveDto : sysFormSaveDto) {
            boolean isSuccess = false;
            try {
                this.addForm((SysFormDto)formSaveDto, formSaveDto.getWidgets(), formSaveDto.isCreateTable()).getData();
                progress.put("successNum", ++successNum);
                isSuccess = true;
            }
            catch (Exception e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
                progress.put("errNum", ++errNum);
                errNames.add(formSaveDto.getFormName());
                if (formSaveDto.isCreateTable() || HussarUtils.isNotEmpty((Object)formSaveDto.getTableName())) {
                    this.sysUserTableNameService.createdFailOne(formSaveDto.getTableName());
                }
                this.sysFormService.remove((Wrapper)Wrappers.lambdaQuery(SysForm.class).eq(SysForm::getId, (Object)formSaveDto.getId()));
            }
            finally {
                progress.put("num", ++num);
                if (num < sysFormSaveDto.size()) {
                    progress.put("name", sysFormSaveDto.get(num).getFormName());
                }
                HussarCacheUtil.put((String)"createFromCacheKey", (Object)key, progress);
                if (!isSuccess || !formSaveDto.isCreateTable() && !HussarUtils.isNotEmpty((Object)formSaveDto.getTableName())) continue;
                this.sysUserTableNameService.created(formSaveDto.getTableName());
            }
        }
    }

    public ApiResponse<Map<String, Object>> getAddFormAndSaveProgress(String key) {
        Map progress = (Map)HussarCacheUtil.get((String)"createFromCacheKey", (Object)key);
        if (HussarUtils.isEmpty((Object)progress)) {
            return ApiResponse.success();
        }
        Integer num = (Integer)progress.get("num");
        Integer size = (Integer)progress.get("size");
        if (num >= size) {
            HussarCacheUtil.evict((String)"createFromCacheKey", (Object)key);
        }
        return ApiResponse.success((Object)progress);
    }

    public void sysCreateButton(ButtonAuthoritiesDto buttonAuthoritiesDto, String formType) {
        ArrayList buttonDtos = Lists.newArrayListWithCapacity((int)10);
        ButtonDto create = new ButtonDto();
        create.setButtonCode(Button.CREATE_OPERATE.getButtonCode());
        create.setButtonName(Button.CREATE_OPERATE.getButtonName());
        ButtonDto edit = new ButtonDto();
        edit.setButtonCode(Button.EDIT_OPERATE.getButtonCode());
        edit.setButtonName(Button.EDIT_OPERATE.getButtonName());
        ButtonDto delete = new ButtonDto();
        delete.setButtonCode(Button.DELETE_OPERATE.getButtonCode());
        delete.setButtonName(Button.DELETE_OPERATE.getButtonName());
        ButtonDto formImport = new ButtonDto();
        formImport.setButtonCode(Button.IMPORT_OPTION.getButtonCode());
        formImport.setButtonName(Button.IMPORT_OPTION.getButtonName());
        ButtonDto formExport = new ButtonDto();
        formExport.setButtonCode(Button.EXPORT_OPTION.getButtonCode());
        formExport.setButtonName(Button.EXPORT_OPTION.getButtonName());
        ButtonDto print = new ButtonDto();
        print.setButtonCode(Button.PRINT_OPERATE.getButtonCode());
        print.setButtonName(Button.PRINT_OPERATE.getButtonName());
        ButtonDto download = new ButtonDto();
        download.setButtonCode(Button.DOWNLOAD_OPERATE.getButtonCode());
        download.setButtonName(Button.DOWNLOAD_OPERATE.getButtonName());
        ButtonDto batchPrint = new ButtonDto();
        batchPrint.setButtonCode(Button.BATCH_PRINT.getButtonCode());
        batchPrint.setButtonName(Button.BATCH_PRINT.getButtonName());
        buttonDtos.add(create);
        buttonDtos.add(edit);
        buttonDtos.add(delete);
        buttonDtos.add(formImport);
        buttonDtos.add(formExport);
        buttonDtos.add(print);
        buttonDtos.add(download);
        buttonDtos.add(batchPrint);
        if ("1".equals(formType)) {
            ButtonDto submit = new ButtonDto();
            submit.setButtonCode(Button.SUBMIT_OPERATE.getButtonCode());
            submit.setButtonName(Button.SUBMIT_OPERATE.getButtonName());
            ButtonDto reject = new ButtonDto();
            reject.setButtonCode(Button.REJECT_OPERATE.getButtonCode());
            reject.setButtonName(Button.REJECT_OPERATE.getButtonName());
            buttonDtos.add(submit);
            buttonDtos.add(reject);
            buttonDtos.remove(edit);
        }
        buttonAuthoritiesDto.setButtonDtoList((List)buttonDtos);
    }

    @HussarTransactional
    public ApiResponse<Boolean> editForm(SysFormDto sysFormDto) {
        boolean flag;
        Long formId = sysFormDto.getId();
        Long appId = sysFormDto.getAppId();
        String formName = sysFormDto.getFormName();
        String formType = sysFormDto.getFormType();
        SysForm sysFormQuery = (SysForm)this.getById(formId);
        if (HussarUtils.isEmpty((Object)sysFormQuery)) {
            throw new BaseException("\u8868\u5355\u4e0d\u5b58\u5728");
        }
        sysFormDto.setSeq(sysFormQuery.getSeq());
        if (HussarUtils.isEmpty((Object)formType)) {
            formType = sysFormQuery.getFormType();
        }
        if (HussarUtils.isNull((Object)appId) || HussarUtils.isEmpty((Object)formName)) {
            appId = sysFormQuery.getAppId();
            formName = sysFormQuery.getFormName();
            sysFormDto.setAppId(appId);
        }
        if ("3".equals(sysFormDto.getFormType())) {
            sysFormDto.setTableName(sysFormDto.getExtname());
        }
        if ("2".equals(formType)) {
            DashEntry dashEntry = new DashEntry();
            dashEntry.setEntryId(formId);
            dashEntry.setEntryName(formName);
            dashEntry.setIcon(sysFormDto.getFormIcon());
            String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
            if (HussarUtils.equals((Object)DbType.ORACLE.name(), (Object)dbType)) {
                dashEntry.setGroupId(sysFormDto.getFormGroupId() == null ? "" : sysFormDto.getFormGroupId().toString());
            } else {
                dashEntry.setGroupId(sysFormDto.getFormGroupId() == null ? null : sysFormDto.getFormGroupId().toString());
            }
            this.dashEntryService.updatePanel(dashEntry);
        } else {
            TransmittableThreadLocalHolder.set((String)"appId", (Object)appId);
            FormDesignResponse formCanvasSchemaFormDesignResponse = this.canvasSchemaService.get(String.valueOf(formId), sysFormQuery);
            FormCanvasSchema formCanvasSchema = (FormCanvasSchema)formCanvasSchemaFormDesignResponse.getData();
            TransmittableThreadLocalHolder.clear((String)"appId");
            if (HussarUtils.isNotEmpty((Object)formCanvasSchema)) {
                formCanvasSchema.setTitle(formName);
                formCanvasSchema.setIcon(sysFormDto.getFormIcon());
                try {
                    this.canvasSchemaService.saveOrUpdate(formCanvasSchema, String.valueOf(appId));
                }
                catch (JsonProcessingException e) {
                    ToolUtil.getLogger(((Object)((Object)this)).getClass()).error("\u66f4\u65b0\u8868\u5355\u753b\u5e03 ==> Storage\u4fdd\u5b58\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)sysFormDto.getId());
                    throw new BaseException("\u66f4\u65b0\u753b\u5e03\u5931\u8d25");
                }
            }
        }
        if (!HussarUtils.equals((Object)sysFormDto.getFormType(), (Object)"2") && !HussarUtils.equals((Object)sysFormDto.getFormType(), (Object)"3") && HussarUtils.isNotEmpty((Object)sysFormDto.getFormName()) && HussarUtils.isNotEmpty((Object)sysFormQuery.getTableName())) {
            this.hussarDdlService.reComment(DataModelUtil.currentDsName(), sysFormQuery.getTableName(), sysFormDto.getFormName());
        }
        if (!(flag = this.updateById((BaseEntity)sysFormDto))) {
            throw new BaseException("\u66f4\u65b0\u5931\u8d25");
        }
        this.appSyncService.syncForm("edit", (SysForm)sysFormDto);
        return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> deleteForm(Long formId) throws IOException, LcdpException {
        SysForm form = (SysForm)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysForm::getId, (Object)formId));
        if (form.getTableName() == null) {
            form.setTableName("");
        }
        HashMap<String, Object> extParams = new HashMap<String, Object>();
        this.formDeleteHookParams(form, extParams);
        if ("0".equals(form.getFormType()) || "1".equals(form.getFormType())) {
            if ("1".equals(form.getFormType())) {
                this.appFormService.deleteAllProcessInstance(String.valueOf(formId), form.getAppId());
                FormCanvasSchema formDesignResponse = (FormCanvasSchema)this.canvasService.get(String.valueOf(formId)).getData();
                String identity = formDesignResponse.getIdentity();
                boolean delProcess = this.godAxeModelService.deleteProcess(identity, null, false).isSuccess();
                if (!delProcess) {
                    throw new BaseException("\u6d41\u7a0b\u6570\u636e\u5220\u9664\u5931\u8d25");
                }
            }
            Long appId = form.getAppId();
            AppContextUtil.setAppId((String)String.valueOf(appId));
            Boolean delMid = (Boolean)this.formCleaner.formClean(String.valueOf(formId)).getData();
            if (!delMid.booleanValue()) {
                throw new BaseException("\u5220\u9664\u5931\u8d25");
            }
        } else if ("2".equals(form.getFormType())) {
            this.dashEntryService.deleteData(formId);
        }
        try {
            this.formOperate.delete(String.valueOf(formId));
        }
        catch (Exception ex) {
            this.LOGGER.error("\u8868\u5355\u5220\u9664\uff0c\u5220\u9664\u6a21\u578b\u6570\u636e\u5931\u8d25", (Throwable)ex);
        }
        Boolean flagFormLink = this.sysFormLinkService.deleteAllForm(formId);
        if (!flagFormLink.booleanValue()) {
            throw new BaseException("\u8868\u5355\u5916\u94fe\u76f8\u5173\u6570\u636e\u5220\u9664\u5931\u8d25");
        }
        boolean flag = this.removeById(formId);
        if (!flag) {
            throw new BaseException("\u66f4\u65b0\u5931\u8d25");
        }
        this.sysFormCheckConfigService.deleteFormCheckConfig(formId);
        this.deleteFormOtherAuthorityInfo(formId);
        this.sysCustomButtonService.deleteSysCustomButtonByFormId(formId);
        this.sysDataPullService.removeByFormId(formId);
        this.sysDataPullTaskService.removeByFormId(formId);
        this.sysDataPullRecordService.removeByFormId(formId);
        this.pushDataService.deleteByFormId(formId);
        this.formMapService.deleteByFormId(formId);
        this.pushDataRecordService.deleteByFormId(formId);
        this.formReferenceService.delReferenceByFormId(formId);
        SysForm sysForm = new SysForm();
        sysForm.setId(formId);
        this.appSyncService.syncForm("del", sysForm);
        this.sysUserTableNameService.removeForm(form.getTableName());
        this.aiService.deleteFromAi(formId);
        this.formDeleteHook(form, extParams);
        return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    private void formDeleteHookParams(SysForm form, Map<String, Object> extParams) {
        FormDeleteHookDto formDeleteHookDto = new FormDeleteHookDto();
        formDeleteHookDto.setFormId(form.getId());
        formDeleteHookDto.setAppId(form.getAppId());
        formDeleteHookDto.setExtParams(extParams);
        if (this.formOperateHookService != null) {
            this.formOperateHookService.beforeFormDelete(formDeleteHookDto);
        }
        String formId = String.valueOf(formDeleteHookDto.getFormId());
        this.hookUtil.beforeFormDelete(formId, form.getTableName(), formDeleteHookDto);
    }

    private void formDeleteHook(SysForm form, Map<String, Object> extParams) {
        FormDeleteHookDto formDeleteHookDto = new FormDeleteHookDto();
        formDeleteHookDto.setFormId(form.getId());
        formDeleteHookDto.setAppId(form.getAppId());
        formDeleteHookDto.setExtParams(extParams);
        if (HussarUtils.isNotEmpty((Object)this.formOperateHookService)) {
            this.formOperateHookService.formDeleteHook(formDeleteHookDto);
        }
        String formId = String.valueOf(formDeleteHookDto.getFormId());
        this.hookUtil.formDeleteHook(formId, form.getTableName(), formDeleteHookDto);
    }

    private void deleteFormOtherAuthorityInfo(Long formId) {
        this.sysAppVisitRoleFieldBoService.deleteSysAppVisitRoleField(null, formId, null);
        this.sysAppVisitDataLogicService.deleteDataLogicByFormId(null, formId, null);
    }

    public SysSiftGroupList getFormList(String formName, String formStatus, String formType, Long appId) {
        SysSiftGroupList sysSiftGroupList = new SysSiftGroupList();
        List<SysFormVo> sysFormList = this.sysFormMapper.getSysFormList(formName, formStatus, null, formType, appId);
        ArrayList<SysFormGroupVo> sysFormGroups = new ArrayList();
        sysFormGroups = this.sysFormGroupMapper.getSysFormGroupList(appId, null);
        if (HussarUtils.isEmpty(sysFormList)) {
            sysSiftGroupList.setHaveGroupList(JSON.parseArray((String)JSON.toJSONString(sysFormGroups), SysFormGroupVo.class));
            return sysSiftGroupList;
        }
        return this.combinedData(sysFormList, sysFormGroups);
    }

    public SysSiftGroupList getFormListWithFormId(String formName, String formStatus, String formType, Long appId, Long formId) {
        SysSiftGroupList sysSiftGroupList = new SysSiftGroupList();
        List<SysFormVo> sysFormList = this.sysFormMapper.getFormListWithFormId(formName, formStatus, null, formType, appId, formId);
        ArrayList<SysFormGroupVo> sysFormGroups = new ArrayList();
        sysFormGroups = this.sysFormGroupMapper.getSysFormGroupList(appId, null);
        if (HussarUtils.isEmpty(sysFormList)) {
            sysSiftGroupList.setHaveGroupList(JSON.parseArray((String)JSON.toJSONString(sysFormGroups), SysFormGroupVo.class));
            return sysSiftGroupList;
        }
        return this.combinedData(sysFormList, sysFormGroups);
    }

    public ApiResponse<List<AppMenuVo>> getFormMenuList(Long appId) {
        List formIds = (List)this.sysAppVisitFormAuthorizeRolesService.getAuthorityFormList(appId).getData();
        return this.getFormMenuListCommon(formIds, appId);
    }

    public ApiResponse<List<AppMenuVo>> getFormMenuList(Long userId, Long appId) {
        List formIds = (List)this.sysAppVisitFormAuthorizeRolesService.getAuthFormListByUserId(userId, appId).getData();
        return this.getFormMenuListCommon(formIds, appId);
    }

    private ApiResponse<List<AppMenuVo>> getFormMenuListCommon(List<Long> formIds, Long appId) {
        if (HussarUtils.isEmpty(formIds)) {
            return ApiResponse.success(new ArrayList(), (String)"\u6ca1\u6709\u53ef\u8bbf\u95ee\u7684\u83dc\u5355");
        }
        List<Object> sysFormGroups = new ArrayList();
        List<SysFormVo> sysFormList = this.sysFormMapper.getSysFormList(null, null, formIds, null, appId);
        ArrayList<Long> groupIds = new ArrayList<Long>();
        for (SysForm sysForm : sysFormList) {
            if (!HussarUtils.isNotEmpty((Object)sysForm.getFormGroupId())) continue;
            groupIds.add(sysForm.getFormGroupId());
        }
        if (HussarUtils.isNotEmpty(groupIds)) {
            sysFormGroups = this.sysFormGroupMapper.getSysFormGroupList(appId, groupIds);
        }
        ArrayList<AppMenuVo> resultList = new ArrayList<AppMenuVo>();
        for (SysFormGroupVo sysFormGroup : sysFormGroups) {
            AppMenuVo appMenuVo = new AppMenuVo();
            appMenuVo.setId(sysFormGroup.getId());
            appMenuVo.setSeq(sysFormGroup.getSeq().intValue());
            appMenuVo.setName(sysFormGroup.getGroupName());
            appMenuVo.setIcon(sysFormGroup.getGroupIcon());
            appMenuVo.setIconType(sysFormGroup.getGroupIconType());
            appMenuVo.setIconColor(sysFormGroup.getGroupIconColor());
            appMenuVo.setI18nKeys(sysFormGroup.getI18nKeys());
            appMenuVo.setType("1");
            resultList.add(appMenuVo);
        }
        Map map = JSON.parseArray((String)JSON.toJSONString(resultList), AppMenuVo.class).stream().distinct().collect(Collectors.toMap(AppMenuVo::getId, AppMenuVo2 -> AppMenuVo2, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysForm sysForm : sysFormList) {
            AppMenuVo appMenuVo = (AppMenuVo)map.get(sysForm.getFormGroupId());
            if (HussarUtils.isEmpty((Object)appMenuVo)) {
                AppMenuVo result = this.giveAppMenuVoProperty(sysForm);
                map.put(result.getId(), result);
                continue;
            }
            if (HussarUtils.isNotEmpty((Object)appMenuVo.getAppMenuVoList())) {
                appMenuVo.getAppMenuVoList().add(this.giveAppMenuVoProperty(sysForm));
            }
            if (!HussarUtils.isEmpty((Object)appMenuVo.getAppMenuVoList())) continue;
            ArrayList<AppMenuVo> menuVoList = new ArrayList<AppMenuVo>();
            menuVoList.add(this.giveAppMenuVoProperty(sysForm));
            appMenuVo.setAppMenuVoList(menuVoList);
        }
        return ApiResponse.success(new ArrayList(map.values()));
    }

    public ApiResponse<SysForm> getDetailById(Long formId) {
        return ApiResponse.success((Object)this.getById(formId));
    }

    public ApiResponse<SysFormVo> getFormDetailById(Long formId) {
        SysForm sysForm = (SysForm)this.getById(formId);
        if (HussarUtils.isNull((Object)sysForm)) {
            return ApiResponse.fail((IResultCode)LcdpExceptionEnum.FORM_NOT_FOUND);
        }
        SysFormVo sysFormVo = (SysFormVo)HussarUtils.copyProperties((Object)sysForm, SysFormVo.class);
        int convertVersion = this.sysFormConvertHistoryService.getConvertCount(formId);
        sysFormVo.setConvertVersion(convertVersion);
        return ApiResponse.success((Object)sysFormVo);
    }

    public ApiResponse<List<SysForm>> getSysFormByAppId(Long appId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysForm::getAppId, (Object)appId);
        return ApiResponse.success((Object)this.list((Wrapper)lambdaQueryWrapper));
    }

    public ApiResponse<List<SysAppFormTreeVo>> getAppFormList(Long appId) {
        ArrayList<SysAppFormTreeVo> treeList = new ArrayList<SysAppFormTreeVo>();
        SysApplication sysApplication = this.applicationBoService.selectById(appId);
        SysAppFormTreeVo appTreeVo = new SysAppFormTreeVo();
        appTreeVo.setLabel(sysApplication.getAppName());
        appTreeVo.setId((Serializable)((Object)sysApplication.getId().toString()));
        appTreeVo.setHasChildren(Boolean.valueOf(true));
        appTreeVo.setIcon(sysApplication.getAppIcon());
        appTreeVo.setIconType(sysApplication.getAppIconType());
        appTreeVo.setIconColor(sysApplication.getAppIconColor());
        appTreeVo.setType(1);
        treeList.add(appTreeVo);
        LambdaQueryWrapper formWrapper = Wrappers.lambdaQuery();
        formWrapper.eq(HussarUtils.isNotEmpty((Object)appId), SysFormGroup::getAppId, (Object)appId);
        formWrapper.orderByAsc(SysFormGroup::getSeq);
        List formGroupList = this.sysFormGroupMapper.selectList((Wrapper)formWrapper);
        for (SysFormGroup sysFormGroup : formGroupList) {
            SysAppFormTreeVo formGroupTreeVo = new SysAppFormTreeVo();
            formGroupTreeVo.setId((Serializable)((Object)sysFormGroup.getId().toString()));
            formGroupTreeVo.setLabel(sysFormGroup.getGroupName());
            formGroupTreeVo.setParentId((Serializable)((Object)sysFormGroup.getAppId().toString()));
            formGroupTreeVo.setIcon(sysFormGroup.getGroupIcon());
            formGroupTreeVo.setIconType(sysFormGroup.getGroupIconType());
            formGroupTreeVo.setIconColor(sysFormGroup.getGroupIconColor());
            formGroupTreeVo.setType(2);
            treeList.add(formGroupTreeVo);
        }
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(HussarUtils.isNotEmpty((Object)appId), SysForm::getAppId, (Object)appId);
        queryWrapper2.orderByAsc(SysForm::getSeq);
        List formList = this.list((Wrapper)queryWrapper2);
        for (SysForm sysForm : formList) {
            SysAppFormTreeVo formTreeVo = new SysAppFormTreeVo();
            formTreeVo.setId((Serializable)((Object)sysForm.getId().toString()));
            formTreeVo.setLabel(sysForm.getFormName());
            if (HussarUtils.isEmpty((Object)sysForm.getFormGroupId())) {
                formTreeVo.setParentId((Serializable)((Object)sysForm.getAppId().toString()));
            } else {
                formTreeVo.setParentId((Serializable)((Object)sysForm.getFormGroupId().toString()));
            }
            formTreeVo.setIcon(sysForm.getFormIcon());
            formTreeVo.setIconType(sysForm.getFormIconType());
            formTreeVo.setIconColor(sysForm.getFormIconColor());
            formTreeVo.setType(3);
            treeList.add(formTreeVo);
        }
        return ApiResponse.success((Object)HussarTreeParser.getTreeList(treeList));
    }

    public ApiResponse<List<FieldVo>> getFormField(Long formId, String appId) {
        try {
            List widgetFields = (List)this.formOperateExposedService.widgets(formId.toString(), appId).getData();
            ArrayList<FieldVo> fieldVos = new ArrayList<FieldVo>();
            if (HussarUtils.isNotEmpty((Object)widgetFields)) {
                for (WidgetField widgetField : widgetFields) {
                    FieldVo fieldVo = new FieldVo();
                    fieldVo.setFieldId(widgetField.getName());
                    fieldVo.setFieldName(widgetField.getTitle());
                    fieldVo.setType(widgetField.getType());
                    fieldVo.setUsage(widgetField.getUsage());
                    fieldVo.setDataType(widgetField.getDataType());
                    fieldVo.setRealField(widgetField.getIsRealField());
                    fieldVo.setProps(widgetField.getProps());
                    if (HussarUtils.isNotEmpty((Object)widgetField.getChildren())) {
                        ArrayList fieldVosChildren = Lists.newArrayListWithCapacity((int)10);
                        widgetField.getChildren().forEach(c -> {
                            FieldVo cT = new FieldVo();
                            cT.setFieldId(c.getName());
                            cT.setFieldName(widgetField.getTitle() + "." + c.getTitle());
                            cT.setType(c.getType());
                            cT.setUsage(c.getUsage());
                            cT.setDataType(c.getDataType());
                            cT.setRealField(c.getIsRealField());
                            cT.setProps(c.getProps());
                            fieldVosChildren.add(cT);
                        });
                        fieldVo.setChildren((List)fieldVosChildren);
                    }
                    fieldVos.add(fieldVo);
                }
            }
            return ApiResponse.success(fieldVos);
        }
        catch (Exception e) {
            throw new BaseException("\u83b7\u53d6\u8868\u5355\u5185\u5b57\u6bb5\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
    }

    private SysSiftGroupList combinedData(List<SysFormVo> sysFormList, List<SysFormGroupVo> sysFormGroups) {
        ArrayList<SysForm> noGroupList = new ArrayList<SysForm>();
        SysSiftGroupList sysSiftGroupList = new SysSiftGroupList();
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysFormGroups), SysFormGroupVo.class).stream().distinct().collect(Collectors.toMap(SysFormGroup::getId, sysFormGroupVo -> sysFormGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysForm sysForm : sysFormList) {
            SysFormGroupVo sysFormGroupVo2 = (SysFormGroupVo)resultCollect.get(sysForm.getFormGroupId());
            if (HussarUtils.isEmpty((Object)sysFormGroupVo2)) {
                noGroupList.add(sysForm);
                continue;
            }
            if (HussarUtils.isNotEmpty((Object)sysFormGroupVo2.getSysFormList())) {
                sysFormGroupVo2.getSysFormList().add(sysForm);
            }
            if (!HussarUtils.isEmpty((Object)sysFormGroupVo2.getSysFormList())) continue;
            ArrayList<SysForm> formGroupList = new ArrayList<SysForm>();
            formGroupList.add(sysForm);
            sysFormGroupVo2.setSysFormList(formGroupList);
        }
        sysSiftGroupList.setHaveGroupList(new ArrayList(resultCollect.values()));
        sysSiftGroupList.setNoGroupList(noGroupList);
        return sysSiftGroupList;
    }

    private AppMenuVo giveAppMenuVoProperty(SysForm sysForm) {
        AppMenuVo trans = new AppMenuVo();
        trans.setId(sysForm.getId());
        trans.setSeq(sysForm.getSeq());
        trans.setName(sysForm.getFormName());
        trans.setIcon(sysForm.getFormIcon());
        trans.setIconType(sysForm.getFormIconType());
        trans.setIconColor(sysForm.getFormIconColor());
        trans.setFormType(sysForm.getFormType());
        trans.setTableName(sysForm.getTableName());
        trans.setStatus(sysForm.getFormStatus());
        trans.setI18nKeys(sysForm.getI18nKeys());
        trans.setHidden(sysForm.getHidden());
        trans.setType("2");
        return trans;
    }

    public List<SysForm> getFormsByAppIds(List<Long> appIds) {
        return this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysForm::getAppId, appIds)).orderBy(true, true, SysForm::getSeq));
    }

    public String getTableNameById(Long formId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysForm::getId, (Object)formId);
        return ((SysForm)this.getOne((Wrapper)queryWrapper)).getTableName();
    }

    public SysSiftGroupListWithAuth getFormListWithAuth(String formName, String formStatus, Long appId, Long roleId, Long formId) {
        SysSiftGroupListWithAuth sysSiftGroupListWithAuth = new SysSiftGroupListWithAuth();
        SysSiftGroupList formList = null;
        formList = HussarUtils.isNotEmpty((Object)formId) ? this.getFormListWithFormId(formName, formStatus, null, appId, formId) : this.getFormList(formName, formStatus, null, appId);
        FormAuthorityMap formAuthorityMap = new FormAuthorityMap();
        formAuthorityMap.setButtonAuthorityMap(this.sysAppVisitRoleButtonService.listButtonAuthorityByAppId(appId, roleId, formId));
        formAuthorityMap.setOrganDataAuthorityMap(this.sysAppVisitRoleOrganDataAuthorityService.listOrganDataAuthorityByAppId(appId, roleId, formId));
        formAuthorityMap.setDataLogicAuthorityMap(this.sysAppVisitDataLogicService.listDataLogicAuthorityByAppId(appId, roleId, formId));
        formAuthorityMap.setFieldAuthorityMap(this.sysUpAppVisitRoleFieldService.listFieldAuthorityByAppId(appId, roleId, formId));
        formAuthorityMap.setFormAuthorizedMap(this.sysAppVisitFormAuthorizeRolesService.listFormAuthorizedByAppId(appId, roleId, formId));
        sysSiftGroupListWithAuth.setNoGroupList(this.addAuthority4Form(formAuthorityMap, formList.getNoGroupList()));
        List<SysFormGroupWithAuthVo> groupListWithAuth = this.addAuthority4Group(formAuthorityMap, formList.getHaveGroupList());
        sysSiftGroupListWithAuth.setHaveGroupList(groupListWithAuth);
        return sysSiftGroupListWithAuth;
    }

    public List<SysFormRoleAuthVo> listFormRoleAuthsById(Long appId, final Long formId) {
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        AssertUtil.isNotNull((Object)sysForm, (String)LcdpExceptionEnum.FORM_NOT_FOUND.getMessage());
        List funIds = this.sysFunctionsBoService.list((List)new ArrayList<Long>(){
            {
                this.add(formId);
            }
        }, appId, null).stream().map(SysFunctions::getId).collect(Collectors.toList());
        List roleFunctionsList = this.sysRoleFunctionsBoService.list(null, funIds);
        if (HussarUtils.isEmpty((Object)roleFunctionsList)) {
            return Collections.emptyList();
        }
        List roleIds = roleFunctionsList.stream().map(SysRoleFunctions::getRoleId).collect(Collectors.toList());
        List sysRoles = this.sysRolesExternalService.getRolesFilterAppDevRole(roleIds).stream().sorted(Comparator.comparingInt(o -> roleIds.indexOf(o.getId()))).collect(Collectors.toList());
        List<SysFormRoleAuthVo> result = sysRoles.stream().map(role -> {
            SysFormRoleAuthVo formRoleAuthVo = new SysFormRoleAuthVo();
            formRoleAuthVo.setRoleId(role.getId());
            formRoleAuthVo.setRoleName(role.getRoleName());
            formRoleAuthVo.setSystemRole(HussarUtils.equals((Object)1L, (Object)role.getFromAppId()));
            return formRoleAuthVo;
        }).collect(Collectors.toList());
        if (HussarUtils.isEmpty(result)) {
            return result;
        }
        this.prepareRoleButtonAuthorities(result, appId, formId, sysForm.getFormType());
        this.sysAppVisitRoleOrganDataAuthorityService.prepareOrganDataAuthorityByFormId(result, appId, formId);
        this.sysAppVisitDataLogicService.prepareDataLogicAuthorityByFormId(result, appId, formId);
        if (!"3".equals(sysForm.getFormType()) && !"2".equals(sysForm.getFormType())) {
            this.sysUpAppVisitRoleFieldService.prepareFieldAuthorityByFormId(result, appId, formId);
        }
        this.prepareAppRoleMembers(result);
        return result;
    }

    private List<SysFormGroupWithAuthVo> addAuthority4Group(FormAuthorityMap formAuthorityMap, List<SysFormGroupVo> sysFormGroupList) {
        ArrayList<SysFormGroupWithAuthVo> groupListWithAuth = new ArrayList<SysFormGroupWithAuthVo>();
        sysFormGroupList.forEach(sysFormGroup -> {
            SysFormGroupWithAuthVo sysFormGroupWithAuthVo = new SysFormGroupWithAuthVo();
            BeanUtils.copyProperties((Object)sysFormGroup, (Object)sysFormGroupWithAuthVo);
            sysFormGroupWithAuthVo.setSysFormList(this.addAuthority4Form(formAuthorityMap, sysFormGroup.getSysFormList()));
            groupListWithAuth.add(sysFormGroupWithAuthVo);
        });
        return groupListWithAuth;
    }

    private List<SysFormWithAuthVo> addAuthority4Form(FormAuthorityMap formAuthorityMap, List<SysForm> sysFormList) {
        if (HussarUtils.isEmpty(sysFormList)) {
            return new ArrayList<SysFormWithAuthVo>();
        }
        return sysFormList.stream().map(form -> {
            SysFormWithAuthVo formWithAuthVo = new SysFormWithAuthVo();
            Long formId = form.getId();
            BeanUtils.copyProperties((Object)form, (Object)formWithAuthVo);
            formWithAuthVo.setButtonAuthorities((List)formAuthorityMap.getButtonAuthorityMap().get(formId));
            formWithAuthVo.setFieldAuthority((FieldAuthWithStatusVo)formAuthorityMap.getFieldAuthorityMap().get(formId));
            formWithAuthVo.setOrganDataAuthority((OrganDataAuthorityVo)formAuthorityMap.getOrganDataAuthorityMap().get(formId));
            formWithAuthVo.setDataLogicAuthority((DataLogicAuthorityVo)formAuthorityMap.getDataLogicAuthorityMap().get(formId));
            formWithAuthVo.setAuthorized(HussarUtils.isNotEmpty(formAuthorityMap.getFormAuthorizedMap().get(formId)));
            return formWithAuthVo;
        }).collect(Collectors.toList());
    }

    private void prepareRoleButtonAuthorities(List<SysFormRoleAuthVo> result, Long appId, final Long formId, String formType) {
        List allFunctionList = this.sysFunctionsBoService.list((List)new ArrayList<Long>(){
            {
                this.add(formId);
            }
        }, appId, "element_" + formId);
        List funIds = allFunctionList.stream().map(SysFunctions::getId).collect(Collectors.toList());
        List roleFunctionsList = this.sysRoleFunctionsBoService.list(null, funIds);
        result.stream().forEach(e -> {
            ArrayList<3> buttonVos = new ArrayList<3>();
            final List roleFunIds = roleFunctionsList.stream().filter(item -> HussarUtils.equals((Object)e.getRoleId(), (Object)item.getRoleId())).map(SysRoleFunctions::getFunctionId).collect(Collectors.toList());
            for (final SysFunctions sysFunctions : allFunctionList) {
                final String[] funCodes = sysFunctions.getFunctionCode().split("_");
                if (funCodes.length == 3) {
                    buttonVos.add(new ButtonVo(){
                        {
                            this.setButtonCode(funCodes[2]);
                            this.setButtonName(sysFunctions.getFunctionName());
                            this.setChecked(roleFunIds.contains(sysFunctions.getId()));
                        }
                    });
                }
                e.setButtonAuthorities(buttonVos);
            }
        });
    }

    private void prepareAppRoleMembers(List<SysFormRoleAuthVo> result) {
        List appRoleIds = result.stream().filter(e -> !e.isSystemRole()).map(SysFormRoleAuthVo::getRoleId).collect(Collectors.toList());
        List appRoleRelateInfoVos = this.sysRolesExternalService.searchAppRoleRelateByRoleIds(appRoleIds);
        Map<Long, List> roleRelateMap = appRoleRelateInfoVos.stream().collect(Collectors.toMap(AppRoleRelateInfoVo::getRoleId, AppRoleRelateInfoVo::getMemberList));
        result.stream().forEach(e -> e.setMemberList((List)roleRelateMap.get(e.getRoleId())));
    }

    public ApiResponse<Boolean> checkTableNameOfForm(String tableName) {
        Long formId = this.sysFormMapper.geFormIdtByTableName(tableName);
        if (HussarUtils.isNotEmpty((Object)formId)) {
            this.LOGGER.info("\u521b\u5efa\u4e1a\u52a1\u8868\u5355\u8868\u540d\u91cd\u590d\uff0c\u8868\u540d\uff1a{}", (Object)tableName);
            return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)false, (String)"\u8868\u540d\u5df2\u5b58\u5728");
        }
        DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        String jdbcUrl = bean.getCurrentDatasource().getUrl();
        String dbType = DbUtil.getDbType((String)jdbcUrl).toUpperCase();
        if (HussarUtils.equals((Object)DbType.ORACLE.name(), (Object)dbType) && tableName.length() > 25) {
            this.LOGGER.info("\u521b\u5efa\u4e1a\u52a1\u8868\u5355\u8868\u540d\u8d85\u957f\uff0c\u8868\u540d\uff1a{}", (Object)tableName);
            return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)false, (String)"\u8868\u540d\u8d85\u957f");
        }
        return ApiResponse.success((Object)true);
    }

    public List<String> getTableNameList() {
        return this.sysFormMapper.getTableNameList();
    }

    public ApiResponse<FlowFormProcessVO> getProcessNodes(String formId) {
        FormDesignResponse formCanvasSchemaFormDesignResponse = this.canvasSchemaService.get(formId);
        FormCanvasSchema formCanvasSchema = (FormCanvasSchema)formCanvasSchemaFormDesignResponse.getData();
        if (HussarUtils.isEmpty((Object)formCanvasSchema)) {
            this.LOGGER.error("\u83b7\u53d6\u8868\u5355\u6d41\u7a0b\u73af\u8282\u6570\u636e\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u753b\u5e03\u6570\u636e\uff0cformId\uff1a{}", (Object)formId);
            return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), null, (String)"\u8868\u5355\u4e0d\u5b58\u5728\u6216\u672a\u67e5\u8be2\u5230\u753b\u5e03");
        }
        if (!HussarUtils.equals((Object)"1", (Object)formCanvasSchema.getFormType())) {
            return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), null, (String)"\u975e\u6d41\u7a0b\u8868\u5355\uff0c\u4e0d\u5b58\u5728\u6d41\u7a0b\u73af\u8282\u4fe1\u606f");
        }
        NodeInfQueryDto nodeInfQueryDto = new NodeInfQueryDto();
        nodeInfQueryDto.setProcessKey(formCanvasSchema.getIdentity());
        BpmResponseResult bpmResponseResult = this.standardDefinitionEngineApiService.queryNodeInfo(nodeInfQueryDto);
        JSONObject bpmResponseResultResult = bpmResponseResult.getResult().getJSONObject(0);
        FlowFormProcessVO result = new FlowFormProcessVO();
        result.setFormId(formId);
        result.setProcessKey(formCanvasSchema.getIdentity());
        result.setProcessDefinitionId(bpmResponseResultResult.getString("processDefinitionId"));
        result.setProcessDefinitionName(bpmResponseResultResult.getString("processDefinitionName"));
        ArrayList<FlowFormProcessNodeVO> nodeInfos = new ArrayList<FlowFormProcessNodeVO>();
        JSONArray nodeInfo = bpmResponseResultResult.getJSONArray("nodeInfo");
        Iterator iterator = nodeInfo.stream().iterator();
        while (iterator.hasNext()) {
            JSONObject next = JSON.parseObject((String)JSON.toJSONString(iterator.next()));
            String taskDefinitionKey = next.getString("taskDefinitionKey");
            String taskDefinitionName = next.getString("taskDefinitionName");
            String taskDefinitionType = next.getString("taskDefinitionType");
            FlowFormProcessNodeVO flowFormProcessNodeVO = new FlowFormProcessNodeVO();
            flowFormProcessNodeVO.setProcessNode(taskDefinitionName);
            flowFormProcessNodeVO.setProcessNodeKey(taskDefinitionKey);
            flowFormProcessNodeVO.setProcessNodeType(taskDefinitionType);
            nodeInfos.add(flowFormProcessNodeVO);
        }
        result.setNodeInfos(nodeInfos);
        return ApiResponse.success((Object)result);
    }

    public ApiResponse<List<SysForm>> getFormsByTableNames(List<String> tableNames) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysForm::getTableName, tableNames);
        List forms = this.sysFormMapper.selectList((Wrapper)queryWrapper);
        return ApiResponse.success((Object)forms);
    }

    public List<Long> getAllAppId() {
        return this.sysFormMapper.getAllAppId();
    }

    public List<Long> getAllFormId(Long appId) {
        DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        String jdbcUrl = bean.getCurrentDatasource().getUrl();
        String dbType = DbUtil.getDbType((String)jdbcUrl).toUpperCase();
        if (HussarUtils.equals((Object)DbType.ORACLE.name(), (Object)dbType)) {
            return this.sysFormMapper.getAllFormIdOracle(appId);
        }
        return this.sysFormMapper.getAllFormId(appId);
    }

    public List<AppFormExistResult> existFormByAppId(List<Long> appIds) {
        return this.sysFormMapper.existFormByAppIds(appIds);
    }
}

