/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.extapi.service.Impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.client.sdk.api.bo.EaiApiSdkInvokeParams;
import com.jxdinfo.hussar.eai.client.sdk.properties.EaiClientSdkProperties;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiInfoSdkDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiApiParamsItem;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.NoCodeHttpUtil;
import com.jxdinfo.hussar.formdesign.application.data.dto.ClientDto;
import com.jxdinfo.hussar.formdesign.application.extapi.dao.SysExtApiDictMapper;
import com.jxdinfo.hussar.formdesign.application.extapi.dao.SysFormExtApiMapper;
import com.jxdinfo.hussar.formdesign.application.extapi.dto.SysFormExtApiDto;
import com.jxdinfo.hussar.formdesign.application.extapi.model.SysExtApiDict;
import com.jxdinfo.hussar.formdesign.application.extapi.model.SysFormExtApi;
import com.jxdinfo.hussar.formdesign.application.extapi.service.ISysFormExtApiService;
import com.jxdinfo.hussar.formdesign.application.extapi.vo.SysFormExtApiExampleParamIn;
import com.jxdinfo.hussar.formdesign.application.extapi.vo.SysFormExtApiVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.extension.api.service.IExtFlowFormService;
import com.jxdinfo.hussar.formdesign.extension.api.service.IExtFormService;
import com.jxdinfo.hussar.formdesign.storage.common.utils.HttpUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.extract.ExtractCoordinate;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.extract.ExtractFactory;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.trans.service.Impl.SysTransRequestServiceImpl")
public class SysFormExtApiServiceImpl
extends HussarServiceImpl<SysFormExtApiMapper, SysFormExtApi>
implements ISysFormExtApiService {
    private static Logger logger = LoggerFactory.getLogger(SysFormExtApiServiceImpl.class);
    private static final String FORM_EXT = "_formExt";
    private static final String TABLE_QUERY_CACHE = "_tableQueryCache";
    @Resource
    private SysExtApiDictMapper sysExtApiDictMapper;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysFormExtApiService sysFormExtApiService;
    @Resource
    private NoCodeHttpUtil noCodeHttpUtil;
    @Resource
    private EaiClientSdkProperties eaiClientSdkProperties;
    private static final String FROM_EXT_API_REQUEST_HEAD = "_fromExtApiRequest";
    private static final String HTTP_TYPE_OUT = "1";
    private static final String TABLE_QUERY_FROM = "_tableQuery_from";

    public ApiResponse<List<SysExtApiDict>> extApiDictList(String formType) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        return ApiResponse.success((Object)this.sysExtApiDictMapper.selectList((Wrapper)queryWrapper.eq(SysExtApiDict::getFormType, (Object)formType)));
    }

    public SysFormExtApi getSysFormExtApi(String appId, String formId, String extApiCode, Map<String, Object> params) {
        Object objectForm;
        HttpServletRequest request;
        String requestHeader;
        if (HussarUtils.isNotEmpty(params) && HussarUtils.equals((Object)params.get(FROM_EXT_API_REQUEST_HEAD), (Object)HTTP_TYPE_OUT)) {
            logger.info("\u8868\u5355id:{}, \u8bf7\u6c42:{}, \u5df2\u662f\u6765\u81ea\u81ea\u5b9a\u4e49\u63a5\u53e3\u8f6c\u53d1\u8bf7\u6c42, \u4e0d\u518d\u8d70\u81ea\u5b9a\u4e49\u63a5\u53e3", (Object)formId, (Object)extApiCode);
            return null;
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (HussarUtils.isNotEmpty((Object)requestAttributes) && HussarUtils.equals((Object)(requestHeader = (request = requestAttributes.getRequest()).getHeader(FROM_EXT_API_REQUEST_HEAD)), (Object)HTTP_TYPE_OUT)) {
            logger.info("\u8868\u5355id:{}, \u8bf7\u6c42:{}, \u5df2\u662f\u6765\u81ea\u81ea\u5b9a\u4e49\u63a5\u53e3\u8f6c\u53d1\u8bf7\u6c42, \u4e0d\u518d\u8d70\u81ea\u5b9a\u4e49\u63a5\u53e3", (Object)formId, (Object)extApiCode);
            return null;
        }
        SysForm sysForm = null;
        Object object = objectForm = HussarUtils.isNotEmpty(params) ? params.get(TABLE_QUERY_FROM) : null;
        if (HussarUtils.isNotEmpty((Object)objectForm)) {
            sysForm = (SysForm)objectForm;
        } else {
            sysForm = (SysForm)HussarCacheUtil.get((String)TABLE_QUERY_FROM, (Object)formId, SysForm.class);
            if (HussarUtils.isEmpty((Object)sysForm)) {
                sysForm = (SysForm)this.sysFormService.getById((Serializable)((Object)formId));
                HussarCacheUtil.put((String)TABLE_QUERY_FROM, (Object)formId, (Object)sysForm, (long)3600L);
            }
        }
        if (HussarUtils.isEmpty((Object)sysForm)) {
            throw new BaseException("\u8868\u5355\u4e0d\u5b58\u5728\uff01");
        }
        String formType = sysForm.getFormType();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysFormExtApi::getAppId, (Object)Long.valueOf(appId))).eq(SysFormExtApi::getFormId, (Object)Long.valueOf(formId))).eq(SysFormExtApi::getFormType, (Object)formType)).eq(SysFormExtApi::getExtApiCode, (Object)extApiCode)).eq(SysFormExtApi::getStatus, (Object)HTTP_TYPE_OUT);
        return (SysFormExtApi)this.getOne((Wrapper)queryWrapper);
    }

    public ResponseEntity<ApiResponse<Object>> invoke(SysFormExtApi sysFormExtApi, Map<String, String> param, Object body) {
        if (HussarUtils.isNotEmpty((Object)body)) {
            Map bodyParams = body;
            bodyParams.put(FROM_EXT_API_REQUEST_HEAD, HTTP_TYPE_OUT);
        } else {
            body = new HashMap();
        }
        Long formId = sysFormExtApi.getFormId();
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        if (HussarUtils.equals((Object)sysFormExtApi.getExtApiType(), (Object)"Bean") && HussarUtils.equals((Object)sysForm.getFormType(), (Object)"0")) {
            return this.doBeanInvoke(sysFormExtApi, param, body);
        }
        if (HussarUtils.equals((Object)sysFormExtApi.getExtApiType(), (Object)"Bean") && HussarUtils.equals((Object)sysForm.getFormType(), (Object)HTTP_TYPE_OUT)) {
            return this.doFlowBeanInvoke(sysFormExtApi, param, body);
        }
        if (HussarUtils.equals((Object)sysFormExtApi.getExtApiType(), (Object)"RESTful")) {
            return this.doTransRequest(sysFormExtApi.getExtApiHttpMethod(), sysFormExtApi.getExtApiHttpUrl(), param, body, sysFormExtApi);
        }
        logger.info("\u8868\u5355[{}]\u914d\u7f6e\u5916\u90e8\u63a5\u53e3\u8c03\u7528\u65b9\u5f0f\u9519\u8bef{}", (Object)sysFormExtApi.getFormId(), (Object)sysFormExtApi.getExtApiType());
        throw new BaseException("\u8868\u5355\u914d\u7f6e\u5916\u90e8\u63a5\u53e3\u8c03\u7528\u65b9\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
    }

    public ResponseEntity<ApiResponse<Object>> doBeanInvoke(SysFormExtApi sysFormExtApi, Map<String, String> param, Object body) {
        ExtractFactory extractFactory = (ExtractFactory)SpringContextUtil.getBean(ExtractFactory.class);
        IExtFormService extFormService = (IExtFormService)extractFactory.getExtractByCoordinate(ExtractCoordinate.build((String)sysFormExtApi.getExtApiBeanBus(), (String)sysFormExtApi.getExtApiBeanScene(), (String)sysFormExtApi.getExtApiBeanUseCase()));
        Long appId = Long.valueOf(param.get("appId"));
        Long formId = Long.valueOf(param.get("formId"));
        String tabType = param.get("tabType");
        String recordId = param.get("id");
        Map paramBody = JsonUtil.toMap((String)JsonUtil.toJson((Object)body));
        switch (sysFormExtApi.getExtApiCode()) {
            case "tableQuery": {
                String viewId = param.get("viewId");
                return ResponseEntity.ok((Object)extFormService.tableQuery(appId, formId, viewId, paramBody));
            }
            case "tableQueryAll": {
                return ResponseEntity.ok((Object)extFormService.tableQueryAll(appId, formId));
            }
            case "tableSave": {
                return ResponseEntity.ok((Object)extFormService.tableSave(appId, formId, paramBody));
            }
            case "formQuery": {
                return ResponseEntity.ok((Object)extFormService.formQuery(appId, formId, recordId, tabType));
            }
            case "formSave": {
                return ResponseEntity.ok((Object)extFormService.formSave(appId, formId, paramBody));
            }
            case "deleteBatch": {
                String ids = param.get("ids");
                return ResponseEntity.ok((Object)extFormService.deleteBatch(appId, formId, ids));
            }
        }
        throw new BaseException("");
    }

    public ResponseEntity<ApiResponse<Object>> doFlowBeanInvoke(SysFormExtApi sysFormExtApi, Map<String, String> param, Object body) {
        ExtractFactory extractFactory = (ExtractFactory)SpringContextUtil.getBean(ExtractFactory.class);
        IExtFlowFormService extFlowFormService = (IExtFlowFormService)extractFactory.getExtractByCoordinate(ExtractCoordinate.build((String)sysFormExtApi.getExtApiBeanBus(), (String)sysFormExtApi.getExtApiBeanScene(), (String)sysFormExtApi.getExtApiBeanUseCase()));
        Long appId = Long.valueOf(param.get("appId"));
        Long formId = Long.valueOf(param.get("formId"));
        String tabType = param.get("tabType");
        String recordId = param.get("id");
        Map paramBody = JsonUtil.toMap((String)JsonUtil.toJson((Object)body));
        switch (sysFormExtApi.getExtApiCode()) {
            case "tableQuery": {
                String viewId = param.get("viewId");
                return ResponseEntity.ok((Object)extFlowFormService.tableQuery(appId, formId, viewId, paramBody));
            }
            case "tableQueryAll": {
                return ResponseEntity.ok((Object)extFlowFormService.tableQueryAll(appId, formId));
            }
            case "formQuery": {
                return ResponseEntity.ok((Object)extFlowFormService.formQuery(appId, formId, recordId, tabType));
            }
            case "deleteBatch": {
                String ids = param.get("ids");
                return ResponseEntity.ok((Object)extFlowFormService.deleteBatch(appId, formId, ids));
            }
            case "flowFormSubmit": {
                return ResponseEntity.ok((Object)extFlowFormService.flowFormSubmit(appId, formId, paramBody));
            }
            case "initialNodeReject": {
                return ResponseEntity.ok((Object)extFlowFormService.initialNodeReject(appId, formId, paramBody));
            }
            case "prevNodeReject": {
                return ResponseEntity.ok((Object)extFlowFormService.prevNodeReject(appId, formId, paramBody));
            }
            case "anyNodeReject": {
                return ResponseEntity.ok((Object)extFlowFormService.anyNodeReject(appId, formId, paramBody));
            }
            case "endProcess": {
                String businessId = (String)paramBody.get("businessId");
                String userId = (String)paramBody.get("userId");
                String reason = (String)paramBody.get("reason");
                Object extendFields = paramBody.get("extendFieldsMap");
                Map extendFieldsMap = new HashMap();
                if (HussarUtils.isNotEmpty(extendFields)) {
                    extendFieldsMap = JsonUtil.toMap((String)JsonUtil.toJson(extendFields));
                }
                return ResponseEntity.ok((Object)extFlowFormService.endProcess(businessId, userId, reason, extendFieldsMap));
            }
            case "taskEntrust": {
                return ResponseEntity.ok((Object)extFlowFormService.taskEntrust(appId, formId, paramBody));
            }
            case "flowFreeJump": {
                return ResponseEntity.ok((Object)extFlowFormService.flowFreeJump(appId, formId, paramBody));
            }
            case "flowEditAssignee": {
                return ResponseEntity.ok((Object)extFlowFormService.flowEditAssignee(appId, formId, paramBody));
            }
            case "flowFormRecall": {
                return ResponseEntity.ok((Object)extFlowFormService.flowFormRecall(appId, formId, paramBody));
            }
        }
        throw new BaseException("");
    }

    public ResponseEntity<ApiResponse<Object>> doTransRequest(String httpMethod, String transUrl, Map<String, String> param, Object body, SysFormExtApi sysFormExtApi) {
        ApiResponse apiResponse = new ApiResponse();
        HttpResponse response = null;
        try {
            logger.info("------------\u6b63\u5728\u6267\u884chttp\u7c7b\u578b\u7684\u81ea\u5b9a\u4e49\u63a5\u53e3,\u63a5\u53e3\u7c7b\u578b\uff1a{}", (Object)sysFormExtApi.getExtApiCode());
            Header[] headers = new Header[]{};
            HashMap<String, Object> allBody = new HashMap<String, Object>();
            if (sysFormExtApi.getExtApiHttpType().equals(HTTP_TYPE_OUT)) {
                ArrayList<BasicHeader> headersList = new ArrayList<BasicHeader>();
                headersList.add(new BasicHeader("Content-Type", "application/json;charset=UTF-8"));
                headersList.add(new BasicHeader("authorization", this.noCodeHttpUtil.getToken(new ClientDto())));
                headersList.add(new BasicHeader("client-id", this.eaiClientSdkProperties.getClientId()));
                headersList.add(new BasicHeader("client-secret", this.eaiClientSdkProperties.getClientSecret()));
                headers = headersList.toArray(new Header[0]);
                if (HussarUtils.isNotEmpty((Object)sysFormExtApi.getExtApiHttpInfo())) {
                    String extApiHttpInfo = sysFormExtApi.getExtApiHttpInfo();
                    JSONObject apiInfoObj = JSON.parseObject((String)extApiHttpInfo);
                    ApiInfoSdkDto apiInfoSdkDto = (ApiInfoSdkDto)JSON.toJavaObject((JSON)apiInfoObj, ApiInfoSdkDto.class);
                    EaiApiSdkInvokeParams eaiApiSdkInvokeParams = new EaiApiSdkInvokeParams();
                    HashMap header = new HashMap();
                    HashMap query = new HashMap();
                    EaiApiParams inParams = apiInfoSdkDto.getInParams();
                    if (HussarUtils.isNotEmpty((Object)inParams)) {
                        List paramsBody = inParams.getBody();
                        for (EaiApiParamsItem eaiApiParamsItem : paramsBody) {
                            if (eaiApiParamsItem.getType() != 7) continue;
                            String name = eaiApiParamsItem.getMappingName();
                            allBody.put(name, body);
                        }
                    }
                    allBody.putAll(param);
                    logger.info("------------http\u7c7b\u578b\u7684\u81ea\u5b9a\u4e49\u878d\u5408\u96c6\u6210\u5e73\u53f0\u63a5\u53e3\uff0c\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(allBody));
                }
            }
            URL url = new URL(transUrl);
            String ipAddress = url.getHost();
            int port = url.getPort();
            if (port != 80) {
                ipAddress = ipAddress + ":" + port;
            }
            String path = url.getPath();
            response = "GET".equals(httpMethod) ? HttpUtil.request((String)"GET", (String)ipAddress, (String)path, param, (Header[])headers, (Object)(HussarUtils.isNotEmpty(allBody) ? allBody : body)) : HttpUtil.request((String)"POST", (String)ipAddress, (String)path, param, (Header[])headers, (Object)(HussarUtils.isNotEmpty(allBody) ? allBody : body));
        }
        catch (Exception e) {
            logger.error("\u8f6c\u53d1\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            apiResponse.setSuccess(false);
            apiResponse.setCode(10001);
            apiResponse.setMsg("\u63a5\u53e3\u65e0\u54cd\u5e94");
            return new ResponseEntity((Object)apiResponse, HttpStatus.OK);
        }
        if (response == null) {
            apiResponse.setSuccess(false);
            apiResponse.setCode(10001);
            apiResponse.setMsg("\u63a5\u53e3\u65e0\u54cd\u5e94");
            return new ResponseEntity((Object)apiResponse, HttpStatus.OK);
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            HttpEntity entity = response.getEntity();
            if (HussarUtils.isNotEmpty((Object)entity)) {
                try {
                    String responseBody = EntityUtils.toString((HttpEntity)entity);
                    apiResponse = (ApiResponse)JsonUtil.parse((String)responseBody, ApiResponse.class);
                }
                catch (Exception e) {
                    apiResponse.setSuccess(false);
                    apiResponse.setCode(10001);
                    apiResponse.setMsg("\u63a5\u53e3\u65e0\u54cd\u5e94");
                    return new ResponseEntity((Object)apiResponse, HttpStatus.OK);
                }
            }
        } else {
            apiResponse.setSuccess(false);
            apiResponse.setCode(10001);
            apiResponse.setMsg("\u63a5\u53e3\u65e0\u54cd\u5e94");
        }
        if (10000 != apiResponse.getCode()) {
            String errMsg = "";
            errMsg = HussarUtils.isNotEmpty((Object)apiResponse.getMsg()) ? apiResponse.getMsg() : "\u64cd\u4f5c\u5931\u8d25";
            apiResponse.setCode(10001);
            apiResponse.setMsg(errMsg);
        }
        return new ResponseEntity((Object)apiResponse, HttpStatus.OK);
    }

    public ResponseEntity<ApiResponse<Object>> transRequestDoPost(String transUrl, Map<String, String> param, Object body) {
        return null;
    }

    public ResponseEntity<ApiResponse<Object>> transRequestDoGet(String transUrl, Map<String, String> param, Object body) {
        return null;
    }

    public ApiResponse<List<SysFormExtApi>> formExtApiList(Long formId) {
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        if (HussarUtils.isEmpty((Object)sysForm)) {
            throw new BaseException("\u8868\u5355\u4e0d\u5b58\u5728\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysFormExtApi::getFormId, (Object)formId)).eq(SysFormExtApi::getFormType, (Object)sysForm.getFormType());
        return ApiResponse.success((Object)this.list((Wrapper)queryWrapper));
    }

    public List<SysFormExtApi> formExtApiAllList(Long formId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFormExtApi::getFormId, (Object)formId);
        return this.list((Wrapper)queryWrapper);
    }

    public List<SysFormExtApi> appExtApiAllList(Long appId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFormExtApi::getAppId, (Object)appId);
        return this.list((Wrapper)queryWrapper);
    }

    public ApiResponse<Object> saveOrEdit(SysFormExtApiDto sysFormExtApiDto) {
        if (HussarUtils.isEmpty((Object)sysFormExtApiDto.getFormId())) {
            throw new BaseException("\u8868\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (HussarUtils.isBlank((CharSequence)sysFormExtApiDto.getExtApiCode())) {
            throw new BaseException("\u8bf7\u5148\u9009\u62e9\u63a5\u53e3\uff01");
        }
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)sysFormExtApiDto.getFormId());
        if (HussarUtils.isEmpty((Object)sysForm)) {
            throw new BaseException("\u8868\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (HussarUtils.isEmpty((Object)sysFormExtApiDto.getAppId())) {
            sysFormExtApiDto.setAppId(sysForm.getAppId());
        }
        sysFormExtApiDto.setFormType(sysForm.getFormType());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysFormExtApi::getFormId, (Object)sysFormExtApiDto.getFormId())).eq(SysFormExtApi::getExtApiCode, (Object)sysFormExtApiDto.getExtApiCode())).eq(SysFormExtApi::getFormType, (Object)sysFormExtApiDto.getFormType());
        List list = this.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)list) && !HussarUtils.equals((Object)((SysFormExtApi)list.get(0)).getApiId(), (Object)sysFormExtApiDto.getApiId())) {
            throw new BaseException("\u63a5\u53e3\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u914d\u7f6e\uff01");
        }
        String cacheKey = String.format("%s:%s", FORM_EXT, sysForm.getId());
        HussarCacheUtil.evict((String)TABLE_QUERY_CACHE, (Object)cacheKey);
        return ApiResponse.success((Object)this.saveOrUpdate((BaseEntity)sysFormExtApiDto));
    }

    public ApiResponse<Object> deleteFormExtApi(SysFormExtApiDto sysFormExtApiDto) {
        String cacheKey = String.format("%s:%s", FORM_EXT, sysFormExtApiDto.getFormId());
        HussarCacheUtil.evict((String)TABLE_QUERY_CACHE, (Object)cacheKey);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(HussarUtils.isNotEmpty((Object)sysFormExtApiDto.getApiId()), SysFormExtApi::getApiId, (Object)sysFormExtApiDto.getApiId())).eq(SysFormExtApi::getFormId, (Object)sysFormExtApiDto.getFormId())).eq(SysFormExtApi::getExtApiCode, (Object)sysFormExtApiDto.getExtApiCode());
        return ApiResponse.success((Object)this.remove((Wrapper)queryWrapper));
    }

    public ApiResponse<Object> switchFormExtApiStatus(SysFormExtApiDto sysFormExtApiDto) {
        String cacheKey = String.format("%s:%s", FORM_EXT, sysFormExtApiDto.getFormId());
        HussarCacheUtil.evict((String)TABLE_QUERY_CACHE, (Object)cacheKey);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(SysFormExtApi::getStatus, (Object)sysFormExtApiDto.getStatus())).eq(SysFormExtApi::getFormId, (Object)sysFormExtApiDto.getFormId())).eq(SysFormExtApi::getExtApiCode, (Object)sysFormExtApiDto.getExtApiCode());
        return ApiResponse.success((Object)this.update((Wrapper)updateWrapper));
    }

    public ApiResponse<SysFormExtApiVo> formExtApiRequestExample(Long formId, String extApiCode, String formType) {
        LambdaQueryWrapper sysExtApiDictLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)sysExtApiDictLambdaQueryWrapper.eq(SysExtApiDict::getExtApiCode, (Object)extApiCode)).eq(SysExtApiDict::getFormType, (Object)formType);
        SysExtApiDict sysExtApiDict = (SysExtApiDict)this.sysExtApiDictMapper.selectOne((Wrapper)sysExtApiDictLambdaQueryWrapper);
        if (HussarUtils.isEmpty((Object)sysExtApiDict)) {
            logger.info("\u975e\u6807\u51c6\u5916\u90e8\u63a5\u53e3{}", (Object)extApiCode);
            throw new BaseException("[" + extApiCode + "]\u975e\u6807\u51c6\u5916\u90e8\u63a5\u53e3");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysFormExtApi::getFormId, (Object)formId)).eq(SysFormExtApi::getExtApiCode, (Object)extApiCode);
        List formExtApis = this.list((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)formExtApis)) {
            logger.info("\u8868\u5355[{}]\u672a\u914d\u7f6e[{}]\u5916\u90e8\u63a5\u53e3", (Object)formId, (Object)extApiCode);
            throw new BaseException("\u8be5\u8868\u5355\u672a\u914d\u7f6e" + extApiCode + "\u5916\u90e8\u63a5\u53e3");
        }
        List sysFormExtApiExampleParamHttpIn = (List)JSON.parseObject((String)sysExtApiDict.getExampleParamsHttpIn(), (TypeReference)new TypeReference<List<SysFormExtApiExampleParamIn>>(){}, (Feature[])new Feature[0]);
        List sysFormExtApiExampleParamMethodIn = (List)JSON.parseObject((String)sysExtApiDict.getExampleParamsMethodIn(), (TypeReference)new TypeReference<List<SysFormExtApiExampleParamIn>>(){}, (Feature[])new Feature[0]);
        SysFormExtApiVo sysFormExtApiVo = (SysFormExtApiVo)HussarUtils.copyProperties(formExtApis.get(0), SysFormExtApiVo.class);
        sysFormExtApiVo.setExampleParamHttpIn(sysFormExtApiExampleParamHttpIn);
        sysFormExtApiVo.setExampleParamMethodIn(sysFormExtApiExampleParamMethodIn);
        sysFormExtApiVo.setExampleParamsOut(sysExtApiDict.getExampleParamsOut());
        return ApiResponse.success((Object)sysFormExtApiVo);
    }

    public ApiResponse<List<Map<String, Object>>> beanList(Long appId, Long formId) {
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        String formType = sysForm.getFormType();
        ArrayList beanList = new ArrayList();
        ExtractFactory extractFactory = (ExtractFactory)SpringContextUtil.getBean(ExtractFactory.class);
        if (HussarUtils.isNull((Object)extractFactory)) {
            return ApiResponse.success(beanList);
        }
        ArrayList classNames = new ArrayList();
        if (HTTP_TYPE_OUT.equals(formType)) {
            extractFactory.getExtractByInterClass(IExtFlowFormService.class).stream().map(service -> service.getClass().getName()).forEach(classNames::add);
        } else {
            extractFactory.getExtractByInterClass(IExtFormService.class).stream().map(service -> service.getClass().getName()).forEach(classNames::add);
        }
        Map extractCoordinates = extractFactory.getExtractCoordinates();
        for (Set extractCoordinateSet : extractCoordinates.values()) {
            for (ExtractCoordinate extractCoordinate : extractCoordinateSet) {
                HashMap<String, String> map = new HashMap<String, String>();
                String className = extractCoordinate.getExtractClass().getName();
                if (!classNames.contains(className)) continue;
                int lastIndex = className.lastIndexOf(46);
                if (lastIndex != -1) {
                    String lastPart = className.substring(lastIndex + 1);
                    String cleanClassName = this.cleanClassName(lastPart);
                    map.put("beanName", cleanClassName);
                } else {
                    String cleanClassName = this.cleanClassName(className);
                    map.put("beanName", cleanClassName);
                }
                map.put("beanBus", extractCoordinate.getBus());
                map.put("beanScene", extractCoordinate.getScene());
                map.put("beanUseCase", extractCoordinate.getUseCase());
                beanList.add(map);
            }
        }
        return ApiResponse.success(beanList);
    }

    public Boolean deleteByAppId(Long appId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysFormExtApi::getAppId, (Object)appId);
        return this.remove((Wrapper)lambdaQueryWrapper);
    }

    private String cleanClassName(String className) {
        String pattern = "\\$\\$EnhancerBySpringCGLIB\\$\\$[0-9a-fA-F]+";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(className);
        return m.replaceAll("");
    }
}

