/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleUserRights;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleStruRightBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleUserRightBoService;
import com.jxdinfo.hussar.formdesign.application.authority.dto.AuthorityDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.OrganDataAuthorityDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.RoleFormAuthorityDto;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppRoleAuthorityService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.authority.service.impl.SysAppRoleAuthorityServiceImpl")
public class SysAppRoleAuthorityServiceImpl
implements ISysAppRoleAuthorityService {
    @Resource
    private ISysFunctionsBoService sysFunctionsBoService;
    @Resource
    private IHussarBaseResourceService hussarBaseResourceService;
    @Resource
    private ISysRoleResourceBoService sysRoleResourceBoService;
    @Resource
    private ISysRoleFunctionsBoService sysRoleFunctionsBoService;
    @Resource
    private ISysRoleDataRightBoService sysRoleDataRightBoService;
    @Resource
    private ISysRoleStruRightBoService sysRoleStruRightBoService;
    @Resource
    private ISysRoleUserRightBoService sysRoleUserRightBoService;

    public void saveRoleAuthorityData(List<RoleFormAuthorityDto> roleFormAuthorityDtoList) {
        List formIds = roleFormAuthorityDtoList.stream().map(AuthorityDto::getFormId).collect(Collectors.toList());
        List roleIds = roleFormAuthorityDtoList.stream().map(AuthorityDto::getRoleId).collect(Collectors.toList());
        List resourcesList = this.hussarBaseResourceService.list(formIds, null);
        List functionsList = this.sysFunctionsBoService.list(formIds, null, null);
        Map<Long, List<SysResources>> resMap = resourcesList.stream().collect(Collectors.groupingBy(SysResources::getModuleId));
        Map<Long, List<SysFunctions>> funcMap = functionsList.stream().collect(Collectors.groupingBy(SysFunctions::getFunctionModuleId));
        ArrayList roleResourceList = new ArrayList();
        ArrayList roleFunctionsList = new ArrayList();
        roleFormAuthorityDtoList.forEach(item -> {
            final Long roleId = item.getRoleId();
            Long formId = item.getFormId();
            boolean isAuthorized = item.isAuthorized();
            if (isAuthorized) {
                List resList = (List)resMap.get(formId);
                List funcList = (List)funcMap.get(formId);
                Optional<SysResources> resourcesOptional = resList.stream().filter(res -> HussarUtils.equals((Object)"res_menu", (Object)res.getResTypeId())).findFirst();
                Optional<SysFunctions> functionsOptional = funcList.stream().filter(fun -> fun.getFunctionCode().contains("menu_")).findFirst();
                if (resourcesOptional.isPresent() && functionsOptional.isPresent()) {
                    final SysResources sysResources = resourcesOptional.get();
                    final SysFunctions sysFunctions = functionsOptional.get();
                    roleFunctionsList.add(new SysRoleFunctions(){
                        {
                            this.setFunctionId(sysFunctions.getId());
                            this.setRoleId(roleId);
                        }
                    });
                    roleResourceList.add(new SysRoleResource(){
                        {
                            this.setResourceId(sysResources.getId());
                            this.setRelationSource("1");
                            this.setRoleId(roleId);
                        }
                    });
                }
                List<SysResources> rightsResourcesList = resList.stream().filter(res -> HussarUtils.equals((Object)"res_form_rights", (Object)res.getResTypeId())).collect(Collectors.toList());
                rightsResourcesList.forEach(opt -> roleResourceList.add(new SysRoleResource((SysResources)opt, roleId){
                    final /* synthetic */ SysResources val$opt;
                    final /* synthetic */ Long val$roleId;
                    {
                        this.val$opt = sysResources;
                        this.val$roleId = l;
                        this.setResourceId(this.val$opt.getId());
                        this.setRelationSource("1");
                        this.setRoleId(this.val$roleId);
                    }
                }));
                List buttonDtoList = item.getButtonAuthoritiesDto().getButtonDtoList();
                if (HussarUtils.isNotEmpty((Object)buttonDtoList)) {
                    buttonDtoList.forEach(but -> {
                        Optional<SysResources> butresourcesOptional = resList.stream().filter(res -> HussarUtils.equals((Object)but.getButtonCode(), (Object)res.getPermissions())).findFirst();
                        Optional<SysFunctions> butFunctionsOptional = funcList.stream().filter(res -> res.getFunctionCode().contains(but.getButtonCode())).findFirst();
                        if (butresourcesOptional.isPresent() && butFunctionsOptional.isPresent()) {
                            final SysResources sysResources = butresourcesOptional.get();
                            final SysFunctions sysFunctions = butFunctionsOptional.get();
                            roleFunctionsList.add(new SysRoleFunctions(){
                                {
                                    this.setFunctionId(sysFunctions.getId());
                                    this.setRoleId(roleId);
                                }
                            });
                            roleResourceList.add(new SysRoleResource(){
                                {
                                    this.setResourceId(sysResources.getId());
                                    this.setRelationSource("1");
                                    this.setRoleId(roleId);
                                }
                            });
                        }
                    });
                }
            }
        });
        if (HussarUtils.isNotEmpty(roleIds) && HussarUtils.isNotEmpty((Object)resourcesList) && HussarUtils.isNotEmpty((Object)functionsList)) {
            List resIds = resourcesList.stream().map(SysResources::getId).collect(Collectors.toList());
            List funIds = functionsList.stream().map(SysFunctions::getId).collect(Collectors.toList());
            this.sysRoleFunctionsBoService.remove(roleIds, funIds);
            this.sysRoleResourceBoService.remove(roleIds, resIds);
        }
        this.sysRoleResourceBoService.saveBatch(roleResourceList);
        this.sysRoleFunctionsBoService.saveBatch(roleFunctionsList);
    }

    public void saveRoleRightsData(List<OrganDataAuthorityDto> list) {
        List functionsList;
        List funIds;
        if (HussarUtils.isEmpty(list)) {
            return;
        }
        ArrayList<SysRoleDataRight> roleDataRightList = new ArrayList<SysRoleDataRight>();
        ArrayList<6> roleStruRightsList = new ArrayList<6>();
        ArrayList<SysRoleUserRights> roleUserRightsList = new ArrayList<SysRoleUserRights>();
        List formIds = list.stream().map(OrganDataAuthorityDto::getFormId).collect(Collectors.toList());
        List roleIds = list.stream().map(OrganDataAuthorityDto::getRoleId).collect(Collectors.toList());
        List roleRightIds = this.sysRoleDataRightBoService.list(roleIds, funIds = (functionsList = this.sysFunctionsBoService.list(formIds, null, "menu_")).stream().map(SysFunctions::getId).collect(Collectors.toList())).stream().map(SysRoleDataRight::getDataRightsId).collect(Collectors.toList());
        if (roleRightIds.size() != 0) {
            this.sysRoleDataRightBoService.removeByIds(roleRightIds);
            this.sysRoleStruRightBoService.remove(roleRightIds);
            this.sysRoleUserRightBoService.removeByDataRightIds(roleRightIds);
        }
        for (final OrganDataAuthorityDto item : list) {
            SysRoleDataRight sysRoleDataRight = new SysRoleDataRight();
            final Long dataRightId = IdWorker.getId((Object)sysRoleDataRight);
            sysRoleDataRight.setDataRightsId(dataRightId);
            sysRoleDataRight.setResTypeCode("res_form_rights");
            sysRoleDataRight.setRoleId(item.getRoleId());
            Optional<SysFunctions> functionsOptional = functionsList.stream().filter(fun -> HussarUtils.equals((Object)item.getFormId(), (Object)fun.getFunctionModuleId())).findFirst();
            if (!functionsOptional.isPresent()) continue;
            sysRoleDataRight.setFunctionId(functionsOptional.get().getId());
            if (HussarUtils.equals((Object)"0", (Object)item.getOnlyIndividuals()) && HussarUtils.equals((Object)"0", (Object)item.getSupOrgan()) && HussarUtils.equals((Object)"0", (Object)item.getSubOrgan()) && HussarUtils.equals((Object)"0", (Object)item.getAllOrgan()) && HussarUtils.isEmpty((Object)item.getUserIds()) && HussarUtils.isEmpty((Object)item.getOrganIds())) continue;
            if (HussarUtils.equals((Object)"1", (Object)item.getOnlyIndividuals())) {
                sysRoleDataRight.setDataScope(Integer.valueOf(4));
                sysRoleDataRight.setDataScopeLabel("4");
            } else if (HussarUtils.equals((Object)"1", (Object)item.getSupOrgan())) {
                sysRoleDataRight.setDataScope(Integer.valueOf(3));
                sysRoleDataRight.setDataScopeLabel("3");
            } else if (HussarUtils.equals((Object)"1", (Object)item.getSubOrgan())) {
                sysRoleDataRight.setDataScope(Integer.valueOf(2));
                sysRoleDataRight.setDataScopeLabel("2");
            } else if (HussarUtils.equals((Object)"1", (Object)item.getAllOrgan())) {
                sysRoleDataRight.setDataScope(Integer.valueOf(1));
                sysRoleDataRight.setDataScopeLabel("1");
            } else {
                sysRoleDataRight.setDataScope(Integer.valueOf(5));
                if (HussarUtils.isNotEmpty((Object)item.getUserIds())) {
                    for (Long userId : item.getUserIds()) {
                        SysRoleUserRights roleUserRights = new SysRoleUserRights();
                        roleUserRights.setRoleId(item.getRoleId());
                        roleUserRights.setUserId(userId);
                        roleUserRights.setRoleDataRightsId(dataRightId);
                        roleUserRightsList.add(roleUserRights);
                    }
                }
                if (HussarUtils.isNotEmpty((Object)item.getOrganIds())) {
                    for (final Long organId : item.getOrganIds()) {
                        roleStruRightsList.add(new SysRoleStruRights(){
                            {
                                this.setRoleId(item.getRoleId());
                                this.setStruid(organId);
                                this.setRoleDataRightsId(dataRightId);
                            }
                        });
                    }
                }
            }
            roleDataRightList.add(sysRoleDataRight);
        }
        this.sysRoleDataRightBoService.saveBatch(roleDataRightList);
        this.sysRoleStruRightBoService.saveBatch(roleStruRightsList);
        this.sysRoleUserRightBoService.saveBatch(roleUserRightsList);
    }
}

