/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.jxdinfo.hussar.authorization.permit.dto.AppRoleMemberDto;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.AppRoleRelateVo;
import com.jxdinfo.hussar.formdesign.application.authority.dto.AuthorityDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.RoleFormAuthorityAndMemberDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.RoleFormAuthorityDto;
import com.jxdinfo.hussar.formdesign.application.authority.service.AuthoritySaveService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppRoleAuthorityService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysUpAppVisitRoleFieldService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.formdesign.application.authority.service.impl.authoritySaveServiceImpl")
public class AuthoritySaveServiceImpl
implements AuthoritySaveService {
    @Autowired
    private ISysAppVisitRoleButtonService roleButtonService;
    @Autowired
    private ISysUpAppVisitRoleFieldService sysUpAppVisitRoleFieldService;
    @Autowired
    private ISysAppVisitRoleOrganDataAuthorityService roleOrganDataAuthorityService;
    @Autowired
    private ISysAppVisitDataLogicService dataLogicService;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService;
    @Resource
    private ISysRolesExternalService sysRolesExternalService;
    @Resource
    private ISysAppRoleAuthorityService sysAppRoleAuthorityService;

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> saveFormAuthority(List<RoleFormAuthorityAndMemberDto> roleFormAuthorityDtoList) {
        List appRoleMemberList = roleFormAuthorityDtoList.stream().filter(authDto -> authDto.getMemberList() != null).map(authDto -> {
            AppRoleMemberDto appRoleMemberDto = new AppRoleMemberDto();
            appRoleMemberDto.setRoleId(authDto.getRoleId());
            List struIds = authDto.getMemberList().stream().filter(e -> "1".equals(e.getRelateType())).map(AppRoleRelateVo::getId).collect(Collectors.toList());
            appRoleMemberDto.setStruIds(struIds);
            List userIds = authDto.getMemberList().stream().filter(e -> "2".equals(e.getRelateType())).map(AppRoleRelateVo::getId).collect(Collectors.toList());
            appRoleMemberDto.setUserIds(userIds);
            return appRoleMemberDto;
        }).collect(Collectors.toList());
        this.sysRolesExternalService.saveAppRoleInfo(appRoleMemberList);
        return this.authoritySaveBath(roleFormAuthorityDtoList.stream().collect(Collectors.toList()), true);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> authoritySaveBath(List<RoleFormAuthorityDto> roleFormAuthorityDtoList, boolean isForm) {
        if (HussarUtils.isEmpty(roleFormAuthorityDtoList)) {
            return ApiResponse.success((Object)Boolean.TRUE);
        }
        List formRoleFieldAuthoritiesDtoList = roleFormAuthorityDtoList.stream().map(AuthorityDto::getFormRoleFieldAuthoritiesDto).collect(Collectors.toList());
        List organDataAuthorityDtoList = roleFormAuthorityDtoList.stream().map(AuthorityDto::getOrganDataAuthorityDto).collect(Collectors.toList());
        List dataLogicAuthorityDtoList = roleFormAuthorityDtoList.stream().map(AuthorityDto::getDataLogicAuthorityDto).collect(Collectors.toList());
        this.sysAppRoleAuthorityService.saveRoleAuthorityData(roleFormAuthorityDtoList);
        this.sysUpAppVisitRoleFieldService.saveBatchFieldAuthority(formRoleFieldAuthoritiesDtoList, isForm);
        this.sysAppRoleAuthorityService.saveRoleRightsData(organDataAuthorityDtoList);
        this.dataLogicService.saveBatchDataLogicAuthority(dataLogicAuthorityDtoList);
        return ApiResponse.success((Object)Boolean.TRUE);
    }
}

