/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.message.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.message.dao.SysMsgPushConfigMapper;
import com.jxdinfo.hussar.formdesign.application.message.dto.SysMsgPushConfigDto;
import com.jxdinfo.hussar.formdesign.application.message.dto.SysMsgPushConfigQueryDto;
import com.jxdinfo.hussar.formdesign.application.message.enums.ReminderType;
import com.jxdinfo.hussar.formdesign.application.message.model.SysMsgPushConfig;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushConfigService;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushTaskService;
import com.jxdinfo.hussar.formdesign.application.message.vo.SysMsgPushConfigVo;
import com.jxdinfo.hussar.msg.push.dto.AppSceneVo;
import com.jxdinfo.hussar.msg.push.dto.AppServiceDto;
import com.jxdinfo.hussar.msg.push.service.PushMsgService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.message.service.impl.sysMsgPushConfigServiceImpl")
public class SysMsgPushConfigServiceImpl
extends HussarServiceImpl<SysMsgPushConfigMapper, SysMsgPushConfig>
implements SysMsgPushConfigService {
    private static final Logger logger = LoggerFactory.getLogger(SysMsgPushConfigServiceImpl.class);
    @Resource
    private SysMsgPushTaskService sysMsgPushTaskService;
    @Autowired(required=false)
    private PushMsgService pushMsgService;
    @Resource
    private SysMsgPushConfigMapper sysMsgPushConfigMapper;

    public ApiResponse<Void> saveConfig(SysMsgPushConfigDto sysMsgPushConfigDto) {
        this.save((BaseEntity)sysMsgPushConfigDto);
        String reminderType = sysMsgPushConfigDto.getReminderType();
        if (reminderType.equals(ReminderType.FORM_FIELD.getValue()) || reminderType.equals(ReminderType.CUSTOM_TIME.getValue())) {
            HussarNoCodeThreadUtil.executeUserTask(() -> this.sysMsgPushTaskService.asyncGenerateTaskBySaveConfig((SysMsgPushConfig)sysMsgPushConfigDto));
        }
        return ApiResponse.success();
    }

    public ApiResponse<List<SysMsgPushConfig>> getConfigList(String formId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMsgPushConfig::getFormId, (Object)formId)).orderByDesc(HussarBaseEntity::getCreateTime);
        List sysMsgPushConfigs = this.list((Wrapper)queryWrapper);
        for (SysMsgPushConfig sysMsgPushConfig : sysMsgPushConfigs) {
            if (!HussarUtils.isEmpty((Object)sysMsgPushConfig.getMessageTitle())) continue;
            sysMsgPushConfig.setMessageTitle(sysMsgPushConfig.getReminderContent());
        }
        return ApiResponse.success((Object)sysMsgPushConfigs);
    }

    public List<SysMsgPushConfig> listByFormIdAndTriggerType(Long formId, String reminderType) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMsgPushConfig::getFormId, (Object)formId)).eq(SysMsgPushConfig::getReminderType, (Object)reminderType)).eq(SysMsgPushConfig::getStatus, (Object)"1");
        return this.list((Wrapper)queryWrapper);
    }

    public List<SysMsgPushConfig> listByAppId(Long appId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMsgPushConfig::getAppId, (Object)appId);
        return this.list((Wrapper)queryWrapper);
    }

    public void removeFlowFields(String formId) {
        ApiResponse<List<SysMsgPushConfig>> configList = this.getConfigList(formId);
        List sysMsgPushConfigs = (List)configList.getData();
        if (HussarUtils.isEmpty((Object)sysMsgPushConfigs)) {
            return;
        }
        sysMsgPushConfigs.forEach(sysMsgPushConfig -> {
            String reminderCondition = sysMsgPushConfig.getReminderCondition();
            JSONObject reminderConditionJsonObject = JSONObject.parseObject((String)reminderCondition);
            JSONArray conds = reminderConditionJsonObject.getJSONArray("cond");
            JSONArray newConds = new JSONArray();
            for (int i = 0; i < conds.size(); ++i) {
                JSONObject condObject = conds.getJSONObject(i);
                String field = condObject.getString("field");
                if ("PROCESS_NODE".equals(field) || "PROCESS_STATE".equals(field) || "START_TIME".equals(field) || "FINISH_TIME".equals(field)) continue;
                newConds.add((Object)condObject);
            }
            reminderConditionJsonObject.put("cond", (Object)newConds);
            sysMsgPushConfig.setReminderCondition(reminderConditionJsonObject.toJSONString());
        });
        this.saveOrUpdateBatch(sysMsgPushConfigs);
    }

    public ApiResponse<Void> editConfig(SysMsgPushConfigDto sysMsgPushConfigDto) {
        String status = sysMsgPushConfigDto.getStatus();
        if (status.equals("1")) {
            SysMsgPushConfig sysMsgPushConfig = (SysMsgPushConfig)this.getById(sysMsgPushConfigDto.getId());
            String originReminderType = sysMsgPushConfig.getReminderType();
            String currentReminderType = sysMsgPushConfigDto.getReminderType();
            if (originReminderType.equals(ReminderType.FORM_FIELD.getValue()) || originReminderType.equals(ReminderType.CUSTOM_TIME.getValue())) {
                this.sysMsgPushTaskService.removeByConfigId(sysMsgPushConfig.getId());
            }
            if (currentReminderType.equals(ReminderType.FORM_FIELD.getValue()) || currentReminderType.equals(ReminderType.CUSTOM_TIME.getValue())) {
                HussarNoCodeThreadUtil.executeUserTask(() -> this.sysMsgPushTaskService.asyncGenerateTaskBySaveConfig((SysMsgPushConfig)sysMsgPushConfigDto));
            }
        }
        this.updateById((BaseEntity)sysMsgPushConfigDto);
        return ApiResponse.success();
    }

    public ApiResponse<Void> status(SysMsgPushConfigDto sysMsgPushConfigDto) {
        String status = sysMsgPushConfigDto.getStatus();
        SysMsgPushConfig sysMsgPushConfig = (SysMsgPushConfig)this.getById(sysMsgPushConfigDto.getId());
        String reminderType = sysMsgPushConfig.getReminderType();
        if (status.equals("0")) {
            if (reminderType.equals(ReminderType.FORM_FIELD.getValue()) || reminderType.equals(ReminderType.CUSTOM_TIME.getValue())) {
                this.sysMsgPushTaskService.removeByConfigId(sysMsgPushConfig.getId());
            }
        } else if (reminderType.equals(ReminderType.FORM_FIELD.getValue()) || reminderType.equals(ReminderType.CUSTOM_TIME.getValue())) {
            HussarNoCodeThreadUtil.executeUserTask(() -> this.sysMsgPushTaskService.asyncGenerateTaskBySaveConfig(sysMsgPushConfig));
        }
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysMsgPushConfig::getId, (Object)sysMsgPushConfigDto.getId())).set(SysMsgPushConfig::getStatus, (Object)sysMsgPushConfigDto.getStatus());
        this.update((Wrapper)updateWrapper);
        return ApiResponse.success();
    }

    public ApiResponse<Void> deleteConfig(Long id) {
        SysMsgPushConfig sysMsgPushConfig = (SysMsgPushConfig)this.getById(id);
        String reminderType = sysMsgPushConfig.getReminderType();
        if (reminderType.equals(ReminderType.FORM_FIELD.getValue()) || reminderType.equals(ReminderType.CUSTOM_TIME.getValue())) {
            this.sysMsgPushTaskService.removeByConfigId(id);
        }
        this.removeById(id);
        return ApiResponse.success();
    }

    public ApiResponse<?> deleteAllConfigByAppId(Long appId) {
        List<SysMsgPushConfig> sysMsgPushConfigList = this.sysMsgPushConfigMapper.listByAppId(appId);
        if (HussarUtils.isEmpty(sysMsgPushConfigList)) {
            return ApiResponse.fail((String)("\u672a\u627e\u5230\u4e0e\u7ed9\u5b9aappId{" + appId + "}\u76f8\u5173\u7684\u914d\u7f6e"));
        }
        ArrayList<Long> deleteIdList = new ArrayList<Long>();
        for (SysMsgPushConfig sysMsgPushConfig : sysMsgPushConfigList) {
            String reminderType = sysMsgPushConfig.getReminderType();
            if (!reminderType.equals(ReminderType.FORM_FIELD.getValue()) && !reminderType.equals(ReminderType.CUSTOM_TIME.getValue())) continue;
            deleteIdList.add(sysMsgPushConfig.getId());
        }
        if (HussarUtils.isNotEmpty(deleteIdList)) {
            this.removeByIds(deleteIdList);
        }
        return ApiResponse.success((Object)this.sysMsgPushConfigMapper.deleteAllConfigByAppId(appId));
    }

    public ApiResponse<Void> copy(Long id) {
        SysMsgPushConfigDto sysMsgPushConfigDto = new SysMsgPushConfigDto();
        SysMsgPushConfig sysMsgPushConfig = (SysMsgPushConfig)this.getById(id);
        BeanUtils.copyProperties((Object)sysMsgPushConfig, (Object)sysMsgPushConfigDto);
        sysMsgPushConfigDto.setId(Long.valueOf(IdWorker.getId((Object)sysMsgPushConfig)));
        SecurityUser loginUser = BaseSecurityUtil.getUser();
        sysMsgPushConfigDto.setCreator(loginUser.getId());
        sysMsgPushConfigDto.setCreateTime(null);
        sysMsgPushConfigDto.setLastEditor(loginUser.getId());
        sysMsgPushConfigDto.setLastTime(null);
        this.saveConfig(sysMsgPushConfigDto);
        return ApiResponse.success();
    }

    public ApiResponse<List<AppSceneVo>> getReminderModes() {
        AppServiceDto appServiceDto = new AppServiceDto();
        appServiceDto.setAppId("formMsgPush");
        appServiceDto.setAppSecret("296416d4aff41d2ead60e4d790e72318");
        appServiceDto.setSceneCategory("formMsgPush");
        List appService = new ArrayList();
        try {
            appService = this.pushMsgService.getAppService(appServiceDto);
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u63a8\u9001=>\u83b7\u53d6\u63d0\u9192\u65b9\u5f0f\u65f6\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return ApiResponse.success(appService);
    }

    public ApiResponse<List<SysMsgPushConfigVo>> listByFormName(String formName) {
        return ApiResponse.success(((SysMsgPushConfigMapper)this.baseMapper).listByFormName(formName));
    }

    public ApiResponse<Page<SysMsgPushConfigVo>> pageByCondition(SysMsgPushConfigQueryDto queryDto) {
        Page page = HussarPageUtils.convert((PageInfo)queryDto);
        List<SysMsgPushConfigVo> records = ((SysMsgPushConfigMapper)this.baseMapper).pageByCondition((Page<SysMsgPushConfigVo>)page, queryDto.getFormName());
        page.setRecords(records);
        return ApiResponse.success((Object)page);
    }
}

