/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormCheckConfigMapper;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormCheckConfigDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormCheckConfig;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormCheckConfigVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.SysFormCheckConfigServiceImpl")
public class SysFormCheckConfigServiceImpl
extends HussarServiceImpl<SysFormCheckConfigMapper, SysFormCheckConfig>
implements ISysFormCheckConfigService {
    @Resource
    private SysFormCheckConfigMapper sysFormCheckConfigMapper;
    @Resource
    private ISysFormService sysFormService;

    @HussarTransactional
    public void deleteFormCheckConfig(Long formId) {
        AssertUtil.isNotNull((Object)formId, (String)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFormCheckConfig::getFormId, (Object)formId);
        this.remove((Wrapper)queryWrapper);
    }

    public ApiResponse<SysFormCheckConfigVo> getFormCheckConfig(Long formId) {
        AssertUtil.isNotNull((Object)formId, (String)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFormCheckConfig::getFormId, (Object)formId);
        SysFormCheckConfig sysFormCheckConfig = (SysFormCheckConfig)this.getOne((Wrapper)queryWrapper, false);
        if (HussarUtils.isNull((Object)sysFormCheckConfig)) {
            return ApiResponse.success((String)"\u8868\u5355\u63d0\u4ea4\u6821\u9a8c\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        return ApiResponse.success((Object)BeanUtil.copyProperties((Object)sysFormCheckConfig, SysFormCheckConfigVo.class));
    }

    public ApiResponse<Boolean> saveFormCheckConfig(SysFormCheckConfigDto sysFormCheckConfigDto) {
        if (HussarUtils.isEmpty((Object)sysFormCheckConfigDto.getCheckConfigId()) && HussarUtils.isNotEmpty((Object)sysFormCheckConfigDto.getFormId())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysFormCheckConfig::getFormId, (Object)sysFormCheckConfigDto.getFormId());
            List sysFormCheckConfigs = this.list((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)sysFormCheckConfigs)) {
                sysFormCheckConfigDto.setCheckConfigId(((SysFormCheckConfig)sysFormCheckConfigs.get(0)).getCheckConfigId());
            }
        }
        AssertUtil.isTrue((boolean)this.saveOrUpdate((BaseEntity)sysFormCheckConfigDto), (String)"\u4fdd\u5b58\u5931\u8d25");
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    public List<SysFormCheckConfig> getFormCheckConfigList(List<Long> formIds) {
        ArrayList<SysFormCheckConfig> formCheckConfigs = new ArrayList<SysFormCheckConfig>();
        if (HussarUtils.isNotEmpty(formIds)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysFormCheckConfig::getFormId, formIds);
            return this.list((Wrapper)queryWrapper);
        }
        return formCheckConfigs;
    }

    @HussarTransactional
    public void copyFormCheckConfig(Long newFormId, Long oldFormId, Map<String, String> map) {
        SysFormCheckConfigVo sysFormCheckConfigVo = (SysFormCheckConfigVo)this.getFormCheckConfig(oldFormId).getData();
        if (HussarUtils.isNotEmpty((Object)sysFormCheckConfigVo)) {
            String checkConfig = sysFormCheckConfigVo.getCheckConfig();
            String json = JSON.parse((String)checkConfig).toString();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!json.contains(key)) continue;
                json = json.replace(key, value);
            }
            sysFormCheckConfigVo.setCheckConfigId(null);
            sysFormCheckConfigVo.setFormId(newFormId);
            this.save((BaseEntity)sysFormCheckConfigVo);
        }
    }

    public List<SysFormCheckConfig> getFlowFormCheckConfigList(String formId) {
        return this.sysFormCheckConfigMapper.getAllFlowFormCheckConfig(formId);
    }

    public Boolean deleteFormCheckConfigByAppId(Long appId, List<Long> allFormId) {
        if (HussarUtils.isNotEmpty(allFormId)) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(SysFormCheckConfig::getFormId, allFormId);
            return this.remove((Wrapper)lambdaQueryWrapper);
        }
        return false;
    }
}

