/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.data.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.NoCodeRuleTriggerType;
import com.jxdinfo.hussar.formdesign.app.frame.api.util.TriggerVerify;
import com.jxdinfo.hussar.formdesign.application.data.dao.PushDataMapper;
import com.jxdinfo.hussar.formdesign.application.data.dao.PushDataRecordMapper;
import com.jxdinfo.hussar.formdesign.application.data.dto.SysDataPushConfigDto;
import com.jxdinfo.hussar.formdesign.application.data.dto.TestUrlDto;
import com.jxdinfo.hussar.formdesign.application.data.enums.TriggerType;
import com.jxdinfo.hussar.formdesign.application.data.model.FieldMap;
import com.jxdinfo.hussar.formdesign.application.data.model.HttpDoPostResponse;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPushConfig;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPushRecord;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.storage.common.utils.HttpUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.data.service.impl.pushDataServiceImpl")
public class PushDataServiceImpl
extends HussarServiceImpl<PushDataMapper, SysDataPushConfig>
implements PushDataService {
    Logger log = LoggerFactory.getLogger(PushDataServiceImpl.class);
    private final PushDataRecordMapper pushDataRecordMapper;
    private final PushDataMapper mapper;
    private static final List<String> ALL_HANDLING = Arrays.asList("JXDNInput", "JXDNTextarea", "JXDNRadioGroup", "JXDNCheckBoxGroup", "JXDNSelect", "JXDNSelectMulti", "JXDNNumber", "JXDNDate", "JXDNAddress", "JXDNSwitch", "JXDNLinkForm", "JXDNUser", "JXDNUserMulti", "JXDNOrg", "JXDNOrgMulti", "JXDNAmountCapital", "JXDNAggregate", "JXDNSerialNumber", "JXDNChildrenTable", "JXDNChildrenTableAgg", "JXDNSecurityLevel", WidgetType.JXDNLinkFormMulti.getType());
    private static final List<String> WIDGET_HANDLING = Arrays.asList("JXDNRadioGroup", "JXDNCheckBoxGroup", "JXDNSelect", "JXDNSelectMulti", "JXDNAddress", "JXDNLinkForm", "JXDNUser", "JXDNUserMulti", "JXDNOrg", "JXDNOrgMulti", WidgetType.JXDNLinkFormMulti.getType());
    private static final List<String> NAME_HANDLING = Arrays.asList("createUser_user", "updateUser_user", "deleteUser_user");
    private static final List<String> TIME_HANDLING = Arrays.asList("createTime_date", "updateTime_date", "deleteTime_date");

    @Autowired
    public PushDataServiceImpl(PushDataRecordMapper pushDataRecordMapper, PushDataMapper mapper) {
        this.pushDataRecordMapper = pushDataRecordMapper;
        this.mapper = mapper;
    }

    public ApiResponse<Void> saveConfig(SysDataPushConfigDto sysDataPushConfigDto) {
        this.save((BaseEntity)sysDataPushConfigDto);
        return ApiResponse.success();
    }

    public ApiResponse<List<SysDataPushConfig>> getConfigList(String formId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPushConfig::getFormId, (Object)formId)).orderByDesc(HussarBaseEntity::getCreateTime);
        return ApiResponse.success((Object)this.list((Wrapper)queryWrapper));
    }

    public ApiResponse<Void> editConfig(SysDataPushConfigDto sysDataPushConfigDto) {
        this.updateById((BaseEntity)sysDataPushConfigDto);
        return ApiResponse.success();
    }

    public ApiResponse<Void> deleteConfig(Long id) {
        this.removeById(id);
        return ApiResponse.success();
    }

    public ApiResponse<Void> copy(Long id) {
        SysDataPushConfigDto sysDataPushConfigDto = new SysDataPushConfigDto();
        SysDataPushConfig sysDataPushConfig = (SysDataPushConfig)this.getById(id);
        BeanUtils.copyProperties((Object)sysDataPushConfig, (Object)sysDataPushConfigDto);
        sysDataPushConfigDto.setId(Long.valueOf(IdWorker.getId((Object)sysDataPushConfig)));
        sysDataPushConfigDto.setCreateTime(LocalDateTime.now());
        sysDataPushConfigDto.setLastTime(LocalDateTime.now());
        this.saveConfig(sysDataPushConfigDto);
        return ApiResponse.success();
    }

    public ApiResponse<Void> status(SysDataPushConfigDto sysDataPushConfigDto) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysDataPushConfig::getId, (Object)sysDataPushConfigDto.getId())).set(SysDataPushConfig::getStatus, (Object)sysDataPushConfigDto.getStatus());
        this.update((Wrapper)updateWrapper);
        return ApiResponse.success();
    }

    public ApiResponse<HttpDoPostResponse> connection(TestUrlDto testUrlDto) throws IOException {
        return ApiResponse.success((Object)this.httpDoPost(testUrlDto.getUrl(), null, null));
    }

    public List<SysDataPushConfig> listByFormIdAndTriggerType(Long formId, String reminderType) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPushConfig::getFormId, (Object)formId)).eq(SysDataPushConfig::getTriggerAction, (Object)reminderType)).eq(SysDataPushConfig::getStatus, (Object)"1");
        return this.list((Wrapper)queryWrapper);
    }

    public void asyncPushDataByDataChange(Long formId, JSONObject businessData, String changeType, SecurityUser user) throws IOException {
        businessData.put("formId", (Object)formId);
        String triggerAction = "";
        if (changeType.equals(NoCodeRuleTriggerType.TriggerTypeCreate.getType())) {
            triggerAction = TriggerType.INSERT_DATA.getValue();
        } else if (changeType.equals(NoCodeRuleTriggerType.TriggerTypeUpdate.getType())) {
            triggerAction = TriggerType.UPDATE_DATA.getValue();
        } else if (changeType.equals(NoCodeRuleTriggerType.TriggerTypeDelete.getType())) {
            triggerAction = TriggerType.DELETE_DATA.getValue();
        }
        List<SysDataPushConfig> configs = this.listByFormIdAndTriggerType(formId, triggerAction);
        for (SysDataPushConfig config : configs) {
            ApiResponse apiResponse;
            String msg;
            if (!this.checkWhetherMetTriggerCondition(config, businessData)) continue;
            JSONArray json = JSON.parseArray((String)config.getFieldMaps());
            List list = json.toJavaList(FieldMap.class);
            SysDataPushRecord sysDataPushRecord = new SysDataPushRecord();
            sysDataPushRecord.setFormId(formId);
            sysDataPushRecord.setPushId(config.getId());
            sysDataPushRecord.setPushName(config.getName());
            sysDataPushRecord.setUrl(config.getUrl());
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("op", changeType);
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date now = new Date();
            paramMap.put("op_datatime", sd.format(now));
            HashMap<String, Object> userMap = new HashMap<String, Object>();
            userMap.put("id", user.getId());
            userMap.put("name", user.getUserName());
            paramMap.put("op_user", userMap);
            try {
                paramMap.put("data", this.buildMapParam(list, businessData));
            }
            catch (Exception e) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("msg", "\u53c2\u6570\u9519\u8bef\uff01");
                map.put("error", e.getStackTrace());
                map.put("errorInfo", e.getMessage());
                sysDataPushRecord.setHttpStatus("500");
                sysDataPushRecord.setParam(JSON.toJSONString(map));
                sysDataPushRecord.setSuccess("0");
                this.pushDataRecordMapper.insert(sysDataPushRecord);
                throw new HussarException("\u6570\u636e\u63a8\u9001==>\u6784\u5efa\u53c2\u6570\u9519\u8bef", (Throwable)e);
            }
            sysDataPushRecord.setParam(JSON.toJSONString(paramMap));
            HttpDoPostResponse response = this.httpDoPost(config.getUrl(), paramMap);
            sysDataPushRecord.setHttpStatus(String.valueOf(response.getStatus()));
            if (response.getStatus() == 200 && HussarUtils.isNotEmpty((Object)(msg = response.getMsg())) && 10000 != (apiResponse = (ApiResponse)JSON.parseObject((String)msg, ApiResponse.class)).getCode()) {
                sysDataPushRecord.setHttpStatus(String.valueOf(500));
            }
            sysDataPushRecord.setSuccess(sysDataPushRecord.getHttpStatus().equals(String.valueOf(200)) ? "1" : "0");
            sysDataPushRecord.setResult(response.getMsg());
            this.pushDataRecordMapper.insert(sysDataPushRecord);
        }
    }

    private boolean checkWhetherMetTriggerCondition(SysDataPushConfig sysDataPushConfig, JSONObject businessData) {
        JSONObject triggerCondition;
        List conditions;
        if (HussarUtils.isNotEmpty((Object)sysDataPushConfig.getTriggerCondition()) && HussarUtils.isNotEmpty((Object)(conditions = JSON.parseArray((String)(triggerCondition = JSON.parseObject((String)sysDataPushConfig.getTriggerCondition())).getString("cond"), JSONObject.class)))) {
            try {
                return TriggerVerify.conditionVerify((JSONObject)businessData, (String)sysDataPushConfig.getTriggerCondition(), (String)String.valueOf(sysDataPushConfig.getFormId()), (String)"");
            }
            catch (Exception e) {
                throw new HussarException("\u6570\u636e\u63a8\u9001 => \u6821\u9a8c\u63a8\u9001\u6761\u4ef6\u5931\u8d25");
            }
        }
        return true;
    }

    private HttpDoPostResponse httpDoPost(String urlString, List<FieldMap> list, JSONObject paramData) throws IOException {
        HttpDoPostResponse result = new HttpDoPostResponse();
        Header[] headers = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
        HashMap<String, Object> paramMap = this.buildParam(list, paramData);
        URL url = new URL(urlString);
        String ipAddress = url.getHost();
        int port = url.getPort();
        if (port != 80) {
            ipAddress = ipAddress + ":" + port;
        }
        String path = url.getPath();
        result.setTestTime(new Date());
        try {
            HttpResponse response = HttpUtil.doPost((String)ipAddress, (String)path, (Header[])headers, paramMap, null);
            if (response == null) {
                result.setStatus(500);
                return result;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            result.setStatus(statusCode);
            if (statusCode == 200) {
                result.setResult("\u6210\u529f\uff01");
            } else {
                result.setResult("\u5931\u8d25\uff01");
            }
            HttpEntity entity = response.getEntity();
            String responseBody = EntityUtils.toString((HttpEntity)entity);
            result.setMsg(responseBody);
        }
        catch (Exception e) {
            result.setStatus(500);
            result.setResult("\u5931\u8d25\uff01");
            result.setMsg(e.getMessage());
        }
        return result;
    }

    private HttpDoPostResponse httpDoPost(String urlString, HashMap paramMap) throws IOException {
        HttpDoPostResponse result = new HttpDoPostResponse();
        Header[] headers = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
        URL url = new URL(urlString);
        String ipAddress = url.getHost();
        int port = url.getPort();
        if (port != 80) {
            ipAddress = ipAddress + ":" + port;
        }
        String path = url.getPath();
        result.setTestTime(new Date());
        try {
            HttpResponse response = HttpUtil.request((String)"POST", (String)ipAddress, (String)path, null, (Header[])headers, (Object)paramMap);
            this.log.info("\u6570\u636e\u63a8\u9001http\u8bf7\u6c42\u8fd4\u56de,ipAddress:{},path:{},headers:{},paramMap:{},response:{}", new Object[]{ipAddress, path, headers, paramMap, JsonUtil.toJson((Object)response)});
            if (response == null) {
                result.setStatus(500);
                result.setMsg("\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a");
                return result;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            result.setStatus(statusCode);
            if (statusCode == 200) {
                result.setResult("\u6210\u529f\uff01");
            } else {
                result.setResult("\u5931\u8d25\uff01");
            }
            HttpEntity entity = response.getEntity();
            String responseBody = EntityUtils.toString((HttpEntity)entity);
            result.setMsg(responseBody);
        }
        catch (Exception e) {
            this.log.error("http\u65b9\u6cd5\u8c03\u7528\u5931\u8d25", (Throwable)e);
            result.setStatus(500);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    private HashMap<String, Object> buildParam(List<FieldMap> list, JSONObject paramData) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (list == null || list.isEmpty()) {
            return paramMap;
        }
        for (FieldMap field : list) {
            String pushName = StringUtil.isNotBlank((CharSequence)field.getAliasName()) ? field.getAliasName() : field.getName();
            List cFieldMap = field.getChildren();
            if (!cFieldMap.isEmpty()) {
                HashMap<String, Object> cMap = this.buildParam(field.getChildren(), (JSONObject)JSON.toJSON((Object)paramData.get((Object)field.getName())));
                paramMap.put(pushName, cMap);
                continue;
            }
            paramMap.put(pushName, paramData.get((Object)field.getName()));
        }
        return paramMap;
    }

    private HashMap<String, Object> buildMapParam(List<FieldMap> list, JSONObject paramData) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (list == null || list.isEmpty()) {
            return paramMap;
        }
        for (FieldMap field : list) {
            String pushName;
            if (!ALL_HANDLING.contains(field.getWidgetType())) continue;
            String string = pushName = StringUtil.isNotBlank((CharSequence)field.getAliasName()) ? field.getAliasName() : field.getName();
            if ("JXDNChildrenTable".equals(field.getWidgetType()) || "JXDNChildrenTableAgg".equals(field.getWidgetType())) {
                ArrayList<HashMap<String, Object>> objectList = new ArrayList<HashMap<String, Object>>();
                List mList = field.getChildren();
                List dList = (List)paramData.get((Object)field.getName());
                if (dList == null || dList.size() == 0) continue;
                for (Map map : dList) {
                    JSONObject jsonObject = new JSONObject(map);
                    HashMap<String, Object> o = this.buildMapParam(mList, jsonObject);
                    objectList.add(o);
                }
                paramMap.put(pushName, objectList);
                continue;
            }
            paramMap.put(pushName, this.buildValue(field.getName(), field.getWidgetType(), paramData));
        }
        return paramMap;
    }

    private Object buildValue(String name, String widgetType, JSONObject data) {
        if (NAME_HANDLING.contains(name)) {
            if ("deleteUser_user".equals(name)) {
                name = "updateUser_user";
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", data.get((Object)name));
            map.put("label", data.get((Object)name.replace("_user", "Name")));
            return map;
        }
        if (TIME_HANDLING.contains(name)) {
            Object object;
            if ("deleteTime_date".equals(name)) {
                name = "updateTime_date";
            }
            if ((object = data.get((Object)name)) instanceof String) {
                return object;
            }
            if (object instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)object;
                if (localDateTime == null) {
                    return null;
                }
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                String time = localDateTime.format(formatter);
                return time;
            }
            return null;
        }
        if ("dataOrgan".equals(name)) {
            ArrayList list = new ArrayList();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", data.get((Object)name));
            map.put("label", data.get((Object)(name + "Name")));
            list.add(map);
            return list;
        }
        if (WIDGET_HANDLING.contains(widgetType)) {
            if ("JXDNRadioGroup".equals(widgetType) || "JXDNSelect".equals(widgetType)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("label", data.get((Object)(name + "_label")));
                map.put("value", data.get((Object)name));
                return map;
            }
            if ("JXDNCheckBoxGroup".equals(widgetType) || "JXDNSelectMulti".equals(widgetType)) {
                ArrayList list = new ArrayList();
                String sValue = (String)data.get((Object)name);
                String sLabel = (String)data.get((Object)(name + "_label"));
                if (StringUtil.isBlank((CharSequence)sValue) || StringUtil.isBlank((CharSequence)sLabel)) {
                    return list;
                }
                String[] value = sValue.split(",");
                JSONArray array = JSON.parseArray((String)sLabel);
                for (int i = 0; i < value.length; ++i) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("label", array.get(i));
                    map.put("value", value[i]);
                    list.add(map);
                }
                return list;
            }
            if ("JXDNAddress".equals(widgetType)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("code", data.get((Object)(name + "_code")));
                map.put("label", data.get((Object)(name + "_label")));
                map.put("detailed", data.get((Object)(name + "_detailed")));
                return map;
            }
            if (WidgetType.JXDNLinkForm.getType().equals(widgetType) || WidgetType.JXDNLinkFormMulti.getType().equals(widgetType)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("childId", data.get((Object)(name + "_ref_child_id")));
                map.put("id", data.get((Object)(name + "_ref_id")));
                map.put("value", data.get((Object)name));
                return map;
            }
            if ("JXDNOrgMulti".equals(widgetType) || "JXDNOrg".equals(widgetType)) {
                ArrayList list = new ArrayList();
                String sValue = (String)data.get((Object)(name + "_id"));
                String sLabel = (String)data.get((Object)(name + "_label"));
                if (StringUtil.isBlank((CharSequence)sValue) || StringUtil.isBlank((CharSequence)sLabel)) {
                    return list;
                }
                String[] value = sValue.split(",");
                String[] label = sLabel.split(",");
                for (int i = 0; i < value.length; ++i) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("label", label[i]);
                    map.put("id", value[i]);
                    list.add(map);
                }
                return list;
            }
            this.log.info("\u63a8\u9001\u6570\u636e\u7ec4\u4ef6\u7c7b\u578b{}\u548c\u53c2\u6570\u540d{}\uff0c\u6570\u636e{}", new Object[]{widgetType, name, data.toJSONString()});
            String sData = (String)data.get((Object)name);
            if (sData == null) {
                return null;
            }
            return JSONArray.parseArray((String)sData);
        }
        return data.get((Object)name);
    }

    public void test(HashMap map, int i) {
        this.mapper.saveTestData(JSON.toJSONString((Object)map), i);
    }

    public List<SysDataPushConfig> listByAppId(Long appId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPushConfig::getAppId, (Object)appId);
        return this.list((Wrapper)queryWrapper);
    }

    public void deleteByFormId(Long formId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPushConfig::getFormId, (Object)formId);
        this.remove((Wrapper)queryWrapper);
    }

    public void deleteByAppId(Long appId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPushConfig::getAppId, (Object)appId);
        this.remove((Wrapper)queryWrapper);
    }

    public void removeFlowFields(String formId) {
        ApiResponse<List<SysDataPushConfig>> configList = this.getConfigList(formId);
        List configListData = (List)configList.getData();
        if (HussarUtils.isEmpty((Object)configListData)) {
            return;
        }
        configListData.forEach(sysDataPushConfig -> {
            String fieldMaps = sysDataPushConfig.getFieldMaps();
            JSONArray fields = JSONArray.parseArray((String)fieldMaps);
            JSONArray newFields = new JSONArray();
            for (int i = 0; i < fields.size(); ++i) {
                JSONObject jsonObject = fields.getJSONObject(i);
                String field = jsonObject.getString("name");
                if ("PROCESS_NODE".equals(field) || "PROCESS_STATE".equals(field) || "START_TIME".equals(field) || "FINISH_TIME".equals(field)) continue;
                newFields.add((Object)jsonObject);
            }
            sysDataPushConfig.setFieldMaps(newFields.toJSONString());
            String triggerCondition = sysDataPushConfig.getTriggerCondition();
            JSONObject triggerConditionsonObject = JSONObject.parseObject((String)triggerCondition);
            JSONArray conds = triggerConditionsonObject.getJSONArray("cond");
            JSONArray newConds = new JSONArray();
            if (HussarUtils.isNotEmpty((Object)conds)) {
                for (int i = 0; i < conds.size(); ++i) {
                    JSONObject condObject = conds.getJSONObject(i);
                    String field = condObject.getString("field");
                    if ("PROCESS_NODE".equals(field) || "PROCESS_STATE".equals(field) || "START_TIME".equals(field) || "FINISH_TIME".equals(field)) continue;
                    newConds.add((Object)condObject);
                }
            }
            triggerConditionsonObject.put("cond", (Object)newConds);
            sysDataPushConfig.setTriggerCondition(triggerConditionsonObject.toJSONString());
        });
        this.saveOrUpdateBatch(configListData);
    }

    public List<SysDataPushConfig> listByCondition(SysDataPushConfigDto sysDataPushConfigDto) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysDataPushConfig::getStatus, (Object)"1");
        if (ToolUtil.isNotEmpty((Object)sysDataPushConfigDto.getAppId())) {
            lambdaQueryWrapper.eq(SysDataPushConfig::getAppId, (Object)sysDataPushConfigDto.getAppId());
        }
        if (ToolUtil.isNotEmpty((Object)sysDataPushConfigDto.getFormId())) {
            lambdaQueryWrapper.eq(SysDataPushConfig::getFormId, (Object)sysDataPushConfigDto.getFormId());
        }
        if (ToolUtil.isNotEmpty((Object)sysDataPushConfigDto.getStatus())) {
            lambdaQueryWrapper.eq(SysDataPushConfig::getStatus, (Object)sysDataPushConfigDto.getStatus());
        }
        if (ToolUtil.isNotEmpty((Object)sysDataPushConfigDto.getTriggerAction())) {
            lambdaQueryWrapper.eq(SysDataPushConfig::getTriggerAction, (Object)sysDataPushConfigDto.getTriggerAction());
        }
        return this.list((Wrapper)lambdaQueryWrapper);
    }

    public void asyncPushDataByActiveTrigger(Long formId, List<Long> dataPushConfigIdList, String triggerType, JSONObject businessData, SecurityUser user) {
        List dataPushConfigList = this.listByIds(dataPushConfigIdList);
        AssertUtil.isNotNull((Object)dataPushConfigList, (String)"\u6570\u636e\u63a8\u9001\u914d\u7f6e\u4e0d\u5b58\u5728");
        this.log.info("\u83b7\u53d6\u5230\u7684\u6570\u636e\u63a8\u9001\u914d\u7f6e\uff1a{}", (Object)JSONObject.toJSONString((Object)dataPushConfigList));
        businessData.put("formId", (Object)formId);
        for (SysDataPushConfig config : dataPushConfigList) {
            HashMap<String, Object> map;
            JSONArray json = JSON.parseArray((String)config.getFieldMaps());
            List list = json.toJavaList(FieldMap.class);
            SysDataPushRecord sysDataPushRecord = new SysDataPushRecord();
            sysDataPushRecord.setFormId(formId);
            sysDataPushRecord.setPushId(config.getId());
            sysDataPushRecord.setPushName(config.getName());
            sysDataPushRecord.setUrl(config.getUrl());
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("op", triggerType);
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date now = new Date();
            paramMap.put("op_datatime", sd.format(now));
            HashMap<String, Object> userMap = new HashMap<String, Object>();
            userMap.put("id", user.getId());
            userMap.put("name", user.getUserName());
            paramMap.put("op_user", userMap);
            try {
                paramMap.put("data", this.buildMapParam(list, businessData));
            }
            catch (Exception e) {
                this.log.error("\u6784\u5efa\u6570\u636e\u63a8\u9001\u53c2\u6570\u9519\u8bef", (Throwable)e);
                map = new HashMap<String, Object>();
                map.put("msg", "\u53c2\u6570\u9519\u8bef\uff01");
                map.put("error", e.getStackTrace());
                map.put("errorInfo", e.getMessage());
                sysDataPushRecord.setHttpStatus("500");
                sysDataPushRecord.setParam(JSON.toJSONString(map));
                sysDataPushRecord.setSuccess("0");
                this.log.info("\u4fdd\u5b58\u65e5\u5fd7\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)sysDataPushRecord));
                this.pushDataRecordMapper.insert(sysDataPushRecord);
                continue;
            }
            sysDataPushRecord.setParam(JSON.toJSONString(paramMap));
            HttpDoPostResponse response = null;
            try {
                this.log.info("\u5f00\u59cb\u8c03\u7528http\u8bf7\u6c42\u8fdb\u884c\u6570\u636e\u63a8\u9001\uff0curl:{},paramMap:{}", (Object)config.getUrl(), (Object)JSONObject.toJSONString(paramMap));
                response = this.httpDoPost(config.getUrl(), paramMap);
                this.log.info("http\u8fd4\u56de\u7684\u54cd\u5e94\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
            }
            catch (IOException e) {
                this.log.error("\u6570\u636e\u63a8\u9001\u8c03\u7528\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
                HashMap<String, Object> map2 = new HashMap<String, Object>();
                map2.put("msg", "\u6570\u636e\u63a8\u9001\u8c03\u7528\u63a5\u53e3\u5f02\u5e38\uff01");
                map2.put("error", e.getStackTrace());
                map2.put("errorInfo", e.getMessage());
                sysDataPushRecord.setHttpStatus("500");
                sysDataPushRecord.setParam(JSON.toJSONString(map2));
                sysDataPushRecord.setSuccess("0");
                this.log.info("\u4fdd\u5b58\u65e5\u5fd7\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)sysDataPushRecord));
                this.pushDataRecordMapper.insert(sysDataPushRecord);
                continue;
            }
            sysDataPushRecord.setHttpStatus(String.valueOf(response.getStatus()));
            if (response.getStatus() == 200) {
                ApiResponse apiResponse;
                String msg = response.getMsg();
                if (HussarUtils.isNotEmpty((Object)msg) && 10000 != (apiResponse = (ApiResponse)JSON.parseObject((String)msg, ApiResponse.class)).getCode()) {
                    sysDataPushRecord.setHttpStatus(String.valueOf(500));
                }
            } else {
                this.log.error("\u6570\u636e\u63a8\u9001\u8c03\u7528\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u7801\u5f02\u5e38");
                map = new HashMap();
                map.put("msg", "\u6570\u636e\u63a8\u9001\u8c03\u7528\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38\uff01");
                map.put("error", "\u6570\u636e\u63a8\u9001\u8c03\u7528\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38\uff01");
                map.put("errorInfo", "\u6570\u636e\u63a8\u9001\u8c03\u7528\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38\uff01");
                sysDataPushRecord.setHttpStatus("500");
                sysDataPushRecord.setParam(JSON.toJSONString(map));
                sysDataPushRecord.setSuccess("0");
                this.log.info("\u4fdd\u5b58\u65e5\u5fd7\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)sysDataPushRecord));
                this.pushDataRecordMapper.insert(sysDataPushRecord);
                continue;
            }
            sysDataPushRecord.setSuccess(sysDataPushRecord.getHttpStatus().equals(String.valueOf(200)) ? "1" : "0");
            sysDataPushRecord.setResult(response.getMsg());
            this.log.info("\u4fdd\u5b58\u65e5\u5fd7\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)sysDataPushRecord));
            this.pushDataRecordMapper.insert(sysDataPushRecord);
        }
    }
}

