/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysAppVisitAuthorization;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.IHussarAppCallBackService;
import com.jxdinfo.hussar.application.service.ISysAppVisitAuthorizationBoService;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageBoService;
import com.jxdinfo.hussar.authorization.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitDataLogicBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysAppVisitRoleFieldBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleInfoVO;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.dashboard.service.IDashEntryService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.utils.AppUtil;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormGroupMapper;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormVo;
import com.jxdinfo.hussar.formdesign.application.tableinfo.service.ISysUserTableNameService;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionAppSdkOff;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.HussarNocodeAppCallBackServiceImpl")
@HussarTokenDs
@Conditional(value={ConditionAppSdkOff.class})
public class HussarNocodeAppCallBackServiceImpl
implements IHussarAppCallBackService {
    @Resource
    private ISysRolesExternalService rolesExternalService;
    @Resource
    private ISysAppVisitAuthorizationBoService sysAppVisitAuthorizationBoService;
    @Resource
    private SysFormMapper formMapper;
    @Resource
    private SysFormGroupMapper formGroupMapper;
    @Resource
    private ISysAppVisitRoleFieldBoService sysAppVisitRoleFieldBoService;
    @Resource
    private ISysAppVisitDataLogicBoService sysAppVisitDataLogicBoService;
    @Resource
    private ISysApplicationBoService sysApplicationService;
    @Resource
    private ISysRolesExternalService rolesService;
    @Resource
    private AppSyncService appSyncService;
    @Resource
    private IDashEntryService dashEntryService;
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private ISysUserTableNameService sysUserTableNameService;
    @Resource
    private AppUtil appUtil;
    @Resource
    private ISysMenuManageBoService menuBoService;
    @Resource
    private ISysApplicationService sysAppService;

    public String getAppType() {
        return "1";
    }

    public void beforeDeleteApp(SysApplication app) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(SysForm::getAppId, (Object)app.getId())).eq(SysForm::getFormType, (Object)"1");
        List sysForms = this.formMapper.selectList((Wrapper)lambdaQueryWrapper);
        sysForms.forEach(sysForm -> this.appFormService.deleteAllProcessInstance(String.valueOf(sysForm.getId()), sysForm.getAppId()));
    }

    public void deleteApp(SysApplication app) {
        this.appSyncService.syncApp("del", app);
    }

    public void updateApp(SysApplication app) {
        SysApplicationVo data = this.sysApplicationService.getAppDetail(app.getId());
        String oldName = data.getAppName();
        if (!HussarUtils.equals((Object)oldName, (Object)app.getAppName())) {
            SysApplicationVo appDetail = data;
            RoleInfoVO roleViewMap = this.rolesService.getRoleViewMap(appDetail.getDevelopRoleId());
            SysRoles sysRoles = new SysRoles();
            HussarUtils.copy((Object)roleViewMap, (Object)sysRoles);
            sysRoles.setRoleName(app.getAppName() + "\u5f00\u53d1\u8005");
            this.rolesService.updateRoleById(sysRoles);
        }
        this.appSyncService.syncApp("edit", app);
    }

    public void addApp(SysApplication app) {
        this.appSyncService.syncApp("add", app);
        SysApplicationDto sysApplicationDto = new SysApplicationDto();
        BeanUtil.copyProperties((Object)app, (Object)sysApplicationDto);
        sysApplicationDto.setReleaseStatus("1");
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        if ("1".equals(sysApplicationDto.getAppType())) {
            this.initDevelopRole(sysApplicationDto, userDetails);
        }
        if (HussarUtils.isNotEmpty((Object)sysApplicationDto.getDevelopRoleId()) && HussarUtils.isNotEmpty((Object)userDetails)) {
            Map extendUserMap = userDetails.getExtendUserMap();
            ArrayList<Long> roleIds = new ArrayList<Long>();
            Object rolesList = extendUserMap.get("rolesList");
            if (HussarUtils.isNotEmpty(rolesList)) {
                roleIds.addAll((List)rolesList);
            }
            roleIds.add(sysApplicationDto.getDevelopRoleId());
            userDetails.addExtendUserMap("rolesList", roleIds);
            SecurityUtil.getTokenSession().addUserDetailToTokenSession(userDetails, userDetails.getTokenValue());
        }
    }

    private void initDevelopRole(SysApplicationDto sysApplicationDto, UserDetails userDetails) {
        ApiResponse result = this.rolesExternalService.addAppDevRole(sysApplicationDto.getAppName(), null);
        if (!result.isSuccess()) {
            throw new BaseException("\u521b\u5efa\u5e94\u7528\u5f00\u53d1\u8005\u89d2\u8272\u5931\u8d25");
        }
        Long developRoleId = (Long)result.getData();
        sysApplicationDto.setDevelopRoleId(developRoleId);
        RoleUserDto userDto = new RoleUserDto();
        userDto.setRoleId(developRoleId);
        ArrayList userVos = Lists.newArrayListWithCapacity((int)1);
        RoleOrgUserVo u = new RoleOrgUserVo();
        Long userId = HussarUtils.isNotEmpty((Object)userDetails) ? userDetails.getUserId() : (HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser()) ? BaseSecurityUtil.getUser().getUserId() : ((SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser")).getUserId());
        u.setId(userId);
        userVos.add(u);
        userDto.setAdds((List)userVos);
        this.rolesExternalService.addAppRoleUser(userDto);
        SysAppVisitAuthorization sysAppVisitAuthorization = new SysAppVisitAuthorization();
        sysAppVisitAuthorization.setId(Long.valueOf(IdWorker.getId((Object)sysAppVisitAuthorization)));
        sysAppVisitAuthorization.setAppId(sysApplicationDto.getId());
        sysAppVisitAuthorization.setRoleId(developRoleId);
        sysAppVisitAuthorization.setAuthorizationType("2");
        this.sysAppVisitAuthorizationBoService.saveOne(sysAppVisitAuthorization);
        this.sysApplicationService.updateApp(sysApplicationDto);
    }

    public void deleteRecycleApp(SysAppRecycle appRecycle) {
        Long developRoleId;
        List roles;
        Long appId = appRecycle.getId();
        List allForms = this.formMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId));
        List allFormId = allForms.stream().map(SysForm::getId).collect(Collectors.toList());
        List<SysFormVo> formVos = this.formMapper.getSysFormList(null, null, null, "2", appId);
        for (SysFormVo vo : formVos) {
            this.dashEntryService.deleteData(vo.getId());
        }
        this.formMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId));
        for (SysForm sysForm : allForms) {
            try {
                if (!HussarUtils.isNotEmpty((Object)sysForm.getTableName())) continue;
                this.sysUserTableNameService.removeForm(sysForm.getTableName());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (LcdpException e) {
                throw new RuntimeException(e);
            }
        }
        this.formGroupMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysFormGroup::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)appRecycle) && HussarUtils.isNotEmpty((Object)(roles = this.rolesExternalService.getRoleInfoByIds(HussarUtils.toLongList((String)String.valueOf(developRoleId = appRecycle.getDevelopRoleId())))))) {
            this.rolesExternalService.delRole(developRoleId);
        }
        this.sysAppVisitAuthorizationBoService.deleteByAppId(appId);
        this.sysAppService.delAppAdvancedInfo(appId, allFormId);
        this.appUtil.deleteAppWater(appId);
        this.appUtil.deleteAppInnerLink(appId);
        this.menuBoService.deleteRecycleApp(appRecycle.getId());
    }

    public void revertRecycleApp(SysAppRecycle appRecycle) {
        this.appSyncService.recycleApp(appRecycle.getId());
    }
}

