/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.vo.AppMenuFuncResVo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.UpgradeMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysApplicationVersion;
import com.jxdinfo.hussar.formdesign.application.application.model.SysApplicationVersionDetail;
import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppUpgradeInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationVersionDetailService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationVersionService;
import com.jxdinfo.hussar.formdesign.application.application.service.impl.AppImportInfoServiceImpl;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppUpFormContrast;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppUpGroupContrast;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVersionDetailVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVersionVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.data.model.FormMap;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullConfig;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPushConfig;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullService;
import com.jxdinfo.hussar.formdesign.application.extapi.model.SysFormExtApi;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormCreateTypeEnum;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormUpgradeTypEnum;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormImportDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.ImportFormDataDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.UpgradeFormMappingDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormCheckConfig;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportThreadService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormUpgradeInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormUpgradeThreadService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormGroupService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.formLink.model.SysFormLink;
import com.jxdinfo.hussar.formdesign.application.formLink.model.SysFormLinkOpen;
import com.jxdinfo.hussar.formdesign.application.formLink.model.SysFormLinkSingleStatus;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.lefttree.model.NavLeftTreeOrder;
import com.jxdinfo.hussar.formdesign.application.message.model.SysMsgPushConfig;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushConfigService;
import com.jxdinfo.hussar.formdesign.application.print.model.SysFileInfoDashboard;
import com.jxdinfo.hussar.formdesign.application.print.model.SysPrintTemplate;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptBase;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleInfoService;
import com.jxdinfo.hussar.formdesign.application.rule.vo.RuleFullVo;
import com.jxdinfo.hussar.formdesign.application.tool.SnowflakeID;
import com.jxdinfo.hussar.formdesign.application.util.AppIoUtil;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.application.util.FormMigrateUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseSetting;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CustomViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineOperationType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.workflow.godaxe.migration.GodAxeMigrationService;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.AppUpgradeInfoServiceImpl")
public class AppUpgradeInfoServiceImpl
implements IAppUpgradeInfoService {
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysFormService formService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private ViewService viewService;
    @Resource
    private IAppImportService appImportService;
    @Resource
    private ISysFormGroupService sysFormGroupService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysFormLinkService sysFormLinkService;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private AppImportInfoServiceImpl appImportInfoService;
    @Resource
    private ISysRuleInfoService ruleInfoService;
    @Resource
    private ISysFormCheckConfigService sysFormCheckConfigService;
    @Resource
    private SysMsgPushConfigService msgPushConfigService;
    @Resource
    private SysDataPullService pullDataService;
    @Resource
    private PushDataService pushDataService;
    @Resource
    private ISysRuleInfoService sysRuleInfoService;
    @Resource
    private CustomViewService customViewService;
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private GodAxeMigrationService flowMigrateService;
    @Resource
    private SnowflakeID snowflakeID;
    @Resource
    private ISysApplicationVersionService sysApplicationVersionService;
    @Resource
    private ISysApplicationVersionDetailService sysApplicationVersionDetailService;
    @Resource
    private AppSyncService appFormSyncService;
    @Resource
    private IFormImportInfoService formImportInfoService;
    @Resource
    private AppSyncService appSyncService;
    @Resource
    private IFormUpgradeInfoService formUpgradeInfoService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private IFormUpgradeThreadService formUpgradeThreadService;
    @Resource
    private IFormImportThreadService formImportThreadService;
    private static final Logger LOGGER = LoggerFactory.getLogger(AppUpgradeInfoServiceImpl.class);

    public void upgradeGroup(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto) {
        LOGGER.info("\u5347\u7ea7\u5206\u7ec4\u4fe1\u606f\u5f00\u59cb\u3010{}\u3011...", (Object)appUpgradeDto.getCurrentAppId());
        List<SysFormGroup> sysFormGroupList = AppIoUtil.readDataByKeyToList(appUpgradeDto.getPath(), "form", "formGroups", SysFormGroup.class);
        Set<Object> addGroupIdSet = Sets.newLinkedHashSetWithExpectedSize((int)5);
        if (CollectionUtil.isNotEmpty((Collection)upgradeMappingDto.getAddGroup())) {
            addGroupIdSet = upgradeMappingDto.getAddGroup().stream().map(AppUpGroupContrast::getTargetGroupId).collect(Collectors.toSet());
        }
        if (HussarUtils.isNotEmpty(sysFormGroupList)) {
            ArrayList<SysFormGroup> addGroup = new ArrayList<SysFormGroup>();
            for (SysFormGroup upgradeFormGroup : sysFormGroupList) {
                if (!CollectionUtil.isNotEmpty((Collection)addGroupIdSet) || !addGroupIdSet.contains(upgradeFormGroup.getId())) continue;
                Long oldFormGroupId = upgradeFormGroup.getId();
                upgradeFormGroup.setAppId(appUpgradeDto.getCurrentAppId());
                this.sysFormGroupService.saveOrUpdate((Object)upgradeFormGroup);
                Long newFormGroupId = upgradeFormGroup.getId();
                upgradeMappingDto.getFormGroupIdMap().put(oldFormGroupId, newFormGroupId);
                addGroup.add(upgradeFormGroup);
            }
            this.appSyncService.syncSaveFormGroupBatch(addGroup);
        }
        LOGGER.info("\u5347\u7ea7\u5206\u7ec4\u4fe1\u606f\u7ed3\u675f\u3010{}\u3011...", (Object)appUpgradeDto.getCurrentAppId());
    }

    public void upgradeForm(SysForm upgradeForm, AppUpgradeDto appUpgradeDto, AppUpFormContrast formContrast) throws Exception {
        TransmittableThreadLocalHolder.set((String)"appId", (Object)String.valueOf(appUpgradeDto.getCurrentAppId()));
        appUpgradeDto.setUpgradeData(formContrast.isUpgradeData());
        ImportMappingDto importMappingDto = new ImportMappingDto();
        this.initFormDataByAppPackage(appUpgradeDto, upgradeForm, importMappingDto);
        FormImportDto formImportDto = new FormImportDto();
        formImportDto.setPath(appUpgradeDto.getPath());
        formImportDto.setAppId(appUpgradeDto.getCurrentAppId());
        formImportDto.setFormGroupId(upgradeForm.getFormGroupId());
        formImportDto.setId(upgradeForm.getId());
        formImportDto.setTableName(upgradeForm.getTableName());
        formImportDto.setUpgradeData(formContrast.isUpgradeData());
        FormUpgradeDto upgradeDto = (FormUpgradeDto)BeanUtil.copy((Object)formImportDto, FormUpgradeDto.class);
        upgradeDto.setUpgradeType(FormUpgradeTypEnum.COVER.getCode());
        importMappingDto.setKeepTableName(true);
        UpgradeFormMappingDto upgradeFormMappingDto = (UpgradeFormMappingDto)BeanUtil.copy((Object)importMappingDto, UpgradeFormMappingDto.class);
        this.formUpgradeThreadService.upgradeForm(upgradeDto, upgradeFormMappingDto);
    }

    public void createByTable(SysForm upgradeForm, AppUpgradeDto appUpgradeDto, AppUpFormContrast formContrast) throws Exception {
        ImportMappingDto importMappingDto = new ImportMappingDto();
        this.initFormDataByAppPackage(appUpgradeDto, upgradeForm, importMappingDto);
        importMappingDto.setKeepTableName(true);
        SysForm form = importMappingDto.getFormDataInit().getForm();
        form.setCreateSource(FormCreateTypeEnum.TABLE_TO_FORM.getType());
        this.formService.save((Object)form);
        this.createMidFile(importMappingDto, form);
        this.saveExtension(importMappingDto);
        if ("1".equals(form.getFormType())) {
            this.formImportInfoService.importFlowData(null, importMappingDto);
        }
        if (formContrast.isUpgradeData()) {
            this.formImportInfoService.importBusinessData(null, importMappingDto);
        }
        Long importFormId = importMappingDto.getFormIdMap().values().stream().findFirst().orElse(null);
        this.appSyncService.importForm(importFormId);
    }

    public void importForm(SysForm upgradeForm, AppUpgradeDto appUpgradeDto, AppUpFormContrast formContrast) throws Exception {
        FormImportDto formImportDto = new FormImportDto();
        ImportMappingDto importMappingDto = new ImportMappingDto();
        appUpgradeDto.setUpgradeData(formContrast.isUpgradeData());
        this.initFormDataByAppPackage(appUpgradeDto, upgradeForm, importMappingDto);
        importMappingDto.setKeepTableName(false);
        formImportDto.setUpgradeData(formContrast.isUpgradeData());
        formImportDto.setPath(appUpgradeDto.getPath());
        BeanUtil.copy((Object)upgradeForm, (Object)formImportDto);
        formImportDto.setAppId(appUpgradeDto.getCurrentAppId());
        formImportDto.setUpgradeData(formContrast.isUpgradeData());
        this.formImportThreadService.importForm(formImportDto, importMappingDto);
    }

    private void saveExtension(ImportMappingDto importMappingDto) throws IOException {
        this.formImportInfoService.importCheckConfig(null, importMappingDto);
        this.formImportInfoService.importMsgPush((FormImportDto)null, importMappingDto);
        this.formImportInfoService.importPrintTemplate(null, importMappingDto);
        this.formImportInfoService.importFormLink(null, importMappingDto);
        this.formImportInfoService.importDataPush((FormImportDto)null, importMappingDto);
        this.formImportInfoService.importDataPushMap(null, importMappingDto);
        this.formImportInfoService.importDataPull((FormImportDto)null, importMappingDto);
        this.formImportInfoService.importPublicView(null, importMappingDto);
        this.formImportInfoService.importLeftTreeData(null, importMappingDto);
        this.formImportInfoService.importExtensionApi(null, importMappingDto);
        this.formImportInfoService.importBusinessRule((FormImportDto)null, importMappingDto);
    }

    private void createMidFile(ImportMappingDto importMappingDto, SysForm form) throws Exception {
        String viewPath;
        FormViewSchema formViewSchema;
        this.formImportInfoService.importCustomButton((FormImportDto)null, importMappingDto);
        this.formImportInfoService.importScript(null, importMappingDto);
        String canvasPath = importMappingDto.getFormDataInit().getCanvasPath();
        FormCanvasSchema formCanvasSchemaUpgrade = FormMigrateUtil.readFileToObject(canvasPath, FormCanvasSchema.class);
        formCanvasSchemaUpgrade.setCreateSource(FormCreateTypeEnum.TABLE_TO_FORM.getType());
        this.canvasService.saveCanvas(formCanvasSchemaUpgrade);
        String settingPath = importMappingDto.getFormDataInit().getSettingPath();
        FormSettingSchema formSettingSchema = FormMigrateUtil.readFileToObject(settingPath, FormSettingSchema.class);
        if (HussarUtils.isNotEmpty((Object)formSettingSchema)) {
            SettingSchemaService settingSchemaService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class);
            settingSchemaService.saveOrUpdate((BaseSetting)formSettingSchema, String.valueOf(form.getId()));
        }
        if (HussarUtils.isNotEmpty((Object)(formViewSchema = FormMigrateUtil.readFileToObject(viewPath = importMappingDto.getFormDataInit().getViewPath(), FormViewSchema.class)))) {
            this.viewSchemaService.saveOrUpdate(formViewSchema);
        }
        FormSchema formSchema = new FormSchema.Builder().formPage(formCanvasSchemaUpgrade).view(formViewSchema).setting(formSettingSchema).build();
        this.canvasService.updateTableAndSync(EngineOperationType.ADD.getOperationType(), formSchema, null);
        formCanvasSchemaUpgrade.setCreateSource(null);
        this.canvasSchemaService.saveOrUpdate(formCanvasSchemaUpgrade);
        form.setCreateSource(null);
        this.formService.updateById((Object)form);
        importMappingDto.getFormIdMap().put(form.getId(), form.getId());
        importMappingDto.getTableNameMap().put(form.getTableName(), form.getTableName());
        if ("1".equals(form.getFormType())) {
            importMappingDto.getProcessKeyMap().put(formCanvasSchemaUpgrade.getIdentity(), formSchema.getIdentity());
        }
    }

    private void initFormDataByAppPackage(AppUpgradeDto appUpgradeDto, SysForm upgradeForm, ImportMappingDto importMappingDto) {
        String menuFuncResPath;
        AppMenuFuncResVo appMenuFuncResInfo;
        String businessFilePath;
        JSONObject businessData;
        String path;
        List<Object> scriptBases;
        String customButtonPath;
        JSONObject customButtonJsonObject;
        List<Object> ruleFullVos;
        String extensionApiPath;
        JSONArray extensionApiJsonArray;
        String leftTreePath;
        JSONObject leftTreeJsonObject;
        List<Object> dataViewList;
        List<Object> sysDataPullConfigs;
        String dataPushMapPath;
        JSONArray dataPshMapArray;
        JSONArray formLinkSingleStatusJsonArray;
        List<Object> formLinkSingleStatuses;
        JSONArray formLinkOpenJsonArray;
        List<Object> formLinkOpens;
        List<Object> printTemplates;
        List<Object> sysMsgPushConfigs;
        List<Object> checkConfigs;
        ImportFormDataDto importFormDataDto = new ImportFormDataDto();
        Long upgradeFormId = upgradeForm.getId();
        importFormDataDto.setForm(upgradeForm);
        String formFilePath = FileUtil.posixPath((String[])new String[]{appUpgradeDto.getPath(), "appConfig", "form.json"});
        if ("2".equals(upgradeForm.getFormType())) {
            String dashboardImagePath;
            JSONObject dashboardImageJsonObject;
            String dashboardFilePath = FileUtil.posixPath((String[])new String[]{appUpgradeDto.getPath(), "appConfig", "dashboard.json"});
            JSONObject dashboardData = AppMigrateUtil.readFileToObject(dashboardFilePath, JSONObject.class);
            if (HussarUtils.isNotEmpty((Object)dashboardData)) {
                JSONArray dashboardArray = (JSONArray)dashboardData.get((Object)upgradeForm.getId());
                importFormDataDto.setDashEntry(dashboardArray);
            }
            if (HussarUtils.isNotEmpty((Object)(dashboardImageJsonObject = FormMigrateUtil.readFileToObject(dashboardImagePath = FileUtil.posixPath((String[])new String[]{appUpgradeDto.getPath(), "appConfig", "dashboardImagePath", "printImage.json"}), JSONObject.class)))) {
                JSONArray printTemplateJsonArray = (JSONArray)dashboardImageJsonObject.getObject("printImageData", JSONArray.class);
                JSONArray currentFormJsonArray = new JSONArray();
                printTemplateJsonArray.forEach(e -> {
                    JSONObject object;
                    if (e instanceof JSONObject && upgradeFormId.equals((object = (JSONObject)e).get((Object)"formId"))) {
                        currentFormJsonArray.add((Object)object);
                    }
                });
                List<SysFileInfoDashboard> dashboardImageInfo = FormMigrateUtil.parseJsonArrayToList(currentFormJsonArray, SysFileInfoDashboard.class);
                importFormDataDto.setDashboardImageList(dashboardImageInfo);
                String imagePath = FileUtil.posixPath((String[])new String[]{appUpgradeDto.getPath(), "appConfig", "dashboardImagePath", "imageFile"});
                importFormDataDto.setDashboardImagePath(imagePath);
            }
        }
        String midFilePath = FileUtil.posixPath((String[])new String[]{appUpgradeDto.getPath(), "appConfig", String.valueOf(upgradeForm.getAppId())});
        File midFileFolder = new File(midFilePath);
        JSONArray files = midFileFolder.listFiles();
        String canvasPath = null;
        if (HussarUtils.isNotEmpty((Object[])files)) {
            for (Object file : files) {
                if (!((File)file).getName().equals(String.valueOf(upgradeFormId))) continue;
                canvasPath = FileUtil.posixPath((String[])new String[]{((File)file).getAbsolutePath(), "canvas", ((File)file).getName() + ".fd"});
                String settingPath = FileUtil.posixPath((String[])new String[]{((File)file).getAbsolutePath(), "setting", ((File)file).getName() + ".setting"});
                String viewPath = FileUtil.posixPath((String[])new String[]{((File)file).getAbsolutePath(), "view", ((File)file).getName() + ".vd"});
                importFormDataDto.setCanvasPath(canvasPath);
                importFormDataDto.setSettingPath(settingPath);
                importFormDataDto.setViewPath(viewPath);
                break;
            }
        }
        if (HussarUtils.isNotEmpty(checkConfigs = AppIoUtil.readDataToList(appUpgradeDto.getPath(), "formCheckConfig", SysFormCheckConfig.class))) {
            checkConfigs = checkConfigs.stream().filter(c -> upgradeFormId.equals(c.getFormId())).collect(Collectors.toList());
            importFormDataDto.setCheckConfigs(checkConfigs);
        }
        if (HussarUtils.isNotEmpty(sysMsgPushConfigs = AppIoUtil.readDataToList(appUpgradeDto.getPath(), "msgPush", SysMsgPushConfig.class))) {
            sysMsgPushConfigs = sysMsgPushConfigs.stream().filter(p -> upgradeFormId.equals(p.getFormId())).collect(Collectors.toList());
            importFormDataDto.setSysMsgPushConfigs(sysMsgPushConfigs);
        }
        if (HussarUtils.isNotEmpty(printTemplates = AppIoUtil.readDataByKeyToList(appUpgradeDto.getPath(), "printTemplate", "printTemplateData", SysPrintTemplate.class))) {
            printTemplates = printTemplates.stream().filter(p -> upgradeFormId.equals(p.getFormId())).collect(Collectors.toList());
            importFormDataDto.setPrintTemplates(printTemplates);
        }
        String templateFilePath = FileUtil.posixPath((String[])new String[]{appUpgradeDto.getPath(), "appConfig", "printTemplate", "templateFile"});
        importFormDataDto.setTemplateFilePath(templateFilePath);
        String formLinkFilePath = FileUtil.posixPath((String[])new String[]{appUpgradeDto.getPath(), "appConfig", "formLink.json"});
        JSONObject formLinkJsonObject = AppMigrateUtil.readFileToObject(formLinkFilePath, JSONObject.class);
        JSONObject formLinkJsonObjectCurrentForm = new JSONObject();
        JSONArray formLinkJsonArray = (JSONArray)formLinkJsonObject.getObject("formLink", JSONArray.class);
        List<Object> formLinks = AppMigrateUtil.parseJsonArrayToList(formLinkJsonArray, SysFormLink.class);
        if (HussarUtils.isNotEmpty(formLinks)) {
            formLinks = formLinks.stream().filter(f -> upgradeFormId.equals(f.getFormId())).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(formLinkOpens = AppMigrateUtil.parseJsonArrayToList(formLinkOpenJsonArray = (JSONArray)formLinkJsonObject.getObject("formLinkOpen", JSONArray.class), SysFormLinkOpen.class))) {
            formLinkOpens = formLinkOpens.stream().filter(f -> upgradeFormId.equals(f.getFormId())).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(formLinkSingleStatuses = AppMigrateUtil.parseJsonArrayToList(formLinkSingleStatusJsonArray = (JSONArray)formLinkJsonObject.getObject("singleStatus", JSONArray.class), SysFormLinkSingleStatus.class))) {
            formLinkSingleStatuses = formLinkSingleStatuses.stream().filter(f -> upgradeFormId.equals(f.getFormId())).collect(Collectors.toList());
        }
        formLinkJsonObjectCurrentForm.put("formLink", formLinks);
        formLinkJsonObjectCurrentForm.put("formLinkOpen", formLinkOpens);
        formLinkJsonObjectCurrentForm.put("singleStatus", formLinkSingleStatuses);
        importFormDataDto.setFormLinkObject(formLinkJsonObjectCurrentForm);
        List<Object> sysDataPushConfigs = AppIoUtil.readDataToList(appUpgradeDto.getPath(), "dataPush", SysDataPushConfig.class);
        if (HussarUtils.isNotEmpty(sysDataPushConfigs)) {
            sysDataPushConfigs = sysDataPushConfigs.stream().filter(p -> upgradeFormId.equals(p.getFormId())).collect(Collectors.toList());
            importFormDataDto.setPushConfigs(sysDataPushConfigs);
        }
        if (HussarUtils.isNotEmpty((Object)(dataPshMapArray = FormMigrateUtil.readFileToJsonArray(dataPushMapPath = FileUtil.posixPath((String[])new String[]{appUpgradeDto.getPath(), "appConfig", "dataPushMap.json"}))))) {
            List<FormMap> formMapList = AppMigrateUtil.parseJsonArrayToList(dataPshMapArray, FormMap.class);
            FormMap formMap = (FormMap)formMapList.stream().filter(f -> upgradeFormId.equals(f.getFormId())).collect(Collectors.toList()).get(0);
            importFormDataDto.setMap(formMap);
        }
        if (HussarUtils.isNotEmpty(sysDataPullConfigs = AppIoUtil.readDataToList(appUpgradeDto.getPath(), "dataPull", SysDataPullConfig.class))) {
            sysDataPullConfigs = sysDataPullConfigs.stream().filter(p -> upgradeFormId.equals(p.getFormId())).collect(Collectors.toList());
            importFormDataDto.setPullConfigs(sysDataPullConfigs);
        }
        if (HussarUtils.isNotEmpty(dataViewList = AppIoUtil.readDataToList(appUpgradeDto.getPath(), "publicView", DataView.class))) {
            dataViewList = dataViewList.stream().filter(v -> upgradeFormId.equals(v.getFormId())).collect(Collectors.toList());
            importFormDataDto.setDataViews(dataViewList);
        }
        if (HussarUtils.isNotEmpty((Object)(leftTreeJsonObject = FormMigrateUtil.readFileToObject(leftTreePath = FileUtil.posixPath((String[])new String[]{appUpgradeDto.getPath(), "appConfig", "leftTree.json"}), JSONObject.class)))) {
            List dragOrders = JSONArray.parseArray((String)leftTreeJsonObject.getString("dragOrder"), NavLeftTreeOrder.class);
            dragOrders = dragOrders.stream().filter(d -> upgradeFormId.equals(d.getFormId())).collect(Collectors.toList());
            importFormDataDto.setDragOrders(dragOrders);
        }
        if (HussarUtils.isNotEmpty((Object)(extensionApiJsonArray = FormMigrateUtil.readFileToJsonArray(extensionApiPath = FileUtil.posixPath((String[])new String[]{appUpgradeDto.getPath(), "appConfig", "extensionApi.json"}))))) {
            List<Object> sysFormExtApis = AppMigrateUtil.parseJsonArrayToList(extensionApiJsonArray, SysFormExtApi.class);
            sysFormExtApis = sysFormExtApis.stream().filter(e -> upgradeFormId.equals(Long.valueOf(e.getFormId()))).collect(Collectors.toList());
            importFormDataDto.setSysFormExtApis(sysFormExtApis);
        }
        if (HussarUtils.isNotEmpty(ruleFullVos = AppIoUtil.readDataToList(appUpgradeDto.getPath(), "businessRule", RuleFullVo.class))) {
            ruleFullVos = ruleFullVos.stream().filter(r -> upgradeFormId.equals(Long.parseLong(r.getSourceForm()))).collect(Collectors.toList());
            importFormDataDto.setRules(ruleFullVos);
        }
        if (HussarUtils.isNotEmpty((Object)(customButtonJsonObject = FormMigrateUtil.readFileToObject(customButtonPath = FileUtil.posixPath((String[])new String[]{appUpgradeDto.getPath(), "appConfig", "customButton.json"}), JSONObject.class)))) {
            JSONArray customButtonJsonArray = (JSONArray)customButtonJsonObject.getObject("customButtonData", JSONArray.class);
            List<Object> customButtons = FormMigrateUtil.parseJsonArrayToList(customButtonJsonArray, SysCustomButton.class);
            customButtons = customButtons.stream().filter(c -> upgradeFormId.equals(c.getFormId())).collect(Collectors.toList());
            importFormDataDto.setCustomButton(customButtons);
        }
        if (HussarUtils.isNotEmpty((Object)(scriptBases = FormMigrateUtil.readFileToObject(path = FileUtil.posixPath((String[])new String[]{appUpgradeDto.getPath(), "appConfig", "script.json"}), List.class)))) {
            scriptBases = FormMigrateUtil.parseListObjectoList(scriptBases, ScriptBase.class);
            scriptBases = scriptBases.stream().filter(s -> upgradeFormId.equals(Long.valueOf(s.getFormId()))).collect(Collectors.toList());
        }
        importFormDataDto.setScriptBases((List)scriptBases);
        if ("1".equals(upgradeForm.getFormType())) {
            FormCanvasSchema formCanvasSchemaUpgrade = FormMigrateUtil.readFileToObject(canvasPath, FormCanvasSchema.class);
            String upgradeIdentity = formCanvasSchemaUpgrade.getIdentity();
            String flowFilePath = FileUtil.posixPath((String[])new String[]{appUpgradeDto.getPath(), "appConfig", "flow.json"});
            JSONObject flowData = AppMigrateUtil.readFileToObject(flowFilePath, JSONObject.class);
            JSONObject currentFormFlowData = new JSONObject();
            currentFormFlowData.put(upgradeIdentity, flowData.get((Object)upgradeIdentity));
            importFormDataDto.setFlowData(currentFormFlowData);
        }
        if (appUpgradeDto.isUpgradeData() && HussarUtils.isNotEmpty((Object)(businessData = AppMigrateUtil.readFileToObject(businessFilePath = FileUtil.posixPath((String[])new String[]{appUpgradeDto.getPath(), "businessData", "businessData.json"}), JSONObject.class)).get((Object)upgradeForm.getTableName()))) {
            JSONObject currentFormBusinessData = new JSONObject();
            currentFormBusinessData.put(upgradeForm.getTableName(), businessData.get((Object)upgradeForm.getTableName()));
            importFormDataDto.setBusinessData(currentFormBusinessData);
        }
        if (HussarUtils.isNotEmpty((Object)(appMenuFuncResInfo = AppMigrateUtil.readFileToObject(menuFuncResPath = FileUtil.posixPath((String[])new String[]{appUpgradeDto.getPath(), "appConfig", "menuFuncRes.json"}), AppMenuFuncResVo.class)))) {
            AppMenuFuncResVo formMenuFuncRes = new AppMenuFuncResVo();
            formMenuFuncRes.setMenus(this.filterList(appMenuFuncResInfo.getMenus(), upgradeFormId, SysMenu::getId));
            formMenuFuncRes.setFuncModules(this.filterList(appMenuFuncResInfo.getFuncModules(), upgradeFormId, SysFunctionModules::getId));
            formMenuFuncRes.setFunctions(this.filterList(appMenuFuncResInfo.getFunctions(), upgradeFormId, SysFunctions::getFunctionModuleId));
            formMenuFuncRes.setResModules(this.filterList(appMenuFuncResInfo.getResModules(), upgradeFormId, SysResourceModules::getId));
            formMenuFuncRes.setResources(this.filterList(appMenuFuncResInfo.getResources(), upgradeFormId, SysResources::getModuleId));
            formMenuFuncRes.setFuncResRelations(this.getFuncResForm(appMenuFuncResInfo.getFuncResRelations(), formMenuFuncRes));
            importFormDataDto.setFormMenuFuncResVo(formMenuFuncRes);
        }
        importMappingDto.setFormDataInit(importFormDataDto);
    }

    private List<SysFunctionResources> getFuncResForm(List<SysFunctionResources> funcResRelations, AppMenuFuncResVo formMenuFuncRes) {
        if (HussarUtils.isNotEmpty(funcResRelations) || HussarUtils.isNotEmpty((Object)formMenuFuncRes.getFunctions()) || HussarUtils.isNotEmpty((Object)formMenuFuncRes.getResources())) {
            return new ArrayList<SysFunctionResources>();
        }
        List funcList = formMenuFuncRes.getFunctions().stream().map(SysFunctions::getId).collect(Collectors.toList());
        List resList = formMenuFuncRes.getResources().stream().map(SysResources::getId).collect(Collectors.toList());
        return funcResRelations.stream().filter(item -> funcList.contains(item.getFunctionId()) && resList.contains(item.getResourceId())).collect(Collectors.toList());
    }

    private <T> List<T> filterList(List<T> list, Long upgradeFormId, Function<T, Long> idGetter) {
        return HussarUtils.isNotEmpty(list) ? list.stream().filter(item -> upgradeFormId.equals(idGetter.apply(item))).collect(Collectors.toList()) : new ArrayList();
    }

    public void upgradeApp(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto) {
        LOGGER.info("\u5347\u7ea7\u5e94\u7528\u4fe1\u606f\u5f00\u59cb\u3010{}\u3011...", (Object)appUpgradeDto.getCurrentAppId());
        SysApplicationVo currentApp = (SysApplicationVo)this.sysApplicationService.getAppDetail(appUpgradeDto.getCurrentAppId()).getData();
        AssertUtil.isNotNull((Object)currentApp, (String)"\u5f53\u524d\u5e94\u7528\u4e0d\u5b58\u5728");
        upgradeMappingDto.setCurrentAppId(appUpgradeDto.getCurrentAppId());
        upgradeMappingDto.setNewAppId(appUpgradeDto.getCurrentAppId());
        SysApplication upgradeApp = AppIoUtil.readDataByKey(appUpgradeDto.getPath(), "app", "appInfo", SysApplication.class);
        AssertUtil.isNotNull((Object)upgradeApp, (String)"\u5347\u7ea7\u5e94\u7528\u4e0d\u5b58\u5728");
        upgradeMappingDto.setOldAppId(upgradeApp.getId());
        upgradeApp.getCreateTime();
        upgradeMappingDto.setAppCreateTime(upgradeApp.getCreateTime());
        if (HussarUtils.isNotEmpty((Object)currentApp) && HussarUtils.isNotEmpty((Object)upgradeApp) && "0".equals(appUpgradeDto.getOperType())) {
            currentApp.setAppIconType(upgradeApp.getAppIconType());
            currentApp.setAppIcon(upgradeApp.getAppIcon());
            currentApp.setAppIconColor(upgradeApp.getAppIconColor());
            SysApplicationDto sysApplicationDto = new SysApplicationDto();
            BeanUtils.copyProperties((Object)currentApp, (Object)sysApplicationDto);
            this.sysApplicationService.updateApp(sysApplicationDto);
        }
        LOGGER.info("\u5347\u7ea7\u5e94\u7528\u4fe1\u606f\u7ed3\u675f\u3010{}\u3011...", (Object)appUpgradeDto.getCurrentAppId());
    }

    public void upgradeForm(SysForm upgradeForm, SysForm currentForm, AppUpFormContrast upFormContrast, AppUpgradeDto appUpgradeDto) throws Exception {
        UpgradeFormMappingDto upgradeFormMappingDto = new UpgradeFormMappingDto();
        appUpgradeDto.setUpgradeData(upFormContrast.isUpgradeData());
        this.initFormDataByAppPackage(appUpgradeDto, upgradeForm, (ImportMappingDto)upgradeFormMappingDto);
        FormUpgradeDto formUpgradeDto = new FormUpgradeDto();
        formUpgradeDto.setPath(appUpgradeDto.getPath());
        formUpgradeDto.setAppId(currentForm.getAppId());
        formUpgradeDto.setFormGroupId(currentForm.getFormGroupId());
        formUpgradeDto.setId(currentForm.getId());
        formUpgradeDto.setUpgradeData(upFormContrast.isUpgradeData());
        formUpgradeDto.setUpgradeType(upFormContrast.getUpgradeType());
        upgradeFormMappingDto.setKeepTableName(true);
        this.formUpgradeThreadService.upgradeForm(formUpgradeDto, upgradeFormMappingDto);
    }

    public void saveUpgradeVersion(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto) {
        if (!"0".equals(appUpgradeDto.getOperType())) {
            return;
        }
        Long appId = appUpgradeDto.getCurrentAppId();
        SysApplicationVersionVo currentAppVersion = (SysApplicationVersionVo)this.sysApplicationVersionService.getCurrentAppVersion(appId).getData();
        if (HussarUtils.isEmpty((Object)currentAppVersion)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
            String formattedDateTime = upgradeMappingDto.getAppCreateTime().format(formatter);
            SysApplicationVersion firstVersion = new SysApplicationVersion();
            firstVersion.setAppId(appId);
            firstVersion.setUpgradefileId(appUpgradeDto.getFileId());
            firstVersion.setPassword(appUpgradeDto.getPassword());
            firstVersion.setVersionNumber(formattedDateTime);
            firstVersion.setUpgradeDesc(appUpgradeDto.getUpgradeDesc());
            firstVersion.setBackFileId(appUpgradeDto.getBackFileId());
            firstVersion.setUpgradeDesc("\u521d\u59cb\u5316\u7248\u672c");
            firstVersion.setCreateTime(upgradeMappingDto.getAppCreateTime());
            this.sysApplicationVersionService.save((Object)firstVersion);
            this.saveVersionDeail(appUpgradeDto, upgradeMappingDto, firstVersion);
            LocalDateTime createTime = LocalDateTime.now();
            DateTimeFormatter formatterNow = DateTimeFormatter.ofPattern("yyyyMMdd");
            String versionNumber = formatterNow.format(createTime);
            SysApplicationVersion latestVersion = new SysApplicationVersion();
            latestVersion.setAppId(appId);
            latestVersion.setVersionNumber(AppUpgradeInfoServiceImpl.generateLatestVersionNumber(versionNumber));
            latestVersion.setCurrentFlag(Boolean.TRUE.booleanValue());
            latestVersion.setUpgradeDesc(appUpgradeDto.getUpgradeDesc());
            this.sysApplicationVersionService.save((Object)latestVersion);
        } else {
            currentAppVersion.setBackFileId(appUpgradeDto.getBackFileId());
            currentAppVersion.setUpgradefileId(appUpgradeDto.getFileId());
            currentAppVersion.setPassword(appUpgradeDto.getPassword());
            currentAppVersion.setCurrentFlag(false);
            this.sysApplicationVersionService.saveOrUpdate((Object)currentAppVersion);
            this.saveVersionDeail(appUpgradeDto, upgradeMappingDto, (SysApplicationVersion)currentAppVersion);
            SysApplicationVersion latestVersion = new SysApplicationVersion();
            latestVersion.setAppId(appId);
            latestVersion.setVersionNumber(AppUpgradeInfoServiceImpl.generateLatestVersionNumber(currentAppVersion.getVersionNumber()));
            latestVersion.setCurrentFlag(Boolean.TRUE.booleanValue());
            latestVersion.setUpgradeDesc(appUpgradeDto.getUpgradeDesc());
            this.sysApplicationVersionService.save((Object)latestVersion);
        }
    }

    private void saveVersionDeail(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto, SysApplicationVersion firstVersion) {
        SysApplicationVersionDetail versionDetail = new SysApplicationVersionDetail();
        versionDetail.setAppVersionId(firstVersion.getId());
        SysApplicationVersionDetailVo versionDetailOperate = new SysApplicationVersionDetailVo();
        versionDetailOperate.setGroupContrastList(appUpgradeDto.getUpGroupContrastList());
        versionDetailOperate.setAddFormGroupIdMap(upgradeMappingDto.getFormGroupIdMap());
        versionDetailOperate.setAddFormIdMap(upgradeMappingDto.getAddFormIdMap());
        versionDetail.setOperateContent(JSON.toJSONString((Object)versionDetailOperate));
        this.sysApplicationVersionDetailService.save((Object)versionDetail);
    }

    private static String generateLatestVersionNumber(String versionNumber) {
        String result;
        int splitIndex = versionNumber.indexOf("-");
        String today = LocalDate.now().toString().replace("-", "");
        if (splitIndex == -1 || !versionNumber.substring(0, splitIndex).equals(today)) {
            result = today + "-1";
        } else {
            String numStr = versionNumber.substring(splitIndex + 1);
            result = today + "-" + (Integer.parseInt(numStr) + 1);
        }
        return result;
    }
}

