/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.print.handle;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.application.print.handle.ExcelHandle;
import com.jxdinfo.hussar.formdesign.application.print.handle.WordHandle;
import com.jxdinfo.hussar.formdesign.application.properties.HussarFormDesignProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Component;

@Component
public class ExcelHandleForCopy {
    @Resource
    private HussarFormDesignProperties hussarFormDesignProperties;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private OssService ossService;
    @Resource
    private WordHandle wordHandle;
    @Resource
    private ExcelHandle excelHandle;
    private static ConcurrentHashMap<String, Object> hashMap = new ConcurrentHashMap();
    private static final Logger LOGGER = LogManager.getLogger(ExcelHandleForCopy.class);

    private void analysisTable(XSSFSheet sheetAt) {
        int lastIndex = sheetAt.getLastRowNum() + 1;
        for (int i = 0; i < lastIndex; ++i) {
            XSSFRow row = sheetAt.getRow(i);
            int lastCellNum = row.getLastCellNum();
            for (int j = 0; j < lastCellNum; ++j) {
                CellType cellType;
                XSSFCell cell = row.getCell(j);
                if (!HussarUtils.isNotEmpty((Object)cell) || (cellType = cell.getCellType()) != CellType.STRING) continue;
                String cellValue = cell.getStringCellValue();
                Matcher matcher = this.wordHandle.matcher(cellValue);
                while (matcher.find()) {
                    String key = matcher.group();
                    if (!key.contains(".")) continue;
                    hashMap.put(key, "");
                }
            }
        }
    }

    private static void getFormData(Map<String, Object> hashMap, JSONObject dataJson) {
        for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
            String key = entry.getKey();
            String substring = key.substring(key.indexOf("#") + 1, key.lastIndexOf("}"));
            if (!substring.contains(".")) continue;
            String[] split = substring.split("\\.");
            substring = split[0];
            String value = key.replace(substring, String.valueOf(dataJson.get((Object)substring)));
            hashMap.put(key, value);
        }
    }

    /*
     * Exception decompiling
     */
    public Long entry(JSONObject parse, AttachmentManagerModelVo attachmentManagerModelVo, Map<String, String> widgets) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void generateExcel(ConcurrentHashMap<String, Object> hashMap, XSSFWorkbook workbook, Map<String, String> widgets) {
        this.replaceInTable(hashMap, workbook, widgets);
    }

    private void replaceInTable(ConcurrentHashMap<String, Object> hashMap, XSSFWorkbook workbook, Map<String, String> widgets) {
        XSSFSheet sheetAt = workbook.getSheetAt(0);
        int lastIndex = sheetAt.getLastRowNum() + 1;
        for (int i = 0; i < lastIndex; ++i) {
            XSSFRow row = sheetAt.getRow(i);
            int lastCellNum = row.getLastCellNum();
            for (int j = 0; j < lastCellNum; ++j) {
                CellType cellType;
                XSSFCell cell = row.getCell(j);
                if (!HussarUtils.isNotEmpty((Object)cell) || (cellType = cell.getCellType()) != CellType.STRING) continue;
                String text = cell.getStringCellValue();
                Matcher matcher = this.wordHandle.matcher(text);
                while (matcher.find()) {
                    String key = matcher.group();
                    if (key.contains("flowHistoryInfo") || !key.contains(".") || !key.contains("$") || !key.contains("{") || !key.contains("#") || !key.contains("}")) continue;
                    text = text.replace(key, HussarUtils.isNotEmpty((Object)hashMap.get(key)) ? hashMap.get(key).toString() : "");
                }
                cell.setCellValue(text);
            }
        }
    }

    private String replaceText(String text, Map<String, Object> map) {
        Matcher matcher;
        if (text != null && (matcher = this.wordHandle.matcher(text)).find() && (matcher = this.wordHandle.matcher(text)).find() && text.contains(".") && text.contains("$") && text.contains("{") && text.contains("#") && text.contains("}")) {
            String value = String.valueOf(map.get(matcher.group()));
            text = text.replace(matcher.group(), value);
        }
        return text;
    }
}

