/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.form.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.openapi.form.util.OpenFormUtils;
import com.jxdinfo.hussar.formdesign.extension.api.dto.TableUpdateDto;
import com.jxdinfo.hussar.formdesign.extension.api.service.IOpeApiService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.FormOperateExposedImpl;
import com.jxdinfo.hussar.formdesign.no.code.constant.ViewIdEnum;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OpenApiServiceImpl
implements IOpeApiService {
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private FormOperateExposedImpl formOperateExposedService;
    @Resource
    private ISysFormService sysFormService;
    private static final String IMPORT_KEY = "importList";

    public ApiResponse<Object> formQuery(String formId, String id, String appId, String tabType) {
        return (ApiResponse)this.formOperateExposedService.formQuery(formId, id, tabType, appId, Boolean.TRUE.booleanValue()).getBody();
    }

    public ApiResponse<Object> tableQuery(String formId, Map<String, Object> params, String appId, String viewId) {
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        AssertUtil.isTrue((boolean)HussarUtils.isNotEmpty((Object)sysForm), (String)"\u8868\u5355\u4e0d\u5b58\u5728");
        params.put("BC8D215A-26F1-9B83-4DE2-7867003DA241", "BC8D215A-26F1-9B83-4DE2-7867003DA241");
        if (HussarUtils.isEmpty((Object)viewId)) {
            switch (sysForm.getFormType()) {
                case "0": {
                    viewId = ViewIdEnum.SYS_ORDINARY_ALL_DATA.getId();
                    break;
                }
                case "1": {
                    viewId = ViewIdEnum.SYS_FLOW_ALL_DATA.getId();
                    break;
                }
                default: {
                    throw new HussarException("\u4e0d\u652f\u6301\u6b64\u7c7b\u578b\u8868\u5355\u7684\u67e5\u8be2!");
                }
            }
        }
        return (ApiResponse)this.appFormService.tableQuery(formId, viewId, params, appId).getBody();
    }

    public ApiResponse<Object> create(String formId, Map<String, Object> params, String appId) {
        ArrayList<Map<String, Object>> importList = new ArrayList<Map<String, Object>>();
        importList.add(params);
        HashMap<String, ArrayList<Map<String, Object>>> map = new HashMap<String, ArrayList<Map<String, Object>>>();
        map.put(IMPORT_KEY, importList);
        this.formOperateExposedService.tableSave(appId, formId, map);
        params.remove(null);
        return ApiResponse.success(params, (String)"\u65b0\u589e\u6210\u529f!");
    }

    public ApiResponse<Object> flowFormSubmit(String formId, Map<String, Object> params) {
        this.formOperateExposedService.flowFormSubmit(formId, params);
        params.remove(null);
        if (HussarUtils.isNotEmpty((Object)params.get("formData"))) {
            JSONObject formData = JSONObject.parseObject((String)JSONObject.toJSONString((Object)params.get("formData")));
            formData.remove(null);
            params.replace("formData", formData);
        }
        return ApiResponse.success(params, (String)"\u63d0\u4ea4\u6210\u529f!");
    }

    public ApiResponse<Object> createBatch(String formId, Map<String, Object> params, String appId) {
        this.formOperateExposedService.tableSave(appId, formId, params);
        ArrayList successIds = new ArrayList();
        List<Map<String, Object>> importList = OpenFormUtils.castListMap(params.get(IMPORT_KEY), String.class, Object.class);
        importList.forEach(entity -> successIds.add(this.getIdValue(formId, (Map<String, Object>)entity)));
        return ApiResponse.success(successIds, (String)"\u65b0\u589e\u6210\u529f!");
    }

    public ApiResponse<Object> update(String formId, Map<String, Object> params, String appId) {
        ArrayList<Map<String, Object>> importList = new ArrayList<Map<String, Object>>();
        importList.add(params);
        HashMap<String, ArrayList<Map<String, Object>>> map = new HashMap<String, ArrayList<Map<String, Object>>>();
        map.put(IMPORT_KEY, importList);
        this.formOperateExposedService.tableSave(appId, formId, map);
        params.remove(null);
        return ApiResponse.success(params, (String)"\u66f4\u65b0\u6210\u529f!");
    }

    public ApiResponse<Object> updateBatch(String appId, String formId, TableUpdateDto tableUpdateDto) {
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        return (ApiResponse)this.appFormService.tableUpdate(appId, formId, tableUpdateDto, sysForm).getBody();
    }

    public ApiResponse<Object> deleteBatch(String formId, String ids, String appId) {
        return (ApiResponse)this.formOperateExposedService.deleteBatch(formId, ids, appId).getBody();
    }

    public String getIdValue(String formId, Map<String, Object> entity) {
        ApiResponse sysFormApiResponse = this.sysFormService.getDetailById(Long.valueOf(formId));
        String tableName = Optional.ofNullable(sysFormApiResponse).map(ApiResponse::getData).map(SysForm::getTableName).orElseThrow(() -> new BaseException("\u8868\u5355\u540d\u67e5\u8be2\u5931\u8d25"));
        return String.valueOf(entity.get(tableName));
    }
}

