/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.data.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.data.dao.SysDataPullTaskMapper;
import com.jxdinfo.hussar.formdesign.application.data.middle.SysDataPullRepeatRule;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullConfig;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullTask;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullTaskService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.message.middle.RepeatRule;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.data.service.impl.sysMsgPushTaskServiceImpl")
@HussarTokenDs
public class SysDataPullTaskServiceImpl
extends HussarServiceImpl<SysDataPullTaskMapper, SysDataPullTask>
implements SysDataPullTaskService {
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private SysDataPullTaskMapper sysDataPullTaskMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(SysDataPullTaskServiceImpl.class);

    public void asyncGenerateTaskBySaveConfig(SysDataPullConfig sysDataPullConfig) {
        ArrayList<SysDataPullTask> sysDataPulltasks = new ArrayList<SysDataPullTask>();
        SysDataPullTask sysDataPullTask = this.parseConfig(sysDataPullConfig);
        if (sysDataPullTask != null) {
            sysDataPulltasks.add(sysDataPullTask);
        }
        if (HussarUtils.isNotEmpty(sysDataPulltasks)) {
            this.saveBatch(sysDataPulltasks);
        }
    }

    public List<SysDataPullTask> queryDataPullTasks(LocalDateTime currentTime) {
        LocalDateTime startTime = currentTime.minusSeconds(20L);
        return this.sysDataPullTaskMapper.queryMsgPushTasks(startTime, currentTime);
    }

    public void removeByFormId(Long formId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPullTask::getFormId, (Object)formId)).eq(SysDataPullTask::getStatus, (Object)"0");
        this.remove((Wrapper)queryWrapper);
    }

    public void removeByConfigId(Long configId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPullTask::getConfigId, (Object)configId);
        this.remove((Wrapper)queryWrapper);
    }

    private SysDataPullTask parseConfig(SysDataPullConfig sysDataPullConfig) {
        SysDataPullTask sysDataPullTask = new SysDataPullTask();
        LocalDateTime now = LocalDateTime.now();
        this.handleCommonPart(sysDataPullConfig, sysDataPullTask);
        LocalDateTime firstExecuteTime = null;
        LocalDateTime triggerBeginTime = sysDataPullConfig.getTriggerBeginTime();
        if (HussarUtils.isNotEmpty((Object)triggerBeginTime)) {
            firstExecuteTime = triggerBeginTime;
        }
        if (HussarUtils.isEmpty((Object)firstExecuteTime)) {
            return null;
        }
        sysDataPullTask.setFirstExecuteTime(firstExecuteTime);
        sysDataPullTask.setRepeatRule(sysDataPullConfig.getRepeatMode());
        sysDataPullTask.setEndExecuteTime(this.handleEndReminderTime(sysDataPullConfig));
        LocalDateTime nextReminderTime = this.handleNextReminderTime(sysDataPullTask, now);
        if (HussarUtils.isEmpty((Object)nextReminderTime)) {
            return null;
        }
        sysDataPullTask.setNextExecuteTime(nextReminderTime);
        return sysDataPullTask;
    }

    private LocalDateTime handleNextReminderTime(SysDataPullTask sysDataPullTask, LocalDateTime currentTime) {
        RepeatRule repeatRule = (RepeatRule)JSON.parseObject((String)sysDataPullTask.getRepeatRule(), RepeatRule.class);
        LocalDateTime nextReminderTime = repeatRule.calculateNextReminderTime(sysDataPullTask.getFirstExecuteTime(), currentTime);
        if (HussarUtils.isNotEmpty((Object)sysDataPullTask.getEndExecuteTime()) && nextReminderTime.isAfter(sysDataPullTask.getEndExecuteTime()) || nextReminderTime.isBefore(currentTime)) {
            return null;
        }
        return nextReminderTime;
    }

    private LocalDateTime handleEndReminderTime(SysDataPullConfig config) {
        RepeatRule repeatRule = (RepeatRule)JSON.parseObject((String)config.getRepeatMode(), RepeatRule.class);
        if (repeatRule.getType().equals("only_once")) {
            return null;
        }
        String triggerEndTimeSet = config.getTriggerEndTimeSet();
        if ("1".equals(triggerEndTimeSet)) {
            LocalDateTime triggerEndTime = config.getTriggerEndTime();
            return triggerEndTime;
        }
        return null;
    }

    private void handleCommonPart(SysDataPullConfig sysDataPullConfig, SysDataPullTask sysDataPullTask) {
        try {
            BeanUtils.copyProperties((Object)sysDataPullTask, (Object)sysDataPullConfig);
        }
        catch (Exception e) {
            LOGGER.error("\u6570\u636e\u62c9\u53d6\u516c\u5171\u4fe1\u606f\u62f7\u8d1d\u5f02\u5e38\uff1a" + e);
        }
        sysDataPullTask.setAppId(sysDataPullConfig.getAppId());
        sysDataPullTask.setFormId(sysDataPullConfig.getFormId());
        sysDataPullTask.setConfigId(sysDataPullConfig.getId());
        sysDataPullTask.setEndExecuteTimeSet(sysDataPullConfig.getTriggerEndTimeSet());
        sysDataPullTask.setStatus("0");
    }

    private LocalDateTime handleNextExecuteTime(SysDataPullTask sysDataPullTask, LocalDateTime currentTime) {
        SysDataPullRepeatRule repeatRule = (SysDataPullRepeatRule)JSON.parseObject((String)sysDataPullTask.getRepeatRule(), SysDataPullRepeatRule.class);
        LocalDateTime nextExecuteTime = repeatRule.calculateNextReminderTime(sysDataPullTask.getFirstExecuteTime(), currentTime);
        if (HussarUtils.isNotEmpty((Object)sysDataPullTask.getEndExecuteTime()) && nextExecuteTime.isAfter(sysDataPullTask.getEndExecuteTime()) || nextExecuteTime.isBefore(currentTime)) {
            return null;
        }
        return nextExecuteTime;
    }
}

