/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppCommonService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppCommonVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicFilterService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysUpAppVisitRoleFieldService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.ButtonVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.DataLogicAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FieldAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.OrganDataAuthorityFeignVo;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.AppMenuVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysSiftGroupList;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.sysApplicationExternalServiceImpl")
public class SysApplicationExternalServiceImpl
implements ISysApplicationExternalService {
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysAppCommonService sysAppCommonService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysAppVisitRoleButtonService roleButtonService;
    @Resource
    private ISysUpAppVisitRoleFieldService roleFieldService;
    @Resource
    private ISysAppVisitRoleOrganDataAuthorityService roleOrganDataAuthorityService;
    @Resource
    private ISysAppVisitDataLogicService dataLogicService;
    @Resource
    private ISysAppVisitDataLogicFilterService sysAppVisitDataLogicFilterService;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService;

    public List<SysAppGroupVo> getAppList(String appName) {
        return this.applicationService.getAppList(appName);
    }

    public List<SysAppCommonVo> getCommonAppList(String platform) {
        return this.sysAppCommonService.getCommonAppList(platform);
    }

    public List<AppMenuVo> getFormMenuList(Long appId) {
        return (List)this.sysFormService.getFormMenuList(appId).getData();
    }

    public SysForm getFormDetailById(Long formId) {
        return (SysForm)this.sysFormService.getDetailById(formId).getData();
    }

    public SysApplicationVo getAppDetailById(Long appId) {
        return (SysApplicationVo)this.applicationService.getAppDetail(appId).getData();
    }

    public SysApplicationVo getAuthorityAppDetailById(Long appId) {
        return this.applicationService.getAuthorityAppDetail(appId);
    }

    public List<ButtonVo> formAuthorityButton(Long formId, List<SysCustomButton> customButtonList) {
        return (List)this.roleButtonService.formAuthorityButton(formId, customButtonList).getData();
    }

    public List<ButtonVo> formAuthorityButton(Long formId) {
        return (List)this.roleButtonService.formAuthorityButton(formId).getData();
    }

    public List<ButtonVo> formAuthorityButton(SysForm sysForm, SysApplicationVo sysApplicationVo) {
        return (List)this.roleButtonService.formAuthorityButton(sysForm, sysApplicationVo).getData();
    }

    public List<FieldAuthorityVo> formAuthorityField(Long formId) {
        return (List)this.roleFieldService.formAuthorityField(formId).getData();
    }

    public List<FieldAuthorityVo> formAuthorityField(SysForm sysForm, SysApplicationVo sysApplication) {
        return (List)this.roleFieldService.formAuthorityField(sysForm, sysApplication).getData();
    }

    public OrganDataAuthorityFeignVo formAuthorityOrganData(Long formId) {
        return (OrganDataAuthorityFeignVo)this.roleOrganDataAuthorityService.formAuthorityOrganData(formId).getData();
    }

    public List<DataLogicAuthorityVo> formAuthorityDataLogic(Long formId) {
        return (List)this.dataLogicService.dataLogicAuthorityByFormId(formId).getData();
    }

    public ApiResponse<Long> addForm(SysFormDto sysFormDto) {
        return this.sysFormService.addForm(sysFormDto);
    }

    public ApiResponse<SysSiftGroupList> getFormListByAppId(Long appId) {
        return ApiResponse.success((Object)this.sysFormService.getFormList(null, null, null, appId));
    }

    public ApiResponse<List<SysAppGroupVo>> getAuthorityAppList() {
        return ApiResponse.success((Object)this.applicationService.getManageAppList(null, null, null));
    }

    public ApiResponse<List<SysApplicationVo>> getAppContainFormInfoList() {
        return ApiResponse.success((Object)this.applicationService.getAppContainFormInfoList());
    }

    public ApiResponse<Boolean> deleteLogicFilterByIds(List<String> fieldIds, String formId) {
        return this.sysAppVisitDataLogicFilterService.deleteLogicFilterByIds(fieldIds, formId);
    }

    public ApiResponse<Boolean> checkRolePermissions(Long formId) {
        return this.sysAppVisitFormAuthorizeRolesService.checkRolePermissions(formId);
    }
}

