/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.sync.union.util;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesBoService;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicFilterService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysUpAppVisitRoleFieldService;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.form.enums.Button;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.sync.union.dto.ConversionProduct;
import com.jxdinfo.hussar.formdesign.application.sync.union.dto.CustomDataCondition;
import com.jxdinfo.hussar.formdesign.application.sync.union.util.SyncUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class SyncUnionConverter {
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private ISysFunctionsBoService functionsBoService;
    @Resource
    private ISysFunctionModulesBoService functionModulesBoService;
    @Resource
    private ISysResourceMosulesBoService resourceMosulesBoService;
    @Resource
    private ISysAppVisitRoleOrganDataAuthorityService roleOrganDataAuthorityService;
    @Resource
    private ISysUpAppVisitRoleFieldService roleFieldService;
    @Resource
    private ISysAppVisitDataLogicService dataLogicService;
    @Resource
    private ISysAppVisitDataLogicFilterService dataLogicFilterService;
    @Resource
    private NodeBusinessService nodeBusinessService;
    @Resource
    private ISysCustomButtonService customButtonService;
    private static final String NO_CODE_SOURCE = "noCode";

    public ConversionProduct appToModule(SysApplication app, ConversionProduct conversionProduct) {
        if (HussarUtils.isEmpty((Object)conversionProduct)) {
            conversionProduct = new ConversionProduct();
        }
        SysFunctionModules funModule = new SysFunctionModules();
        funModule.setId(app.getId());
        funModule.setFunctionModuleName(app.getAppName());
        funModule.setFunctionModuleCode(String.valueOf(app.getId()));
        funModule.setParentModuleId(Long.valueOf(1L));
        funModule.setSeq(this.functionModulesBoService.getMaxOrderByParentIdAndAppId(Long.valueOf(1L), Long.valueOf(1L)));
        funModule.setFunModSource(NO_CODE_SOURCE);
        conversionProduct.getFunctionModulesList().add(funModule);
        SysResourceModules resModule = new SysResourceModules();
        resModule.setId(app.getId());
        resModule.setModuleName(app.getAppName());
        resModule.setModuleCode(String.valueOf(app.getId()));
        resModule.setParentModuleId(Long.valueOf(1L));
        resModule.setSeq(this.resourceMosulesBoService.getMaxOrderByParentIdAndAppId(Long.valueOf(1L), Long.valueOf(1L)));
        resModule.setResModSource(NO_CODE_SOURCE);
        conversionProduct.getResourceModulesList().add(resModule);
        return conversionProduct;
    }

    public ConversionProduct formGroupToModule(SysFormGroup formGroup, ConversionProduct conversionProduct) {
        if (HussarUtils.isEmpty((Object)conversionProduct)) {
            conversionProduct = new ConversionProduct();
        }
        SysFunctionModules funModule = new SysFunctionModules();
        funModule.setId(formGroup.getId());
        funModule.setFunctionModuleName(formGroup.getGroupName());
        funModule.setFunctionModuleCode(String.valueOf(formGroup.getId()));
        funModule.setParentModuleId(formGroup.getAppId());
        funModule.setSeq(formGroup.getSeq());
        funModule.setFunModSource(NO_CODE_SOURCE);
        conversionProduct.getFunctionModulesList().add(funModule);
        SysResourceModules resModule = new SysResourceModules();
        resModule.setId(formGroup.getId());
        resModule.setModuleName(formGroup.getGroupName());
        resModule.setModuleCode(String.valueOf(formGroup.getId()));
        resModule.setParentModuleId(formGroup.getAppId());
        resModule.setSeq(formGroup.getSeq());
        resModule.setResModSource(NO_CODE_SOURCE);
        conversionProduct.getResourceModulesList().add(resModule);
        return conversionProduct;
    }

    public void formToModule(SysForm form, ConversionProduct conversionProduct) {
        Long parentModuleId = HussarUtils.isNotEmpty((Object)form.getFormGroupId()) ? form.getFormGroupId() : form.getAppId();
        SysFunctionModules funModule = new SysFunctionModules();
        funModule.setId(form.getId());
        funModule.setFunctionModuleName(form.getFormName());
        funModule.setFunctionModuleCode(String.valueOf(form.getId()));
        funModule.setParentModuleId(parentModuleId);
        funModule.setSeq(Integer.valueOf(form.getSeq()));
        funModule.setFunModSource(NO_CODE_SOURCE);
        conversionProduct.getFunctionModulesList().add(funModule);
        SysResourceModules resModule = new SysResourceModules();
        resModule.setId(form.getId());
        resModule.setModuleName(form.getFormName());
        resModule.setModuleCode(String.valueOf(form.getId()));
        resModule.setParentModuleId(parentModuleId);
        resModule.setSeq(Integer.valueOf(form.getSeq()));
        resModule.setResModSource(NO_CODE_SOURCE);
        conversionProduct.getResourceModulesList().add(resModule);
    }

    public void formToMenuRes(SysForm form, ConversionProduct conversionProduct) {
        SysResources res = new SysResources();
        res.setId(Long.valueOf(IdWorker.getId((Object)res)));
        res.setResourceName(form.getFormName());
        res.setResourceAlias(form.getFormName());
        res.setModuleId(form.getId());
        res.setPath(SyncUtil.asmResPath(form));
        res.setComponent(SyncUtil.asmResComponent(form));
        res.setResTypeId("res_menu");
        res.setStrategy("4");
        res.setResourceCode("menu_" + form.getId());
        res.setResSource(NO_CODE_SOURCE);
        res.setSeq(Integer.valueOf(conversionProduct.getResourceList().size() + 1));
        conversionProduct.getResourceList().add(res);
        conversionProduct.getMenuResIdMap().put(form.getId(), res.getId());
        SysFunctions fun = new SysFunctions();
        fun.setId(Long.valueOf(IdWorker.getId((Object)fun)));
        fun.setFunctionCode("menu_" + form.getId());
        fun.setFunctionModuleId(form.getId());
        fun.setFunctionName(form.getFormName());
        fun.setDefaultResourceId(res.getId());
        fun.setFunSource(NO_CODE_SOURCE);
        fun.setSeq(Integer.valueOf(conversionProduct.getFunctionList().size() + 1));
        conversionProduct.getFunctionList().add(fun);
        conversionProduct.getMenuFunIdMap().put(form.getId(), fun.getId());
        conversionProduct.getFunctionResourceList().add(this.newFunRes(fun.getId(), res.getId()));
    }

    public void formToElementRes(SysForm form, ConversionProduct conversionProduct) {
        List customButtons;
        Long formId = form.getId();
        conversionProduct.getElementFunMap().put(formId, new ArrayList());
        conversionProduct.getElementResMap().put(formId, new ArrayList());
        ArrayList<Button> buttons = new ArrayList<Button>();
        switch (form.getFormType()) {
            case "0": {
                buttons.add(Button.CREATE_OPERATE);
                buttons.add(Button.EDIT_OPERATE);
                buttons.add(Button.DELETE_OPERATE);
                buttons.add(Button.IMPORT_OPTION);
                buttons.add(Button.EXPORT_OPTION);
                buttons.add(Button.PRINT_OPERATE);
                buttons.add(Button.DOWNLOAD_OPERATE);
                break;
            }
            case "1": {
                buttons.add(Button.CREATE_OPERATE);
                buttons.add(Button.EDIT_OPERATE);
                buttons.add(Button.DELETE_OPERATE);
                buttons.add(Button.IMPORT_OPTION);
                buttons.add(Button.EXPORT_OPTION);
                buttons.add(Button.PRINT_OPERATE);
                buttons.add(Button.DOWNLOAD_OPERATE);
                buttons.add(Button.SUBMIT_OPERATE);
                buttons.add(Button.REJECT_OPERATE);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (HussarUtils.isNotEmpty(buttons)) {
            for (Button button : buttons) {
                SysResources elementRes = new SysResources();
                elementRes.setId(Long.valueOf(IdWorker.getId((Object)elementRes)));
                elementRes.setResourceName(button.getButtonName() + "\u6309\u94ae");
                elementRes.setResourceAlias(button.getButtonName() + "\u6309\u94ae");
                elementRes.setModuleId(form.getId());
                elementRes.setResTypeId("res_element");
                elementRes.setPermissions(button.getButtonCode());
                elementRes.setResourceCode("element_" + form.getId() + "_" + button.getButtonCode());
                elementRes.setParentResourceId(form.getId());
                elementRes.setResSource(NO_CODE_SOURCE);
                elementRes.setSeq(Integer.valueOf(conversionProduct.getResourceList().size() + 1));
                conversionProduct.getResourceList().add(elementRes);
                conversionProduct.getElementResMap().get(formId).add(elementRes);
                SysFunctions fun = new SysFunctions();
                fun.setId(Long.valueOf(IdWorker.getId((Object)fun)));
                fun.setFunctionCode("element_" + form.getId() + "_" + button.getButtonCode());
                fun.setFunctionModuleId(form.getId());
                fun.setFunctionName(button.getButtonName() + "\u529f\u80fd");
                fun.setFunSource(NO_CODE_SOURCE);
                fun.setSeq(Integer.valueOf(conversionProduct.getFunctionList().size() + 1));
                conversionProduct.getFunctionList().add(fun);
                conversionProduct.getElementFunMap().get(formId).add(fun);
                conversionProduct.getFunctionResourceList().add(this.newFunRes(fun.getId(), elementRes.getId()));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(customButtons = this.customButtonService.list((Wrapper)new LambdaQueryWrapper().eq(SysCustomButton::getFormId, (Object)form.getId()))))) {
            for (SysCustomButton customButton : customButtons) {
                String buttonCode = customButton.getAction();
                String buttonAlias = customButton.getAlias();
                SysFunctions fun = new SysFunctions();
                fun.setId(customButton.getId());
                fun.setFunctionCode("element_" + formId + "_" + buttonCode);
                fun.setFunctionModuleId(formId);
                fun.setFunctionName(buttonAlias + "\u529f\u80fd");
                fun.setFunSource(NO_CODE_SOURCE);
                fun.setSeq(Integer.valueOf(conversionProduct.getFunctionList().size() + 1));
                conversionProduct.getFunctionList().add(fun);
                conversionProduct.getElementFunMap().get(formId).add(fun);
                SysResources customButtonRes = new SysResources();
                customButtonRes.setId(customButton.getId());
                customButtonRes.setResourceName(buttonAlias);
                customButtonRes.setResourceAlias(buttonAlias);
                customButtonRes.setModuleId(formId);
                customButtonRes.setResTypeId("res_element");
                customButtonRes.setPermissions(buttonCode);
                customButtonRes.setResourceCode("element_" + formId + "_" + buttonCode);
                customButtonRes.setParentResourceId(formId);
                customButtonRes.setResSource(NO_CODE_SOURCE);
                customButtonRes.setSeq(Integer.valueOf(conversionProduct.getResourceList().size() + 1));
                conversionProduct.getResourceList().add(customButtonRes);
                conversionProduct.getElementResMap().get(formId).add(customButtonRes);
                conversionProduct.getFunctionResourceList().add(this.newFunRes(fun.getId(), customButtonRes.getId()));
            }
        }
    }

    public void formToDataRes(SysForm form, ConversionProduct conversionProduct) {
        Long menuFunId = conversionProduct.getMenuFunIdMap().get(form.getId());
        List<SysResources> dataResources = this.dataResToResource(form);
        if (HussarUtils.isNotEmpty(dataResources)) {
            conversionProduct.getResourceList().addAll(dataResources);
            conversionProduct.getDataResIdMap().put(form.getId(), dataResources.stream().map(SysResources::getId).collect(Collectors.toList()));
            for (SysResources resources : dataResources) {
                conversionProduct.getFunctionResourceList().add(this.newFunRes(menuFunId, resources.getId()));
            }
        }
    }

    public List<SysResources> dataResToResource(SysForm form) {
        ArrayList<SysResources> dataResources = new ArrayList<SysResources>(6);
        ArrayList<String> nodeNames = new ArrayList<String>();
        nodeNames.add("POST." + form.getAppId() + "." + form.getId() + ".TableQuery");
        nodeNames.add("POST." + form.getAppId() + "." + form.getId() + ".TableQueryAll");
        if ("0".equals(form.getFormType())) {
            nodeNames.add("POST." + form.getAppId() + "." + form.getId() + ".TableQueryjoiopt0oou9plqj559byloyqdj0dk31i");
        } else {
            nodeNames.add("POST." + form.getAppId() + "." + form.getId() + ".TableQuerye33a41s5fcl06btfvdc0qnbvqt9wd1h4");
            nodeNames.add("POST." + form.getAppId() + "." + form.getId() + ".TableQueryjvcdwume0vxztr0lfnp4doe8152rrdtz");
            nodeNames.add("POST." + form.getAppId() + "." + form.getId() + ".TableQuery5m3f3ywhll6fjnk916ywvqbfp11mu5bq");
            nodeNames.add("POST." + form.getAppId() + "." + form.getId() + ".TableQuery2is61eg3qeb3a662lsh6j385v2blbv24");
        }
        List tableQueryInterfaces = this.nodeBusinessService.list((Wrapper)new LambdaQueryWrapper().in(NodeBusiness::getNodeName, nodeNames));
        if (HussarUtils.isNotEmpty((Object)tableQueryInterfaces)) {
            for (NodeBusiness nodeBusiness : tableQueryInterfaces) {
                SysResources res = new SysResources();
                res.setId(Long.valueOf(IdWorker.getId((Object)res)));
                res.setResourceName(nodeBusiness.getNodeDec() + "\u6570\u636e\u8d44\u6e90");
                res.setResourceAlias(nodeBusiness.getNodeDec() + "\u6570\u636e\u8d44\u6e90");
                res.setModuleId(form.getId());
                res.setResTypeId("res_rights");
                res.setResourceCode(form.getId() + "_res_rights_" + SyncUtil.subNodeNameType(nodeBusiness.getNodeName()));
                res.setUserRight("data_holder");
                res.setDeptRight("data_organ");
                res.setMapper(nodeBusiness.getNodeName());
                res.setResSource(NO_CODE_SOURCE);
                dataResources.add(res);
            }
        }
        return dataResources;
    }

    public void authFormForAppDevRole(SysForm form, ConversionProduct conversionProduct) {
        Long appDevRoleId = this.sysApplicationBoService.selectById(form.getAppId()).getDevelopRoleId();
        List allFunIdsByForm = conversionProduct.getFunctionList().stream().map(SysFunctions::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty((Object)appDevRoleId) && HussarUtils.isNotEmpty(allFunIdsByForm)) {
            for (Long funId : allFunIdsByForm) {
                conversionProduct.getRoleFunctionList().add(this.newRoleFun(appDevRoleId, funId));
            }
        }
        List allResIdsByForm = conversionProduct.getResourceList().stream().map(SysResources::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty((Object)appDevRoleId) && HussarUtils.isNotEmpty(allResIdsByForm)) {
            for (Long resId : allResIdsByForm) {
                conversionProduct.getRoleResourceList().add(this.newRoleRes(appDevRoleId, resId));
            }
        }
    }

    public void formAuthToRelation(SysAppVisitFormAuthorizeRoles formAuth, ConversionProduct conversionProduct) {
        Long roleId = formAuth.getRoleId();
        Long formId = formAuth.getFormId();
        Long menuFunId = conversionProduct.getMenuFunIdMap().get(formId);
        Long menuResId = conversionProduct.getMenuResIdMap().get(formId);
        if (HussarUtils.isNotEmpty((Object)menuFunId) && HussarUtils.isNotEmpty((Object)menuResId)) {
            conversionProduct.getRoleFunctionList().add(this.newRoleFun(roleId, menuFunId));
            conversionProduct.getRoleResourceList().add(this.newRoleRes(roleId, menuResId));
            List<Long> dataResIdByForm = conversionProduct.getDataResIdMap().get(formId);
            if (HussarUtils.isNotEmpty(dataResIdByForm)) {
                for (Long dataResId : dataResIdByForm) {
                    conversionProduct.getRoleResourceList().add(this.newRoleRes(roleId, dataResId));
                }
            }
        }
    }

    public void buttonAuthToRelation(SysAppVisitRoleButton buttonAuth, ConversionProduct conversionProduct) {
        Long formId = buttonAuth.getFormId();
        Long roleId = buttonAuth.getRoleId();
        String buttonCode = buttonAuth.getButtonCode();
        Long menuFunId = conversionProduct.getMenuFunIdMap().get(formId);
        if (HussarUtils.isNotEmpty((Object)menuFunId)) {
            SysResources elementRes;
            String elementCode = "element_" + formId + "_" + buttonCode;
            SysFunctions elementFun = conversionProduct.getElementFunMap().get(formId).stream().filter(fun -> elementCode.equals(fun.getFunctionCode())).findFirst().orElse(null);
            if (HussarUtils.isNotEmpty((Object)elementFun)) {
                conversionProduct.getRoleFunctionList().add(this.newRoleFun(roleId, elementFun.getId()));
            }
            if (HussarUtils.isNotEmpty((Object)(elementRes = (SysResources)conversionProduct.getElementResMap().get(formId).stream().filter(res -> elementCode.equals(res.getResourceCode())).findFirst().orElse(null)))) {
                conversionProduct.getRoleResourceList().add(this.newRoleRes(roleId, elementRes.getId()));
            }
        }
    }

    public void dataAuthToRoleDataRight(SysAppVisitFormAuthorizeRoles formAuth, ConversionProduct conversionProduct) {
        SysRoleDataRight roleDataRight = new SysRoleDataRight();
        Long formId = formAuth.getFormId();
        Long roleId = formAuth.getRoleId();
        Long menuFunId = conversionProduct.getMenuFunIdMap().get(formId);
        if (HussarUtils.isNotEmpty((Object)menuFunId)) {
            List roleFields;
            SysAppVisitDataLogic dataLogic;
            roleDataRight.setRoleId(roleId);
            roleDataRight.setFunctionId(menuFunId);
            roleDataRight.setDataScope(Integer.valueOf("1"));
            roleDataRight.setResTypeCode("res_rights");
            roleDataRight.setDataScopeLabel("1");
            CustomDataCondition customDataCondition = new CustomDataCondition();
            SysAppVisitRoleOrganDataAuthority roleOrganDataAuth = (SysAppVisitRoleOrganDataAuthority)this.roleOrganDataAuthorityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId)).eq(SysAppVisitRoleOrganDataAuthority::getRoleId, (Object)roleId));
            if (HussarUtils.isNotEmpty((Object)roleOrganDataAuth)) {
                roleDataRight.setDataScope(this.covertDataScope(roleOrganDataAuth));
                roleDataRight.setDataScopeLabel(String.valueOf(this.covertDataScope(roleOrganDataAuth)));
                boolean customFlag = "5".equals(String.valueOf(roleDataRight.getDataScope()));
                if (customFlag) {
                    customDataCondition.setCustomOrganAndUserInfo(this.roleOrganAuthToCustomDataCondition(roleOrganDataAuth));
                }
            }
            if (HussarUtils.isNotEmpty((Object)(dataLogic = (SysAppVisitDataLogic)this.dataLogicService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getFormId, (Object)formId)).eq(SysAppVisitDataLogic::getRoleId, (Object)roleId))))) {
                customDataCondition.setDataLogic(this.dataLogicToCustomDataCondition(dataLogic));
            }
            if (HussarUtils.isNotEmpty((Object)(roleFields = this.roleFieldService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getFormId, (Object)formId)).eq(SysUpAppVisitRoleField::getRoleId, (Object)roleId))))) {
                customDataCondition.setFieldAuthority(this.roleFieldToCustomDataCondition(roleFields));
            }
            roleDataRight.setCustomDataCondition(JSON.toJSONString((Object)customDataCondition));
            conversionProduct.getRoleDataRightList().add(roleDataRight);
        }
    }

    private SysFunctionResources newFunRes(Long funId, Long resId) {
        SysFunctionResources functionResources = new SysFunctionResources();
        functionResources.setFunctionId(funId);
        functionResources.setResourceId(resId);
        return functionResources;
    }

    private SysRoleFunctions newRoleFun(Long roleId, Long funId) {
        SysRoleFunctions sysRoleFunctions = new SysRoleFunctions();
        sysRoleFunctions.setRoleId(roleId);
        sysRoleFunctions.setFunctionId(funId);
        return sysRoleFunctions;
    }

    private SysRoleResource newRoleRes(Long roleId, Long resId) {
        SysRoleResource sysRoleResource = new SysRoleResource();
        sysRoleResource.setRoleId(roleId);
        sysRoleResource.setResourceId(resId);
        sysRoleResource.setRelationSource("1");
        return sysRoleResource;
    }

    public SysRoleDataRight dataAuthToRoleDataRight(Long formId, Long roleId) {
        List roleFields;
        SysAppVisitDataLogic dataLogic;
        SysRoleDataRight roleDataRight = new SysRoleDataRight();
        roleDataRight.setRoleId(roleId);
        roleDataRight.setFunctionId(this.getMenuFunId(formId));
        roleDataRight.setDataScope(Integer.valueOf("1"));
        roleDataRight.setResTypeCode("res_rights");
        roleDataRight.setDataScopeLabel("1");
        CustomDataCondition customDataCondition = new CustomDataCondition();
        SysAppVisitRoleOrganDataAuthority roleOrganDataAuth = (SysAppVisitRoleOrganDataAuthority)this.roleOrganDataAuthorityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId)).eq(SysAppVisitRoleOrganDataAuthority::getRoleId, (Object)roleId));
        if (HussarUtils.isNotEmpty((Object)roleOrganDataAuth)) {
            roleDataRight.setDataScope(this.covertDataScope(roleOrganDataAuth));
            roleDataRight.setDataScopeLabel(String.valueOf(this.covertDataScope(roleOrganDataAuth)));
            boolean customFlag = "5".equals(String.valueOf(roleDataRight.getDataScope()));
            if (customFlag) {
                customDataCondition.setCustomOrganAndUserInfo(this.roleOrganAuthToCustomDataCondition(roleOrganDataAuth));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(dataLogic = (SysAppVisitDataLogic)this.dataLogicService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getFormId, (Object)formId)).eq(SysAppVisitDataLogic::getRoleId, (Object)roleId))))) {
            customDataCondition.setDataLogic(this.dataLogicToCustomDataCondition(dataLogic));
        }
        if (HussarUtils.isNotEmpty((Object)(roleFields = this.roleFieldService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getFormId, (Object)formId)).eq(SysUpAppVisitRoleField::getRoleId, (Object)roleId))))) {
            customDataCondition.setFieldAuthority(this.roleFieldToCustomDataCondition(roleFields));
        }
        roleDataRight.setCustomDataCondition(JSON.toJSONString((Object)customDataCondition));
        return roleDataRight;
    }

    private Integer covertDataScope(SysAppVisitRoleOrganDataAuthority roleOrganAuth) {
        String dataScope = HussarUtils.equals((Object)"1", (Object)roleOrganAuth.getOnlyIndividuals()) ? "4" : (HussarUtils.equals((Object)"1", (Object)roleOrganAuth.getOnlySupOrgan()) ? "3" : (HussarUtils.equals((Object)"1", (Object)roleOrganAuth.getAllOrgan()) ? "1" : "5"));
        return Integer.valueOf(dataScope);
    }

    private CustomDataCondition.CustomOrganAndUserInfo roleOrganAuthToCustomDataCondition(SysAppVisitRoleOrganDataAuthority roleOrganAuth) {
        CustomDataCondition.CustomOrganAndUserInfo customOrganAndUserInfo = new CustomDataCondition.CustomOrganAndUserInfo();
        customOrganAndUserInfo.setOrganIdList(roleOrganAuth.getOrganIdList());
        customOrganAndUserInfo.setUserIdList(roleOrganAuth.getUserIdList());
        return customOrganAndUserInfo;
    }

    private CustomDataCondition.DataLogic dataLogicToCustomDataCondition(SysAppVisitDataLogic dataLogicNo) {
        CustomDataCondition.DataLogic dataLogicLow = new CustomDataCondition.DataLogic();
        dataLogicLow.setCombineType(dataLogicNo.getCombineType());
        List dataLogicFilters = this.dataLogicFilterService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogicFilter::getRoleDataLogicId, (Object)dataLogicNo.getId()));
        if (HussarUtils.isNotEmpty((Object)dataLogicFilters)) {
            ArrayList<CustomDataCondition.DataLogic.Filter> filters = new ArrayList<CustomDataCondition.DataLogic.Filter>(dataLogicFilters.size());
            for (SysAppVisitDataLogicFilter dataLogicFilter : dataLogicFilters) {
                CustomDataCondition.DataLogic.Filter filter = new CustomDataCondition.DataLogic.Filter();
                filter.setFieldId(dataLogicFilter.getFieldId());
                filter.setFieldName(dataLogicFilter.getFieldName());
                filter.setFilterConditionCode(dataLogicFilter.getFilterConditionCode());
                filter.setFilterConditionName(dataLogicFilter.getFilterConditionName());
                filter.setFilterValue(dataLogicFilter.getFilterValue());
                filters.add(filter);
            }
            dataLogicLow.setFilters(filters);
        }
        return dataLogicLow;
    }

    private CustomDataCondition.FieldAuthority roleFieldToCustomDataCondition(List<SysUpAppVisitRoleField> roleFields) {
        CustomDataCondition.FieldAuthority fieldAuthority = new CustomDataCondition.FieldAuthority();
        ArrayList<CustomDataCondition.FieldAuthority.Rule> rules = new ArrayList<CustomDataCondition.FieldAuthority.Rule>(roleFields.size());
        for (SysUpAppVisitRoleField roleField : roleFields) {
            CustomDataCondition.FieldAuthority.Rule rule = new CustomDataCondition.FieldAuthority.Rule();
            rule.setRoleFieldId(roleField.getId());
            rule.setFieldId(roleField.getFieldId());
            rule.setFieldName(roleField.getFieldName());
            rule.setCanRead(roleField.getCanRead());
            rule.setCanWrite(roleField.getCanWrite());
            rule.setParentId(roleField.getParentId());
            rules.add(rule);
        }
        fieldAuthority.setRules(rules);
        return fieldAuthority;
    }

    public Long getMenuFunId(Long formId) {
        String eleCode = "menu_" + formId;
        SysFunctions function = this.functionsBoService.getOneByCode(eleCode);
        return HussarUtils.isNotEmpty((Object)function) ? function.getId() : null;
    }

    public SysFunctions systemButtonToFunction(Button systemButton, Long formId) {
        SysFunctions fun = new SysFunctions();
        fun.setFunctionCode("element_" + formId + "_" + systemButton.getButtonCode());
        fun.setFunctionModuleId(formId);
        fun.setFunctionName(systemButton.getButtonName() + "\u529f\u80fd");
        return fun;
    }

    public SysResources systemButtonToResource(Button systemButton, Long formId) {
        SysResources elementRes = new SysResources();
        elementRes.setResourceName(systemButton.getButtonName() + "\u6309\u94ae");
        elementRes.setResourceAlias(systemButton.getButtonName() + "\u6309\u94ae");
        elementRes.setModuleId(formId);
        elementRes.setResTypeId("res_element");
        elementRes.setPermissions(systemButton.getButtonCode());
        elementRes.setResourceCode("element_" + formId + "_" + systemButton.getButtonCode());
        elementRes.setParentResourceId(formId);
        return elementRes;
    }
}

