/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtFormAuthorityDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdFormAuthorityService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ThirdFormAuthorityServiceImpl
implements IThirdFormAuthorityService {
    @Resource
    private ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService;
    @Resource
    private ISysFormService sysFormService;
    public static final String FORM_AUTH_ADD = "add";
    public static final String FORM_AUTH_DEL = "del";

    @Override
    public ApiResponse<Boolean> formAuthorize(List<ExtFormAuthorityDto> extFormAuthorityDto) {
        if (HussarUtils.isNotEmpty(extFormAuthorityDto)) {
            ArrayList<SysAppVisitFormAuthorizeRoles> addAuthList = new ArrayList<SysAppVisitFormAuthorizeRoles>();
            ArrayList<SysAppVisitFormAuthorizeRoles> delAuthList = new ArrayList<SysAppVisitFormAuthorizeRoles>();
            Map<Long, Long> formAppIdMap = this.getFormAppIdMap(extFormAuthorityDto.stream().map(ExtFormAuthorityDto::getFormId).collect(Collectors.toList()));
            for (ExtFormAuthorityDto formAuthorityDto : extFormAuthorityDto) {
                SysAppVisitFormAuthorizeRoles formAuthorizeRoles = new SysAppVisitFormAuthorizeRoles();
                formAuthorizeRoles.setFormId(formAuthorityDto.getFormId());
                formAuthorizeRoles.setRoleId(formAuthorityDto.getRoleId());
                formAuthorizeRoles.setAppId(formAppIdMap.get(formAuthorityDto.getFormId()));
                if (FORM_AUTH_ADD.equals(formAuthorityDto.getAuthType())) {
                    addAuthList.add(formAuthorizeRoles);
                    continue;
                }
                if (!FORM_AUTH_DEL.equals(formAuthorityDto.getAuthType())) continue;
                delAuthList.add(formAuthorizeRoles);
            }
            if (HussarUtils.isNotEmpty(addAuthList)) {
                this.sysAppVisitFormAuthorizeRolesService.saveBatch(addAuthList);
            }
            if (HussarUtils.isNotEmpty(delAuthList)) {
                List roleIdList = delAuthList.stream().map(SysAppVisitFormAuthorizeRoles::getRoleId).collect(Collectors.toList());
                List formIdList = delAuthList.stream().map(SysAppVisitFormAuthorizeRoles::getFormId).collect(Collectors.toList());
                this.sysAppVisitFormAuthorizeRolesService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysAppVisitFormAuthorizeRoles::getRoleId, roleIdList)).in(SysAppVisitFormAuthorizeRoles::getFormId, formIdList));
            }
        }
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    private Map<Long, Long> getFormAppIdMap(List<Long> formIdList) {
        HashMap<Long, Long> formAppIdMap = new HashMap<Long, Long>();
        List sysForms = this.sysFormService.listByIds(formIdList);
        sysForms.forEach(sysForm -> formAppIdMap.put(sysForm.getId(), sysForm.getAppId()));
        return formAppIdMap;
    }
}

