/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.message.middle;

import com.jxdinfo.hussar.formdesign.application.message.middle.RepeatRule;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class EndReminderTime {
    private String mode;
    private String customTime;
    private String maxReminderCount;
    public static final String CUSTOM = "custom";
    public static final String MAX_REMINDER = "maxReminder";

    public LocalDateTime calculate(LocalDateTime firstReminderTime, RepeatRule repeatRule) {
        switch (this.mode) {
            case "custom": {
                return this.custom();
            }
            case "maxReminder": {
                return this.maxReminder(firstReminderTime, repeatRule);
            }
        }
        throw new HussarException("\u6d88\u606f\u63a8\u9001 => \u7ed3\u675f\u63d0\u9192\u65f6\u95f4\u914d\u7f6e\u4e0d\u7b26\u5408\u89c4\u8303");
    }

    private LocalDateTime custom() {
        if (HussarUtils.isNotEmpty((Object)this.customTime)) {
            return LocalDateTime.parse(this.customTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return null;
    }

    private LocalDateTime maxReminder(LocalDateTime firstReminderTime, RepeatRule repeatRule) {
        if (HussarUtils.isNotEmpty((Object)this.maxReminderCount)) {
            int maxCount = Integer.parseInt(this.maxReminderCount);
            switch (repeatRule.getType()) {
                case "only_once": {
                    return null;
                }
                case "daily": {
                    return firstReminderTime.plusDays(maxCount - 1);
                }
                case "weekly": {
                    return firstReminderTime.plusWeeks(maxCount - 1);
                }
                case "monthly": {
                    LocalDateTime endReminderTime = firstReminderTime.plusMonths(maxCount - 1);
                    int dayOfMonth = firstReminderTime.getDayOfMonth();
                    int length = endReminderTime.getMonth().length(endReminderTime.toLocalDate().isLeapYear());
                    return endReminderTime.withDayOfMonth(Math.min(dayOfMonth, length));
                }
                case "yearly": {
                    LocalDateTime endReminderTime = firstReminderTime.plusYears(maxCount - 1);
                    int dayOfMonthForYearly = firstReminderTime.getDayOfMonth();
                    int lengthForYearly = endReminderTime.getMonth().length(endReminderTime.toLocalDate().isLeapYear());
                    return endReminderTime.withDayOfMonth(Math.min(dayOfMonthForYearly, lengthForYearly));
                }
                case "custom": {
                    return this.customForMaxCount(firstReminderTime, repeatRule);
                }
            }
        }
        return null;
    }

    private LocalDateTime customForMaxCount(LocalDateTime firstReminderTime, RepeatRule repeatRule) {
        String customType;
        int maxCount = Integer.parseInt(this.maxReminderCount);
        switch (customType = repeatRule.getCustomType()) {
            case "by_week": {
                LocalDateTime nextReminderTime = firstReminderTime;
                List<Integer> daysOfWeek = repeatRule.getDaysOfWeek();
                int plusWeeks = 0;
                int firstIndex = -1;
                for (int i = 0; i < daysOfWeek.size(); ++i) {
                    if (daysOfWeek.get(i) < firstReminderTime.getDayOfWeek().getValue()) continue;
                    firstIndex = i;
                    break;
                }
                if (firstIndex == -1) {
                    firstIndex = 0;
                    plusWeeks = 1;
                }
                int selectDayOfWeek = daysOfWeek.get((firstIndex + maxCount - 1) % daysOfWeek.size());
                return nextReminderTime.plusWeeks(plusWeeks += (firstIndex + maxCount - 1) / daysOfWeek.size()).with(DayOfWeek.of(selectDayOfWeek));
            }
            case "by_month": {
                boolean relativeRepeat = repeatRule.isRelativeRepeat();
                if (relativeRepeat) {
                    LocalDateTime nextReminderTime = firstReminderTime.plusMonths(maxCount - 1);
                    int length = nextReminderTime.getMonth().length(nextReminderTime.toLocalDate().isLeapYear());
                    return nextReminderTime.withDayOfMonth(length);
                }
                List<Integer> daysOfMonth = repeatRule.getDaysOfMonth();
                int day = firstReminderTime.getDayOfMonth();
                int firstIndexByMonth = -1;
                for (int i = 0; i < daysOfMonth.size(); ++i) {
                    if (daysOfMonth.get(i) < day) continue;
                    firstIndexByMonth = i;
                    break;
                }
                int plusMonths = 0;
                if (firstIndexByMonth == -1) {
                    firstIndexByMonth = 0;
                    plusMonths = 1;
                }
                int selectDayOfMonth = daysOfMonth.get((firstIndexByMonth + maxCount - 1) % daysOfMonth.size());
                LocalDate resultDate = firstReminderTime.toLocalDate().plusMonths(plusMonths += (firstIndexByMonth + maxCount - 1) / daysOfMonth.size());
                int length = resultDate.getMonth().length(resultDate.isLeapYear());
                resultDate = resultDate.withDayOfMonth(Math.min(selectDayOfMonth, length));
                return LocalDateTime.of(resultDate, firstReminderTime.toLocalTime());
            }
        }
        throw new HussarException("\u6d88\u606f\u63a8\u9001 => \u7ed3\u675f\u63d0\u9192\u65f6\u95f4\u89e3\u6790\u5931\u8d25");
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getCustomTime() {
        return this.customTime;
    }

    public void setCustomTime(String customTime) {
        this.customTime = customTime;
    }

    public String getMaxReminderCount() {
        return this.maxReminderCount;
    }

    public void setMaxReminderCount(String maxReminderCount) {
        this.maxReminderCount = maxReminderCount;
    }
}

