/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.ChildFormImportProperties;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.ExcelCreateImportProperties;
import com.jxdinfo.hussar.formdesign.app.frame.api.module.SysExcelTaskNoCode;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.ISysExcelTaskNoCodeService;
import com.jxdinfo.hussar.formdesign.app.frame.server.enmus.ExcelFormatEnum;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.CreateForByExcelImport;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExcelExport;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExcelImport;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.form.enums.ExcelCellDataTypeEnum;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormCreateByExcelService;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportCellVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportDataVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportResult;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportRowVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportSheetVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormCreateByExcelVo;
import com.jxdinfo.hussar.formdesign.application.properties.HussarFormDesignProperties;
import com.jxdinfo.hussar.formdesign.application.util.ExcelCellTypeAnalysisUtil;
import com.jxdinfo.hussar.formdesign.application.util.SysNoCodeFileUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormCreateByExcelServiceImpl")
public class FormCreateByExcelServiceImpl
implements IFormCreateByExcelService {
    private static Logger logger = LoggerFactory.getLogger(FormCreateByExcelServiceImpl.class);
    private static final int MAX_FILE_SIZE = 5;
    private static final String EXCEL_SUFFIX_REG = ".+\\.(?i)(xls|xlsx)$";
    private static final int EXCEL_COUNT_NUM = 50000;
    private static final int EXCEL_COUNT_CELL_NUM = 150;
    private static final int EXCEL_IMPORT_PREVIEWNUM = 100;
    private static final String EXCEL_SHEET_HIDDEN_NAME_REG = "dict_hide_sheet\\d+";
    private static final String CACHE_NAME_NUM = "excel\u5bfc\u5165\u521b\u5efa\u8868\u5355\u4e2a\u6570";
    private static final String CACHE_EXCEL_IMPORT_PROCESS = "excel\u5bfc\u5165\u8fdb\u5ea6";
    private static final String EXCEL_MODEL_TYPE_EXCELCREATE = "1";
    private static final String EXCEL_MODEL_TYPE_CHILD = "2";
    @Resource
    private HussarFormDesignProperties hussarFormDesignProperties;
    @Resource
    private ExcelImport excelImport;
    @Resource
    private ExcelExport excelExport;
    @Resource
    private CreateForByExcelImport createForByExcelImport;
    @Resource
    private ISysExcelTaskNoCodeService sysExcelTaskNoCodeService;
    @Resource
    private IHussarAppFormService appFormService;

    public ApiResponse<ExcelImportDataVo> excelImportUploadContainsCheckFile(MultipartFile file) {
        return this.excelImportUploadContainsCheckFile(file, 5, 50000, 150, 100, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<ExcelImportDataVo> excelImportUploadContainsCheckFile(MultipartFile file, int maxFileSize, int maxRow, int maxCell, int maxPreviewnum, boolean cacheFile) {
        if (file.isEmpty()) {
            return ApiResponse.fail((String)"\u6587\u4ef6\u5185\u5bb9\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (file.getOriginalFilename() == null || !file.getOriginalFilename().matches(".+\\.(?i)(xls|xlsx)$")) {
            excelType = file.getOriginalFilename().split(".")[1];
            return ApiResponse.fail((String)("\u6682\u4e0d\u652f\u6301" + excelType + "\u7c7b\u578b\u7684\u6587\u4ef6"));
        }
        if (file.getSize() > (long)(maxFileSize * 1024 * 1024)) {
            return ApiResponse.fail((String)("\u6587\u4ef6" + file.getOriginalFilename() + "\u8fc7\u5927,\u4e0a\u4f20\u5931\u8d25"));
        }
        excelImportDataVo = new ExcelImportDataVo();
        inputStream = null;
        try {
            inputStream = (FileInputStream)file.getInputStream();
            list = new ArrayList<ExcelImportSheetVo>();
            fileName = file.getOriginalFilename();
            startTime = System.currentTimeMillis();
            workbook = ExcelFormatEnum.getWorkbook((String)fileName, (InputStream)inputStream);
            FormCreateByExcelServiceImpl.logger.info("\u4e0a\u4f20\u6587\u4ef6\u83b7\u53d6excel\u5de5\u4f5c\u7c3f\uff0c\u8017\u65f6\u3010{}\u3011ms", (Object)(System.currentTimeMillis() - startTime));
            checkFileEmptyFlag = true;
            numberOfSheets = workbook.getNumberOfSheets();
            sheetIndex = 0;
lbl20:
            // 2 sources

            while (true) {
                block54: {
                    block57: {
                        block56: {
                            block55: {
                                if (sheetIndex >= numberOfSheets) break block54;
                                excelImportSheetVo = new ExcelImportSheetVo();
                                sheet = workbook.getSheetAt(sheetIndex);
                                if (sheet.getSheetName().matches("dict_hide_sheet\\d+")) ** GOTO lbl160
                                excelImportSheetVo.setSheetIndex(sheetIndex);
                                excelImportSheetVo.setSheetName(HussarUtils.isNotEmpty((Object)sheet.getSheetName().trim()) != false ? sheet.getSheetName() : "\u672a\u547d\u540d\u8868\u5355");
                                checkSheetEmptyFlag = this.checkSheetEmpty(sheet);
                                if (!checkSheetEmptyFlag && checkFileEmptyFlag) {
                                    checkFileEmptyFlag = false;
                                }
                                if (!checkSheetEmptyFlag) break block55;
                                excelImportSheetVo.setCheckFlag(false);
                                excelImportSheetVo.setCheckMsg("Sheet\u9875:" + sheet.getSheetName() + "\u4e3a\u7a7a");
                                list.add(excelImportSheetVo);
                                ** GOTO lbl160
                            }
                            if (sheet.getNumMergedRegions() <= 0) break block56;
                            excelImportSheetVo.setCheckFlag(false);
                            excelImportSheetVo.setCheckMsg("Sheet\u9875:" + sheet.getSheetName() + "\u4e2d\u5b58\u5728\u5408\u5e76\u5355\u5143\u683c");
                            list.add(excelImportSheetVo);
                            ** GOTO lbl160
                        }
                        if (sheet.getLastRowNum() <= maxRow) break block57;
                        excelImportSheetVo.setCheckFlag(false);
                        excelImportSheetVo.setCheckMsg("Sheet\u9875:" + sheet.getSheetName() + "\u7684\u6570\u636e\u4e0d\u80fd\u8d85\u8fc7" + maxRow + "\u884c");
                        list.add(excelImportSheetVo);
                        ** GOTO lbl160
                    }
                    firstRowCellNum = 0;
                    for (Object row : sheet) {
                        if (this.checkRowEmpty((Row)row)) continue;
                        firstRowCellNum = row.getLastCellNum();
                        break;
                    }
                    notEmptyRowNum = 0;
                    row = sheet.iterator();
                    while (row.hasNext()) {
                        row = (Row)row.next();
                        isEmpty = true;
                        for (Cell cell : row) {
                            if (null == cell || cell.getCellType() == CellType.BLANK || !HussarUtils.isNotEmpty((Object)this.createForByExcelImport.getCellValue(cell).trim())) continue;
                            isEmpty = false;
                            break;
                        }
                        if (isEmpty) continue;
                        ++notEmptyRowNum;
                    }
                    if (firstRowCellNum > maxCell) {
                        excelImportSheetVo.setCheckFlag(false);
                        excelImportSheetVo.setCheckMsg("Sheet\u9875:" + sheet.getSheetName() + "\u7684\u6570\u636e\u4e0d\u80fd\u8d85\u8fc7" + maxCell + "\u5217");
                        list.add(excelImportSheetVo);
                    } else {
                        excelImportSheetVo.setSheetIndex(sheetIndex);
                        rowList = new ArrayList<ExcelImportRowVo>();
                        getFirstNotEmptyRow = true;
                        findNotEmptyRowFlag = false;
                        firstNotEmptyRowNum = 0;
                        maxCellNum = 0;
                        minCellNum = 0;
                        effectiveRowNum = 0;
                        break;
                    }
                }
                if (checkFileEmptyFlag) {
                    sheetIndex = ApiResponse.fail((String)"\u6587\u4ef6\u5185\u5bb9\u4e0d\u53ef\u4e3a\u7a7a");
                    return sheetIndex;
                }
                if (CollectionUtil.isNotEmpty(list)) {
                    fileCheckFlag = false;
                    mergeCellSum = 0;
                    for (ExcelImportSheetVo importSheetT : list) {
                        if (importSheetT.isCheckFlag()) {
                            fileCheckFlag = true;
                            continue;
                        }
                        if (!importSheetT.getCheckMsg().contains("\u5b58\u5728\u5408\u5e76\u5355\u5143\u683c")) continue;
                        ++mergeCellSum;
                    }
                    if (list.size() == mergeCellSum) {
                        var18_25 = ApiResponse.fail((String)"\u6587\u4ef6\u4e2d\u5b58\u5728\u5408\u5e76\u5355\u5143\u683c,\u89e3\u6790\u5931\u8d25");
                        return var18_25;
                    }
                    if (!fileCheckFlag) {
                        if (list.size() == 1) {
                            var18_25 = ApiResponse.fail((String)((ExcelImportSheetVo)list.get(0)).getCheckMsg());
                            return var18_25;
                        }
                        var18_25 = ApiResponse.fail((String)"\u6587\u4ef6\u4e0d\u7b26\u5408\u89c4\u8303");
                        return var18_25;
                    }
                }
                excelImportDataVo.setSheets(list);
                if (cacheFile) {
                    this.cacheFile(file, fileName, excelImportDataVo);
                }
                var16_20 = ApiResponse.success((Object)excelImportDataVo);
                return var16_20;
            }
        }
        catch (IOException e) {
            var10_12 = ApiResponse.fail((String)"\u89e3\u6790excle\u6587\u4ef6\u53d1\u751f\u5f02\u5e38");
            return var10_12;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException var11_14) {}
            }
        }
        for (i = 0; i <= maxPreviewnum - 1; ++i) {
            rowT = sheet.getRow(i);
            emptyRowFlag = this.createForByExcelImport.isRowEmpty(rowT);
            if (!emptyRowFlag) {
                if (maxCellNum < rowT.getLastCellNum()) {
                    maxCellNum = rowT.getLastCellNum();
                }
                var32_48 = rowT.iterator();
            } else {
                if (!findNotEmptyRowFlag) continue;
                break;
            }
            while (var32_48.hasNext()) {
                cell = (Cell)var32_48.next();
                if (null == cell || cell.getCellType() == CellType.BLANK) continue;
                if (getFirstNotEmptyRow) {
                    minCellNum = cell.getColumnIndex();
                    firstNotEmptyRowNum = rowT.getRowNum();
                    getFirstNotEmptyRow = false;
                    continue;
                }
                if (minCellNum <= cell.getColumnIndex()) continue;
                minCellNum = cell.getColumnIndex();
            }
            findNotEmptyRowFlag = true;
            effectiveRowNum = rowT.getRowNum();
        }
        effectiveRowNum = effectiveRowNum < maxPreviewnum ? effectiveRowNum : maxPreviewnum;
        i = firstNotEmptyRowNum;
        while (true) {
            if (i <= effectiveRowNum) {
                excelImportRowVo = new ExcelImportRowVo();
                cells = new ArrayList<ExcelImportCellVo>();
                row = sheet.getRow(i);
            } else {
                if (HussarUtils.isNotEmpty((Object)excelImportSheetVo) && CollectionUtil.isNotEmpty(rowList)) {
                    excelImportSheetVo.setRows(rowList);
                    excelImportSheetVo.setRealRows(notEmptyRowNum);
                    excelImportSheetVo.setCheckFlag(true);
                    list.add(excelImportSheetVo);
                }
lbl160:
                // 8 sources

                ++sheetIndex;
                ** continue;
            }
            for (j = minCellNum; j < maxCellNum; ++j) {
                excelImportCellVo = new ExcelImportCellVo();
                cellValue = HussarUtils.isNotEmpty((Object)row) != false ? this.createForByExcelImport.getCellValue(row.getCell(j)) : "";
                excelImportCellVo.setRow(i);
                excelImportCellVo.setCol(j);
                excelImportCellVo.setValue(cellValue);
                excelImportCellVo.setFieldType(this.getCellDataTypeByCellValue(cellValue));
                cells.add(excelImportCellVo);
            }
            excelImportRowVo.setCells(cells);
            rowList.add(excelImportRowVo);
            ++i;
        }
    }

    private boolean checkRowEmpty(Row row) {
        boolean checkRowEmptyFlag = true;
        for (Cell cell : row) {
            if (null == cell || cell.getCellType() == CellType.BLANK || !HussarUtils.isNotEmpty((Object)this.createForByExcelImport.getCellValue(cell).trim())) continue;
            return false;
        }
        return checkRowEmptyFlag;
    }

    private boolean checkSheetEmpty(Sheet sheet) {
        boolean checkSheetEmptyFlag = true;
        for (Row row : sheet) {
            boolean checkRowEmptyFlag = this.checkRowEmpty(row);
            if (checkRowEmptyFlag) continue;
            return false;
        }
        return checkSheetEmptyFlag;
    }

    public ApiResponse<ExcelImportDataVo> excelImportWhite(MultipartFile file) {
        return this.excelImportUploadContainsCheckFile(file, 5, 50000, 150, 50000, false);
    }

    public ApiResponse excelDownloadTemplate(String langCode, HttpServletResponse response) {
        List<String> titles = Arrays.asList("\u59d3\u540d", "\u5e74\u9f84", "\u6027\u522b", "\u5bb6\u5ead\u4f4f\u5740", "\u51fa\u751f\u65e5\u671f");
        try {
            return this.excelDownload(titles, null, langCode, response, EXCEL_MODEL_TYPE_EXCELCREATE);
        }
        catch (IOException e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    public ApiResponse<Long> createForm(FormCreateByExcelVo formCreateByExcelVo) {
        AssertUtil.isNotEmpty((String)formCreateByExcelVo.getAppId(), (String)"\u5e94\u7528ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        AssertUtil.isNotEmpty((Collection)formCreateByExcelVo.getExcelImports(), (String)"\u6807\u9898\u884c\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        Long taskId = System.currentTimeMillis() + (long)new Random().nextInt();
        this.createTask(taskId, formCreateByExcelVo);
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        TransmittableThreadLocalHolder.set((String)"loginUserDetails", (Object)userDetails);
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)BaseSecurityUtil.getUser());
        String dataSourceKey = DataModelUtil.currentDsName();
        HussarNoCodeThreadUtil.executeUserTask(() -> this.createForByExcelImport.createFormAndImportData(formCreateByExcelVo, taskId, userDetails, dataSourceKey));
        return ApiResponse.success((Object)taskId);
    }

    public ApiResponse<ExcelImportResult> queryCreateResult(Long taskId) {
        ExcelImportResult result = new ExcelImportResult();
        SysExcelTaskNoCode excelTaskById = (SysExcelTaskNoCode)this.sysExcelTaskNoCodeService.getById((Serializable)taskId);
        if (0 == excelTaskById.getTaskStatus()) {
            result.setTaskStatus(Integer.valueOf(0));
            result.setResultDesc((String)HussarCacheUtil.get((String)CACHE_EXCEL_IMPORT_PROCESS, (Object)taskId));
        } else if (4 == excelTaskById.getTaskStatus()) {
            int successNum = excelTaskById.getDataSuccess();
            int failNum = excelTaskById.getDataError();
            int successFormNum = (Integer)HussarCacheUtil.get((String)CACHE_NAME_NUM, (Object)taskId);
            String tipName = excelTaskById.getExcelName();
            if (tipName.endsWith(".xls")) {
                tipName = tipName.substring(0, tipName.length() - 4);
            } else if (tipName.endsWith(".xlsx")) {
                tipName = tipName.substring(0, tipName.length() - 5);
            }
            result.setTaskStatus(Integer.valueOf(4));
            StringBuilder sb = new StringBuilder();
            if (failNum > 0) {
                result.setErrorFlag(true);
                sb.append("\u6210\u529f\u5bfc\u5165\uff1a").append(tipName).append("\u3002").append("\u5171\u751f\u6210").append(successFormNum).append("\u4e2a\u8868\u5355\uff0c").append("\u5bfc\u5165\u6210\u529f\u6570\u636e").append(successNum).append("\u6761\u3002").append("\u5931\u8d25").append(failNum).append("\u6761\u3002\u70b9\u51fb\u4e0b\u8f7d\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u3002");
            } else {
                result.setErrorFlag(false);
                sb.append("\u6210\u529f\u5bfc\u5165\uff1a").append(tipName).append("\u3002").append("\u5171\u751f\u6210").append(successFormNum).append("\u4e2a\u8868\u5355\uff0c").append("\u5bfc\u5165\u6210\u529f\u6570\u636e").append(successNum).append("\u6761\u3002");
            }
            result.setResultDesc(sb.toString());
        } else if (-1 == excelTaskById.getTaskStatus()) {
            return ApiResponse.fail((String)excelTaskById.getErrorMsg());
        }
        return ApiResponse.success((Object)result);
    }

    public void download(Long taskId, HttpServletResponse response) {
        SysExcelTaskNoCode excelTaskById = (SysExcelTaskNoCode)this.sysExcelTaskNoCodeService.getById((Serializable)taskId);
        if (HussarUtils.isEmpty((Object)excelTaskById.getExcelName())) {
            return;
        }
        String fileName = excelTaskById.getExcelName();
        String fileSuffix = null;
        if (fileName.endsWith(".xls")) {
            fileSuffix = ".xls";
            fileName = fileName.substring(0, fileName.length() - 4);
        } else if (fileName.endsWith(".xlsx")) {
            fileSuffix = ".xlsx";
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        String downloadFileName = FileUtil.posixPath((String[])new String[]{this.hussarFormDesignProperties.getWorkspace(), "import", fileName + "_\u6821\u9a8c\u7ed3\u679c_" + taskId + fileSuffix});
        fileName = fileName + "_\u6821\u9a8c\u7ed3\u679c" + fileSuffix;
        ServletOutputStream os = null;
        FileInputStream fis = null;
        try {
            os = response.getOutputStream();
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setContentType("multipart/form-data");
            fis = new FileInputStream(downloadFileName);
            IOUtils.copy((InputStream)fis, (OutputStream)os);
        }
        catch (IOException e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ApiResponse excelDownloadTemplateWhite(List<String> titiles, String sheetName, String langCode, HttpServletResponse response) {
        try {
            return this.excelDownload(titiles, sheetName, langCode, response, EXCEL_MODEL_TYPE_CHILD);
        }
        catch (IOException e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    public void removeCheckFile(Long taskId) {
        SysExcelTaskNoCode excelTaskById = (SysExcelTaskNoCode)this.sysExcelTaskNoCodeService.getById((Serializable)taskId);
        if (HussarUtils.isEmpty((Object)excelTaskById.getExcelName())) {
            return;
        }
        String fileName = excelTaskById.getExcelName();
        String fileSuffix = null;
        if (fileName.endsWith(".xls")) {
            fileSuffix = ".xls";
            fileName = fileName.substring(0, fileName.length() - 4);
        } else if (fileName.endsWith(".xlsx")) {
            fileSuffix = ".xlsx";
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        String checkFileName = FileUtil.posixPath((String[])new String[]{this.hussarFormDesignProperties.getWorkspace(), "import", fileName + "_\u6821\u9a8c\u7ed3\u679c_" + taskId + fileSuffix});
        SysNoCodeFileUtil.removeFileByPath((String)checkFileName);
    }

    private ApiResponse excelDownload(List<String> titiles, String sheetName, String langCode, HttpServletResponse response, String modelType) throws IOException {
        sheetName = HussarUtils.isNotEmpty((Object)sheetName) ? sheetName : "\u8868\u5355\u6570\u636e\u5bfc\u5165";
        langCode = HussarUtils.isNotEmpty((Object)langCode) ? langCode : "zh-CN";
        ArrayList headers = Lists.newArrayListWithCapacity((int)1);
        List<ExcelImportCellVo> cellVos = this.getExcelImportCellVosByTitles(titiles);
        headers.add(cellVos);
        List headers2 = null;
        List exampleDataList = null;
        if (modelType.equals(EXCEL_MODEL_TYPE_EXCELCREATE)) {
            Map exampleDataParse = ExcelCreateImportProperties.exampleDataMap;
            String jsonString = JSON.toJSONString((Object)exampleDataParse);
            Map exampleDataMap = (Map)JSON.parse((String)jsonString);
            logger.info("before==>exampleDataMap:{}", (Object)exampleDataMap);
            this.appFormService.handleExampleData(exampleDataMap, langCode, ExcelCreateImportProperties.exampleDefaultDataMap);
            logger.info("after==>exampleDataMap:{}", (Object)exampleDataMap);
            Map exampleTitleParse = ExcelCreateImportProperties.exampleTitleMap;
            String jsonString1 = JSON.toJSONString((Object)exampleTitleParse);
            Map exampleTitleMap = (Map)JSON.parse((String)jsonString1);
            logger.info("before==>exampleTitleMap:{}", (Object)exampleTitleMap);
            this.appFormService.handleExampleData(exampleTitleMap, langCode, ExcelCreateImportProperties.exampleDefaultTitleMap);
            logger.info("after==>exampleTitleMap:{}", (Object)exampleTitleMap);
            long time2 = System.currentTimeMillis();
            JSONObject example = this.excelImport.createExampleHeadersAndData(exampleDataMap, exampleTitleMap);
            long time3 = System.currentTimeMillis();
            logger.info("\u751f\u6210\u793a\u4f8b\u6570\u636e\u8017\u65f6\uff1a{}", (Object)(time3 - time2));
            headers2 = (List)example.get((Object)"exampleHeaderList");
            exampleDataList = (List)example.get((Object)"exampleDataList");
        } else if (modelType.equals(EXCEL_MODEL_TYPE_CHILD)) {
            Map exampleDataParse = ChildFormImportProperties.exampleDataMap;
            String jsonString = JSON.toJSONString((Object)exampleDataParse);
            Map exampleDataMap = (Map)JSON.parse((String)jsonString);
            logger.info("before==>exampleDataMap:{}", (Object)exampleDataMap);
            this.appFormService.handleExampleData(exampleDataMap, langCode, ChildFormImportProperties.exampleDefaultDataMap);
            logger.info("after==>exampleDataMap:{}", (Object)exampleDataMap);
            Map exampleTitleParse = ChildFormImportProperties.exampleTitleMap;
            String jsonString1 = JSON.toJSONString((Object)exampleTitleParse);
            Map exampleTitleMap = (Map)JSON.parse((String)jsonString1);
            logger.info("before==>exampleTitleMap:{}", (Object)exampleTitleMap);
            this.appFormService.handleExampleData(exampleTitleMap, langCode, ChildFormImportProperties.exampleDefaultTitleMap);
            logger.info("after==>exampleTitleMap:{}", (Object)exampleTitleMap);
            long time2 = System.currentTimeMillis();
            JSONObject example = this.excelImport.createExampleHeadersAndData(exampleDataMap, exampleTitleMap);
            long time3 = System.currentTimeMillis();
            logger.info("\u751f\u6210\u793a\u4f8b\u6570\u636e\u8017\u65f6\uff1a{}", (Object)(time3 - time2));
            headers2 = (List)example.get((Object)"exampleHeaderList");
            exampleDataList = (List)example.get((Object)"exampleDataList");
        }
        this.createForByExcelImport.exportForImport(sheetName, (List)headers, null, headers2, exampleDataList, "\u6807\u51c6\u5bfc\u5165\u6a21\u677f.xlsx", langCode, response);
        return ApiResponse.success();
    }

    private List<ExcelImportCellVo> getExcelImportCellVosByTitles(List<String> titiles) {
        ArrayList cellVos = Lists.newArrayListWithCapacity((int)5);
        for (String str : titiles) {
            ExcelImportCellVo c = new ExcelImportCellVo();
            if (HussarUtils.isNotEmpty((Object)str)) {
                c.setValue(str);
            }
            cellVos.add(c);
        }
        return cellVos;
    }

    private void createTask(Long taskId, FormCreateByExcelVo formCreateByExcelVo) {
        String fileSuffix = null;
        String excelName = formCreateByExcelVo.getCacheKey();
        if (excelName.endsWith(".xls")) {
            fileSuffix = ".xls";
        } else if (excelName.endsWith(".xlsx")) {
            fileSuffix = ".xlsx";
        }
        SysExcelTaskNoCode sysExcelTask = new SysExcelTaskNoCode();
        sysExcelTask.setId(taskId);
        sysExcelTask.setTaskStatus(Integer.valueOf(0));
        sysExcelTask.setExcelName(formCreateByExcelVo.getAppName() + fileSuffix);
        this.sysExcelTaskNoCodeService.save((Object)sysExcelTask);
    }

    private String getCellDataTypeByCellValue(String cellValue) {
        if (HussarUtils.isNotEmpty((Object)cellValue)) {
            if (ExcelCellTypeAnalysisUtil.analysisNumber((String)cellValue)) {
                return ExcelCellDataTypeEnum.KEY_INTEGER.getDesc();
            }
            if (ExcelCellTypeAnalysisUtil.analysisDate((String)cellValue)) {
                return ExcelCellDataTypeEnum.KEY_DATE.getDesc();
            }
            if (ExcelCellTypeAnalysisUtil.analysisDateTime((String)cellValue)) {
                return ExcelCellDataTypeEnum.KEY_DATETIME.getDesc();
            }
            return ExcelCellDataTypeEnum.KEY_VARCHAR.getDesc();
        }
        return ExcelCellDataTypeEnum.KEY_VARCHAR.getDesc();
    }

    private void cacheFile(MultipartFile file, String fileName, ExcelImportDataVo excelImportDataVo) throws IOException {
        String suffixName = fileName.substring(fileName.lastIndexOf("."));
        fileName = UUID.randomUUID() + suffixName;
        String filePath = FileUtil.posixPath((String[])new String[]{this.hussarFormDesignProperties.getWorkspace(), "import"});
        File newFile = new File(filePath);
        if (!newFile.exists()) {
            newFile.mkdirs();
        }
        file.transferTo(new File(FileUtil.posixPath((String[])new String[]{filePath, fileName})));
        excelImportDataVo.setCacheKey(fileName);
    }
}

