/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.print.strategy.widgetstrategy;

import com.jxdinfo.hussar.formdesign.application.print.enums.NumberType;
import com.jxdinfo.hussar.formdesign.application.print.enums.WidgetProps;
import com.jxdinfo.hussar.formdesign.application.print.strategy.IWidgetStrategy;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import java.text.DecimalFormat;
import org.springframework.stereotype.Component;

@Component
public class NumberStrategy
implements IWidgetStrategy {
    @Override
    public WidgetType getWidgetType() {
        return WidgetType.NUMBER;
    }

    @Override
    public Object deal(EngineResultEntity entity, Widget widget) {
        if (HussarUtils.isEmpty((Object)entity.get((Object)widget.getName()))) {
            return "";
        }
        double number = Double.parseDouble(String.valueOf(entity.get((Object)widget.getName())));
        int decimalNum = Integer.parseInt(widget.getProps().get((Object)WidgetProps.DECIMAL_NUM.getName()).toString());
        String showType = widget.getProps().get((Object)WidgetProps.SHOW_TYPE.getName()).toString();
        String prefix = (String)widget.getProps().get((Object)WidgetProps.PREFIX.getName());
        String suffix = (String)widget.getProps().get((Object)WidgetProps.SUFFIX.getName());
        boolean thousandth = (Boolean)widget.getProps().get((Object)WidgetProps.THOUSANDTH.getName());
        String format = this.showPrefix(showType, prefix) + this.showThousandth(thousandth) + this.showDecimalPoint(decimalNum) + this.showDecimal(decimalNum) + this.showPercent(showType) + this.showSuffix(showType, suffix);
        return new DecimalFormat(format).format(number);
    }

    private String showPrefix(String showType, String prefix) {
        return NumberType.NUMBER.getType().equals(showType) ? prefix : "";
    }

    private String showSuffix(String showType, String suffix) {
        return NumberType.NUMBER.getType().equals(showType) ? suffix : "";
    }

    private String showThousandth(boolean thousandth) {
        return thousandth ? "###,###" : "#";
    }

    private String showDecimalPoint(int decimalNum) {
        return decimalNum > 0 ? "." : "";
    }

    private String showDecimal(int decimalNum) {
        StringBuilder format = new StringBuilder();
        for (int i = 0; i < decimalNum; ++i) {
            format.append("0");
        }
        return format.toString();
    }

    private String showPercent(String showType) {
        return NumberType.PERCENT.getType().equals(showType) ? "%" : "";
    }
}

