/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.formLink.controller;

import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppLinkInnerService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkOpenService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleInnerService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleService;
import com.jxdinfo.hussar.formdesign.application.properties.HussarNocodePublicProperties;
import com.jxdinfo.hussar.formdesign.application.util.NoCodeSecurityUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="com.jxdinfo.hussar.formdesign.application.formLink.controller.RedirectController")
@RequestMapping(value={"/public_release"})
public class RedirectController {
    @Autowired
    private ISysFormLinkService sysFormLinkService;
    @Autowired
    private ISysFormLinkSingleService sysFormLinkSingleService;
    @Autowired
    private ISysFormLinkSingleInnerService sysFormLinkSingleInnerService;
    @Autowired
    private ISysFormLinkOpenService sysFormLinkOpenService;
    @Autowired
    private ISysAppLinkInnerService sysAppLinkInnerService;
    @Autowired(required=false)
    private ISysTenantService sysTenantService;
    @Resource
    private HussarNocodePublicProperties hussarNocodePublicProperties;

    @GetMapping(path={"/appLinkInner/{shortLink}"})
    @ApiOperation(value="\u5e94\u7528\u8bbf\u95ee\u94fe\u63a5\u91cd\u5b9a\u5411", notes="\u5e94\u7528\u8bbf\u95ee\u94fe\u63a5\u91cd\u5b9a\u5411")
    public String appInnerRedirect(@ApiParam(value="\u5e94\u7528\u8bbf\u95ee\u77ed\u94fe\u63a5") @PathVariable(value="shortLink") String shortLink, HttpServletRequest request, @RequestParam(required=false) String tcode) {
        NoCodeSecurityUtil.setLoginInfo(null, (String)tcode);
        tcode = this.getConnNameByTcode(tcode);
        String redirect = this.sysAppLinkInnerService.redirectInner(shortLink, request);
        String longIp = "redirect:" + this.hussarNocodePublicProperties.getFrontIp();
        if (HussarUtils.isNotEmpty((Object)redirect)) {
            if (HussarUtils.isNotEmpty((Object)tcode) && !tcode.equals("master")) {
                return longIp + redirect + "&tcode=" + tcode;
            }
            return longIp + redirect;
        }
        return longIp + "/public/#/404";
    }

    @GetMapping(path={"/link/{shortLink}"})
    @ApiOperation(value="\u8868\u5355\u586b\u5199\u5916\u94fe\u91cd\u5b9a\u5411", notes="\u8868\u5355\u586b\u5199\u5916\u94fe\u91cd\u5b9a\u5411")
    public String formLinkRedirect(@ApiParam(value="\u8868\u5355\u5916\u94fe\u77ed\u94fe\u63a5") @PathVariable(value="shortLink") String shortLink, @RequestParam(required=false) String tcode) {
        String trim;
        int index;
        if (HussarUtils.isNotEmpty((Object)tcode) && (index = (trim = tcode.replaceAll(" ", "")).indexOf("\u5bc6")) != -1) {
            tcode = trim.substring(0, index);
        }
        tcode = this.getConnNameByTcode(tcode);
        String redirect = this.sysFormLinkService.redirect(shortLink, tcode);
        String longIp = "redirect:" + this.hussarNocodePublicProperties.getFrontIp();
        if (HussarUtils.isNotEmpty((Object)redirect)) {
            if (HussarUtils.isNotEmpty((Object)tcode) && !tcode.equals("master")) {
                return longIp + redirect + '/' + shortLink + "?tcode=" + tcode;
            }
            return longIp + redirect + '/' + shortLink;
        }
        return longIp + "/public/#/404";
    }

    @GetMapping(path={"/singleLink/{shortLink}"})
    @ApiOperation(value="\u8868\u5355\u5355\u6761\u6570\u636e\u5916\u94fe\u91cd\u5b9a\u5411", notes="\u8868\u5355\u5355\u6761\u6570\u636e\u5916\u94fe\u91cd\u5b9a\u5411")
    public String formSingleLinkRedirect(@ApiParam(value="\u8868\u5355\u5355\u6761\u6570\u636e\u77ed\u94fe\u63a5") @PathVariable(value="shortLink") String shortLink, @RequestParam(required=false) String tcode) {
        String trim;
        int index;
        if (HussarUtils.isNotEmpty((Object)tcode) && (index = (trim = tcode.replaceAll(" ", "")).indexOf("\u5bc6")) != -1) {
            tcode = trim.substring(0, index);
        }
        tcode = this.getConnNameByTcode(tcode);
        String redirect = this.sysFormLinkSingleService.redirect(shortLink, tcode);
        String longIp = "redirect:" + this.hussarNocodePublicProperties.getFrontIp();
        if (HussarUtils.isNotEmpty((Object)redirect)) {
            if (HussarUtils.isNotEmpty((Object)tcode) && !tcode.equals("master")) {
                return longIp + redirect + '/' + shortLink + "?tcode=" + tcode;
            }
            return longIp + redirect + '/' + shortLink;
        }
        return longIp + "/public/#/404";
    }

    @GetMapping(path={"/singleLink/inner/{shortLink}"})
    @ApiOperation(value="\u8868\u5355\u5355\u6761\u6570\u636e\u5e94\u7528\u5185\u94fe\u63a5\u91cd\u5b9a\u5411", notes="\u8868\u5355\u5355\u6761\u6570\u636e\u5e94\u7528\u5185\u94fe\u63a5\u91cd\u5b9a\u5411")
    public String formSingleLinkInnerRedirect(@ApiParam(value="\u8868\u5355\u5355\u6761\u6570\u636e\u77ed\u94fe\u63a5") @PathVariable(value="shortLink") String shortLink, HttpServletRequest request) {
        String redirect = this.sysFormLinkSingleInnerService.redirectInner(shortLink, request);
        String longIp = "redirect:" + this.hussarNocodePublicProperties.getFrontIp();
        return redirect != null ? longIp + redirect : longIp + "/public/#/404";
    }

    @GetMapping(path={"/openLink/{shortLink}"})
    @ApiOperation(value="\u8868\u5355\u516c\u5f00\u67e5\u8be2\u5916\u94fe\u91cd\u5b9a\u5411", notes="\u8868\u5355\u516c\u5f00\u67e5\u8be2\u5916\u94fe\u91cd\u5b9a\u5411")
    public String formOpenLinkRedirect(@ApiParam(value="\u8868\u5355\u516c\u5f00\u67e5\u8be2\u77ed\u94fe\u63a5") @PathVariable(value="shortLink") String shortLink, @RequestParam(required=false) String tcode) {
        String trim;
        int index;
        if (HussarUtils.isNotEmpty((Object)tcode) && (index = (trim = tcode.replaceAll(" ", "")).indexOf("\u5bc6")) != -1) {
            tcode = trim.substring(0, index);
        }
        tcode = this.getConnNameByTcode(tcode);
        String redirect = this.sysFormLinkOpenService.redirect(shortLink, tcode);
        String longIp = "redirect:" + this.hussarNocodePublicProperties.getFrontIp();
        if (HussarUtils.isNotEmpty((Object)redirect)) {
            if (HussarUtils.isNotEmpty((Object)tcode) && !tcode.equals("master")) {
                return longIp + redirect + '/' + shortLink + "?tcode=" + tcode;
            }
            return longIp + redirect + '/' + shortLink;
        }
        return longIp + "/public/#/404";
    }

    private String getConnNameByTcode(String tcode) {
        boolean tenantOpen = TenantCacheUtil.openTenant();
        if (tenantOpen) {
            HussarTenantDefinition tenantByTenantCode = this.sysTenantService.getTenantByTenantCode(tcode);
            if (HussarUtils.isNotEmpty((Object)tenantByTenantCode)) {
                HussarContextHolder.setTenant((HussarTenantDefinition)tenantByTenantCode);
                return tenantByTenantCode.getConnName();
            }
            return null;
        }
        return null;
    }
}

