/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.formLink.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.application.application.enums.NoFieldControlEnum;
import com.jxdinfo.hussar.formdesign.application.application.enums.SysFormLinkEnum;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.formLink.FieldControlUtil;
import com.jxdinfo.hussar.formdesign.application.formLink.dao.SysFormLinkOpenMapper;
import com.jxdinfo.hussar.formdesign.application.formLink.dto.SysFormLinkOpenDto;
import com.jxdinfo.hussar.formdesign.application.formLink.model.SysFormLinkOpen;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkOpenService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.formLink.vo.SysFormLinkOpenQueryFieldVo;
import com.jxdinfo.hussar.formdesign.application.formLink.vo.SysFormLinkOpenVo;
import com.jxdinfo.hussar.formdesign.application.print.model.SysPrintTemplate;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.print.util.PrintTemplateUtil;
import com.jxdinfo.hussar.formdesign.application.print.vo.SysPrintTemplateVo;
import com.jxdinfo.hussar.formdesign.application.properties.HussarNocodePublicProperties;
import com.jxdinfo.hussar.formdesign.application.properties.RedirectProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControl;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SettingService;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.RandomType;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.formLink.service.impl.SysFormLinkOpenServiceImpl")
public class SysFormLinkOpenServiceImpl
extends HussarServiceImpl<SysFormLinkOpenMapper, SysFormLinkOpen>
implements ISysFormLinkOpenService {
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Resource
    private SysFormLinkOpenMapper sysFormLinkOpenMapper;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private SettingService settingService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private ISysFormLinkService sysFormLinkService;
    @Resource
    private HussarNocodePublicProperties hussarNocodePublicProperties;
    @Resource
    private RedirectProperties redirectProperties;

    public ApiResponse<SysFormLinkOpenVo> addFormLinkOpen(SysFormLinkOpenDto sysFormLinkOpenDto, HttpServletRequest request) {
        String tcode;
        Long formId = sysFormLinkOpenDto.getFormId();
        if (HussarUtils.isNull((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFormLinkOpen::getFormId, (Object)formId);
        SysFormLinkOpen sysFormLinkOpen = (SysFormLinkOpen)this.getOne((Wrapper)queryWrapper);
        if (!HussarUtils.isNull((Object)sysFormLinkOpen)) {
            String tcode2;
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.set(SysFormLinkOpen::getLinkStatus, (Object)SysFormLinkEnum.OPEN_LINK_OPEN.getValue())).eq(SysFormLinkOpen::getLinkId, (Object)sysFormLinkOpen.getLinkId());
            boolean flag = this.update((Wrapper)updateWrapper);
            if (!flag) {
                throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
            }
            SysFormLinkOpenVo sysFormLinkOpenVo = new SysFormLinkOpenVo(sysFormLinkOpen);
            this.getPrintContents(sysFormLinkOpenVo);
            sysFormLinkOpenVo.setLinkStatus(SysFormLinkEnum.OPEN_LINK_OPEN.getValue());
            String shortLinks = this.hussarNocodePublicProperties.getFrontIp() + "/" + this.redirectProperties.getPublicOpen() + sysFormLinkOpenVo.getLinkShortAddress();
            if (HussarUtils.isNotEmpty((Object)request) && HussarUtils.isNotEmpty((Object)(tcode2 = request.getHeader("Tcode")))) {
                shortLinks = shortLinks + "?tcode=" + tcode2;
            }
            sysFormLinkOpenVo.setShortLink(shortLinks);
            return ApiResponse.success((Object)sysFormLinkOpenVo, (String)"\u8868\u5355\u516c\u5f00\u5916\u94fe\u5df2\u5b58\u5728");
        }
        long linkId = IdWorker.getId((Object)sysFormLinkOpenDto);
        sysFormLinkOpenDto.setLinkId(Long.valueOf(linkId));
        sysFormLinkOpenDto.setHasPass(SysFormLinkEnum.LINKPASS_CLOSE.getValue());
        String shortLink = this.generateShortLink();
        sysFormLinkOpenDto.setLinkShortAddress(shortLink);
        sysFormLinkOpenDto.setHasFieldControl(SysFormLinkEnum.OPEN_NO_FIELD_CONTROL.getValue());
        ArrayList fieldControlList = new ArrayList();
        SysForm sysForm = (SysForm)this.sysFormService.getDetailById(formId).getData();
        if (SysFormLinkEnum.FLOW_FORM.getValue().toString().equals(sysForm.getFormType())) {
            List editBpmFiledControl = this.sysFormLinkService.getEditBpmFiledControl(formId, sysForm.getAppId());
            fieldControlList.addAll(editBpmFiledControl);
        } else {
            List editFiledControl = this.sysFormLinkService.getEditFiledControl(formId);
            fieldControlList.addAll(editFiledControl);
        }
        fieldControlList.forEach(fieldControl -> {
            fieldControl.setWitable(false);
            fieldControl.setRequired(false);
            fieldControl.getChildren().forEach(fieldControlChildren -> {
                fieldControlChildren.setRequired(false);
                fieldControlChildren.setWitable(false);
            });
        });
        String jsonString = JSON.toJSONString(fieldControlList);
        sysFormLinkOpenDto.setLinkShow(jsonString);
        boolean flag = this.save((BaseEntity)sysFormLinkOpenDto);
        if (!flag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25");
        }
        SysFormLinkOpen formLinkOpen = (SysFormLinkOpen)this.getById(Long.valueOf(linkId));
        SysFormLinkOpenVo sysFormLinkOpenVo = new SysFormLinkOpenVo(formLinkOpen);
        this.getPrintContents(sysFormLinkOpenVo);
        String formName = this.getFormName(sysFormLinkOpenDto.getFormId());
        sysFormLinkOpenVo.setFormName(formName);
        String shortLinks = this.hussarNocodePublicProperties.getFrontIp() + "/" + this.redirectProperties.getPublicOpen() + formLinkOpen.getLinkShortAddress();
        if (HussarUtils.isNotEmpty((Object)request) && HussarUtils.isNotEmpty((Object)(tcode = request.getHeader("Tcode")))) {
            shortLinks = shortLinks + "?tcode=" + tcode;
        }
        sysFormLinkOpenVo.setShortLink(shortLinks);
        return ApiResponse.success((Object)sysFormLinkOpenVo);
    }

    public ApiResponse<SysFormLinkOpenVo> editFormLinkOpen(SysFormLinkOpenDto sysFormLinkOpenDto, HttpServletRequest request) {
        boolean flag;
        SysFormLinkOpenVo fromLinkOpenByFromId = this.sysFormLinkOpenMapper.getFromLinkOpenByFromId(sysFormLinkOpenDto.getFormId());
        if (HussarUtils.isNull((Object)fromLinkOpenByFromId)) {
            throw new BaseException("\u8868\u5355\u516c\u5f00\u5916\u94fe\u4e0d\u5b58\u5728");
        }
        if (sysFormLinkOpenDto.isRefresh()) {
            sysFormLinkOpenDto.setLinkShortAddress(this.generateShortLink());
        }
        if (fromLinkOpenByFromId.getHasPass().intValue() == SysFormLinkEnum.CLOSED.getValue().intValue() && sysFormLinkOpenDto.getHasPass().intValue() == SysFormLinkEnum.OPENED.getValue().intValue()) {
            sysFormLinkOpenDto.setLinkPass(HussarUtils.random((int)6, (RandomType)RandomType.ALL));
        }
        if (sysFormLinkOpenDto.isRefreshPass()) {
            sysFormLinkOpenDto.setLinkPass(HussarUtils.random((int)6, (RandomType)RandomType.ALL));
        }
        if (!(flag = this.updateById((BaseEntity)sysFormLinkOpenDto))) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
        }
        return ApiResponse.success((Object)this.getFormLinkOpenDetail(sysFormLinkOpenDto.getFormId(), request).getData(), (String)"\u4fdd\u5b58\u6210\u529f");
    }

    public ApiResponse<Boolean> deleteFormLinkOpen(Long linkId) {
        boolean flag = this.removeById(linkId);
        if (!flag) {
            throw new BaseException("\u5220\u9664\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    public ApiResponse<SysFormLinkOpenVo> getFormLinkOpenDetail(Long formId, HttpServletRequest request) {
        String tcode;
        if (HussarUtils.isEmpty((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFormLinkOpen::getFormId, (Object)formId);
        SysFormLinkOpen sysFormLinkOpen = (SysFormLinkOpen)this.getOne((Wrapper)queryWrapper);
        SysFormLinkOpenVo sysFormLinkOpenVo = new SysFormLinkOpenVo();
        String formName = this.getFormName(formId);
        if (HussarUtils.isNull((Object)sysFormLinkOpen)) {
            sysFormLinkOpenVo.setFormName(formName);
            return ApiResponse.success((Object)sysFormLinkOpenVo, (String)"\u8be5\u516c\u5f00\u67e5\u8be2\u5916\u94fe\u4e0d\u5b58\u5728");
        }
        BeanUtil.copy((Object)sysFormLinkOpen, (Object)sysFormLinkOpenVo);
        this.getPrintContents(sysFormLinkOpenVo);
        sysFormLinkOpenVo.setFormName(formName);
        sysFormLinkOpenVo.setType("o");
        String shortLink = this.hussarNocodePublicProperties.getFrontIp() + "/" + this.redirectProperties.getPublicOpen() + sysFormLinkOpenVo.getLinkShortAddress();
        if (HussarUtils.isNotEmpty((Object)request) && HussarUtils.isNotEmpty((Object)(tcode = request.getHeader("Tcode")))) {
            shortLink = shortLink + "?tcode=" + tcode;
        }
        sysFormLinkOpenVo.setShortLink(shortLink);
        return ApiResponse.success((Object)sysFormLinkOpenVo);
    }

    private void getPrintContents(SysFormLinkOpenVo sysFormLinkOpenVo) {
        JSONArray jsonArray;
        String printIdArr = sysFormLinkOpenVo.getPrintIdArr();
        if (HussarUtils.isNotEmpty((Object)printIdArr) && HussarUtils.isNotEmpty((Object)(jsonArray = JSON.parseArray((String)printIdArr)))) {
            ApiResponse sysPrintTemplateVoApiResponse;
            SysPrintTemplateVo data;
            ArrayList printIds = new ArrayList();
            jsonArray.forEach(id -> printIds.add(Long.valueOf(String.valueOf(id))));
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(SysPrintTemplate::getId, printIds);
            List sysPrintTemplates = this.sysPrintTemplateService.list((Wrapper)lambdaQueryWrapper);
            JSONArray contents = new JSONArray();
            if (printIds.contains(-1L) && HussarUtils.isNotEmpty((Object)(data = (SysPrintTemplateVo)(sysPrintTemplateVoApiResponse = this.sysPrintTemplateService.initSysTemp(sysFormLinkOpenVo.getFormId())).getData()))) {
                Long id2 = data.getId();
                String replace = printIdArr.replace("-1", id2.toString());
                sysFormLinkOpenVo.setPrintIdArr(replace);
                SysPrintTemplate sysPrintTemplate = new SysPrintTemplate();
                PrintTemplateUtil.copyProperties(data, sysPrintTemplate);
                sysPrintTemplates.add(sysPrintTemplate);
            }
            ArrayList templates = new ArrayList();
            JSONArray array = JSON.parseArray((String)sysFormLinkOpenVo.getPrintIdArr());
            if (HussarUtils.isNotEmpty((Object)sysPrintTemplates) && HussarUtils.isNotEmpty((Object)array)) {
                array.forEach(id -> {
                    Optional<SysPrintTemplate> optionalTemplate = sysPrintTemplates.stream().filter(sysPrintTemplate -> sysPrintTemplate.getId().equals(Long.valueOf(String.valueOf(id)))).findFirst();
                    if (optionalTemplate.isPresent()) {
                        templates.add(optionalTemplate.get());
                    }
                });
            }
            if (HussarUtils.isEmpty((Object)sysPrintTemplates)) {
                sysFormLinkOpenVo.setPrintIdArr("");
            }
            contents.addAll(templates);
            sysFormLinkOpenVo.setContents(contents);
        }
    }

    public String generateShortLink() {
        String shortLink = HussarUtils.random((int)6, (RandomType)RandomType.ALL);
        int count = this.sysFormLinkOpenMapper.getCountByShortLink(shortLink);
        if (count != 0) {
            this.generateShortLink();
        }
        return shortLink;
    }

    public ApiResponse<Map<String, Object>> getQueryList(Long formId) {
        if (HussarUtils.isNull((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FormCanvasSchema canvas = (FormCanvasSchema)this.canvasSchemaService.get(String.valueOf(formId)).getData();
        if (HussarUtils.isEmpty((Object)canvas)) {
            ToolUtil.getLogger(((Object)((Object)this)).getClass()).error("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            return ApiResponse.success((String)"\u83b7\u53d6\u8868\u5355\u5b57\u6bb5\u5931\u8d25");
        }
        if (HussarUtils.isNull((Object)canvas.getWidgets())) {
            return ApiResponse.success((String)"\u8868\u5355\u7ec4\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List beforeWidgets = canvas.widgets();
        List<String> queryFields = Arrays.asList(NoFieldControlEnum.JXDNInput.getValue(), NoFieldControlEnum.JXDNNumber.getValue(), NoFieldControlEnum.JXDNRadioGroup.getValue(), NoFieldControlEnum.JXDNSelect.getValue(), NoFieldControlEnum.JXDNSerialNumber.getValue(), NoFieldControlEnum.JXDNDate.getValue());
        List<Widget> widgets = beforeWidgets.stream().filter(widget -> queryFields.contains(widget.getType())).collect(Collectors.toList());
        ArrayList queryFieldVOList = new ArrayList();
        widgets.forEach(widget -> {
            SysFormLinkOpenQueryFieldVo vo = new SysFormLinkOpenQueryFieldVo();
            vo.setLabel(widget.getLabel());
            vo.setName(widget.getName());
            vo.setTitle(widget.getTitle());
            vo.setType(widget.getType());
            vo.setIconClass(widget.getIconClass());
            queryFieldVOList.add(vo);
        });
        HashMap map = new HashMap();
        map.put("queryFieldVOList", queryFieldVOList);
        return ApiResponse.success(map);
    }

    @HussarTransactional
    public ApiResponse<Map<String, Object>> getShowList(Long formId) {
        if (HussarUtils.isNull((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysFormLinkOpenVo fromLinkOpenByFromId = this.sysFormLinkOpenMapper.getFromLinkOpenByFromId(formId);
        if (HussarUtils.isNull((Object)fromLinkOpenByFromId)) {
            return ApiResponse.success((String)"\u8be5\u516c\u5f00\u67e5\u8be2\u5916\u94fe\u4e0d\u5b58\u5728");
        }
        ArrayList<FieldControl> fieldControls = new ArrayList<FieldControl>();
        SysForm sysForm = (SysForm)this.sysFormService.getDetailById(formId).getData();
        if (SysFormLinkEnum.FLOW_FORM.getValue().toString().equals(sysForm.getFormType())) {
            List editBpmFiledControls = this.sysFormLinkService.getEditBpmFiledControl(formId, sysForm.getAppId());
            fieldControls.addAll(editBpmFiledControls);
        } else {
            List editFiledControl = this.sysFormLinkService.getEditFiledControl(formId);
            fieldControls.addAll(editFiledControl);
        }
        String linkShow = fromLinkOpenByFromId.getLinkShow();
        List formLinkSingleFieldVoList = JSON.parseArray((String)linkShow, FieldControl.class);
        FieldControlUtil.mergeFieldControl(fieldControls, formLinkSingleFieldVoList);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.set(SysFormLinkOpen::getLinkShow, (Object)JSON.toJSONString(fieldControls))).eq(SysFormLinkOpen::getFormId, (Object)formId);
        boolean flag = this.update((Wrapper)updateWrapper);
        if (!flag) {
            throw new BaseException("\u521d\u59cb\u5316\u516c\u5f00\u67e5\u8be2\u5b57\u6bb5\u63a7\u5236\u5931\u8d25");
        }
        HashMap<String, ArrayList<FieldControl>> map = new HashMap<String, ArrayList<FieldControl>>();
        map.put("showFieldVOList", fieldControls);
        return ApiResponse.success(map);
    }

    public ApiResponse<Boolean> verifyStatus(Long formId, String shortLink) {
        if (HussarUtils.isNull((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysFormLinkOpenVo fromLinkOpenByFromId = this.sysFormLinkOpenMapper.getFromLinkOpenByFromId(formId);
        if (HussarUtils.isNull((Object)fromLinkOpenByFromId)) {
            return ApiResponse.success((Object)false);
        }
        if (!fromLinkOpenByFromId.getLinkShortAddress().equals(shortLink)) {
            return ApiResponse.success((Object)false);
        }
        if (fromLinkOpenByFromId.getLinkStatus().intValue() == SysFormLinkEnum.OPEN_LINK_CLOSE.getValue().intValue()) {
            return ApiResponse.success((Object)false);
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> verifyStatusPublic(Long formId) {
        SysFormLinkOpenVo fromLinkOpenByFromId = this.sysFormLinkOpenMapper.getFromLinkOpenByFromId(formId);
        if (HussarUtils.isNull((Object)fromLinkOpenByFromId)) {
            return ApiResponse.success((Object)false);
        }
        if (fromLinkOpenByFromId.getLinkStatus().intValue() == SysFormLinkEnum.OPEN_LINK_CLOSE.getValue().intValue()) {
            return ApiResponse.success((Object)false);
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> isLinkPass(Long formId) {
        if (HussarUtils.isNull((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysFormLinkOpenVo fromLinkOpenByFromId = this.sysFormLinkOpenMapper.getFromLinkOpenByFromId(formId);
        if (fromLinkOpenByFromId.getHasPass().intValue() == SysFormLinkEnum.LINKPASS_CLOSE.getValue().intValue()) {
            return ApiResponse.success((Object)false);
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> verifyLinkPass(SysFormLinkOpenDto sysFormLinkOpenDto) {
        String linkPass = sysFormLinkOpenDto.getLinkPass();
        Long formId = sysFormLinkOpenDto.getFormId();
        if (HussarUtils.isNull((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysFormLinkOpenVo fromLinkOpenByFromId = this.sysFormLinkOpenMapper.getFromLinkOpenByFromId(formId);
        if (linkPass.equals(fromLinkOpenByFromId.getLinkPass())) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.success((Object)false);
    }

    @HussarDs(value="#tcode")
    public String redirect(String shortLink, String tcode) {
        if (HussarUtils.isNull((Object)shortLink)) {
            throw new BaseException("\u8868\u5355\u516c\u5f00\u67e5\u8be2\u5916\u94fe\u77ed\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysFormLinkOpenVo sysFormLinkOpenVo = this.sysFormLinkOpenMapper.getOpenFormLinkByShortAddress(shortLink = shortLink.substring(0, 6));
        if (HussarUtils.isNull((Object)sysFormLinkOpenVo)) {
            return null;
        }
        return sysFormLinkOpenVo.getLinkAddress();
    }

    public void cleanPrintArr(Long templateId, Long formId) {
        JSONArray jsonArray;
        String printIdArr;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFormLinkOpen::getFormId, (Object)formId);
        SysFormLinkOpen sysFormLinkOpen = (SysFormLinkOpen)this.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)sysFormLinkOpen) && HussarUtils.isNotEmpty((Object)(printIdArr = sysFormLinkOpen.getPrintIdArr())) && HussarUtils.isNotEmpty((Object)(jsonArray = JSON.parseArray((String)printIdArr)))) {
            jsonArray.remove((Object)String.valueOf(templateId));
            if (jsonArray.isEmpty()) {
                sysFormLinkOpen.setPrintIdArr("");
            } else {
                sysFormLinkOpen.setPrintIdArr(JSON.toJSONString((Object)jsonArray));
            }
            this.updateById((BaseEntity)sysFormLinkOpen);
        }
    }

    private String getFormName(Long formId) {
        try {
            SysForm sysForm = (SysForm)this.sysFormService.getDetailById(formId).getData();
            return sysForm.getFormName();
        }
        catch (Exception e) {
            throw new BaseException("\u83b7\u53d6\u8868\u5355\u57fa\u7840\u4fe1\u606f\u5931\u8d25");
        }
    }

    private static List<FieldControl> copy(List<FieldControl> fieldControls) {
        ArrayList<FieldControl> add = new ArrayList<FieldControl>();
        fieldControls.forEach(fieldControl -> {
            if (!HussarUtils.isNull((Object)fieldControl)) {
                FieldControl fieldControl1 = new FieldControl();
                fieldControl1.setField(fieldControl.getField());
                fieldControl1.setType(fieldControl.getType());
                fieldControl1.setTitle(fieldControl.getTitle());
                fieldControl1.setVisible(fieldControl.isVisible());
                fieldControl1.setWitable(fieldControl.isWitable());
                fieldControl1.setRequired(fieldControl.isRequired());
                fieldControl1.setReadOnly(fieldControl.isReadOnly());
                ArrayList add1 = new ArrayList();
                if (!HussarUtils.isNull((Object)fieldControl.getChildren())) {
                    fieldControl.getChildren().forEach(fieldControl2 -> {
                        if (!HussarUtils.isNull((Object)fieldControl2)) {
                            FieldControl fieldControl3 = new FieldControl();
                            fieldControl3.setField(fieldControl2.getField());
                            fieldControl3.setType(fieldControl2.getType());
                            fieldControl3.setTitle(fieldControl2.getTitle());
                            fieldControl3.setVisible(fieldControl2.isVisible());
                            fieldControl3.setWitable(fieldControl2.isWitable());
                            fieldControl3.setRequired(fieldControl2.isRequired());
                            fieldControl3.setReadOnly(fieldControl2.isReadOnly());
                            add1.add(fieldControl3);
                        }
                    });
                }
                fieldControl1.setChildren(add1);
                add.add(fieldControl1);
            }
        });
        return add;
    }

    private static Map<String, Object> setMap(List<FieldControl> fieldControls) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formLinkFieldVoList", fieldControls);
        AtomicLong visibleCount = new AtomicLong(fieldControls.stream().filter(FieldControl::isVisible).count());
        fieldControls.forEach(fieldControl -> fieldControl.getChildren().stream().filter(FieldControl::isVisible).collect(Collectors.toList()).forEach(fieldControl1 -> visibleCount.getAndIncrement()));
        map.put("visibleNum", visibleCount);
        AtomicLong witableCount = new AtomicLong(fieldControls.stream().filter(FieldControl::isWitable).count());
        fieldControls.forEach(fieldControl -> fieldControl.getChildren().stream().filter(FieldControl::isWitable).collect(Collectors.toList()).forEach(fieldControl1 -> witableCount.getAndIncrement()));
        map.put("editableNum", witableCount);
        return map;
    }
}

